//+------------------------------------------------------------------+
//|                                                        sMACD.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  Silver
#property  indicator_color2  Red
#property  indicator_width1  2
//---- indicator parameters
extern int FastEMA = 12;
extern int SlowEMA = 26;
extern int SignalSMA = 9;
//---- indicator buffers
double MacdBuffer[];
double SignalBuffer[];
//  ,     
#define SIGNAL_BAR 1
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0, DRAW_HISTOGRAM);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexDrawBegin(1, SignalSMA);
   IndicatorDigits(Digits + 1);
//---- indicator buffers mapping
   SetIndexBuffer(0, MacdBuffer);
   SetIndexBuffer(1, SignalBuffer);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("sMACD(" + FastEMA + "," + SlowEMA + "," + SignalSMA + ")");
   SetIndexLabel(0, "sMACD"); 
   SetIndexLabel(1, "sSignal");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars = IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars > 0) 
       counted_bars--;
   limit = Bars - counted_bars;
//---- macd counted in the 1-st buffer
   for(int i = 0; i < limit; i++)
       MacdBuffer[i] = iMA(NULL, 0, FastEMA, 0, MODE_EMA, PRICE_CLOSE, i) - 
                       iMA(NULL, 0, SlowEMA, 0, MODE_EMA, PRICE_CLOSE, i);
//---- signal line counted in the 2-nd buffer
   for(i = 0; i < limit; i++)
       SignalBuffer[i] = iMAOnArray(MacdBuffer, Bars, SignalSMA, 0, MODE_SMA, i);
//---- done
//----  ,   
//----       
	  static int PrevSignal = 0, PrevTime = 0;
//----       0-,     
//----  .     , .
	  if(SIGNAL_BAR > 0 && Time[0] <= PrevTime) 
	      return(0);
//---- ,    
	  PrevTime = Time[0];

//----          (PrevSignal=0)
	  if(PrevSignal <= 0)
	    {
		     //---- ,       :
		     if(MacdBuffer[SIGNAL_BAR] - SignalBuffer[SIGNAL_BAR] > 0 && 
				      SignalBuffer[SIGNAL_BAR+1] - MacdBuffer[SIGNAL_BAR+1] >= 0)
		       {
			        //----  ,     - 
			        PrevSignal = 1;
			        //----   :
			        Alert( "sMACD (", Symbol(), ", ", Period(), ")  -  BUY!!!" );
           //			Print("sMACD (", Symbol(), ", ", Period(), ")  -  BUY!!!");
           //			Comment("sMACD (", Symbol(), ", ", Period(), ")  -  BUY!!!");
           //			PlaySound("Alert.wav");
		       }
	    }
//----     
	  if(PrevSignal >= 0)
	    {
		     if(SignalBuffer[SIGNAL_BAR] - MacdBuffer[SIGNAL_BAR] > 0 && 
				      MacdBuffer[SIGNAL_BAR+1] - SignalBuffer[SIGNAL_BAR+1] >= 0)
		       {
			        PrevSignal = -1;
			        Alert("sMACD (", Symbol(), ", ", Period(), ")  -  SELL!!!");
           //			Print("sMACD (", Symbol(), ", ", Period(), ")  -  SELL!!!");
           //			Comment("sMACD (", Symbol(), ", ", Period(), ")  -  SELL!!!");
           //			PlaySound("Alert.wav");
		       }
	    }
//----	
   return(0);
  }
//+------------------------------------------------------------------+