//+------------------------------------------------------------------+
//|                                                     SignalWZ.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Math\Alglib\dataanalysis.mqh>
#include <Expert\ExpertSignal.mqh>
#define __PI 245850922/78256779
#define __PHI 0.61803398874989
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on K-MEANS classifier with WAVE Fractals     |
//| Type=SignalAdvanced                                              |
//| Name=KMEANS                                                      |
//| ShortName=KMEANS                                                 |
//| Class=CSignalKMEANS                                              |
//| Page=signal_kmeans                                               |
//| Parameter=TrainingPoints,int,120,Training Points                 |
//| Parameter=PointFeatures,int,30,Point Features                    |
//| Parameter=Clusters,int,3,Clusters Used                           |
//| Parameter=MaxBuffer,int,1000,Max Buffer                          |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalKMEANS.                                             |
//| Purpose: Class of of trade signals based on K-MEANS classifier with WAVE Fractals.  |
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalKMEANS                 : public CExpertSignal
  {
protected:

   CiFractals                    m_fractals;
   
   int                           m_clusters;                            // clusters
   int                           m_training_points;                     // training points
   int                           m_point_features;                      // point features
   int                           m_max_buffer;                          // max buffer

public:
                                 CSignalKMEANS(void);
                                 ~CSignalKMEANS(void);
   
   //--- method of verification of settings
   virtual bool                  ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool                  InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int                   LongCondition(void);
   virtual int                   ShortCondition(void);
   //---
   void                          Clusters(int value)                    { m_clusters=value;        }
   void                          TrainingPoints(int value)              { m_training_points=value; }
   void                          PointFeatures(int value)               { m_point_features=value;  }
   void                          MaxBuffer(int value)                   { m_max_buffer=value;      }

protected:

   double                        Optimize(double lots);
   
   vector                        m_wave;
   bool                          m_loaded;
      
   double                        GetOutput();

   CClusterizerState             m_state;
   
   CKmeansReport                 m_report;
   
   struct                        Sdata
                                 {
                                    CMatrixDouble  x;
                                    CRowDouble     y;
                                    
                                                   Sdata(){};
                                                   ~Sdata(){};
                                 };
                                 
   Sdata                         m_data;
   
   CClustering                   m_clustering;
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalKMEANS::CSignalKMEANS(void)  :   m_training_points(12),
                                             m_point_features(4),
                                             m_clusters(3),
                                             m_max_buffer(1000)
  {
//--- initialization of protected data
      m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE+USE_SERIES_SPREAD+USE_SERIES_TIME;
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalKMEANS::~CSignalKMEANS(void)
  {
  }
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalKMEANS::ValidationSettings(void)
  {
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks

   if(m_clusters<2){
      printf(__FUNCSIG__+" clusters should at least be 2! ");
      return(false);}
    
    m_wave.Resize(m_training_points+m_point_features+1);
    m_wave.Fill(0.0);
    m_loaded=false;
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalKMEANS::InitIndicators(CIndicators *indicators)
  {
//--- check pointer
   if(indicators==NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
   
   if(!m_fractals.Create(m_symbol.Name(),m_period))
     {
      return(false);
     }
      
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalKMEANS::LongCondition(void)
  {
      int result=0;
      return(result);
      
      m_high.Refresh(-1);
      m_low.Refresh(-1);
   
      double _output=GetOutput();
      
      
      int _range_size=1;
      
      double _range=m_high.GetData(m_high.MaxIndex(StartIndex(),StartIndex()+_range_size))-m_low.GetData(m_low.MinIndex(StartIndex(),StartIndex()+_range_size));
      
      _output/=fmax(_range,m_symbol.Point());
      _output*=100.0;
      
      if(_output>0.0){ result=int(fmin(100.0,round(_output))); }//printf(__FUNCSIG__+" gap call is: "+DoubleToString(_gap_call)+", range is: "+DoubleToString(_range)+" gap is: "+DoubleToString(_output)+", result is: "+IntegerToString(result)); 
      
      return(result);
  }
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalKMEANS::ShortCondition(void)
  {
      int result=0;
      
      m_high.Refresh(-1);
      m_low.Refresh(-1);
      
      double _output=GetOutput();
      
         
      int _range_size=1;
      
      double _range=m_high.GetData(m_high.MaxIndex(StartIndex(),StartIndex()+_range_size))-m_low.GetData(m_low.MinIndex(StartIndex(),StartIndex()+_range_size));
      
      _output/=fmax(_range,m_symbol.Point());
      _output*=100.0;
      
      if(_output<0.0){ result=int(fmax(-100.0,round(_output)))*-1; }//printf(__FUNCSIG__+" gap call is: "+DoubleToString(_gap_call)+", range is: "+DoubleToString(_range)+" gap is: "+DoubleToString(_output)+", result is: "+IntegerToString(result)); 
      
      return(result);
  }
//+------------------------------------------------------------------+
//| Get k-means cluster output from identified cluster.              |
//+------------------------------------------------------------------+
double CSignalKMEANS::GetOutput()
   {
      double _output=0.0;
      
      m_data.x.Resize(m_training_points,m_point_features);
      m_data.y.Resize(m_training_points-1);
      
      m_data.x.Fill(0.0);
      m_data.y.Fill(0.0);
      
      m_fractals.Refresh();
      m_fractals.Refresh(-1);
      m_fractals.Refresh(-1);
      //m_fractals.RefreshCurrent(true);
      
      int _size=m_training_points+m_point_features+1,_index=0;
      
      for(int i=0;i<m_fractals.Available();i++)
      {
         double _0=m_fractals.GetData(0,i);
         double _1=m_fractals.GetData(1,i);
         
         if(_0!=DBL_MAX||_1!=DBL_MAX)
         { 
            double _v=0.0;
            if(_0!=DBL_MAX){_v=_0;}
            if(_1!=DBL_MAX){_v=_1;}
            if(!m_loaded){ m_wave[_index]=_v; _index++; } 
            else
            {
               for(int i=_size-1;i>0;i--){ m_wave[i]=m_wave[i-1]; }
               m_wave[0]=_v; break;
            }
         }
         
         if(_index>=int(m_wave.Size())){ break; }
      }
      
      if(!m_loaded){ m_loaded=true; }
      
      if(m_wave[_size-1]==0.0){ return(0.0); }
      
      for(int i=0;i<m_training_points;i++)
      {
         for(int ii=0;ii<m_point_features;ii++)
         {
            double _value=m_wave[i+1]-m_wave[ii+i+2];
            m_data.x.Set(i,ii,_value);
            matrix _m=m_data.x.ToMatrix();if(_m.HasNan()){ _m.ReplaceNan(0.0); }m_data.x=CMatrixDouble(_m);
         }
         
         if(i>0)
         {
            double _value=m_wave[i-1]-m_wave[i];
            m_data.y.Set(i-1,_value);
            vector _v=m_data.y.ToVector();if(_v.HasNan()){ _v.ReplaceNan(0.0); }m_data.y=CRowDouble(_v);
         }
      }
      
      m_clustering.ClusterizerCreate(m_state);
      
      m_clustering.ClusterizerSetPoints(m_state, m_data.x, m_training_points, m_point_features, 2);
      
      m_clustering.ClusterizerRunKMeans(m_state, m_clusters, m_report);
      
      if(m_report.m_terminationtype==1)
      {
         int _clusters_by_index[];
         if(m_report.m_cidx.ToArray(_clusters_by_index))
         {
            int _output_count=0;
            for(int i=1;i<m_training_points;i++)
            {
               if(_clusters_by_index[0]==_clusters_by_index[i])
               {
                  _output+=(m_data.y[i-1]);
                  _output_count++;
               }
            }
            //
            if(_output_count>0){ _output/=_output_count; } 
         }
      }
      else
      {
         if(m_report.m_terminationtype==-5)
         {
            printf(__FUNCSIG__+" distance type should be euclidean. ");
         }
         else if(m_report.m_terminationtype==-3)
         {
            printf(__FUNCSIG__+" degenerate dataset either  size is less than cluster no. or clusters are 0 for non empty dataset. ");
         }
      }
      
      return(_output);
   }
//+------------------------------------------------------------------+
