//+------------------------------------------------------------------+
//|                                                     SignalWZ.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Math\Alglib\dataanalysis.mqh>
#include <Expert\ExpertSignal.mqh>
#define __PI 245850922/78256779
#define __PHI 0.61803398874989
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on K-MEANS classifier                        |
//| Type=SignalAdvanced                                              |
//| Name=KMEANS                                                      |
//| ShortName=KMEANS                                                 |
//| Class=CSignalKMEANS                                              |
//| Page=signal_kmeans                                               |
//| Parameter=TrainingPoints,int,120,Training Points                 |
//| Parameter=PointFeatures,int,30,Point Features                    |
//| Parameter=Clusters,int,3,Clusters Used                           |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalKMEANS.                                             |
//| Purpose: Class of of trade signals based on K-MEANS classifier.  |
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalKMEANS                 : public CExpertSignal
  {
protected:

   int                           m_clusters;                            // clusters
   int                           m_training_points;                     // training points
   int                           m_point_features;                      // point featues

public:
                                 CSignalKMEANS(void);
                                 ~CSignalKMEANS(void);
   
   //--- method of verification of settings
   virtual bool                  ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool                  InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int                   LongCondition(void);
   virtual int                   ShortCondition(void);
   //---
   void                          Clusters(int value)                    { m_clusters=value;        }
   void                          TrainingPoints(int value)              { m_training_points=value; }
   void                          PointFeatures(int value)               { m_point_features=value;  }

protected:

   double                        Optimize(double lots);
   
      
   double                        GetOutput();

   CClusterizerState             m_state;
   
   CKmeansReport                 m_report;
   
   struct                        Sdata
                                 {
                                    CMatrixDouble  x;
                                    CRowDouble     y;
                                    
                                                   Sdata(){};
                                                   ~Sdata(){};
                                 };
                                 
   Sdata                         m_data;
   
   CClustering                   m_clustering;
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalKMEANS::CSignalKMEANS(void)  :   m_training_points(120),
                                             m_point_features(30),
                                             m_clusters(3)
  {
//--- initialization of protected data
      m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE+USE_SERIES_SPREAD+USE_SERIES_TIME;
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalKMEANS::~CSignalKMEANS(void)
  {
  }
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalKMEANS::ValidationSettings(void)
  {
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks

   if(m_clusters<2){
      printf(__FUNCSIG__+" clusters should at least be 2! ");
      return(false);}
     
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalKMEANS::InitIndicators(CIndicators *indicators)
  {
//--- check pointer
   if(indicators==NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
      
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalKMEANS::LongCondition(void)
  {
      int result=0;
      return(result);
      
      m_high.Refresh(-1);
      m_low.Refresh(-1);
   
      double _output=GetOutput();
      
      int _range_size=1;
      
      double _range=m_high.GetData(m_high.MaxIndex(StartIndex(),StartIndex()+_range_size))-m_low.GetData(m_low.MinIndex(StartIndex(),StartIndex()+_range_size));
      
      _output/=fmax(_range,m_symbol.Point());
      _output*=100.0;
      
      if(_output>0.0){ result=int(fmin(100.0,round(_output))); }//printf(__FUNCSIG__+" gap call is: "+DoubleToString(_gap_call)+", range is: "+DoubleToString(_range)+" gap is: "+DoubleToString(_output)+", result is: "+IntegerToString(result)); 
      
      return(result);
  }
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalKMEANS::ShortCondition(void)
  {
      int result=0;
      
      m_high.Refresh(-1);
      m_low.Refresh(-1);
      
      double _output=GetOutput();
      
      int _range_size=1;
      
      double _range=m_high.GetData(m_high.MaxIndex(StartIndex(),StartIndex()+_range_size))-m_low.GetData(m_low.MinIndex(StartIndex(),StartIndex()+_range_size));
      
      _output/=fmax(_range,m_symbol.Point());
      _output*=100.0;
      
      if(_output<0.0){ result=int(fmax(-100.0,round(_output)))*-1; }
      
      return(result);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CSignalKMEANS::GetOutput()
   {
      double _output=0.0;
      
      m_data.x.Resize(m_training_points,m_point_features);
      m_data.y.Resize(m_training_points-1);
      
      m_data.x.Fill(0.0);
      m_data.y.Fill(0.0);
      
      m_close.Refresh(-1);
      
      double _dbl_min=-1000.0,_dbl_max=1000.0;
      
      for(int i=0;i<m_training_points;i++)
      {
         for(int ii=0;ii<m_point_features;ii++)
         {
            double _value=m_close.GetData(StartIndex()+i)-m_close.GetData(StartIndex()+ii+i+1);
            if(_dbl_min>=_value||!MathIsValidNumber(_value)||_value>=_dbl_max){ _value=0.0; }
            m_data.x.Set(i,ii,_value);
            matrix _m=m_data.x.ToMatrix();if(_m.HasNan()){ _m.ReplaceNan(0.0); }m_data.x=CMatrixDouble(_m);
         }
         
         if(i>0)//assign classifier only for data points for which eventual bar range is known
         {
            double _value=m_close.GetData(StartIndex()+i-1)-m_close.GetData(StartIndex()+i);
            if(_dbl_min>=_value||!MathIsValidNumber(_value)||_value>=_dbl_max){ _value=0.0; }
            m_data.y.Set(i-1,_value);
            vector _v=m_data.y.ToVector();if(_v.HasNan()){ _v.ReplaceNan(0.0); }m_data.y=CRowDouble(_v);
         }
      }
      
      m_clustering.ClusterizerCreate(m_state);
      
      m_clustering.ClusterizerSetPoints(m_state, m_data.x, m_training_points, m_point_features, 2);
      
      m_clustering.ClusterizerRunKMeans(m_state, m_clusters, m_report);
      
      if(m_report.m_terminationtype==1)
      {
         int _clusters_by_index[];
         if(m_report.m_cidx.ToArray(_clusters_by_index))
         {
            int _output_count=0;
            for(int i=1;i<m_training_points;i++)
            {
               if(_clusters_by_index[0]==_clusters_by_index[i])
               {
                  _output+=(m_data.y[i-1]);
                  _output_count++;
               }
            }
            //
            if(_output_count>0){ _output/=_output_count; } 
         }
      }
      else
      {
         if(m_report.m_terminationtype==-5)
         {
            printf(__FUNCSIG__+" distance type should be euclidean. ");
         }
         else if(m_report.m_terminationtype==-3)
         {
            printf(__FUNCSIG__+" degenerate dataset either  size is less than cluster no. or clusters are 0 for non empty dataset. ");
         }
      }
      
      return(_output);
   }
//+------------------------------------------------------------------+
