//+------------------------------------------------------------------+
//|                                                        ct_16.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\Expert.mqh>
//--- available signals
#include <Expert\Signal\My\SignalCT_16_.mqh>
//--- available trailing
#include <Expert\Trailing\TrailingNone.mqh>
//--- available money management
#include <Expert\Money\MoneyFixedMargin.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
//--- inputs for expert
input string   Expert_Title           = "ct_16";      // Document name
ulong          Expert_MagicNumber     = 29498;        //
bool           Expert_EveryTick       = false;        //
//--- inputs for main ExtSignal
input int      Signal_ThresholdOpen   = 10;           // Signal threshold value to open [0...100]
input int      Signal_ThresholdClose  = 10;           // Signal threshold value to close [0...100]
input double   Signal_PriceLevel      = 0.0;          // Price level to execute a deal
input double   Signal_StopLevel       = 50.0;         // Stop Loss level (in points)
input double   Signal_TakeLevel       = 50.0;         // Take Profit level (in points)
input int      Signal_Expiration      = 4;            // Expiration of pending orders (in bars)
input string   Signal_CT_Currency     = "USD";        // CategoryTheory("USD",true,...) Currency (EUR implies Germany)
input bool     Signal_CT_Objects      = true;         // CategoryTheory("USD",true,...) Use Objects to Objects
input double   Signal_CT_Decay        = 0.001;        // CategoryTheory("USD",true,...) Multi Layer Perceptron Decay
input int      Signal_CT_Restarts     = 2;            // CategoryTheory("USD",true,...) Multi Layer Perceptron Restarts
input datetime Signal_CT_TrainingStop = D'2023.01.01'; // CategoryTheory("USD",true,...) Training Stop
input int      Signal_CT_TrainingPasses = 100;        // CategoryTheory("USD",true,...) Training Passes
input datetime Signal_CT_TestingStop  = D'2023.08.01'; // CategoryTheory("USD",true,...) Testing Stop
input int      Signal_CT_Hidden       = 7;            // CategoryTheory("USD",true,...) Hidden Layer Size
input double   Signal_CT_Weight       = 1.0;          // CategoryTheory("USD",true,...) Weight [0...1.0]
//--- inputs for money
input double   Money_FixMargin_Percent = 10.0;        // Percentage of margin
//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert;
//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
{
//--- Initializing expert
   if(!ExtExpert.Init(Symbol(), Period(), Expert_EveryTick, Expert_MagicNumber))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing expert");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Creating ExtSignal
   CSignalCT *ExtSignal = new CSignalCT;
   if(ExtSignal == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating ExtSignal");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//---
   ExtExpert.InitSignal(ExtSignal);
   ExtSignal.ThresholdOpen(Signal_ThresholdOpen);
   ExtSignal.ThresholdClose(Signal_ThresholdClose);
   ExtSignal.PriceLevel(Signal_PriceLevel);
   ExtSignal.StopLevel(Signal_StopLevel);
   ExtSignal.TakeLevel(Signal_TakeLevel);
   ExtSignal.Expiration(Signal_Expiration);
//--- Creating filter CSignalCT
   CSignalCT *filter0 = new CSignalCT;
   if(filter0 == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating filter0");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
   ExtSignal.AddFilter(filter0);
//--- Set filter parameters
   filter0.Currency(Signal_CT_Currency);
   filter0.Objects(Signal_CT_Objects);
   filter0.Decay(Signal_CT_Decay);
   filter0.Restarts(Signal_CT_Restarts);
   filter0.TrainingStop(Signal_CT_TrainingStop);
   filter0.TestingStop(Signal_CT_TestingStop);
   filter0.Hidden(Signal_CT_Hidden);
   filter0.Weight(Signal_CT_Weight);
//--- Creation of trailing object
   CTrailingNone *trailing = new CTrailingNone;
   if(trailing == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Add trailing to expert (will be deleted automatically))
   if(!ExtExpert.InitTrailing(trailing))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Set trailing parameters
//--- Creation of money object
   CMoneyFixedMargin *money = new CMoneyFixedMargin;
   if(money == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Add money to expert (will be deleted automatically))
   if(!ExtExpert.InitMoney(money))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Set money parameters
   money.Percent(Money_FixMargin_Percent);
//--- Check all trading objects parameters
   if(!ExtExpert.ValidationSettings())
   {  //--- failed
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Tuning of all necessary indicators
   if(!ExtExpert.InitIndicators())
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing indicators");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
   //
//--- ok
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{  ExtExpert.Deinit();
}
//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
{  ExtExpert.OnTick();
}
//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
{  ExtExpert.OnTrade();
}
//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
{  ExtExpert.OnTimer();
}
//+------------------------------------------------------------------+
