//+------------------------------------------------------------------+
//|                                                          Cct.mqh |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright                 "Copyright 2022, MetaQuotes Ltd."
#property link                      "https://www.mql5.com"
#property version                   "1.00"

#include                            <Object.mqh>
//#include <Math\Stat\stat.mqh>
//+------------------------------------------------------------------+
//| ELEMENT CLASS                                                    |
//+------------------------------------------------------------------+
template <typename T>
class CElement                      : public CObject
   {
      protected:
      
      int                           cardinal;
      T                             element[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(element,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIdentity,T &Type) { if(ElementIdentity>=0 && ElementIdentity<Cardinality()) { Type=element[ElementIdentity]; return(true); } return(false); }
      bool                          Set(int ValueIndex,T Value) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { element[ValueIndex]=Value; return(true); } return(false); }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
                                    CElement(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CElement(void) {};
   };
//+------------------------------------------------------------------+
//| DOMAIN CLASS                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CDomain                       : public CObject
   {
      protected:
      
      int                           cardinal;
      CElement<T>                   elements[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(elements,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,CElement<T> &Element) { if(ElementIndex>=0 && ElementIndex<Cardinality()) { Element=elements[ElementIndex]; return(true); } return(false); }
                                    
                                    //'IsIndexed' parameter specifies value should be unique in domain which is a typical requirement
                                    //there are exceptions however, such as when swapping values (see GetIsomorphisms()), where this rule could be suspended
      bool                          Set(int ValueIndex,CElement<T> &Value,bool IsIndexed=false) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Cardinality()) 
                                       { 
                                          if(!IsIndexed||Index(Value)<0)
                                          { 
                                             elements[ValueIndex]=Value; 
                                             return(true); 
                                          }
                                          else
                                          { 
                                             printf(__FUNCSIG__+" value already exists. "); 
                                          } 
                                       }
                                       else
                                       { 
                                          if(ValueIndex>=0 && Cardinality()<ValueIndex+1 && ValueIndex<INT_MAX)
                                          {
                                             if(Cardinality(ValueIndex+1))
                                             {
                                                elements[ValueIndex]=Value; 
                                                return(true); 
                                             }
                                          }
                                          else
                                          {
                                             printf(__FUNCSIG__+" index: "+IntegerToString(ValueIndex)+" out of bounds in domain cardinal: "+IntegerToString(Cardinality())); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
      int                           Index(CElement<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int c=0; c<cardinal; c++)
                                       {
                                          if(ElementMatch(Value,elements[c]))
                                          {
                                             //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value cardinality: "+IntegerToString(Value.Cardinality())+", & element cardinality: "+string(elements[c].Cardinality()));
                                             //
                                             //for(int cc=0; cc<elements[c].Cardinality(); cc++)
                                             {
                                                //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value: "+string(Value.Get(cc))+", & element: "+string(elements[c].Get(cc)));
                                             }
                                             _index=c; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CDomain(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CDomain(void) {};
   };
//+------------------------------------------------------------------+
//| Enumeration for Monoid Operations                                |
//+------------------------------------------------------------------+
enum EOperations
  {
      OP_FURTHEST=5,
      OP_CLOSEST=4,
      OP_MOST=3,
      OP_LEAST=2,
      OP_MULTIPLY=1,
      OP_ADD=0
  };
//+------------------------------------------------------------------+
//| Monoid Class                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CMonoid                       : public CDomain<T>
   {
      protected:
      //double                        weights[];
      
      int                           identity;
      EOperations                   operation;
      
      public:
      
      double                        weights[];
      
      bool                          Weights(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX && Cardinality(Value)) 
                                       {  
                                          ArrayResize(weights,cardinal); 
                                          return(true); 
                                       } 
                                       
                                       return(false); 
                                    }
                                    
      int                           Weights()
                                    { 
                                       return(Cardinality()); 
                                    }
      
      bool                          GetWeight(int WeightIndex,double &Weight) { if(WeightIndex>=0 && WeightIndex<Cardinality()) { Weight=weights[WeightIndex]; return(true); } return(false); }
                                    
      bool                          SetWeight(int ValueIndex,double Value) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Cardinality()) 
                                       { 
                                          weights[ValueIndex]=Value;
                                          return(true);  
                                       }
                                       else
                                       { 
                                          printf(__FUNCSIG__+" index: "+IntegerToString(ValueIndex)+" out of bounds in domain cardinal: "+IntegerToString(Cardinality())); 
                                       } 
                                       
                                       return(false); 
                                    }
      
      void                          Operation(EOperations Value) {  operation=Value; }
      EOperations                   Operation() { return(operation); }
      
      bool                          Identity(int ElementIdentity) { if(ElementIdentity>=0 && ElementIdentity<Cardinality()) { identity=ElementIdentity; return(true); } return(false); }
      int                           Identity() { return(identity); }
                                    
      int                           Operate(int IndexA,int IndexB)
                                    {
                                       int _operate=-1;
                                       
                                       if(IndexA>=0 && IndexA<Cardinality() && IndexB>=0 && IndexB<Cardinality())
                                       {
                                          if(this.Operation()==OP_ADD)
                                          {
                                             double _value=weights[IndexA]+weights[IndexB];
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(_value==weights[i]){ _operate=i; break; }
                                             }
                                          }
                                          else if(this.Operation()==OP_MULTIPLY)
                                          {
                                             double _value=weights[IndexA]*weights[IndexB];
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(_value==weights[i]){ _operate=i; break; }
                                             }
                                          }
                                          else if(this.Operation()==OP_MOST)
                                          {
                                             double _value=weights[IndexA]*weights[IndexB];
                                             
                                             if(weights[IndexA]>=weights[IndexB])
                                             {
                                                _operate=IndexA;
                                             }
                                             else if(weights[IndexA]<=weights[IndexB])
                                             {
                                                _operate=IndexB;
                                             }
                                          }
                                          else if(this.Operation()==OP_LEAST)
                                          {
                                             double _value=weights[IndexA]*weights[IndexB];
                                             
                                             if(weights[IndexA]<=weights[IndexB])
                                             {
                                                _operate=IndexA;
                                             }
                                             else if(weights[IndexA]>=weights[IndexB])
                                             {
                                                _operate=IndexB;
                                             }
                                          }
                                          else if(this.Operation()==OP_FURTHEST)
                                          {
                                             double _value=0.5*(weights[IndexA]+weights[IndexB]);
                                             double _furthest=fabs(_value-weights[0]);
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(fabs(_value-weights[i])>_furthest){ _furthest=fabs(_value-weights[i]); _operate=i; }
                                             }
                                          }
                                          else if(this.Operation()==OP_CLOSEST)
                                          {
                                             double _value=0.5*(weights[IndexA]+weights[IndexB]);
                                             double _closest=fabs(_value-weights[0]);
                                             
                                             for(int i=0;i<Cardinality();i++)
                                             {
                                                if(fabs(_value-weights[i])<_closest){ _closest=fabs(_value-weights[i]); _operate=i; }
                                             }
                                          }
                                       }
                                       
                                       return(_operate);
                                    }
      
                                    CMonoid(){ identity=0; operation=OP_ADD; };
                                    ~CMonoid(){};
   };
//+------------------------------------------------------------------+
//| Monoid Action Class                                              |
//+------------------------------------------------------------------+
template <typename TM,typename TA>
class CMonoidAction                 : public CMonoid<TM>
   {
      protected:
      
      EOperations                   action;
      int                           modulo;
      
      public:
      
      CMonoid<TA>                   set;
      
      void                          Action(EOperations Value) {  action=Value; }
      EOperations                   Action() { return(action); }
      
      int                           GetModulo() {  return(modulo); }
                                    
      bool                          SetModulo(int Value) 
                                    { 
                                       if(Value>0 && Value%2==1 && Value<INT_MAX) 
                                       { 
                                          modulo=Value;
                                          return(/*set.Weights(modulo) && */set.Identity(int(round(modulo/2.0)-1.0)));
                                       }
                                       else
                                       { 
                                          printf(__FUNCSIG__+" value: "+IntegerToString(Value)+" is negative, even, or not an integer. "); 
                                       } 
                                       
                                       return(false); 
                                    }
                                    
      int                           OperateModulo(int Index,int Modulo=1)
                                    {
                                       int _operate=-1;
                                       
                                       if(Index>=0 && Index<this.Cardinality())
                                       {
                                          int _value=int(round(set.weights[Index]));
                                          
                                          _operate=_value%Modulo;
                                       }
                                       
                                       return(_operate);
                                    }
                                    
      bool                          IsInverseModulo(int IndexA,int IndexB)
                                    {
                                       if(IndexA!=IndexB && fabs(IndexA-set.weights[set.Identity()])==fabs(IndexB-set.weights[set.Identity()]))
                                       {
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
                                    
      int                           OperateGroup()
                                    {
                                       int _operate=-1;
                                       
                                       for(int i=0;i<GetModulo();i++)
                                       {
                                          for(int ii=0;ii<GetModulo();ii++)
                                          {
                                             if(i==ii)
                                               {
                                                
                                               }
                                          }
                                       }
                                       
                                       /*if(Modulo%2!=1){ return(_operate); }
                                       
                                       int _identity=int(round(Modulo/2.0)-1.0);
                                       
                                       if(_identity==IndexA){ _operate=IndexB; }
                                       else if(_identity==IndexB){ _operate=IndexA; }
                                       
                                       if(Index>=0 && Index<this.Cardinality())
                                       {
                                          _operate=int(round(weights[Index]))%Modulo;
                                       }*/
                                       
                                       return(_operate);
                                    }
      
                                    CMonoidAction(){ action=OP_CLOSEST; };
                                    ~CMonoidAction(){};
   };
//+------------------------------------------------------------------+
//| Monoid Group Class                                               |
//+------------------------------------------------------------------+
template <typename T>
class CMonoidGroup                 : public CMonoid<T>
   {
      protected:
      
      public:
      
      bool                          HasInversion() 
                                    {  
                                       bool _has_inversion=true;
                                       
                                       for(int i=0;i<this.Cardinality();i++)
                                       {
                                          bool _has_inverse=false;
                                          
                                          for(int ii=0;ii<this.Cardinality();ii++)
                                          {
                                             if(Operate(i,ii)==Identity()){ _has_inverse=true; }
                                          }
                                          
                                          if(!_has_inverse){ _has_inversion=false; break; }
                                       }
                                       
                                       return(_has_inversion); 
                                    }
      
                                    CMonoidGroup(){};
                                    ~CMonoidGroup(){};
   };
//+------------------------------------------------------------------+
//| Graph Class                                                      |
//+------------------------------------------------------------------+
template <typename T>
class CGraph                        //: public CDomain<T>
   {
      protected:
      
      int                           vertices;
      int                           arrows;
      
      public:
      
      CElement<T>                   vertex[];
      CElement<int>                 arrow[];
      
      bool                          Vertices(int Value) { if(Value>=0 && Value<INT_MAX) { vertices=Value; ArrayResize(vertex,vertices); return(true); } return(false); }
      int                           Vertices() { return(vertices); }
      
      bool                          Arrows(int Value) 
                                    { 
                                       if(Value>=0 && Value<INT_MAX) 
                                       { 
                                          arrows=Value; 
                                          ArrayResize(arrow,arrows); 
                                          
                                          for(int i=0;i<arrows;i++){ arrow[i].Cardinality(2); }
                                          
                                          return(true); 
                                       } 
                                       
                                       return(false); 
                                    }
      int                           Arrows() { return(arrows); }
      
                                    
   };
//+------------------------------------------------------------------+
//| Fill Domain with handle data.                                    |
//+------------------------------------------------------------------+
template <typename T>
bool FillDomain(CDomain<T> &D,int Index,int Size,int &Handle,int Buffer=0)
   {
      double _buffer[];ArrayResize(_buffer,Size);ArrayInitialize(_buffer,0.0);
      
      if(CopyBuffer(Handle,Buffer,0,Size,_buffer)>=Size)
      {
         for(int p=0;p<Size;p++)
         {
            CElement<double> _e;
            if(_e.Cardinality(1))
            {
               if(_e.Set(0,_buffer[p]))
               { 
                  D.Set(p,_e); 
               }
            }
         }
      }
      
      return(true);
   }
//+------------------------------------------------------------------+
//| Element Match function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool ElementMatch(CElement<TA> &A,CElement<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int r=0; r<A.Cardinality(); r++)
      {
         TA _a;TB _b;
         if(A.Get(r,_a) && B.Get(r,_b) && _a!=_b)
         {
            _matched=false;
            break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Domain Match function                                            |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool DomainMatch(CDomain<TA> &A,CDomain<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         //printf(__FUNCSIG__+" type mismatch. ");
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         //printf(__FUNCSIG__+" cardinality mismatch. ");
         return(false);
      }
      
      /*if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }*/
      
      bool _matched=true;
      
      for(int o=0; o<A.Cardinality(); o++)
      {
         CElement<TA> _a;
         CElement<TB> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !ElementMatch(_a,_b))
         {
            //printf(__FUNCSIG__+" element mismatch at: "+IntegerToString(o));
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Print Element function                                           |
//+------------------------------------------------------------------+
template <typename T>
string PrintElement(CElement<T> &E,int FloatPrecision=1)
   {
      string _element="(";
      //
      for(int r=0; r<E.Cardinality(); r++)
      {
         if(string(typename(T))=="datetime")
         {
            T _date;
            if(E.Get(r,_date)){ _element+=TimeToString(datetime(_date)); }
         }
         else if(string(typename(T))=="string")
         {
            T _string;
            if(E.Get(r,_string)){ _element+=string(_string); }
         }
         else if(string(typename(T))=="double"||string(typename(T))=="float")
         {
            T _double;
            if(E.Get(r,_double)){ _element+=DoubleToString(double(_double)); }
         }
         else //if(string(typename(T))=="int")
         {
            T _int;
            if(E.Get(r,_int)){ _element+=IntegerToString(int(_int)); }
         }
         
         if(r<E.Cardinality()-1){ _element+=","; }
      }
      //
      return(_element+")");
   }
//+------------------------------------------------------------------+
//| Print Domain function                                            |
//+------------------------------------------------------------------+
template <typename T>
string PrintDomain(CDomain<T> &D,int FloatPrecision=1)
   {
      string _domain="{";
      //
      CElement<T> _e;
      for(int o=0; o<D.Cardinality(); o++)
      {
         D.Get(o,_e);
         _domain+=PrintElement(_e,FloatPrecision);if(o<D.Cardinality()-1){ _domain+=","; }
      }
      //
      return(_domain+"}\n");
   }
//+------------------------------------------------------------------+
