//+------------------------------------------------------------------+
//|                                                     template.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#property                           script_show_inputs

#include <Object.mqh>
#include <Math\Stat\stat.mqh>

#define OBJECT_NAME(x) #x+" "   // macro for displaying an object name

typedef string (*Tid)(int,double);
typedef string (*Tdd)(double,double);

string int_double(int A,double B) { return((string(IntegerToString(A)+"|"+DoubleToString(B)))); }
string double_double(double A,double B) { return(DoubleToString(A)+"|"+DoubleToString(B)); }
//+------------------------------------------------------------------+
//| ELEMENT CLASS                                                    |
//+------------------------------------------------------------------+
template <typename T>
class CElement                      : public CObject
   {
      protected:
      
      int                           cardinal;
      T                             element[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(element,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      T                             Get(int ElementIndex) { T _element=NULL; if(ElementIndex>=0 && ElementIndex<Cardinality()) { _element=element[ElementIndex]; return(_element); } return(_element); }
      bool                          Set(int ValueIndex,T Value) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { element[ValueIndex]=Value; return(true); } return(false); }
      
                                    CElement(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CElement(void) {};
   };
//+------------------------------------------------------------------+
//| DOMAIN CLASS                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CDomain                       : public CObject
   {
      protected:
      
      int                           cardinal;
      CElement<T>                   elements[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(elements,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,CElement<T> &Element) { if(ElementIndex>=0 && ElementIndex<Cardinality()) { Element=elements[ElementIndex]; return(true); } return(false); }
                                    
                                    //'IsIndexed' parameter specifies value should be unique in domain which is a typical requirement
                                    //there are exceptions however, such as when swapping values (see GetIsomorphisms()), where this rule could be suspended
      bool                          Set(int ValueIndex,CElement<T> &Value,bool IsIndexed=false) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { if(!IsIndexed||Index(Value)<0){ elements[ValueIndex]=Value; return(true); }else{ printf(__FUNCSIG__+" value already exists. "); } }else{ printf(__FUNCSIG__+" index out of bounds. "); } return(false); }
      
      int                           Index(CElement<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int c=0; c<cardinal; c++)
                                       {
                                          if(ElementMatch(Value,elements[c]))
                                          {
                                             //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value cardinality: "+IntegerToString(Value.Cardinality())+", & element cardinality: "+string(elements[c].Cardinality()));
                                             //
                                             //for(int cc=0; cc<elements[c].Cardinality(); cc++)
                                             {
                                                //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value: "+string(Value.Get(cc))+", & element: "+string(elements[c].Get(cc)));
                                             }
                                             _index=c; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CDomain(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CDomain(void) {};
   };
//+------------------------------------------------------------------+
//| MORPHISM CLASS                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CMorphism
   {
      protected:
      
      int                           domain_index;
      int                           codomain_index;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      int                           Domain(){ return(domain_index); };
      bool                          Domain(int DomainIndex) { if(DomainIndex>=0 && DomainIndex<domain.Cardinality()) { domain_index=DomainIndex; }else{ printf(__FUNCSIG__+" index out of bounds. "); } return(false); }
      
      int                           Codomain(){ return(codomain_index); };
      bool                          Codomain(int CodomainIndex) { if(CodomainIndex>=0 && CodomainIndex<codomain.Cardinality()) { codomain_index=CodomainIndex; }else{ printf(__FUNCSIG__+" index out of bounds. "); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Morph(CDomain<TDD> &D,CDomain<TDC> &C,int  &DomainIndex,int &CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Cardinality() && CodomainIndex>=0 && CodomainIndex<D.Cardinality())
                                       {
                                          domain_index=DomainIndex;
                                          codomain_index=CodomainIndex;
                                          
                                          domain=D;
                                          codomain=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
                                    CMorphism(void){ domain_index=-1; codomain_index=-1; };
                                    ~CMorphism(void){};
   };
//+------------------------------------------------------------------+
//| HOMO-MORPHISM CLASS                                              |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CHomomorphism                 : public CObject
   {
      protected:
      
      int                           morphisms;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      CMorphism<TD,TC>              morphism[];
      
      int                           Morphisms() { return(morphisms); }
      bool                          Morphisms(int Value) { if(Value>=0 && Value<INT_MAX) { morphisms=Value; ArrayResize(morphism,morphisms); return(true); } return(false); }
      
      bool                          Get(int MorphismIndex,CMorphism<TD,TC> &Morphism) { if(MorphismIndex>=0 && MorphismIndex<Morphisms()) { Morphism=morphism[MorphismIndex]; Morphism.domain=domain; Morphism.codomain=codomain; return(true); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Set(int ValueIndex,CMorphism<TDD,TDC> &Value)
                                    {
                                       if
                                       (
                                       (string(typename(TD))!=string(typename(TDD)))
                                       ||
                                       (string(typename(TC))!=string(typename(TDC)))
                                       )
                                       {
                                          return(false);
                                       }
                                       //
                                       /*if(!DomainMatch(Value.domain,domain)||!DomainMatch(Value.codomain,codomain))
                                       {
                                          printf(__FUNCSIG__+" mismatched domain and/or codomain... ");
                                          return(false);
                                       }*/
                                       // 
                                       int _index=Index(Value);//printf(__FUNCSIG__+" Index: "+IntegerToString(_index));
                                       //
                                       if(_index==-1)
                                       {
                                          if(ValueIndex>=0 && ValueIndex<Morphisms())
                                          {
                                             morphism[ValueIndex]=Value;//printf(__FUNCSIG__+" re-assigned... ");
                                             
                                             return(true);
                                          }
                                          else if(ValueIndex>=0 && ValueIndex<INT_MAX)
                                          {
                                             if(Morphisms(ValueIndex+1))
                                             {
                                                morphism[ValueIndex]=Value;//printf(__FUNCSIG__+" incremented... ");
                                                
                                                return(true);
                                             }
                                          }
                                       }
                                       
                                       return(false); 
                                    };
      
      
      int                           Index(CMorphism<TD,TC> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int m=0; m<Morphisms(); m++)
                                       {
                                          if(MorphismMatch(Value,morphism[m]))
                                          {
                                             _index=m; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CHomomorphism(void){  Morphisms(0); };
                                    ~CHomomorphism(void){};
   };
//+------------------------------------------------------------------+
//| ONTOLOGY ENUM                                                    |
//+------------------------------------------------------------------+
enum EOntology
  {
      ONTOLOGY_PRE=-1,
      ONTOLOGY_NEW=0,
      ONTOLOGY_POST=1
  };
//+------------------------------------------------------------------+
//| ONTOLOGY STRUCT                                                  |
//+------------------------------------------------------------------+
struct SOntology
  {
      int                           in;
      int                           out;
      
                                    SOntology()
                                    {
                                       in=-1;
                                       out=-1;
                                    };
                                    ~SOntology(){};
  };
//+------------------------------------------------------------------+
//| ONTOLOGY CLASS                                                   |
//+------------------------------------------------------------------+
class COntology
  {
      protected:
      
      int                           facts;
      
      SOntology                     types[];
      SOntology                     universe[];
      
      public:
      
      string                        ontology;
      
      int                           Facts() { return(facts); }
      bool                          Facts(int Value) { if(Value>=0 && Value<INT_MAX) { facts=Value; ArrayResize(types,facts); ArrayResize(universe,facts); return(true); } return(false); }
      
      bool                          GetType(int TypeIndex,int &TypeIn,int &TypeOut) { if(TypeIndex>=0 && TypeIndex<Facts()) { TypeIn=types[TypeIndex].in; TypeOut=types[TypeIndex].out; return(true); } return(false); }
      bool                          SetType(int ValueIndex,int ValueIn,int ValueOut) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Facts()) 
                                       { 
                                          types[ValueIndex].in=ValueIn; types[ValueIndex].out=ValueOut; 
                                          return(true); 
                                       } 
                                       else if(ValueIndex>=0 && ValueIndex>=Facts() && ValueIndex<INT_MAX-1) 
                                       { 
                                          if(Facts(ValueIndex+1))
                                          {
                                             types[ValueIndex].in=ValueIn; types[ValueIndex].out=ValueOut; 
                                             return(true); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      bool                          GetUniverse(int UniverseIndex,int &UniverseIn,int &UniverseOut) { if(UniverseIndex>=0 && UniverseIndex<Facts()) { UniverseIn=universe[UniverseIndex].in; UniverseOut=universe[UniverseIndex].out; return(true); } return(false); }
      bool                          SetUniverse(int ValueIndex,int ValueIn,int ValueOut) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Facts()) 
                                       { 
                                          universe[ValueIndex].in=ValueIn; universe[ValueIndex].out=ValueOut; 
                                          return(true); 
                                       } 
                                       else if(ValueIndex>=0 && ValueIndex>=Facts() && ValueIndex<INT_MAX-1) 
                                       { 
                                          if(Facts(ValueIndex+1))
                                          {
                                             universe[ValueIndex].in=ValueIn; universe[ValueIndex].out=ValueOut; 
                                             return(true); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      string                        old_hash;
      string                        new_hash;
      
                                    COntology()
                                    {
                                       ontology="";
                                       
                                       facts=0;
                                       
                                       ArrayResize(types,facts);
                                       ArrayResize(universe,facts);
                                       
                                       old_hash="";
                                       new_hash="";
                                    };
                                    ~COntology(){};
  };
//+------------------------------------------------------------------+
//| CATEGORY CLASS                                                   |
//+------------------------------------------------------------------+
class CCategory
   {
      protected:
      
      int                           domains_datetime;
      int                           domains_string;
      int                           domains_double;
      int                           domains_int;
      
      int                           ontologies;
      
      CDomain<datetime>             domain_datetime[];
      CDomain<string>               domain_string[];
      CDomain<double>               domain_double[];
      CDomain<int>                  domain_int[];
      
      COntology                     ontology[];
      
      public:
      
      int                           Domain(string T)
                                    { 
                                       if(T=="datetime"){ return(domains_datetime); }
                                       else if(T=="string"){ return(domains_string); }
                                       else if(T=="double"){ return(domains_double); }
                                       
                                       return(domains_int);
                                    };
      
      bool                          Domain(string T,int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       { 
                                          if(T=="datetime")
                                          { 
                                             if(ArrayResize(domain_datetime,Value)>=Value)
                                             {
                                                domains_datetime=Value;  
                                                return(true); 
                                             } 
                                          }
                                          else if(T=="string")
                                          { 
                                             if(ArrayResize(domain_string,Value)>=Value)
                                             {
                                                domains_string=Value;  
                                                return(true); 
                                             } 
                                          }
                                          else if(T=="double")
                                          { 
                                             if(ArrayResize(domain_double,Value)>=Value)
                                             {
                                                domains_double=Value;  
                                                return(true); 
                                             } 
                                          }
                                          else //if(T=="int")
                                          { 
                                             if(ArrayResize(domain_int,Value)>=Value)
                                             {
                                                domains_int=Value;  
                                                return(true);
                                             }  
                                          }
                                       } 
                                       
                                       return(false); 
                                    };
                                    
                                    
      int                           Ontology(){ return(ontologies); };
      bool                          Ontology(int Value){ if(Value>=0 && Value<INT_MAX){ ontologies=Value; ArrayResize(ontology,ontologies); return(true); } return(false); };
      
      
                                    template <typename T>
      bool                          Set(int ValueIndex,CDomain<T> &Value)
                                    {
                                       if(Index(Value)==-1 && ValueIndex>=0)
                                       {
                                          if
                                          (
                                          ValueIndex<Domain(string(typename(T)))
                                          ||
                                          (ValueIndex>=Domain(string(typename(T))) && Domain(string(typename(T)),ValueIndex+1))
                                          )
                                          {
                                             if(string(typename(T))=="datetime")
                                             {
                                                domain_datetime[ValueIndex]=Value;
                                                return(true);
                                             }
                                             else if(string(typename(T))=="string")
                                             {
                                                domain_string[ValueIndex]=Value;
                                                
                                                return(true);
                                             }
                                             else if(string(typename(T))=="double")
                                             {
                                                domain_double[ValueIndex]=Value;
                                                return(true);
                                             }
                                             else //if(string(typename(T))=="int")
                                             {
                                                domain_int[ValueIndex]=Value;
                                                return(true);
                                             }
                                          }
                                       }
                                       //
                                       return(false);
                                    };
                                    
                                    template <typename T>
      bool                          Get(int DomainIndex,CDomain<T> &D)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<Domain(string(typename(T))))
                                       {
                                          if(string(typename(T))=="datetime")
                                          {
                                             D=domain_datetime[DomainIndex];
                                             
                                             return(true);
                                          }
                                          else if(string(typename(T))=="string")
                                          {
                                             D=domain_string[DomainIndex];
                                             
                                             return(true);
                                          }
                                          else if(string(typename(T))=="double")
                                          {
                                             D=domain_double[DomainIndex];
                                             
                                             return(true);
                                          }
                                          else //if(string(typename(T))=="int")
                                          {
                                             D=domain_int[DomainIndex];
                                             
                                             return(true);
                                          }
                                       }
                                       
                                       return(false);
                                    };
                                    
      bool                          Set(int ValueIndex,COntology &Value)
                                    {
                                       if
                                       (
                                       ValueIndex>=0 && ValueIndex<Ontology()
                                       )
                                       {
                                          ontology[ValueIndex]=Value;
                                          return(true);
                                       }
                                       else if(ValueIndex>=Ontology())
                                       {
                                          if(Ontology(Ontology()+1))
                                          {
                                             ontology[Ontology()-1]=Value;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
                                    
      bool                          Get(int OntologyIndex,COntology &O)
                                    {
                                       if(OntologyIndex>=0 && OntologyIndex<Ontology())
                                       {
                                          O=ontology[OntologyIndex];
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    };
      
      
                                    template <typename T>
      int                           Index(CDomain<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<Domain(string(typename(T))); d++)
                                       {
                                          if(string(typename(T))=="string")
                                          {
                                             if(DomainMatch(Value,domain_string[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                          else if(string(typename(T))=="datetime")
                                          {
                                             if(DomainMatch(Value,domain_int[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                          else if(string(typename(T))=="double")
                                          {
                                             if(DomainMatch(Value,domain_double[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                          else if(string(typename(T))=="int")
                                          {
                                             if(DomainMatch(Value,domain_int[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      
      int                           Index(COntology &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int o=0; o<Ontology(); o++)
                                       {
                                          if(!OntologyMatch(Value,ontology[o]))
                                          {
                                             _index=o; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CCategory()
                                    { 
                                       domains_datetime=0; 
                                       domains_string=0; 
                                       domains_double=0; 
                                       domains_int=0; 
                                       
                                       ontologies=0; 
                                    };
                                    ~CCategory()
                                    { 
                                    };
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CComposition
   {
      protected:
      
      int                           projectors;
      string                        projector[];
      
      bool                          Projectors(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       {
                                          projectors=Value;
                                          ArrayResize(projector,projectors);
                                          return(true);
                                       }
                                       
                                       return(false); 
                                    };
      
      int                           Projectors(){ return(projectors); };
                                    
      public:
                                    
      string                        Get(int ProjectorIndex) { string _projector=""; if(ProjectorIndex>=0 && ProjectorIndex<Projectors()) { _projector=projector[ProjectorIndex]; } return(_projector); }
      bool                          Set(int ValueIndex,string Value) { if(ValueIndex>=0 && ValueIndex<Projectors()) { projector[ValueIndex]=Value; return(true); } return(false); }
      
   
                                    CComposition(void){ projectors=0;ArrayFree(projector); };
                                    ~CComposition(void){};
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CCone                         : public CComposition
   {              
      public:
      
      CDomain<string>               property;
      CHomomorphism<string,string>  universal_pullback;
      CHomomorphism<string,string>  universal_pushout;
      CDomain<string>               apex;
      
                                    CCone(void)
                                    {
                                       universal_pullback.domain=property;
                                       universal_pullback.domain=apex;
                                       //
                                       universal_pushout.domain=apex;
                                       universal_pushout.domain=property;
                                    };
                                    ~CCone(void){};
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CProduct                      :public CCone  
   {
      protected:
      
      CDomain<string>               surjector[];
      
      public:
      
      bool                          Surjectors(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       {
                                          CCone::Projectors(Value);
                                          ArrayResize(surjector,Value);
                                          return(true);
                                       }
                                       
                                       return(false); 
                                    };
      
      int                           Surjectors(){ return(CCone::projectors); };
                                    
      bool                          Get(int SurjectorIndex,CDomain<string> &Surjector) { if(SurjectorIndex>=0 && SurjectorIndex<CCone::Projectors()) { Surjector=surjector[SurjectorIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,CDomain<string> &Value) { if(ValueIndex>=0 && ValueIndex<CCone::Projectors()) { surjector[ValueIndex]=Value; return(true); } return(false); }
      
                                    CProduct(void){ ArrayFree(surjector); };
                                    ~CProduct(void){};
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CCoproduct                    :public CCone  
   {
      protected:
      
      CDomain<string>               injector[];
      
      public:
      
      bool                          Injectors(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       {
                                          CCone::Projectors(Value);
                                          ArrayResize(injector,Value);
                                          return(true);
                                       }
                                       
                                       return(false); 
                                    };
      
      int                           Injectors(){ return(CCone::projectors); };
                                    
      bool                          Get(int InjectorIndex,CDomain<string> &Injector) { if(InjectorIndex>=0 && InjectorIndex<CCone::Projectors()) { Injector=injector[InjectorIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,CDomain<string> &Value) { if(ValueIndex>=0 && ValueIndex<CCone::Projectors()) { injector[ValueIndex]=Value; return(true); } return(false); }
      
                                    CCoproduct(void){ ArrayFree(injector); };
                                    ~CCoproduct(void){};
   };
//+------------------------------------------------------------------+
//| INPUTS                                                           |
//+------------------------------------------------------------------+
input int __domain_elements=3;
input int __domain_morphisms=5;

input int __product_size=2;
input int __coproduct_size=3;
input ENUM_APPLIED_PRICE __product_price=PRICE_CLOSE;

#define  __DA 3 //Association domains per category
#define  __EA 5 //Association elements per domain

#define  __DC 5 //Commutation domains per category 
#define  __EC 2 //Commutation elements per domain

sinput datetime __test_start=D'2021.01.01';
sinput datetime __test_stop=D'2022.01.01';
sinput datetime __walk_start=D'2022.01.01';
sinput datetime __walk_stop=D'2022.12.01';

#define        __e_size 10

double         _f_mp_1[],_a_mp_1[];
double         _f_mp_2[],_a_mp_2[];

double         _f_ep_1[],_a_ep_1[];
double         _f_ep_2[],_a_ep_2[];
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
   {
      ////////////
      //EQUALIZERS
      ////////////
      
      double _atr[];
      MqlRates _prices[];
      int _atr_handle=iATR(_Symbol,_Period,14);
      
      ArraySetAsSeries(_prices,true);
      ArraySetAsSeries(_atr,true);
      
      int _copied_prices=CopyRates(_Symbol,_Period,__test_start,__test_stop,_prices);
      int _copied_atr=CopyBuffer(_atr_handle,0,0,_copied_prices,_atr);
      
      if(_copied_atr==_copied_prices)
      {
         ArraySetAsSeries(_prices,true);
         ArraySetAsSeries(_atr,true);
         
         CDomain<string> _d_atr; _d_atr.Cardinality(__e_size);
         CDomain<string> _d_price; _d_price.Cardinality(__e_size);
         
         CHomomorphism<string,string> _h_hypo,_h_test;
         
         _h_hypo.Morphisms(__e_size);
         _h_test.Morphisms(__e_size);
         
         int _counts[__e_size][__e_size];
         ArrayInitialize(_counts,0);
         
         for(int a=_copied_atr-3;a>=0;a--)
         {
            double _a=(_atr[a+1]-_atr[a+2])/fmax(_Point,_atr[a+2]);
            //
            double _p=((_prices[a].high-_prices[a].low)-(_prices[a+1].high-_prices[a+1].low))/fmax(_Point,(_prices[a+1].high-_prices[a+1].low));
            //
            int _a_index=-1,_p_index=-1;
            //
            if(-1.0<=_a && _a<-0.8){ _a_index=0; }
            else if(-0.8<=_a && _a<-0.6){ _a_index=1; }
            else if(-0.6<=_a && _a<-0.4){ _a_index=2; }
            else if(-0.4<=_a && _a<-0.2){ _a_index=3; }
            else if(-0.2<=_a && _a<0.0){ _a_index=4; }
            else if(0.0<=_a && _a<0.2){ _a_index=5; }
            else if(0.2<=_a && _a<0.4){ _a_index=6; }
            else if(0.4<=_a && _a<0.6){ _a_index=7; }
            else if(0.6<=_a && _a<0.8){ _a_index=8; }
            else if(0.8<=_a && _a<=1.0){ _a_index=9; }
            
            if(-1.0<=_p && _p<-0.8){ _p_index=0; }
            else if(-0.8<=_p && _p<-0.6){ _p_index=1; }
            else if(-0.6<=_p && _p<-0.4){ _p_index=2; }
            else if(-0.4<=_p && _p<-0.2){ _p_index=3; }
            else if(-0.2<=_p && _p<0.0){ _p_index=4; }
            else if(0.0<=_p && _p<0.2){ _p_index=5; }
            else if(0.2<=_p && _p<0.4){ _p_index=6; }
            else if(0.4<=_p && _p<0.6){ _p_index=7; }
            else if(0.6<=_p && _p<0.8){ _p_index=8; }
            else if(0.8<=_p && _p<=1.0){ _p_index=9; }
            
            if(_a_index!=-1 && _p_index!=-1){ _counts[_a_index][_p_index]++; }
         }
         
         //
         
         for(int s=0;s<__e_size;s++)
         {
            CElement<string> _e;_e.Cardinality(1);
            //
            int _band_start=(s*20)-100,_band_stop=(s*20)-80;
            _e.Set(0,IntegerToString(_band_start)+"%% to "+IntegerToString(_band_stop)+"%%");
            
            _d_atr.Set(s,_e);_d_price.Set(s,_e);
         }
         
         ArrayPrint(_counts,0,",");
         
         
         //
         
         _h_hypo.domain=_d_atr; _h_hypo.codomain=_d_price;
         _h_test.domain=_d_atr; _h_test.codomain=_d_price;
         
         //
         
         for(int s=0;s<__e_size;s++)
         {
            int _count=_counts[s][0],_index=0;
            //
            for(int ss=1;ss<__e_size;ss++)
            {
               if(_count<_counts[s][ss]){ _count=_counts[s][ss]; _index=ss; }
            }
            
            CMorphism<string,string> _m_test,_m_hypo;
            
            _m_test.Morph(_d_atr,_d_price,s,_index);
            _h_test.Set(s,_m_test);
            
            _m_hypo.Morph(_d_atr,_d_price,s,s);
            _h_hypo.Set(s,_m_hypo);
         }
         
         printf(__FUNCSIG__+" hypo hom-set: "+PrintHomomorphism(_h_hypo));
         printf(__FUNCSIG__+" test hom-set: "+PrintHomomorphism(_h_test));
         
         CDomain<string> _equalizer;
         
         for(int s=0;s<__e_size;s++)
         {
            CMorphism<string,string> _m_hypo,_m_test;
            if(_h_hypo.Get(s,_m_hypo) && _h_test.Get(s,_m_test))
            {
               if(_m_hypo.Codomain()==_m_test.Codomain())
               {
                  //printf(__FUNCSIG__+" hypo: "+IntegerToString(_m_hypo.Codomain())+" test: "+IntegerToString(_m_test.Codomain()));
                         
                  ResetLastError();
                  if(_equalizer.Cardinality(_equalizer.Cardinality()+1))
                  {
                     ResetLastError();
                     CElement<string> _e_dom;
                     if(!_d_atr.Get(_m_hypo.Codomain(),_e_dom) || !_equalizer.Set(_equalizer.Cardinality()-1,_e_dom))
                     {
                         printf(__FUNCSIG__+" failed to asign equalizer value, err: "+IntegerToString(GetLastError()));
                     }
                  }
                  else{ printf(__FUNCSIG__+" failed to resize equalizer domain, err: "+IntegerToString(GetLastError())); }
               }
            }
         }
         
         if(_equalizer.Cardinality()>0){ printf(__FUNCSIG__+" eq dom: "+PrintDomain(_equalizer)); }
      }
      
      
      
      ///////////////////////
      //MONOMORPHIC PULLBACKS
      ///////////////////////
      
      string _results_mp_1[][6],_results_mp_2[][6];//,_results_ep_1[][6],_results_ep_2[][6];
         
      MqlRates _usdx[];
      MqlRates _eurusd[],_usdjpy[],_eurjpy[];
      ArraySetAsSeries(_usdx,true);
      ArraySetAsSeries(_eurusd,true);ArraySetAsSeries(_usdjpy,true);ArraySetAsSeries(_eurjpy,true);
      int _copied_usdx=CopyRates("USDX-JUN23",PERIOD_W1,D'2020.07.01',D'2022.01.01',_usdx);
      if(_copied_usdx>=67)
      {
         ArraySetAsSeries(_usdx,true);
         
         int _start_index=0;
         for(int c=_copied_usdx-1;c>=0;c--)
         {
            if(_usdx[c].time>=D'2021.07.01')
            {
               _start_index=c; break;
            }
         }
         
         //
         InitResultsMP(_start_index,_results_mp_1);
         InitResultsMP(_start_index,_results_mp_2);
         
         ArrayResize(_f_mp_1,(_start_index+2));ArrayResize(_a_mp_1,(_start_index+2));
         ArrayInitialize(_f_mp_1,0.0);ArrayInitialize(_a_mp_1,0.0);
         
         ArrayResize(_f_mp_2,(_start_index+2));ArrayResize(_a_mp_2,(_start_index+2));
         ArrayInitialize(_f_mp_2,0.0);ArrayInitialize(_a_mp_2,0.0);
         
         if(_copied_usdx-_start_index>2*21)
         {
            int _copied_eurusd=CopyRates("EURUSD",PERIOD_W1,D'2020.07.01',D'2022.01.01',_eurusd);
            int _copied_usdjpy=CopyRates("USDJPY",PERIOD_W1,D'2020.07.01',D'2022.01.01',_usdjpy);
            int _copied_eurjpy=CopyRates("EURJPY",PERIOD_W1,D'2020.07.01',D'2022.01.01',_eurjpy);
            
            for(int i=_start_index;i>=0;i--)
            {
               double _21=Correlation(_start_index,i,21,_usdx);
               //
               double _13=Correlation(_start_index,i,13,_usdx);
               //
               double _8=Correlation(_start_index,i,8,_usdx);
               //
               double _5=Correlation(_start_index,i,5,_usdx);
               //
               double _3=Correlation(_start_index,i,3,_usdx);
               
               if(_copied_eurusd>=_copied_usdx && _copied_usdjpy>=_copied_usdx)
               {
                  ArraySetAsSeries(_eurusd,true);ArraySetAsSeries(_usdjpy,true);ArraySetAsSeries(_eurjpy,true);
                  
                  if(_21>=_13 && _21>=_8 && _21>=_5 && _21>=_3)
                  {
                     Morph_MP_1(_start_index,i,21,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_1);
                     Morph_MP_2(_start_index,i,21,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_2);
                  }
                  else if(_21<=_13 && _13>=_8 && _13>=_5 && _13>=_3)
                  {
                     Morph_MP_1(_start_index,i,13,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_1);
                     Morph_MP_2(_start_index,i,13,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_2);
                  }
                  else if(_21<=_8 && _13<=_8 && _8>=_5 && _8>=_3)
                  {
                     Morph_MP_1(_start_index,i,8,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_1);
                     Morph_MP_2(_start_index,i,8,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_2);
                  }
                  else if(_21<=_5 && _13<=_5 && _8<=_5 && _5>=_3)
                  {
                     Morph_MP_1(_start_index,i,5,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_1);
                     Morph_MP_2(_start_index,i,5,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_2);
                  }
                  else if(_21<=_3 && _13<=_3 && _8<=_3 && _5<=_3)
                  {
                     Morph_MP_1(_start_index,i,3,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_1);
                     Morph_MP_2(_start_index,i,3,_usdx[i].time,_eurusd,_usdjpy,_eurjpy,_results_mp_2);
                  }  
               }
               
               //
               
               /*if(i==0)
               {
                  CDomain<int> _usdx_d;
                  CDomain<string> _eurusd_d,_usdjpy_d;
                  CDomain<string> _eurjpy_d;
                  
                  double _eu3=Correlation(_start_index,i,3,_eurusd);
                  double _eu5=Correlation(_start_index,i,5,_eurusd);
                  double _eu8=Correlation(_start_index,i,8,_eurusd);
                  double _eu13=Correlation(_start_index,i,13,_eurusd);
                  double _eu21=Correlation(_start_index,i,21,_eurusd);
                  
                  double _uj3=Correlation(_start_index,i,3,_usdjpy);
                  double _uj5=Correlation(_start_index,i,5,_usdjpy);
                  double _uj8=Correlation(_start_index,i,8,_usdjpy);
                  double _uj13=Correlation(_start_index,i,13,_usdjpy);
                  double _uj21=Correlation(_start_index,i,21,_usdjpy);
                  
                  double _ej3=Correlation(_start_index,i,3,_usdjpy);
                  double _ej5=Correlation(_start_index,i,5,_usdjpy);
                  double _ej8=Correlation(_start_index,i,8,_usdjpy);
                  double _ej13=Correlation(_start_index,i,13,_usdjpy);
                  double _ej21=Correlation(_start_index,i,21,_usdjpy);
                  
                  
                  //double _forecast=MathPow((_eu+1.0)*(_uj+1.0),0.5)-1.0;
                  
                  //uniform 3,5,8,13,21 period bucketting
                  //
                  //usdx pull-back
                  _usdx_d.Cardinality(5);
                  CElement<int> _e_ux_3; _e_ux_3.Cardinality(1); _e_ux_3.Set(0,3); _usdx_d.Set(0,_e_ux_3,true);
                  CElement<int> _e_ux_5; _e_ux_5.Cardinality(1); _e_ux_5.Set(0,5); _usdx_d.Set(1,_e_ux_5,true);
                  CElement<int> _e_ux_8; _e_ux_8.Cardinality(1); _e_ux_8.Set(0,8); _usdx_d.Set(2,_e_ux_8,true);
                  CElement<int> _e_ux_13; _e_ux_13.Cardinality(1); _e_ux_13.Set(0,13); _usdx_d.Set(3,_e_ux_13,true);
                  CElement<int> _e_ux_21; _e_ux_21.Cardinality(1); _e_ux_21.Set(0,21); _usdx_d.Set(4,_e_ux_21,true);
                  
                  //eurusd factor
                  _eurusd_d.Cardinality(5);
                  CElement<string> _e_eu_3; _e_eu_3.Cardinality(1); _e_eu_3.Set(0,int_double(3,_eu3)); _eurusd_d.Set(0,_e_eu_3,true);
                  CElement<string> _e_eu_5; _e_eu_5.Cardinality(1); _e_eu_5.Set(0,int_double(5,_eu5)); _eurusd_d.Set(1,_e_eu_5,true);
                  CElement<string> _e_eu_8; _e_eu_8.Cardinality(1); _e_eu_8.Set(0,int_double(8,_eu8)); _eurusd_d.Set(2,_e_eu_8,true);
                  CElement<string> _e_eu_13; _e_eu_13.Cardinality(1); _e_eu_13.Set(0,int_double(13,_eu13)); _eurusd_d.Set(3,_e_eu_13,true);
                  CElement<string> _e_eu_21; _e_eu_21.Cardinality(1); _e_eu_21.Set(0,int_double(21,_eu21)); _eurusd_d.Set(4,_e_eu_21,true);
                  
                  //usdjpy factor
                  _usdjpy_d.Cardinality(5);
                  CElement<string> _e_uj_3; _e_uj_3.Cardinality(1); _e_uj_3.Set(0,int_double(3,_uj3)); _usdjpy_d.Set(0,_e_uj_3,true);
                  CElement<string> _e_uj_5; _e_uj_5.Cardinality(1); _e_uj_5.Set(0,int_double(5,_uj5)); _usdjpy_d.Set(1,_e_uj_5,true);
                  CElement<string> _e_uj_8; _e_uj_8.Cardinality(1); _e_uj_8.Set(0,int_double(8,_uj8)); _usdjpy_d.Set(2,_e_uj_8,true);
                  CElement<string> _e_uj_13; _e_uj_13.Cardinality(1); _e_uj_13.Set(0,int_double(13,_uj13)); _usdjpy_d.Set(3,_e_uj_13,true);
                  CElement<string> _e_uj_21; _e_uj_21.Cardinality(1); _e_uj_21.Set(0,int_double(21,_uj21)); _usdjpy_d.Set(4,_e_uj_21,true);
                  
                  //eurjpy product
                  _eurjpy_d.Cardinality(5);
                  CElement<string> _e_ej_3; _e_ej_3.Cardinality(1); _e_ej_3.Set(0,double_double(0.0,_ej3)); _eurjpy_d.Set(0,_e_ej_3,true);
                  CElement<string> _e_ej_5; _e_ej_5.Cardinality(1); _e_ej_5.Set(0,double_double(5,0.0)); _eurjpy_d.Set(1,_e_ej_5,true);
                  CElement<string> _e_ej_8; _e_ej_8.Cardinality(1); _e_ej_8.Set(0,double_double(8,0.0)); _eurjpy_d.Set(2,_e_ej_8,true);
                  CElement<string> _e_ej_13; _e_ej_13.Cardinality(1); _e_ej_13.Set(0,double_double(13,0.0)); _eurjpy_d.Set(3,_e_ej_13,true);
                  CElement<string> _e_ej_21; _e_ej_21.Cardinality(1); _e_ej_21.Set(0,double_double(21,0.0)); _eurjpy_d.Set(4,_e_ej_21,true);
               }*/
            }
         }
         
         ArrayPrint(_results_mp_1,0,",");
         
         double _r_1=0.0;
         MathCorrelationSpearman(_f_mp_1,_a_mp_1,_r_1);
         printf(__FUNCSIG__+" analysis and actual correlation is: "+DoubleToString(_r_1));
         
         ArrayPrint(_results_mp_2,0,",");
         
         double _r_2=0.0;
         MathCorrelationSpearman(_f_mp_2,_a_mp_2,_r_2);
         printf(__FUNCSIG__+" analysis and actual correlation is: "+DoubleToString(_r_2));
      }
      
      
      
      /////////////////////
      //EPIMORPHIC PUSHOUTS
      /////////////////////
      
      string _results_ep_1[][7],_results_ep_2[][7];
      
      MqlRates _bollinger[];
      ArraySetAsSeries(_bollinger,true);
      int _copied_bollinger=CopyRates(_Symbol,PERIOD_W1,D'2020.07.01',D'2022.01.01',_bollinger);
      if(_copied_bollinger>=67)
      {
         ArraySetAsSeries(_bollinger,true);
         
         int _start_index=0;
         for(int c=_copied_bollinger-1;c>=0;c--)
         {
            if(_bollinger[c].time>=D'2021.07.01')
            {
               _start_index=c; break;
            }
         }
         
         //
         InitResultsEP(_start_index,_results_ep_1);
         InitResultsEP(_start_index,_results_ep_2);
         
         ArrayResize(_f_ep_1,(_start_index+2));ArrayResize(_a_ep_1,(_start_index+2));
         ArrayInitialize(_f_ep_1,0.0);ArrayInitialize(_a_ep_1,0.0);
         
         ArrayResize(_f_ep_2,(_start_index+2));ArrayResize(_a_ep_2,(_start_index+2));
         ArrayInitialize(_f_ep_2,0.0);ArrayInitialize(_a_ep_2,0.0);
         
         if(_copied_bollinger-_start_index>2*21)
         {
            for(int i=_start_index;i>=0;i--)
            {
               double _21=Deviation(_start_index,i,21,_bollinger);
               //
               double _13=Deviation(_start_index,i,13,_bollinger);
               //
               double _8=Deviation(_start_index,i,8,_bollinger);
               //
               double _5=Deviation(_start_index,i,5,_bollinger);
               //
               double _3=Deviation(_start_index,i,3,_bollinger);
            
               if(_21>=_13 && _21>=_8 && _21>=_5 && _21>=_3)
               {
                  Morph_EP_1(_start_index,i,21,_usdx[i].time,_bollinger,_results_ep_1);
                  Morph_EP_2(_start_index,i,21,_usdx[i].time,_bollinger,_results_ep_2);
               }
               else if(_21<=_13 && _13>=_8 && _13>=_5 && _13>=_3)
               {
                  Morph_EP_1(_start_index,i,13,_usdx[i].time,_bollinger,_results_ep_1);
                  Morph_EP_2(_start_index,i,13,_usdx[i].time,_bollinger,_results_ep_2);
               }
               else if(_21<=_8 && _13<=_8 && _8>=_5 && _8>=_3)
               {
                  Morph_EP_1(_start_index,i,8,_usdx[i].time,_bollinger,_results_ep_1);
                  Morph_EP_2(_start_index,i,8,_usdx[i].time,_bollinger,_results_ep_2);
               }
               else if(_21<=_5 && _13<=_5 && _8<=_5 && _5>=_3)
               {
                  Morph_EP_1(_start_index,i,5,_usdx[i].time,_bollinger,_results_ep_1);
                  Morph_EP_2(_start_index,i,5,_usdx[i].time,_bollinger,_results_ep_2);
               }
               else if(_21<=_3 && _13<=_3 && _8<=_3 && _5<=_3)
               {
                  Morph_EP_1(_start_index,i,3,_usdx[i].time,_bollinger,_results_ep_1);
                  Morph_EP_2(_start_index,i,3,_usdx[i].time,_bollinger,_results_ep_2);
               }
            }
         }
         
         ArrayPrint(_results_ep_1,0,",");
         
         double _r_1=0.0;
         MathCorrelationSpearman(_f_ep_1,_a_ep_1,_r_1);
         printf(__FUNCSIG__+" 1 analysis and actual correlation is: "+DoubleToString(_r_1));
         
         double _r_2=0.0;
         MathCorrelationSpearman(_f_ep_2,_a_ep_2,_r_2);
         printf(__FUNCSIG__+" 2 analysis and actual correlation is: "+DoubleToString(_r_2));
      }
   } 
//+------------------------------------------------------------------+
//| Create Simple Domain(Set) of natural numbers                     |
//+------------------------------------------------------------------+
template <typename T>
void FillDomain(CDomain<T> &D,int Cardinal,bool Odd=false)
   {
      if(Cardinal<0||INT_MAX<=Cardinal)
      {
         return;
      }
      
      //Set its cardinal to input value
      D.Cardinality(Cardinal);
      
      //Assign numbers to the domain in ascending order
      for(int c=0;c<Cardinal*2;c++)
      {
         int _index=int(floor(c/2.0));
         //
         if(!Odd)
         {
            if(c%2==0)
            {
               CElement<T> _e;
               
               ResetLastError();
               
               if(!_e.Cardinality(1)||!_e.Set(0,c)||!D.Set(_index,_e,true))
               {
                  printf(__FUNCSIG__+" failed assigning: "+IntegerToString(c)+", at index: "+IntegerToString(_index)+" with err: "+IntegerToString(GetLastError()));
               }
            }
         }
         else
         {
            if(c%2==1)
            {
               CElement<T> _e;
               
               ResetLastError();
               
               if(!_e.Cardinality(1)||!_e.Set(0,c)||!D.Set(_index,_e,true))
               {
                  printf(__FUNCSIG__+" failed assigning: "+IntegerToString(c)+", at index: "+IntegerToString(_index)+" with err: "+IntegerToString(GetLastError()));
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Fill Domain(Set) with one-cardinal elements from input E array.  |
//+------------------------------------------------------------------+
template <typename TD,typename TE>
void FillDomain(CDomain<TD> &D,CElement<TE> &E[])
   {
      if(string(typename(TD))!=string(typename(TE)))
      {
         return;
      }
      
      int _cardinal=ArraySize(E);
      //
      if(_cardinal<0||INT_MAX<=_cardinal)
      {
         return;
      }
      
      //Set its cardinal to input array size
      if(D.Cardinality(_cardinal))
      {
         for(int c=0;c<_cardinal;c++)
         {
            D.Set(c,E[c],true);
         }
      }
   }
//+------------------------------------------------------------------+
//| Fill Domain with handle data.                                    |
//+------------------------------------------------------------------+
template <typename T>
bool FillDomain(CDomain<T> &D,int Index,int Size,int &Handle,int Buffer=0)
   {
      double _buffer[];ArrayResize(_buffer,Size);ArrayInitialize(_buffer,0.0);
      
      if(CopyBuffer(Handle,Buffer,0,Size,_buffer)>=Size)
      {
         for(int p=0;p<Size;p++)
         {
            CElement<double> _e;
            if(_e.Cardinality(1))
            {
               if(_e.Set(0,_buffer[p]))
               { 
                  D.Set(p,_e); 
               }
            }
         }
      }
      
      return(true);
   }
//+------------------------------------------------------------------+
//| Element Match function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool ElementMatch(CElement<TA> &A,CElement<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int r=0; r<A.Cardinality(); r++)
      {
         if(A.Get(r)!=B.Get(r))
         {
            _matched=false;
            break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Domain Match function                                            |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool DomainMatch(CDomain<TA> &A,CDomain<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         //printf(__FUNCSIG__+" type mismatch. ");
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         //printf(__FUNCSIG__+" cardinality mismatch. ");
         return(false);
      }
      
      /*if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }*/
      
      bool _matched=true;
      
      for(int o=0; o<A.Cardinality(); o++)
      {
         CElement<TA> _a;
         CElement<TB> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !ElementMatch(_a,_b))
         {
            //printf(__FUNCSIG__+" element mismatch at: "+IntegerToString(o));
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Morphism Match function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool MorphismMatch(CMorphism<TD,TC> &A,CMorphism<TD,TC> &B)
   {
      bool _matched=true;
      
      if(A.Domain()!=B.Domain()||A.Codomain()!=B.Codomain())
      {
         _matched=false;return(_matched);
      }
      
      if(!DomainMatch(A.domain,B.domain)||!DomainMatch(A.codomain,B.codomain))
      {
         _matched=false;return(_matched);
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Homomorphism Match function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool HomomorphismMatch(CHomomorphism<TD,TC> &A,CHomomorphism<TD,TC> &B)
   {
      if(A.Morphisms()!=B.Morphisms())
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int m=0; m<A.Morphisms(); m++)
      {
         CMorphism<TD> _a;
         CMorphism<TC> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !MorphismMatch(_a,_b))
         {
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Ontology Match function                                          |
//+------------------------------------------------------------------+
bool OntologyMatch(COntology &A,COntology &B)
   {
      if(A.Facts()!=B.Facts())
      {
         return(false);
      }
      
      if(A.ontology!=B.ontology)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int o=0; o<A.Facts(); o++)
      {
         int _a_t_in=-1,_a_t_out=-1,_a_u_in=-1,_a_u_out=-1;
         int _b_t_in=-1,_b_t_out=-1,_b_u_in=-1,_b_u_out=-1;
         
         if(A.GetType(o,_a_t_in,_a_t_out) && B.GetType(o,_b_t_in,_b_t_out) && A.GetUniverse(o,_a_u_in,_a_u_out) && B.GetUniverse(o,_b_u_in,_b_u_out))
         {
            if(_a_t_in!=_b_t_in||_a_t_out!=_b_t_out||_a_u_in!=_b_u_in||_a_u_out!=_b_u_out)
            {
               _matched=false; break;
            }
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Print Element function                                           |
//+------------------------------------------------------------------+
template <typename T>
string PrintElement(CElement<T> &E,int FloatPrecision=1)
   {
      string _element="(";
      //
      for(int r=0; r<E.Cardinality(); r++)
      {
         if(string(typename(T))=="datetime")
         {
            _element+=TimeToString(datetime(E.Get(r)));
         }
         else if(string(typename(T))=="string")
         {
            _element+=string(E.Get(r));
         }
         else if(string(typename(T))=="double"||string(typename(T))=="float")
         {
            _element+=DoubleToString(double(E.Get(r)),FloatPrecision);
         }
         else //if(string(typename(T))=="int")
         {
            _element+=IntegerToString(int(E.Get(r)));
         }
         
         if(r<E.Cardinality()-1){ _element+=","; }
      }
      //
      return(_element+")");
   }
//+------------------------------------------------------------------+
//| Print Morphism function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintMorphism(CMorphism<TD,TC> &M,int FloatPrecision=1)
   {
      string _morphism="";
      //
      CElement<TD> _d;
      CElement<TC> _c;
      ResetLastError();
      if(M.domain.Get(M.Domain(),_d) && M.codomain.Get(M.Codomain(),_c))
      {
         _morphism=PrintElement(_d,FloatPrecision);
         _morphism+="|----->";
         _morphism+=PrintElement(_c,FloatPrecision);
         _morphism+="\n";
      }
      else
      {
         //printf(__FUNCSIG__+" could not get element from: "+OBJECT_NAME(M.Domain)+", at domain index: "+IntegerToString(M.Domain())+" and/or "+OBJECT_NAME(M.Codomain)+", at codomain index: "+IntegerToString(M.Codomain())+", err: "+IntegerToString(GetLastError()));
      }
      //
      return(_morphism);
   }
//+------------------------------------------------------------------+
//| Print Domain function                                            |
//+------------------------------------------------------------------+
template <typename T>
string PrintDomain(CDomain<T> &D,int FloatPrecision=1)
   {
      string _domain="{";
      //
      CElement<T> _e;
      for(int o=0; o<D.Cardinality(); o++)
      {
         D.Get(o,_e);
         _domain+=PrintElement(_e,FloatPrecision);if(o<D.Cardinality()-1){ _domain+=","; }
      }
      //
      return(_domain+"}\n");
   }
//+------------------------------------------------------------------+
//| Print Homomorphism function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintHomomorphism(CHomomorphism<TD,TC> &H,int FloatPrecision=1)
   {
      string _homomorphism="\n\n"+PrintDomain(H.domain,FloatPrecision);
      //
      _homomorphism+="|\n";
      
      CMorphism<TD,TC> _m;
      for(int m=0;m<H.Morphisms();m++)
      {
         if(H.Get(m,_m))
         {
            _homomorphism+=(PrintMorphism(_m,FloatPrecision));
         }
      }
      //
      _homomorphism+="|\n";
      
      _homomorphism+=PrintDomain(H.codomain,FloatPrecision);
      //
      return(_homomorphism);
   }
//+------------------------------------------------------------------+
//| Get Subdomains function                                          |
//+------------------------------------------------------------------+
template <typename T>
void GetSubdomains(CDomain<T> &D,int &SubdomainCount,CDomain<T> &Subdomains[])
   {
      for(int o=1; o<=D.Cardinality(); o++)
      {
         GetSubdomains(D,0,0,o,SubdomainCount,Subdomains);
      }
   }
//+------------------------------------------------------------------+
//| Get Subdomains function                                          |
//+------------------------------------------------------------------+
template <typename T>
void GetSubdomains(CDomain<T> &D,int Start,int Index,int Number,int &SubdomainCount,CDomain<T> &Subdomains[])
   {
      // Get domain cardinal
      int _n = D.Cardinality();
      
      int _i,_j;
      
      if(Index-Start+1==Number)
      {
         if(Number==1)
         {
            CElement<T> _e;
            
            if(_e.Cardinality(0))
            {
               for(_i=0; _i<_n; _i++)
               {
                  SubdomainCount++;
                  ArrayResize(Subdomains,SubdomainCount);
                  
                  if(ArraySize(Subdomains)==SubdomainCount && Subdomains[SubdomainCount-1].Cardinality(0) && D.Get(_i,_e) && Subdomains[SubdomainCount-1].Cardinality(1))
                  {
                     Subdomains[SubdomainCount-1].Set(0,_e,true);
                  }
               }
            }
         }
         else
         {
            for(_j=Index; _j<_n; _j++)
            {
               SubdomainCount++;
               ArrayResize(Subdomains,SubdomainCount);
               
               CElement<T> _e;
               
               if(_e.Cardinality(0) && ArraySize(Subdomains)==SubdomainCount && Subdomains[SubdomainCount-1].Cardinality(0))
               {
                  for(_i=Start; _i<Index; _i++)
                  {
                     if(D.Get(_i,_e) && Subdomains[SubdomainCount-1].Cardinality(Subdomains[SubdomainCount-1].Cardinality()+1))
                     {
                        Subdomains[SubdomainCount-1].Set(Subdomains[SubdomainCount-1].Cardinality()-1,_e,true);
                     }
                  }
                  
                  if(D.Get(_j,_e) && Subdomains[SubdomainCount-1].Cardinality(Subdomains[SubdomainCount-1].Cardinality()+1))
                  {
                     Subdomains[SubdomainCount-1].Set(Subdomains[SubdomainCount-1].Cardinality()-1,_e,true);
                  }
               }
            }
            
            if(Start!=_n-Number)
            {
               GetSubdomains(D,Start+1,Start+1,Number,SubdomainCount,Subdomains);
            }
         }
      }
      else
      {
         GetSubdomains(D,Start,Index+1,Number,SubdomainCount,Subdomains);
      }
   }
//+------------------------------------------------------------------+
//| Is Subdomain function                                            |
//+------------------------------------------------------------------+
template <typename T>
bool IsSubdomain(CDomain<T> &Domain,CDomain<T> &SubDomain)
   {
      bool _is_subdomain=false;
      
      int _subdomain_count=0; CDomain<T> _subdomains[];
      GetSubdomains(Domain,_subdomain_count,_subdomains);
      
      for(int c=0;c<_subdomain_count;c++)
      {
         if(DomainMatch(SubDomain,_subdomains[c]))
         {
            _is_subdomain=true;
            break;
         }
      }
      
      return(_is_subdomain);
   }
//+------------------------------------------------------------------+
//| Image function                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
void Image(CHomomorphism<TD,TC> &H,CDomain<TC> &Output)
   {
      for(int m=0;m<H.Morphisms();m++)
      {
         CElement<TC> _e;
         CMorphism<TD,TC> _m;
         if(H.Get(m,_m) && H.codomain.Get(_m.Codomain(),_e))
         {
            bool _matched=false;
            for(int o=0;o<Output.Cardinality();o++)
            {
               CElement<TC> _ee;
               if(Output.Get(o,_ee) && ElementMatch(_e,_ee))
               {
                  _matched=true; break;
               }
            }
            
            if(!_matched)
            {
               Output.Cardinality(Output.Cardinality()+1);
               Output.Set(Output.Cardinality()-1,_e,true);
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Get Isomorphisms function                                        |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool IsIsomorphic(CDomain<TD> &A,CDomain<TC> &B,CHomomorphism<TD,TC> &Output[])
   {
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      int _cardinal=A.Cardinality();
      
      uint _factorial=MathFactorial(_cardinal);
      
      ArrayResize(Output,_factorial);
      
      for(uint f=0;f<_factorial;f++)
      {
         ArrayResize(Output[f].morphism,_cardinal);
         //
         for(int c=0;c<_cardinal;c++)
         {
            Output[f].morphism[c].domain=A;
            Output[f].morphism[c].codomain=B;
         }
      }
      
      int _index=0;
      CDomain<TC> _output[];ArrayResize(_output,_factorial);
      GetIsomorphisms(B, 0, _cardinal-1, _cardinal, _index, _output);
      
      for(uint f=0;f<_factorial;f++)
      {
         for(int c=0;c<_cardinal;c++)
         {
            CElement<TC> _ec;
            if(_output[f].Get(c,_ec))
            {
               for(int cc=0;cc<_cardinal;cc++)
               {
                  CElement<TC> _ecc;
                  if(B.Get(cc,_ecc))
                  {
                     if(ElementMatch(_ec,_ecc))
                     {
                        if(Output[f].morphism[c].Codomain(cc))
                        {
                           break;
                        }
                     }
                  }
               }
            }
            
            if(Output[f].morphism[c].Domain(c))
            {
            }
         }
      }
         
      return(true);
   }
//+------------------------------------------------------------------+
//| Get Isomorphisms function                                        |
//+------------------------------------------------------------------+
template <typename T>
void GetIsomorphisms(CDomain<T> &B,int Start,int Stop,int Cardinality,int &Index,CDomain<T> &Output[]) 
   {
      if(Start == Stop) 
      {
         Output[Index].Cardinality(0);
         Output[Index].Cardinality(B.Cardinality());
         // the permutation
         for (int i = 0; i <= Stop; i++) 
         {
            CElement<T> _e;
            if(B.Get(i,_e))
            {
               Output[Index].Set(i,_e,true);
            }
         }
         
         Index++;
      } 
      else 
      {
         CElement<T> _e;
         if(B.Get(Start,_e))
         {
            for (int i = Start; i <= Stop; i++) 
            {
               // swap the elements at indices start and i
               CElement<T> _ei;
               if(B.Get(i,_ei))
               {
                  CElement<T> _temp = _e;
                  if(B.Set(Start,_ei))
                  {
                     if(B.Set(i,_e))
                     {
                        // recursively permute the remaining elements
                        GetIsomorphisms(B, Start + 1, Stop, Cardinality, Index, Output);
                     
                        // swap the elements back to their original positions
                        if(B.Set(Start,_e))
                        {
                           B.Set(i,_ei);
                        }
                     }
                  }
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Factorial function                                               |
//+------------------------------------------------------------------+
uint MathFactorial(uint N)
   {
      uint _factorial=N,_n=N-1;
      
      while(_n>0)
      {
         _factorial*=_n;
         
         _n--;
         
         if(_n<=0){ break; }
      }
      
      return(_factorial);
   }
//+------------------------------------------------------------------+
//| Set Ontology function                                            |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool SetCategory(CCategory &C,int DomainIndex,int CodomainIndex,int TypeIndex,int CotypeIndex,COntology &Log,string Aspect,CMorphism<TD,TC> &Output,EOntology LogType=ONTOLOGY_NEW)
   {
      if(Log.Facts(Log.Facts()+1))
      {
         int _fact=Log.Facts()-1;
         
         if(Log.SetType(_fact,TypeIndex,CotypeIndex) && Log.SetUniverse(_fact,DomainIndex,CodomainIndex))
         {
            CDomain<TD> _dd;
            CDomain<TC> _dc;
            CElement<TD> _ed;
            CElement<TC> _ec;
            
            if(C.Get(DomainIndex,_dd) && C.Get(CodomainIndex,_dc))
            {
               if(_dd.Get(TypeIndex,_ed) && _dc.Get(CotypeIndex,_ec))
               {
                  string _eds="",_ecs="";
                  for(int c=0;c<_ed.Cardinality();c++){ _eds+=string(_ed.Get(c)); }
                  for(int c=0;c<_ec.Cardinality();c++){ _ecs+=string(_ec.Get(c)); }
                  
                  if(LogType==ONTOLOGY_NEW)
                  {
                     Log.ontology=_eds+Aspect+_ecs;
                  }
                  else if(LogType==ONTOLOGY_POST)
                  {
                     Log.ontology=Log.ontology+Aspect+_ecs;
                  }
                  else if(LogType==ONTOLOGY_PRE)
                  {
                     Log.ontology=_eds+Aspect+Log.ontology;
                  }
                  
                  Log.old_hash=Log.new_hash;
                  int _u_in=-1,_t_in=-1,_u_out=-1,_t_out=-1;
                  //
                  if(Log.GetUniverse(DomainIndex,_u_in,_u_out) && Log.GetType(TypeIndex,_t_in,_t_out))
                  {
                     string _encoding=IntegerToString(_u_in)+"-"+IntegerToString(_t_in)+"-"+IntegerToString(_u_out)+"-"+IntegerToString(_t_out);
                     
                     uchar _encoded_string[];
                     string _encoded=EncodeString(_encoding,_encoded_string);
                     
                     Log.new_hash=EncodeHEX(_encoded_string);
                  }
                  
                  if(Output.Morph(_dd,_dc,_ed,_ec))
                  {
                     return(true);
                  }
               }
            }
         }
      }
      
      return(false);
   }
//+------------------------------------------------------------------+
//| Encode string to HEX function                                    |
//+------------------------------------------------------------------+
string EncodeHEX(uchar &EncodedString[],int Count=-1)
   {
      string _hex="";
      
      if(Count<0 || Count>ArraySize(EncodedString)){ Count=ArraySize(EncodedString); }
      
      for(int c=0;c<Count;c++)
      {
         _hex+=StringFormat("%.2X",EncodedString[c]);
      }
      
      return(_hex);
   }
//+------------------------------------------------------------------+
//| Encode HEX to hash function                                      |
//+------------------------------------------------------------------+
string EncodeString(string RawString,uchar &EncodedString[])
   {
      uchar _source[],_key[],_hashkey[];
      ArrayResize(_key,8);
      for(int k=0;k<8;k++){ _key[k]=uchar((k*5)%13); }
      
      StringToCharArray(TimeToString(TimeCurrent()),_source,0,fmin(StringLen(TimeToString(TimeCurrent())),StringLen(RawString)));
      
      ResetLastError();
      if(CryptEncode(CRYPT_HASH_SHA1,_source,_key,_hashkey)<1)
      {
         printf(__FUNCSIG__+" encode err: "+IntegerToString(GetLastError()));
      }
      
      StringToCharArray(RawString,_source,0,StringLen(RawString));
      
      ResetLastError();
      if(CryptEncode(CRYPT_HASH_SHA1,_source,_hashkey,EncodedString)<1)
      {
         printf(__FUNCSIG__+" encode err: "+IntegerToString(GetLastError()));
      }
      
      return(CharArrayToString(EncodedString));
   }
//+------------------------------------------------------------------+
//| Get Product function                                             |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
void GetProduct(CDomain<TA> &A,CDomain<TB> &B,CProduct &Output,int FloatPrecision=2)
   {
      int _cardinal_a=A.Cardinality(),_cardinal_b=B.Cardinality();
      
      if(_cardinal_a==0||_cardinal_b==0)
      {
         return;
      }
      //
      CDomain<string> _a,_b;
      bool _a_match=false,_b_match=false;
      if(DomainToString(A,_a) && DomainToString(B,_b))
      {
         for(int s=0;s<Output.Surjectors();s++)
         {
            CDomain<string> _d;
            if(Output.Get(s,_d))
            {
               if(DomainMatch(_a,_d))
               {
                  _a_match=true;
               }
               //
               if(DomainMatch(_b,_d))
               {
                  _b_match=true;
               }
            }
            //
            if(_a_match && _b_match)
            {
               break;
            }
         }
         //
         if(_a_match && _b_match)
         {
            return;
         }
         //
         int _cardinality=(_cardinal_a*_cardinal_b)-1;
         //
         if(Output.apex.Cardinality(Output.apex.Cardinality()+_cardinality+1))
         {
            for(int a=0;a<_cardinal_a;a++)
            {
               CElement<TA> _e_a;
               _e_a.Cardinality(1);
               if(A.Get(a,_e_a) && string(_e_a.Get(0))!="")
               {
                  for(int b=0;b<_cardinal_b;b++)
                  {
                     CElement<TB> _e_b;
                     _e_b.Cardinality(1);
                     if(B.Get(b,_e_b) && string(_e_b.Get(0))!="")
                     {
                        CElement<string> _product; _product.Cardinality(1);
                        string _a_out=PrintElement(_e_a,FloatPrecision);
                        string _b_out=PrintElement(_e_b,FloatPrecision);
                        if(_product.Set(0,string(_a_out+","+_b_out)))
                        {
                           if(Output.apex.Set(_cardinality,_product,true))
                           {
                              _cardinality--;
                              if(_cardinality<0){ break; }
                           }
                        }
                     }  
                  }
               }
               //
               if(_cardinality<0){ break; }
            }
            //
            if(!_a_match)
            {
               if(Output.Surjectors(Output.Surjectors()+1))
               {
                  Output.Set(Output.Surjectors()-1,_a);
               }
            }
            //
            if(!_b_match)
            {
               if(Output.Surjectors(Output.Surjectors()+1))
               {
                  Output.Set(Output.Surjectors()-1,_b);
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Get Coproduct function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
void GetCoproduct(CDomain<TA> &A,CDomain<TB> &B,CCoproduct &Output,int FloatPrecision=2)
   {
      int _cardinal_a=A.Cardinality(),_cardinal_b=B.Cardinality();
      
      if(_cardinal_a==0||_cardinal_b==0)
      {
         return;
      }
      //
      CDomain<string> _a,_b;
      bool _a_match=false,_b_match=false;
      if(DomainToString(A,_a) && DomainToString(B,_b))
      {
         for(int s=0;s<Output.Injectors();s++)
         {
            CDomain<string> _d;
            if(Output.Get(s,_d))
            {
               if(DomainMatch(_a,_d))
               {
                  _a_match=true;
               }
               //
               if(DomainMatch(_b,_d))
               {
                  _b_match=true;
               }
            }
            //
            if(_a_match && _b_match)
            {
               break;
            }
         }
         //
         if(_a_match && _b_match)
         {
            return;
         }
         //
         int _cardinality=(_cardinal_a+_cardinal_b)-1;
         //
         if(Output.apex.Cardinality(Output.apex.Cardinality()+_cardinality+1))
         {
            for(int a=0;a<_cardinal_a;a++)
            {
               CElement<TA> _e_a;
               _e_a.Cardinality(1);
               if(A.Get(a,_e_a) && string(_e_a.Get(0))!="")
               {
                  CElement<string> _product; _product.Cardinality(1);
                  string _a_out=PrintElement(_e_a,FloatPrecision);
                  if(_product.Set(0,string(_a_out)))
                  {
                     if(Output.apex.Set(_cardinality,_product,true))
                     {
                        _cardinality--;
                        if(_cardinality<0){ break; }
                     }
                  }
               }
            }
            //
            for(int b=0;b<_cardinal_b;b++)
            {
               CElement<TB> _e_b;
               _e_b.Cardinality(1);
               if(B.Get(b,_e_b) && string(_e_b.Get(0))!="")
               {
                  CElement<string> _product; _product.Cardinality(1);
                  string _b_out=PrintElement(_e_b,FloatPrecision);
                  if(_product.Set(0,string(_b_out)))
                  {
                     if(Output.apex.Set(_cardinality,_product,true))
                     {
                        _cardinality--;
                        if(_cardinality<0){ break; }
                     }
                  }
               }  
            }
            //
            if(!_a_match)
            {
               if(Output.Injectors(Output.Injectors()+1))
               {
                  Output.Set(Output.Injectors()-1,_a);
               }
            }
            //
            if(!_b_match)
            {
               if(Output.Injectors(Output.Injectors()+1))
               {
                  Output.Set(Output.Injectors()-1,_b);
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Get Coproduct function                                           |
//+------------------------------------------------------------------+
template <typename T>
bool DomainToString(CDomain<T> &D,CDomain<string> &Output)
   {
      if(D.Cardinality()<=0){ return(false); }
      
      bool _set=true;
      //
      if(Output.Cardinality(D.Cardinality()))
      {
         for(int d=0;d<D.Cardinality();d++)
         {
            CElement<T> _e_get;
            CElement<string> _e_set;
            if(D.Get(d,_e_get))
            {
               if(_e_set.Cardinality(_e_get.Cardinality()))
               {
                  for(int e=0;e<_e_get.Cardinality();e++)
                  {
                     if(!_e_set.Set(e,string(_e_get.Get(e))))
                     {
                        _set=false;break;
                     }
                  }
                  //
                  if(_set)
                  {
                     Output.Set(d,_e_set,true);
                  }
                  else{ break; }
               }
            }
         }
      }
      
      return(_set);
   }
//+------------------------------------------------------------------+
//| Get Equalizer function (not tested)                              |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
int GetEqualizer(CHomomorphism<TD,TC> &H)
   {
      int _equal=-1;
      
      for(int d=1;d<=_Digits;d++)
      {
         CElement<double> _e;
         if(H.codomain.Get(0,_e))
         {
            double _base=_e.Get(0);
            
            for(int c=1;c<H.codomain.Cardinality();c++)
            {
               CElement<double> _e_1;
               if(H.codomain.Get(c,_e_1))
               {
                  if(NormalizeDouble(_e_1.Get(0),d)!=_base)
                  {
                     break;
                  }
                  else if(c==H.codomain.Cardinality()-1)
                  {
                     _equal=d; break;
                  }
               }
            }
            
            if(_equal!=-1){ break; }
         }
         
         if(_equal!=-1){ break; }
      }
      
      return(_equal);
   }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void InitResultsMP(int StartIndex,string &Results[][6])
   {
      ArrayResize(Results,(StartIndex+2));
      
      Results[0][0]=" DATE ";
      Results[0][1]=" N period ";
      Results[0][2]=" EURUSD corr. ";
      Results[0][3]=" USDJPY corr. ";
      Results[0][4]=" geometric mean ";
      Results[0][5]=" actual corr. ";
   }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double Correlation(int StartIndex,int StopIndex,int Size,MqlRates &R[])
   {
      double _correlation=0.0;
      
      double _new[],_old[];
      ArrayResize(_new,Size);ArrayResize(_old,Size);
      ArrayInitialize(_new,0.0);ArrayInitialize(_old,0.0);
      //
      for(int i=StartIndex;i>=0;i--)
      {
         if(i!=StopIndex){ continue; }
            
         for(int ii=i;ii<i+(2*Size);ii++)
         {
            if(ii<i+Size)
            {
               _new[ii-i]=R[ii].close;
            }
            else if(ii-i>=Size && ii<i+(2*Size))
            {
               _old[ii-i-Size]=R[ii].close;
            }
         }
         
         if(MathCorrelationSpearman(_new,_old,_correlation))
         {
            if(i==StopIndex){ break; }
         }
      }
      
      return(_correlation);
   }
//+------------------------------------------------------------------+
//| Standard Cardinal across all f, g, f', and g'.                   |
//+------------------------------------------------------------------+
void Morph_MP_1(int StartIndex,int StopIndex,int Size,datetime Time,MqlRates &EU[],MqlRates &UJ[],MqlRates &EJ[],string &Results[][6])
   {
      double _eu=Correlation(StartIndex,StopIndex,Size,EU);
      double _uj=Correlation(StartIndex,StopIndex,Size,UJ);
      double _ej=Correlation(StartIndex,StopIndex,Size,EJ);
      
      double _forecast=MathPow((_eu+1.0)*(_uj+1.0),0.5)-1.0;
      
      Results[1+StartIndex-StopIndex][0]=TimeToString(Time);
      Results[1+StartIndex-StopIndex][1]=IntegerToString(Size);
      Results[1+StartIndex-StopIndex][2]=DoubleToString(_eu,2);
      Results[1+StartIndex-StopIndex][3]=DoubleToString(_uj,2);
      Results[1+StartIndex-StopIndex][4]=DoubleToString(_forecast,2);
      Results[1+StartIndex-StopIndex][5]=DoubleToString(_ej,2);
      
      _f_mp_1[1+StartIndex-StopIndex]=_forecast;
      _a_mp_1[1+StartIndex-StopIndex]=_ej;
      
      //printf(__FUNCSIG__+" on: "+TimeToString(Time)+" correlation period is: "+IntegerToString(Size)+", with forecast: "+DoubleToString(_forecast,2)+", versus actual: "+DoubleToString(_ej,2));
   }
//+------------------------------------------------------------------+
//| Different Cardinals across all f, g, f', and g'.                 |
//+------------------------------------------------------------------+
void Morph_MP_2(int StartIndex,int StopIndex,int Size,datetime Time,MqlRates &EU[],MqlRates &UJ[],MqlRates &EJ[],string &Results[][6])
   {
      int _eu_size=Size;
      int _ej_size=Size;
      //
      double _eu_rsi[];int _eu_rsi_handle=iRSI("EURUSD",PERIOD_W1,Size,PRICE_CLOSE);
      double _ej_rsi[];int _ej_rsi_handle=iRSI("EURJPY",PERIOD_W1,Size,PRICE_CLOSE);
      //
      if(Size==3)
      {
         if(CopyBuffer(_eu_rsi_handle,0,0,1,_eu_rsi)>=1){ _eu_size=int(round(3+(_eu_rsi[0]/100.0)*1.0)); }
         if(CopyBuffer(_ej_rsi_handle,0,0,1,_ej_rsi)>=1){ _ej_size=int(round(3+(_ej_rsi[0]/100.0)*1.0)); }
      }
      else if(Size==5)
      {
         if(CopyBuffer(_eu_rsi_handle,0,0,1,_eu_rsi)>=1){ _eu_size=int(round(4+(_eu_rsi[0]/100.0)*2.5)); }
         if(CopyBuffer(_ej_rsi_handle,0,0,1,_ej_rsi)>=1){ _ej_size=int(round(4+(_ej_rsi[0]/100.0)*2.5)); }
      }
      else if(Size==8)
      {
         if(CopyBuffer(_eu_rsi_handle,0,0,1,_eu_rsi)>=1){ _eu_size=int(round(6.5+(_eu_rsi[0]/100.0)*4.0)); }
         if(CopyBuffer(_ej_rsi_handle,0,0,1,_ej_rsi)>=1){ _ej_size=int(round(6.5+(_ej_rsi[0]/100.0)*4.0)); }
      }
      else if(Size==13)
      {
         if(CopyBuffer(_eu_rsi_handle,0,0,1,_eu_rsi)>=1){ _eu_size=int(round(10.5+(_eu_rsi[0]/100.0)*6.5)); }
         if(CopyBuffer(_ej_rsi_handle,0,0,1,_ej_rsi)>=1){ _ej_size=int(round(10.5+(_ej_rsi[0]/100.0)*6.5)); }
      }
      else if(Size==21)
      {
         if(CopyBuffer(_eu_rsi_handle,0,0,1,_eu_rsi)>=1){ _eu_size=int(round(17.0+(_eu_rsi[0]/100.0)*4.0)); }
         if(CopyBuffer(_ej_rsi_handle,0,0,1,_ej_rsi)>=1){ _ej_size=int(round(17.0+(_ej_rsi[0]/100.0)*4.0)); }
      }
      
      double _eu=Correlation(StartIndex,StopIndex,_eu_size,EU);
      double _uj=Correlation(StartIndex,StopIndex,Size,UJ);
      double _ej=Correlation(StartIndex,StopIndex,_ej_size,EJ);
      
      double _forecast=MathPow((_eu+1.0)*(_uj+1.0),0.5)-1.0;
      
      Results[1+StartIndex-StopIndex][0]=TimeToString(Time);
      Results[1+StartIndex-StopIndex][1]=IntegerToString(Size);
      Results[1+StartIndex-StopIndex][2]=DoubleToString(_eu,2);
      Results[1+StartIndex-StopIndex][3]=DoubleToString(_uj,2);
      Results[1+StartIndex-StopIndex][4]=DoubleToString(_forecast,2);
      Results[1+StartIndex-StopIndex][5]=DoubleToString(_ej,2);
      
      _f_mp_2[1+StartIndex-StopIndex]=_forecast;
      _a_mp_2[1+StartIndex-StopIndex]=_ej;
      
      //printf(__FUNCSIG__+" on: "+TimeToString(Time)+" correlation period is: "+IntegerToString(Size)+", with forecast: "+DoubleToString(_forecast,2)+", versus actual: "+DoubleToString(_ej,2));
   }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void InitResultsEP(int StartIndex,string &Results[][7])
   {
      ArrayResize(Results,(StartIndex+2));
      
      Results[0][0]=" DATE ";
      Results[0][1]=" N period ";
      Results[0][2]=" Baseline-MA ";
      Results[0][3]=" Upper Bands ";
      Results[0][4]=" Lower Bands ";
      Results[0][5]=" Envelope Delta ";
      Results[0][6]=" Actual Range ";
   }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double Deviation(int StartIndex,int StopIndex,int Size,MqlRates &R[])
   {
      double _deviation=0.0;
      
      double _new[];
      ArrayResize(_new,Size);
      ArrayInitialize(_new,0.0);
      //
      for(int i=StartIndex;i>=0;i--)
      {
         if(i!=StopIndex){ continue; }
            
         for(int ii=i;ii<i+(Size);ii++)
         {
            _new[ii-i]=R[ii].close;
         }
         
         _deviation=MathStandardDeviation(_new);
         
         if(i==StopIndex){ break; }
      }
      
      return(_deviation);
   }
//+------------------------------------------------------------------+
//| Standard Cardinal across all f, g, f', and g'.                   |
//+------------------------------------------------------------------+
void Morph_EP_1(int StartIndex,int StopIndex,int Size,datetime Time,MqlRates &BB[],string &Results[][7])
   {
      double _bb_base[],_bb_up[],_bb_dn[];int _bb_handle=iBands(_Symbol,PERIOD_W1,Size,0,2.0,PRICE_CLOSE);
      //
      if(CopyBuffer(_bb_handle,0,0,1,_bb_base)>=1 && CopyBuffer(_bb_handle,1,0,1,_bb_up)>=1 && CopyBuffer(_bb_handle,2,0,1,_bb_dn)>=1)
      { 
         Results[1+StartIndex-StopIndex][0]=TimeToString(Time);
         Results[1+StartIndex-StopIndex][1]=IntegerToString(Size);
         Results[1+StartIndex-StopIndex][2]=DoubleToString(_bb_base[0],_Digits);
         Results[1+StartIndex-StopIndex][3]=DoubleToString(_bb_up[0],_Digits);
         Results[1+StartIndex-StopIndex][4]=DoubleToString(_bb_dn[0],_Digits);
         Results[1+StartIndex-StopIndex][5]=DoubleToString(_bb_up[0]-_bb_dn[0],_Digits); 
         Results[1+StartIndex-StopIndex][6]=DoubleToString(BB[StopIndex].high-BB[StopIndex].low,_Digits);
         
         _f_ep_1[1+StartIndex-StopIndex]=_bb_up[0]-_bb_dn[0];
         _a_ep_1[1+StartIndex-StopIndex]=BB[StopIndex].high-BB[StopIndex].low; 
      }
   }
//+------------------------------------------------------------------+
//| Different Cardinals across all f, g, f', and g'.                 |
//+------------------------------------------------------------------+
void Morph_EP_2(int StartIndex,int StopIndex,int Size,datetime Time,MqlRates &BB[],string &Results[][7])
   {
      int _size=Size;
      //
      double _rsi[];int _rsi_handle=iRSI(_Symbol,PERIOD_W1,Size,PRICE_CLOSE);
      //
      if(Size==3)
      {
         if(CopyBuffer(_rsi_handle,0,0,1,_rsi)>=1){ _size=int(round(3+(_rsi[0]/100.0)*1.0)); }
      }
      else if(Size==5)
      {
         if(CopyBuffer(_rsi_handle,0,0,1,_rsi)>=1){ _size=int(round(4+(_rsi[0]/100.0)*2.5)); }
      }
      else if(Size==8)
      {
         if(CopyBuffer(_rsi_handle,0,0,1,_rsi)>=1){ _size=int(round(6.5+(_rsi[0]/100.0)*4.0)); }
      }
      else if(Size==13)
      {
         if(CopyBuffer(_rsi_handle,0,0,1,_rsi)>=1){ _size=int(round(10.5+(_rsi[0]/100.0)*6.5)); }
      }
      else if(Size==21)
      {
         if(CopyBuffer(_rsi_handle,0,0,1,_rsi)>=1){ _size=int(round(17.0+(_rsi[0]/100.0)*4.0)); }
      }
      
      double _bb_base[],_bb_up[],_bb_dn[];int _bb_handle=iBands(_Symbol,PERIOD_W1,_size,0,2.0,PRICE_CLOSE);
      //
      if(CopyBuffer(_bb_handle,0,0,1,_bb_base)>=1 && CopyBuffer(_bb_handle,1,0,1,_bb_up)>=1 && CopyBuffer(_bb_handle,2,0,1,_bb_dn)>=1)
      { 
         Results[1+StartIndex-StopIndex][0]=TimeToString(Time);
         Results[1+StartIndex-StopIndex][1]=IntegerToString(Size);
         Results[1+StartIndex-StopIndex][2]=DoubleToString(_bb_base[0],_Digits);
         Results[1+StartIndex-StopIndex][3]=DoubleToString(_bb_up[0],_Digits);
         Results[1+StartIndex-StopIndex][4]=DoubleToString(_bb_dn[0],_Digits);
         Results[1+StartIndex-StopIndex][5]=DoubleToString(_bb_up[0]-_bb_dn[0],_Digits); 
         Results[1+StartIndex-StopIndex][6]=DoubleToString(BB[StopIndex].high-BB[StopIndex].low,_Digits);
         
         _f_ep_2[1+StartIndex-StopIndex]=_bb_up[0]-_bb_dn[0];
         _a_ep_2[1+StartIndex-StopIndex]=BB[StopIndex].high-BB[StopIndex].low; 
      }
   }
//+------------------------------------------------------------------+
