//+------------------------------------------------------------------+
//|                                  MetaquotesCommentsToDoxygen.mq5 |
//|                                     Copyright Paul Hampton-Smith |
//|                            http://paulsfxrandomwalk.blogspot.com |
//+------------------------------------------------------------------+
#property copyright "Paul Hampton-Smith"
#property link      "http://paulsfxrandomwalk.blogspot.com"
#property version   "1.00"
#property script_show_inputs

input string FileList="MQL5\\MQL5codeList.txt"; // list of file paths to be processed
//+------------------------------------------------------------------+
/// Replaces strRemove if it exists in strTarget with strAdd.        |
//+------------------------------------------------------------------+
bool StringReplace(string &strTarget,string strRemove,string strAdd)
  {
   int nRemovePos=StringFind(strTarget,strRemove);
   if(nRemovePos==-1) return(false);
   string strBeforeRemove= StringSubstr(strTarget,0,nRemovePos);
   string strAfterRemove = StringSubstr(strTarget,nRemovePos+StringLen(strRemove));
   StringConcatenate(strTarget,strBeforeRemove,strAdd,strAfterRemove);
   return(true);
  }
//+------------------------------------------------------------------+
//| Converts Metaquotes style function comment lines to Doxygen equivalents.
//+------------------------------------------------------------------+
bool ModifyLine(string &strLine)
  {
   static bool bProcessingInputs=false;
   if(StringFind(strLine,"//| ")!=0)
     {
      // not a comment to be modified - just return without altering
      bProcessingInputs=false;
      return(true);
     }

// Found a comment to be modified

// create Doxygen triple slash
   StringSetCharacter(strLine,2,'/');
// remove end "|"
   int nBarPos=StringFind(strLine," |");
   if(nBarPos>0) StringSetCharacter(strLine,nBarPos+1,' ');

   if(StringReplace(strLine,"Appointment: ","             "))
     {
      bProcessingInputs=false;
     }
// Doxygen automatically treats unflagged comments as additional info, therefore remove "REMARK:"
   if(StringFind(strLine,"/// REMARK: no.")==0)
     {
      bProcessingInputs=false;
      return(false);
     }
   if(StringReplace(strLine,"REMARK:","       "))
     {
      bProcessingInputs=false;
     }

// output parameter description
// skip if no inputs
   if(StringFind(strLine,"/// OUTPUT: no.")==0)
     {
      bProcessingInputs=false;
      return(false);
     }
// first input parameter description
// skip if no inputs
   if(StringFind(strLine,"/// INPUT:  no.")==0)
     {
      bProcessingInputs=false;
      return(false);
     }
// replace INPUT: with \param
   if(StringReplace(strLine,"INPUT:","\\param"))
     {
      bProcessingInputs=true;
     }
// replace OUTPUT: with \return
   if(StringReplace(strLine,"OUTPUT:","\\return"))
     {
      bProcessingInputs=false;
     }
   else
     {
      // 2nd and subsequent input parameter descriptions
      if(bProcessingInputs)
        {
         StringReplace(strLine,"///       ","/// \\param");
        }
     }
   return(true);
  }
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   int hList=FileOpen(FileList,FILE_TXT|FILE_READ|FILE_ANSI);
   string inputfile="";
// Process each filepath in input FileList
   do
     {
      inputfile=FileReadString(hList);
      Print(inputfile);

      int hInput=FileOpen(inputfile,FILE_TXT|FILE_READ|FILE_ANSI);
      if(hInput == INVALID_HANDLE)
        {
         Alert("Can't open file"+inputfile+" for reading");
         return;
        }

      // Output to modified file path
      string OutputFileName=inputfile+"_tmp";
      int hOutput=FileOpen(OutputFileName,FILE_TXT|FILE_WRITE|FILE_ANSI);
      if(hOutput == INVALID_HANDLE)
        {
         Alert("Can't open temporary output file"+OutputFileName+" for writing");
         return;
        }

      do // check all the lines in the input file and modify if required
        {
         string strLine=FileReadString(hInput);
         if(ModifyLine(strLine)) FileWrite(hOutput,strLine);
        }
      while(!FileIsEnding(hInput));
      FileClose(hInput);
      FileClose(hOutput);

      // replace original file with modified file
      FileCopy(inputfile+"_tmp",1,inputfile,FILE_REWRITE);
      FileDelete(inputfile+"_tmp",1);
     }
   while(!FileIsEnding(hList));
   FileClose(hList);
  }
//+------------------------------------------------------------------+
