//+------------------------------------------------------------------+
//|                                                         nRSI.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DOT
#property indicator_level1 30
#property indicator_level2 70

#property indicator_type1  DRAW_LINE
#property indicator_label1 "nRSI"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID
#property indicator_applied_price PRICE_CLOSE

enum mode {Linear,Power,Exponential};
input mode iMode=Linear;
input ushort iPeriod=14;

ushort period=2;
int array[][2];
double buffer[],weight[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(period,iPeriod);

   ArrayResize(weight,period);
   for(int i=0; i<period; i++)
     {
      if(iMode==Linear)
         weight[i]=period-i;
      if(iMode==Power)
         weight[i]=MathPow(period-i,2);
      if(iMode==Exponential)
         weight[i]=MathPow(2,period-i-1);
     }

   ArrayResize(array,0,1000);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);
   static int cnt;

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      if(i>0)
        {
         int diff=(int)MathRound((price[i]-price[i+1])/_Point),
             ind=ArrayBsearch(array,diff);
         if(ind>=0 && array[ind][0]==diff)
            array[ind][1]++;
         else
           {
            int size=ArrayRange(array,0);
            ArrayResize(array,size+1);
            array[size][0]=diff;
            array[size][1]=1;
            ArraySort(array);
           }
         cnt++;
        }

      double sum_all=0,sum_up=0;
      for(int j=0; j<period; j++)
        {
         double p1=price[i+j],p2=price[i+j+1];
         int diff=(int)MathRound((p1-p2)/_Point),
             ind=ArrayBsearch(array,diff);
         double val=weight[j]*(cnt-array[ind][1]);
         sum_all=sum_all+val;
         if(p1>p2)
            sum_up=sum_up+val;
        }

      buffer[i]=sum_all>0? 100*sum_up/sum_all:EMPTY_VALUE;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
