//+------------------------------------------------------------------+
//|                                          nIchimoku Kinko Hyo.mq4 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property strict
#property indicator_chart_window
#property indicator_buffers 5
#property indicator_plots   5

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Tenkan-sen"
#property indicator_color1 clrRed
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_LINE
#property indicator_label2 "Kijun-sen"
#property indicator_color2 clrBlue
#property indicator_width2 1
#property indicator_style2 STYLE_SOLID

#property indicator_type3  DRAW_LINE
#property indicator_label3 "Senkou span A"
#property indicator_color3 clrGreen
#property indicator_width3 1
#property indicator_style3 STYLE_SOLID

#property indicator_type4  DRAW_LINE
#property indicator_label4 "Senkou span B"
#property indicator_color4 clrGreen
#property indicator_width4 1
#property indicator_style4 STYLE_SOLID

#property indicator_type5  DRAW_LINE
#property indicator_label5 "Chikou span"
#property indicator_color5 clrLime
#property indicator_width5 1
#property indicator_style5 STYLE_SOLID

input ushort PeriodS=9,
             PeriodM=26,
             PeriodL=52;

double Tenkan[],Kijun[],SenkouA[],SenkouB[],Chikou[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,Tenkan,INDICATOR_DATA);
   ArraySetAsSeries(Tenkan,true);
   SetIndexEmptyValue(0,EMPTY_VALUE);

   SetIndexBuffer(1,Kijun,INDICATOR_DATA);
   ArraySetAsSeries(Kijun,true);
   SetIndexEmptyValue(1,EMPTY_VALUE);

   SetIndexBuffer(2,SenkouA,INDICATOR_DATA);
   ArraySetAsSeries(SenkouA,true);
   SetIndexEmptyValue(2,EMPTY_VALUE);
   SetIndexShift(2,PeriodM);

   SetIndexBuffer(3,SenkouB,INDICATOR_DATA);
   ArraySetAsSeries(SenkouB,true);
   SetIndexEmptyValue(3,EMPTY_VALUE);
   SetIndexShift(3,PeriodM);

   SetIndexBuffer(4,Chikou,INDICATOR_DATA);
   ArraySetAsSeries(Chikou,true);
   SetIndexEmptyValue(4,EMPTY_VALUE);
   SetIndexShift(4,-1*PeriodM);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-PeriodL-1;

   for(int i=bars; i>=0; i--)
     {
      int cnt=0;
      double array[];
      ArrayResize(array,2*PeriodS);
      for(int j=0; j<PeriodS; j++)
        {
         array[cnt]=high[i+j];
         array[cnt+1]=low[i+j];
         cnt=cnt+2;
        }
      Tenkan[i]=Median(array);

      cnt=0;
      ArrayResize(array,2*PeriodM);
      for(int j=0; j<PeriodM; j++)
        {
         array[cnt]=high[i+j];
         array[cnt+1]=low[i+j];
         cnt=cnt+2;
        }
      Kijun[i]=Median(array);

      cnt=0;
      ArrayResize(array,2*(PeriodS+PeriodM));
      for(int j=0; j<PeriodM; j++)
        {
         if(j<PeriodS)
           {
            array[cnt]=high[i+j];
            array[cnt+1]=low[i+j];
            cnt=cnt+2;
           }
         array[cnt]=high[i+j];
         array[cnt+1]=low[i+j];
         cnt=cnt+2;
        }
      SenkouA[i]=Median(array);

      cnt=0;
      ArrayResize(array,2*PeriodL);
      for(int j=0; j<PeriodL; j++)
        {
         array[cnt]=high[i+j];
         array[cnt+1]=low[i+j];
         cnt=cnt+2;
        }
      SenkouB[i]=Median(array);

      Chikou[i]=close[i];
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double Median(double &array[])
  {
//---
   int size=ArraySize(array),
       ind1=size/2,ind2=MathMod(size,2)==0?ind1-1:ind1;
   ArraySort(array);
   return((array[ind1]+array[ind2])/2);
//---
  }
//+------------------------------------------------------------------+
