//+------------------------------------------------------------------+
//|                                               Strength Trend.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_plots   3

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Real Trend"
#property indicator_color1 clrGreen
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_LINE
#property indicator_label2 "Up Trend"
#property indicator_color2 clrBlue
#property indicator_width2 1
#property indicator_style2 STYLE_SOLID

#property indicator_type3  DRAW_LINE
#property indicator_label3 "Down Trend"
#property indicator_color3 clrRed
#property indicator_width3 1
#property indicator_style3 STYLE_SOLID

#property indicator_applied_price PRICE_CLOSE

enum mode {Linear,Power,Exponential};
input mode iMode=Linear;
input ushort iPeriod=14;

ushort period=2;
double buffer[],up[],down[],weight[],array[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   SetIndexBuffer(1,up,INDICATOR_DATA);
   ArraySetAsSeries(up,true);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   SetIndexBuffer(2,down,INDICATOR_DATA);
   ArraySetAsSeries(down,true);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(period,iPeriod);

   ArrayResize(weight,period);

   double denom=0;
   for(int i=0; i<period; i++)
     {
      if(iMode==Linear)
         weight[i]=period-i;
      if(iMode==Power)
         weight[i]=MathPow(period-i,2);
      if(iMode==Exponential)
         weight[i]=MathPow(2,period-i-1);
      denom=denom+weight[i];
     }

   for(int i=0; i<period; i++)
      weight[i]=weight[i]/denom;

   ArrayResize(array,period);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      double sum_r=0,sum_up=0,sum_dn=0;
      for(int j=0; j<period; j++)
        {
         array[j]=price[i+j];
         sum_r=sum_r+weight[j]*array[j];
        }

      ArraySort(array);
      for(int j=0; j<period; j++)
        {
         sum_dn=sum_dn+weight[j]*array[j];
         sum_up=sum_up+weight[j]*array[period-j-1];
        }

      buffer[i]=sum_r;
      up[i]=sum_up;
      down[i]=sum_dn;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
