//+------------------------------------------------------------------+
//|                                                      Pattern.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_type1  DRAW_ARROW
#property indicator_label1 "Up"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_ARROW
#property indicator_label2 "Down"
#property indicator_color2 clrRed
#property indicator_width2 1
#property indicator_style2 STYLE_SOLID

input uchar Least=0;
ulong pattern[][4];
int cnt=0;
double buffer_up[],buffer_dn[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer_up,INDICATOR_DATA);
   ArraySetAsSeries(buffer_up,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   SetIndexBuffer(1,buffer_dn,INDICATOR_DATA);
   ArraySetAsSeries(buffer_dn,true);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   ArrayResize(pattern,cnt,100);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);
      ArraySetAsSeries(high,true);
      ArraySetAsSeries(low,true);

      int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-4;

      for(int i=bars; i>=0; i--)
        {
         int array[10][2];
         array[0][0]=(int)MathRound(open[i]/_Point);
         array[0][1]=0;
         for(int j=0; j<3; j++)
           {
            array[3*j+1][0]=(int)MathRound(low[i+j]/_Point);
            array[3*j+1][1]=3*j+1;
            array[3*j+2][0]=(int)MathRound(high[i+j]/_Point);
            array[3*j+2][1]=3*j+2;
            array[3*j+3][0]=(int)MathRound(open[i+j]/_Point);
            array[3*j+3][1]=3*j+3;
           }

         ArraySort(array);

         for(int j=1; j<10; j++)
            if(array[j-1][0]==array[j][0] && array[j-1][1]>array[j][1])
              {
               int v=array[j-1][1];
               array[j-1][1]=array[j][1];
               array[j][1]=v;
               j=1;
              }

         ulong number=0;
         for(int j=0; j<10; j++)
            number=number+array[j][1]*(ulong)MathRound(MathPow(10,j));

         int ind=ArrayBsearch(pattern,number);

         if(ind>=0 && pattern[ind][0]==number && pattern[ind][1]>=Least)
           {
            if(pattern[ind][2]>pattern[ind][3])
               buffer_up[i]=open[i];
            if(pattern[ind][2]<pattern[ind][3])
               buffer_dn[i]=open[i];
           }

         if(i>0)
           {
            int h=(int)MathRound((high[i]-open[i])/_Point),l=(int)MathRound((open[i]-low[i])/_Point);
            if(ind>=0 && pattern[ind][0]==number)
              {
               pattern[ind][1]++;
               pattern[ind][2]=pattern[ind][2]+h;
               pattern[ind][3]=pattern[ind][3]+l;
              }
            else
              {
               ArrayResize(pattern,cnt+1);
               pattern[cnt][0]=number;
               pattern[cnt][1]=1;
               pattern[cnt][2]=h;
               pattern[cnt][3]=l;
               cnt++;
               ArraySort(pattern);
              }
           }
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
