//+------------------------------------------------------------------+
//|                                                Median Median.mq4 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property strict
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Median Median"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ENUM_APPLIED_PRICE iPrice=PRICE_CLOSE;
input ushort iPeriod=14;

ushort period=2,ind1=0,ind2=0;
double buffer[],array[],median[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(period,iPeriod);

   ArrayResize(array,period);
   ArrayResize(median,period);

   ind1=period/2;
   ind2=MathMod(period,2)==0? ind1-1:ind1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-2*period;

   for(int i=bars; i>=0; i--)
     {
      for(int j=0; j<period; j++)
        {
         for(int k=0; k<period; k++)
            array[k]=price(open[i+j+k],high[i+j+k],low[i+j+k],close[i+j+k]);
         ArraySort(array);
         median[j]=(array[ind1]+array[ind2])/2;
        }

      buffer[i]=(median[ind1]+median[ind2])/2;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double price(double o,double h,double l,double c)
  {
   if(iPrice==PRICE_CLOSE)
      return(c);
   if(iPrice==PRICE_OPEN)
      return(o);
   if(iPrice==PRICE_HIGH)
      return(h);
   if(iPrice==PRICE_LOW)
      return(l);
   if(iPrice==PRICE_MEDIAN)
      return((h+l)/2);
   if(iPrice==PRICE_TYPICAL)
      return(h+l+c)/3;
   return(h+l+2*c)/4;
  }
//+------------------------------------------------------------------+
