//+------------------------------------------------------------------+
//|                                                         MMMM.mq4 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property strict
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "MMMM"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ENUM_APPLIED_PRICE iPrice=PRICE_CLOSE;
enum ENUM_MODE {Mean,Median,Mode,MidRange};
input ENUM_MODE iMode=Mean;
input ushort iPeriod=14;
ushort period=2;
double buffer[],array[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(period,iPeriod);

   ArrayResize(array,period);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      for(int j=0; j<period; j++)
         array[j]=price(open[i+j],high[i+j],low[i+j],close[i+j]);

      if(iMode==Mean)
         buffer[i]=CalcMean();
      if(iMode==Median)
         buffer[i]=CalcMedian();
      if(iMode==Mode)
         buffer[i]=3*CalcMedian()-2*CalcMean();
      if(iMode==MidRange)
         buffer[i]=CalcMidRange();
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalcMean()
  {
//---
   double sum=0;
   for(int i=0; i<period; i++)
      sum=sum+array[i];
   return(sum/period);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalcMedian()
  {
//---
   int ind1=period/2,ind2=MathMod(period,2)==0? ind1-1:ind1;
   ArraySort(array);
   return((array[ind1]+array[ind2])/2);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalcMidRange()
  {
//---
   ArraySort(array);
   return((array[0]+array[period-1])/2);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double price(double o,double h,double l,double c)
  {
   if(iPrice==PRICE_CLOSE)
      return(c);
   if(iPrice==PRICE_OPEN)
      return(o);
   if(iPrice==PRICE_HIGH)
      return(h);
   if(iPrice==PRICE_LOW)
      return(l);
   if(iPrice==PRICE_MEDIAN)
      return((h+l)/2);
   if(iPrice==PRICE_TYPICAL)
      return(h+l+c)/3;
   return(h+l+2*c)/4;
  }
//+------------------------------------------------------------------+
