//+------------------------------------------------------------------+
//|                                              EA Along Across.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"

enum mode {Along,Across};
input mode Mode=Along;
input uchar Least=1,
            Percent=60;

ulong pattern[][4],SL,TP;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   ArrayResize(pattern,0,100);
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   for(int i=iBars(_Symbol,PERIOD_CURRENT)-20; i>=5; i--)
      Lesson(i);

   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();
      if(signal==0)
         PutPosition(ORDER_TYPE_BUY);
      if(signal==1)
         PutPosition(ORDER_TYPE_SELL);
      Lesson(5);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PutPosition(ENUM_ORDER_TYPE type)
  {
//---
   double price=type==ORDER_TYPE_BUY? SymbolInfoDouble(_Symbol,SYMBOL_ASK):SymbolInfoDouble(_Symbol,SYMBOL_BID),margin;
   if(OrderCalcMargin(type,_Symbol,lot,price,margin)==false)
      return;
   if(margin>AccountInfoDouble(ACCOUNT_MARGIN_FREE))
     {
      Print("Not enough money for ",EnumToString(type)," ",lot," ",_Symbol," Error code # ",GetLastError());
      return;
     }

   int slippage=(int)MathMax(SymbolInfoInteger(_Symbol,SYMBOL_SPREAD)/2,3),
       stoplvl=(int)SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL);
   double sl=0,tp=0;

   if(type==ORDER_TYPE_BUY)
     {
      sl=SymbolInfoDouble(_Symbol,SYMBOL_BID)-MathMax(stoplvl,SL)*_Point;
      tp=price+MathMax(stoplvl,TP)*_Point;
     }
   else
     {
      sl=SymbolInfoDouble(_Symbol,SYMBOL_ASK)+MathMax(stoplvl,SL)*_Point;
      tp=price-MathMax(stoplvl,TP)*_Point;
     }

   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.symbol=_Symbol;
   request.volume=lot;
   request.price=price;
   request.sl=NormalizeDouble(sl,_Digits);
   request.tp=NormalizeDouble(tp,_Digits);
   request.deviation=slippage;
   request.type=type;
   if(OrderSend(request,result)==false)
      Print("OrderSend error ",GetLastError());
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcSignal()
  {
//---
   ulong number=CalcNumber(0);
   int ind=ArrayBsearch(pattern,number);
   if(pattern[ind][0]==number && pattern[ind][1]>=Least)
     {
      ulong up=pattern[ind][2],dn=pattern[ind][3];

      if(100*up>=Percent*(up+dn))
        {
         SL=dn/pattern[ind][1];
         TP=up/pattern[ind][1];
         return(0);
        }
      if(100*dn>=Percent*(up+dn))
        {
         SL=up/pattern[ind][1];
         TP=dn/pattern[ind][1];
         return(1);
        }
     }
   return(-1);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void Lesson(int bar)
  {
//---
   double open=iOpen(_Symbol,PERIOD_CURRENT,bar),max=open,min=open;
   for(int i=0; i<5; i++)
     {
      max=MathMax(max,iHigh(_Symbol,PERIOD_CURRENT,bar-i));
      min=MathMin(min,iLow(_Symbol,PERIOD_CURRENT,bar-i));
     }
   int h=(int)MathRound((max-open)/_Point),l=(int)MathRound((open-min)/_Point);

   ulong number=CalcNumber(bar);
   int ind=ArrayBsearch(pattern,number);
   if(ind>=0 && pattern[ind][0]==number)
     {
      pattern[ind][1]++;
      pattern[ind][2]=pattern[ind][2]+h;
      pattern[ind][3]=pattern[ind][3]+l;
     }
   else
     {
      int cnt=ArrayRange(pattern,0);
      ArrayResize(pattern,cnt+1);
      pattern[cnt][0]=number;
      pattern[cnt][1]=1;
      pattern[cnt][2]=h;
      pattern[cnt][3]=l;
      ArraySort(pattern);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
ulong CalcNumber(int bar)
  {
//---
   int array[10][2];
   for(int i=0; i<10; i++)
     {
      array[i][0]=Mode==Along? CalcMA(bar+i,1):CalcMA(bar,2*i+1);
      array[i][1]=i;
     }

   ArraySort(array);

   for(int i=1; i<10; i++)
      if(array[i-1][0]==array[i][0] && array[i-1][1]>array[i][1])
        {
         int v=array[i-1][1];
         array[i-1][1]=array[i][1];
         array[i][1]=v;
         i=1;
        }

   ulong number=0;
   for(int j=0; j<10; j++)
      number=number+array[j][1]*(ulong)MathRound(MathPow(10,j));

   return(number);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcMA(int bar,int period)
  {
//---
   double sum=0;
   for(int i=0; i<period; i++)
      sum=sum+iOpen(_Symbol,PERIOD_CURRENT,bar+i);
   return((int)MathRound(sum/(period*_Point)));
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long last_bar;
   long cur_bar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(last_bar<cur_bar)
     {
      last_bar=cur_bar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
