//+------------------------------------------------------------------+
//|                                      Bayesian Moving Average.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Bayesian MA"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID
#property indicator_applied_price PRICE_CLOSE

enum ENUM_MODE {Median,MidRange,Max,Min,MaxMin};
input ENUM_MODE iMode=Median;
input ushort iPeriod=14,
             Parameter=14;

ushort period=2,ind1=0,ind2=0;
double buffer[],array[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(period,iPeriod);

   ArrayResize(array,period);

   if(iMode==Median)
     {
      ind1=period/2;
      ind2=MathMod(period,2)==0? ind1-1:ind1;
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<period; j++)
        {
         array[j]=price[i+j];
         sum=sum+array[j];
        }
      ArraySort(array);

      if(iMode==Median)
         buffer[i]=(sum+Parameter*(array[ind1]+array[ind2])/2)/(period+Parameter);
      if(iMode==MidRange)
         buffer[i]=(sum+Parameter*(array[0]+array[period-1])/2)/(period+Parameter);
      if(iMode==Max)
         buffer[i]=(sum+Parameter*array[period-1])/(period+Parameter);
      if(iMode==Min)
         buffer[i]=(sum+Parameter*array[0])/(period+Parameter);
      if(iMode==MaxMin)
         buffer[i]=(sum+Parameter*(array[0]+array[period-1]))/(period+2*Parameter);
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
