//+------------------------------------------------------------------+
//|                                            Base LogIndicator.mq4 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property strict
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Base LogIndicator"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ENUM_APPLIED_PRICE iPrice=PRICE_CLOSE;
input string InpCoefficient="1,1,1,1,1";
int size=0;
double buffer[],coeff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   string s[];
   size=StringSplit(InpCoefficient,StringGetCharacter(",",0),s);
   ArrayResize(coeff,size);

   double denom=0,center=0;
   for(int i=0; i<size; i++)
     {
      coeff[i]=StringToDouble(s[i]);
      denom=denom+coeff[i];
     }

   if(denom==0)
     {
      Alert("Wrong odds!");
      return(INIT_FAILED);
     }

   for(int i=0; i<size; i++)
     {
      coeff[i]=coeff[i]/denom;
      center=center+coeff[i]*(i+1);
     }

   Print((int)MathRound(center));
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-size-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<size; j++)
        {
         int p=i+j;
         double pr=MathLog(price(open[p],high[p],low[p],close[p]));
         sum=sum+coeff[j]*pr;
        }

      buffer[i]=MathExp(sum);
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double price(double o,double h,double l,double c)
  {
   if(iPrice==PRICE_CLOSE)
      return(c);
   if(iPrice==PRICE_OPEN)
      return(o);
   if(iPrice==PRICE_HIGH)
      return(h);
   if(iPrice==PRICE_LOW)
      return(l);
   if(iPrice==PRICE_MEDIAN)
      return((h+l)/2);
   if(iPrice==PRICE_TYPICAL)
      return(h+l+c)/3;
   return(h+l+2*c)/4;
  }
//+------------------------------------------------------------------+
