//+------------------------------------------------------------------+
//|                                              C_TemplateChart.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include <NanoEA-SIMD\Auxiliar\C_Terminal.mqh>
#include <NanoEA-SIMD\SubWindow\Chart IDE\C_Chart_IDE.mqh>
//+------------------------------------------------------------------+
class C_TemplateChart : public C_Chart_IDE
{
#define def_MaxTemplates		8
#define def_NameTemplateRAD	"IDE"
//+------------------------------------------------------------------+
	enum eTypeChart {INDICATOR, SYMBOL};
//+------------------------------------------------------------------+
	private	:
		struct st
		{
			string	szObjName,
						szSymbol,
						szTemplate;
			int		width;
		}m_Info[def_MaxTemplates];
		int					m_IdSubWin,
								m_Counter,
								m_CPre,
								m_Aggregate;
		long					m_handle;
		ENUM_TIMEFRAMES	m_Period;
//+------------------------------------------------------------------+
		void SetBase(string szTemplate, string szSymbol, int iScale, int iSize)
			{
#define macro_SetInteger(A, B) ObjectSetInteger(Terminal.Get_ID(), m_Info[m_Counter].szObjName, A, B)
				if (m_IdSubWin < 0)
				{
					m_IdSubWin = (int)ChartGetInteger(Terminal.Get_ID(), CHART_WINDOWS_TOTAL) - 1;
					m_Aggregate = m_CPre = m_Counter = 0;
				}
				m_Info[m_Counter].szObjName = __FILE__ + (string) MathRand() + (string) ObjectsTotal(Terminal.Get_ID(), -1, OBJ_CHART);
				m_Info[m_Counter].szTemplate = szTemplate;
				ObjectCreate(Terminal.Get_ID(), m_Info[m_Counter].szObjName, OBJ_CHART, m_IdSubWin, 0, 0);
				ObjectSetString(Terminal.Get_ID(), m_Info[m_Counter].szObjName, OBJPROP_SYMBOL, (m_Info[m_Counter].szSymbol = szSymbol));
				macro_SetInteger(OBJPROP_CHART_SCALE, iScale);
				macro_SetInteger(OBJPROP_CORNER, CORNER_LEFT_UPPER);
				macro_SetInteger(OBJPROP_XDISTANCE, 0);
				macro_SetInteger(OBJPROP_YDISTANCE, 0);
				macro_SetInteger(OBJPROP_XSIZE, ChartGetInteger(Terminal.Get_ID(), CHART_WIDTH_IN_PIXELS, m_IdSubWin));
				macro_SetInteger(OBJPROP_YSIZE, ChartGetInteger(Terminal.Get_ID(), CHART_HEIGHT_IN_PIXELS, m_IdSubWin));
				macro_SetInteger(OBJPROP_DATE_SCALE, false);
				macro_SetInteger(OBJPROP_PRICE_SCALE, false);
				macro_SetInteger(OBJPROP_PERIOD, m_Period);
				m_handle = ObjectGetInteger(Terminal.Get_ID(), m_Info[m_Counter].szObjName, OBJPROP_CHART_ID);
				if (szTemplate == def_NameTemplateRAD)
				{
					ChartSetInteger(m_handle, CHART_COLOR_BID, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_ASK, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_VOLUME, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_CANDLE_BEAR, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_CANDLE_BULL, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_CHART_LINE, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_CHART_DOWN, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_CHART_UP, clrNONE);
					ChartSetInteger(m_handle, CHART_COLOR_STOP_LEVEL, clrNONE);
					ChartSetInteger(m_handle, CHART_SHOW_ASK_LINE, false);
					ChartSetInteger(m_handle, CHART_SHOW_BID_LINE, false);
					ChartSetInteger(m_handle, CHART_SHOW_OHLC, false);
					ChartSetInteger(m_handle, CHART_SHOW_LAST_LINE, false);
					ChartSetInteger(m_handle, CHART_SHOW_TRADE_LEVELS, false);
				}
				m_Aggregate += iSize;
				m_Info[m_Counter].width = iSize;
				m_CPre += (iSize > 0 ? 1 : 0);
				m_Counter++;
#undef macro_SetInteger
			};
//+------------------------------------------------------------------+
		void Decode(string &szArg, int &iScale, int &iSize)
			{
#define def_ScaleDefault 4
#define macro_GetData(A) 		\
	b0 = false;						\
	for (c0++; (c0 < max) && (szArg[c0] == ' '); c0++);	\
	for (i0 = 0, i1 = c0; (c0 < max) && (szArg[c0] != A); i0 = (szArg[c0] != ' ' ? c0 - i1 + 1 : i0), c0++);	\
	if (szArg[c0] == A) sz1 = StringSubstr(szArg, i1, i0); else sz1 = "";
								
				string sz1;
				int i0, i1, c1 = StringLen(szArg);
				bool b0 = true;
				StringToUpper(szArg);
				iScale = def_ScaleDefault;
				m_Period = _Period;
				for (int c0 = 0, max = StringLen(szArg); c0 < max; c0++) switch (szArg[c0])
				{
					case ':':
						b0 = false;
						for (; (c0 < max) && ((szArg[c0] < '0') || (szArg[c0] > '9')); c0++);
						iScale = (int)(szArg[c0] - '0');
						iScale = ((iScale > 5) || (iScale < 0) ? def_ScaleDefault : iScale);
						break;
					case ' ':
						break;
					case '<':
						macro_GetData('>');
						if (sz1 == "1M") m_Period = PERIOD_M1; else
						if (sz1 == "2M") m_Period = PERIOD_M2; else
						if (sz1 == "3M") m_Period = PERIOD_M3; else
						if (sz1 == "4M") m_Period = PERIOD_M4; else
						if (sz1 == "5M") m_Period = PERIOD_M5; else
						if (sz1 == "6M") m_Period = PERIOD_M6; else
						if (sz1 == "10M") m_Period = PERIOD_M10; else
						if (sz1 == "12M") m_Period = PERIOD_M12; else
						if (sz1 == "15M") m_Period = PERIOD_M15; else
						if (sz1 == "20M") m_Period = PERIOD_M20; else
						if (sz1 == "30M") m_Period = PERIOD_M30; else
						if (sz1 == "1H") m_Period = PERIOD_H1; else
						if (sz1 == "2H") m_Period = PERIOD_H2; else
						if (sz1 == "3H") m_Period = PERIOD_H3; else
						if (sz1 == "4H") m_Period = PERIOD_H4; else
						if (sz1 == "6H") m_Period = PERIOD_H6; else
						if (sz1 == "8H") m_Period = PERIOD_H8; else
						if (sz1 == "12H") m_Period = PERIOD_H12; else
						if (sz1 == "1D") m_Period = PERIOD_D1; else
						if (sz1 == "1S") m_Period = PERIOD_W1; else
						if (sz1 == "1MES") m_Period = PERIOD_MN1;
						break;
					case '[':
						macro_GetData(']');
						iSize = (int) StringToInteger(sz1);
						break;
					default:
						c1 = (b0 ? c0 : c1);
						break;
				}
				szArg = StringSubstr(szArg, 0, c1 + 1);
#undef macro_GetData
#undef def_ScaleDefault
			}
//+------------------------------------------------------------------+
	public	:
		C_TemplateChart() : m_IdSubWin(-1), m_Counter(0), m_CPre(0) {};
//+------------------------------------------------------------------+
		~C_TemplateChart() 
			{
				ClearTemplateChart();
			}
//+------------------------------------------------------------------+
		void ClearTemplateChart(void)
			{
				for (char c0 = 0; c0 < m_Counter; c0++)
				{
					ObjectDelete(Terminal.Get_ID(), m_Info[c0].szObjName);
					SymbolSelect(m_Info[c0].szSymbol, false);
				}
				m_IdSubWin = -1;
			}
//+------------------------------------------------------------------+
		void AddTemplate(const eTypeChart type, const string szTemplate, int scale, int iSize)
			{
				if (m_Counter >= def_MaxTemplates) return;
				if (type == SYMBOL) SymbolSelect(szTemplate, true);
				SetBase(szTemplate, (type == INDICATOR ? _Symbol : szTemplate), scale, iSize);
				if (!ChartApplyTemplate(m_handle, szTemplate + ".tpl")) if (type == SYMBOL) ChartApplyTemplate(m_handle, "Default.tpl");
				if (szTemplate == def_NameTemplateRAD) C_Chart_IDE::Create(m_IdSubWin);
				ChartRedraw(m_handle);
			}
//+------------------------------------------------------------------+
		void Resize(void)
			{
#define macro_SetInteger(A, B) ObjectSetInteger(Terminal.Get_ID(), m_Info[c0].szObjName, A, B)
				int x0 = 0, x1, y = (int)(ChartGetInteger(Terminal.Get_ID(), CHART_HEIGHT_IN_PIXELS, m_IdSubWin));
				x1 = (int)((ChartGetInteger(Terminal.Get_ID(), CHART_WIDTH_IN_PIXELS, m_IdSubWin) - m_Aggregate) / (m_Counter > 0 ? (m_CPre == m_Counter ? m_Counter : (m_Counter - m_CPre)) : 1));
				for (char c0 = 0; c0 < m_Counter; x0 += (m_Info[c0].width > 0 ? m_Info[c0].width : x1), c0++)
				{
					macro_SetInteger(OBJPROP_XDISTANCE, x0);
					macro_SetInteger(OBJPROP_XSIZE, (m_Info[c0].width > 0 ? m_Info[c0].width : x1));
					macro_SetInteger(OBJPROP_YSIZE, y);
					if (m_Info[c0].szTemplate == "IDE") C_Chart_IDE::Resize(x0);
				}
				ChartRedraw();
#undef macro_SetInteger
			}
//+------------------------------------------------------------------+
		void AddThese(const eTypeChart type, string szArg)
			{
				string szLoc;
				int i0, iSize;
				StringToUpper(szArg);
				StringAdd(szArg, ";");
				for (int c0 = 0, c1 = 0, c2 = 0, max = StringLen(szArg); c0 < max; c0++) switch (szArg[c0])
				{
					case ';':
						if (c1 != c2)
						{
							szLoc = StringSubstr(szArg, c1, c2 - c1 + 1);
							Decode(szLoc, i0, iSize);
							AddTemplate(type, szLoc, i0, iSize);
						}
						c1 = c2 = (c0 + 1);
						break;
					case ' ':
						c1 = (c1 >= c2 ? c0 + 1 : c1);
						break;
					default:
						c2 = c0;
						break;
				}
			}
//+------------------------------------------------------------------+
#undef def_MaxTemplates
#undef def_NameTemplateRAD
};
//+------------------------------------------------------------------+
