//+------------------------------------------------------------------+
//|                                         WinKernel32.mqh          |
//|                                         Copyright  Zhunko       |
//|21.12.2007                               MF ZHUNKO zhunko@mail.ru |
//+------------------------------------------------------------------+
//|  WinAPI - -   -                  |
//|  http://books.kulichki.ru/data/api/api1/index0.htm               |
//+------------------------------------------------------------------+
#define copyright "Copyright  2007, Zhunko"
#define link      "zhunko@zhunko.ru"
//
//====    . ======================================================================================================================================================================
#define CREATE_NEW                   1
#define CREATE_ALWAYS                2
#define OPEN_EXISTING                3
#define OPEN_ALWAYS                  4
#define FILE_SHARE_READ              0x0001
#define FILE_SHARE_WRITE             0x0002
#define FILE_MAP_WRITE               0x0002
#define FILE_MAP_READ                0x0004
#define GENERIC_READ                 0x80000000
#define GENERIC_WRITE                0x40000000
#define PAGE_READONLY                0x0002
#define PAGE_READWRITE               0x0004
//====    "_lopen()". ===================================================================================================================================================================
                                                // ----  "iReadWrite".------------------------------------------------------------------------------------------------------------------------------
#define OF_READ_                     0          //     
#define OF_WRITE_                    1          //     
#define OF_READWRITE_                2          //     /
#define OF_SHARE_COMPAT_             3          //       .            .         ,   HFILE_ERROR.
#define OF_SHARE_DENY_NONE_          4          //          /  .        OF_SHARE_COMPAT,   HFILE_ERROR.
#define OF_SHARE_DENY_READ_          5          //            .        OF_SHARE_COMPAT / OF_READ  OF_READWRITE,   HFILE_ERROR.
#define OF_SHARE_DENY_WRITE_         6          //            .        OF_SHARE_COMPAT / OF_READ  OF_READWRITE,   HFILE_ERROR.
#define OF_SHARE_EXCLUSIVE_          7          //             /.          ( ).       .
//====    "CreateFile()". ===============================================================================================================================================================
                                                // ----  "dwDesiredAccess". ------------------------------------------------------------------------------------------------------------------------
//#define GENERIC_EXECUTE                         //    .
#define GENERIC_WRITE                0x40000000 //     .
#define GENERIC_READ                 0x80000000 //     .
                                                // ----     "dwDesiredAccess". -------------------------------------------------------------------------------------------
#define FILE_ADD_FILE                0x0002     //  ,     .
#define FILE_ADD_SUBDIRECTORY        0x0004     //  ,   subdirectory.
//#define FILE_ALL_ACCESS                         //      .
#define FILE_APPEND_DATA             0x0004     //   ,     .
#define FILE_CREATE_PIPE_INSTANCE    0x0004     //   ,   .
#define FILE_DELETE_CHILD            0x0040     //  ,      ,   ,     .
#define FILE_EXECUTE                 0x0020     //    ,   .        ,   ,     .
#define FILE_LIST_DIRECTORY          0x0001     //  ,    .
#define FILE_READ_ATTRIBUTES         0x0080     //    .
#define FILE_READ_DATA               0x0001     //   ,     .   ,     .
#define FILE_READ_EA                 0x0008     //     .
#define FILE_TRAVERSE                0x0020     //  ,   .  ,    BYPASS_TRAVERSE_CHECKING,     FILE_TRAVERSE.
#define FILE_WRITE_ATTRIBUTES        0x0100     //    .
#define FILE_WRITE_DATA              0x0002     //   ,     .   ,      (FILE_ADD_FILE).
#define FILE_WRITE_EA                0x0010     //     .
//#define STANDARD_RIGHTS_READ                    //  READ_CONTROL,  -          .      SACL.
//#define STANDARD_RIGHTS_WRITE                   // ,  STANDARD_RIGHTS_READ.
//#define SYNCHRONIZE                             //         .
                                                // ----  "dwShareMode". ----------------------------------------------------------------------------------------------------------------------------
#define FILE_SHARE_NO                0x00000000 //    .
#define FILE_SHARE_READ              0x00000001 //          .
#define FILE_SHARE_WRITE             0x00000002 //          .
#define FILE_SHARE_DELETE            0x00000004 //          . 
                                                // ----  "dwCreationDisposition".-------------------------------------------------------------------------------------------------------------------
#define CREATE_NEW                   1          //   ,    .
#define CREATE_ALWAYS                2          //   , .
#define OPEN_EXISTING                3          //    ,   .
#define OPEN_ALWAYS                  4          //  , .
#define TRUNCATE_EXISTING            5          //        -  ,    .
                                                // ----  "dwFlagsAndAttributes". -------------------------------------------------------------------------------------------------------------------
                                                // ---- . -------------------------------------------------------------------------------------------------------------------------------------------
#define FILE_ATTRIBUTE_READONLY      0x1        //    (1)   .    ,        .
#define FILE_ATTRIBUTE_HIDDEN        0x2        //    (2)  .       .
#define FILE_ATTRIBUTE_SYSTEM        0x4        //    (4)        .
#define FILE_ATTRIBUTE_ARCHIVE       0x20       //   (32)    .    ,       .
#define FILE_ATTRIBUTE_NORMAL        0x80       //  (128)      .   -      .
#define FILE_ATTRIBUTE_TEMPORARY     0x100      //  (256)     .
#define FILE_ATTRIBUTE_OFFLINE       0x1000     // (4096)     .   ,       offline .
#define FILE_ATTRIBUTE_ENCRYPTED     0x4000     //(16384)    .
                                                // ---- . ----------------------------------------------------------------------------------------------------------------------------------------------
#define FILE_FLAG_BACKUP_SEMANTICS   0x02000000 //         .
#define FILE_FLAG_DELETE_ON_CLOSE    0x04000000 //      .
#define FILE_FLAG_NO_BUFFERING       0x20000000 //      ,      .
#define FILE_FLAG_OPEN_NO_RECALL     0x00100000 //   ,        .
#define FILE_FLAG_OPEN_REPARSE_POINT 0x00200000 //  reparse    ; CreateFile   reparse .
#define FILE_FLAG_OVERLAPPED         0x40000000 //         /.
#define FILE_FLAG_POSIX_SEMANTICS    0x0100000  //     POSIX.
#define FILE_FLAG_RANDOM_ACCESS      0x10000000 //    .      ,    .
#define FILE_FLAG_SEQUENTIAL_SCAN    0x08000000 //      ,  .      ,    .
#define FILE_FLAG_WRITE_THROUGH      0x80000000 //        ,     .
//====    "OpenFile()". =================================================================================================================================================================
                                                // ----  "wStyle". ---------------------------------------------------------------------------------------------------------------------------------
#define OF_CANCEL                    0x00000800 // .  ,    ,   ,  OF_PROMPT.
#define OF_CREATE                    0x00001000 //   .   ,     (0) .
#define OF_DELETE                    0x00000200 //  .
#define OF_EXIST                     0x00004000 //     .  ,     .
#define OF_PARSE                     0x00000100 //   OFSTRUCT,    - .
#define OF_PROMPT                    0x00002000 //        .
#define OF_READ                      0x00000000 //     .
#define OF_READWRITE                 0x00000002 //    / .
#define OF_REOPEN                    0x00008000 //        .
#define OF_SHARE_COMPAT              0x00000000 //    -DOS based,     ,      ,     .
#define OF_SHARE_DENY_NONE           0x00000040 //           .
#define OF_SHARE_DENY_READ           0x00000030 //         .
#define OF_SHARE_DENY_WRITE          0x00000020 //         .
#define OF_SHARE_EXCLUSIVE           0x00000010 //         /    .
//#define OF_VERIFY                               // ,             .         .
#define OF_WRITE                     0x00000001 //     .
//====    "SetFilePointer()". ===========================================================================================================================================================
#define FILE_BEGIN                   0          //   .
#define FILE_CURRENT                 1          //   .
#define FILE_END                     2          //   .
//==========================================================================================================================================================================================================
#import "kernel32.dll"
 //   p    .    p    HFILE_ERROR = -1.
 int    _hread (int    hFile,    //  .
     /*VARIANT*/string lpBuffer, // p/ p.
                int    lBytes);  //   .     -  .
 //    p   .    p    HFILE_ERROR = -1.
 int    _hwrite (int    hFile,    //  .
      /*VARIANT*/string lpBuffer, // p/ p.
                 int    lBytes);  //   .     -  .
 // p  . p: 0.    p    HFILE_ERROR = -1.
 int    _lclose (int hFile); //  .
 //   .   p:  .    p    HFILE_ERROR = -1.
 int    _lcreat (string lpPathName,  // p, p    .
                 int    iAttribute); // 0 -   ; 1 -  ; 2 - ; 3 - .
 //    p . p   .    p    HFILE_ERROR = -1.
 int    _llseek (int hFile,    //  .
                 int lOffset,  //  ,  p p .
                 int iOrigin); //     p p: 0 - p  ; 1 -   ; 2 -    .
 // p  . p  .    p    HFILE_ERROR = -1.
 int    _lopen (string lpPathName,  // p, p    .
                int    iReadWrite); //  .
 //   p    . p:   ; 0 -   .    p    HFILE_ERROR = -1.
 int    _lread (int    hFile,    //  .
     /*VARIANT*/string lpBuffer, // p/ p.
                int    wBytes);  //   .     -  .
 //    p   . p   .    p    HFILE_ERROR = -1.
 int    _lwrite (int    hFile,    //  .
      /*VARIANT*/string lpBuffer, // p/ p.
                 int    wBytes);  //   .     -  .
 // 
 int    AddAtomA (string lpString);
 int    AllocConsole ();
 int    BackupRead (int hFile, int lpBuffer /*char*/, int nNumberOfBytesToRead, int lpNumberOfBytesRead, int bAbort, int bProcessSecurity, int lpContext /*VARIANT*/);
 int    BackupSeek (int hFile, int dwLowBytesToSeek, int dwHighBytesToSeek, int lpdwLowByteSeeked, int lpdwHighByteSeeked, int lpContext);
 int    BackupWrite (int hFile, int lpBuffer /*char*/, int nNumberOfBytesToWrite, int lpNumberOfBytesWritten, int bAbort, int bProcessSecurity, int lpContext);
 int    Beep (int dwFreq, int dwDuration);
 int    BeginUpdateResourceA (string pFileName, int bDeleteExistingResources);
 int    BuildCommDCBA (string lpDef, int lpDCB /*DCB*/);
 int    BuildCommDCBAndTimeoutsA (string lpDef, int lpDCB /*DCB*/, int lpCommTimeouts /*COMMTIMEOUTS*/);
 int    ClearCommBreak (int nCid);
 int    ClearCommError (int hFile, int lpErrors, int lpStat /*COMSTAT*/);
 //        .     TRUE,  FALSE.
 bool   CloseHandle (int hObject); //   ,      CreateFileMapping.
 bool   CommConfigDialogA (string lpszName, int hWnd, int lpCC /*COMMCONFIG*/);
 int    CompareFileTime (int lpFileTime1 /*FILETIME*/, int lpFileTime2 /*FILETIME*/);
 int    CompareStringA (int Locale, int dwCmpFlags, string lpString1, int cchCount1, string lpString2, int cchCount2);
 int    ConnectNamedPipe (int hNamedPipe, int lpOverlapped /*OVERLAPPED*/);
 int    ContinueDebugEvent (int dwProcessId, int dwThreadId, int dwContinueStatus);
 int    ConvertDefaultLocale (int Locale);
 int    CopyFileA (string lpExistingFileName, string lpNewFileName, int bFailIfExists);
 int    CreateDirectoryA (string lpPathName, int lpSecurityAttributes /*SECURITY_ATTRIBUTES*/);
 int    CreateDirectoryExA (string lpTemplateDirectory, string lpNewDirectory, int lpSecurityAttributes /*SECURITY_ATTRIBUTES*/);
 int    CreateEventA (int lpEventAttributes /*SECURITY_ATTRIBUTES*/, int bManualReset, int bInitialState, string lpName);
 //  .    ,      .    - HFILE_ERROR (-1).
 int    CreateFileA (string lpFileName,            //      .
                     int    dwDesiredAccess,       //      ,      , ,    (NULL). 
                                                   //     - GENERIC_READ, GENERIC_WRITE,   (GENERIC_READ | GENERIC_WRITE).
                                                   //     ,       , , ,
                                                   //     ,    ,     GENERIC_READ  .      ,
                                                   //     ,    dwShareMode   ,     .
                                                   // ---- Access right. -----------------------+-----------------------------------------------------------------------------------------------------------
                                                   // GENERIC_EXECUTE	FILE_READ_ATTRIBUTES    |  ()   :
                                                   //                   STANDARD_RIGHTS_EXECUTE | CreateFileA (PathName, GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, CREATE_ALWAYS, 0, 0);
                                                   //                   SYNCHRONIZE             +-----------------------------------------------------------------------------------------------------------
                                                   // GENERIC_READ	   FILE_READ_ATTRIBUTES    |      :
                                                   //                   FILE_READ_DATA          | CreateFileA (PathName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, 0, 0);
                                                   //                   FILE_READ_EA            +-----------------------------------------------------------------------------------------------------------
                                                   //                   STANDARD_RIGHTS_READ    |    :
                                                   //                   SYNCHRONIZE             | CreateFileA (PathName, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, 0, 0);
                                                   // GENERIC_WRITE     FILE_APPEND_DATA        +-----------------------------------------------------------------------------------------------------------
                                                   //                   FILE_WRITE_ATTRIBUTES
                                                   //                   FILE_WRITE_DATA
                                                   //                   FILE_WRITE_EA
                                                   //                   STANDARD_RIGHTS_WRITE
                                                   //                   SYNCHRONIZE
                                                   // ---- Access right. -----------------------------------------------------------------------------------------------------------------------------------
                                                   // FILE_ADD_FILE             0x0002  ,     .
                                                   // FILE_ADD_SUBDIRECTORY     0x0004  ,   subdirectory.
                                                   // FILE_ALL_ACCESS                       .
                                                   // FILE_APPEND_DATA          0x0004   ,     . (  ,    
                                                   //                                         FILE_WRITE_DATA.)   ,  
                                                   //                                  subdirectory (FILE_ADD_SUBDIRECTORY).
                                                   // FILE_CREATE_PIPE_INSTANCE 0x0004   ,   .
                                                   // FILE_DELETE_CHILD         0x0040  ,      ,   ,     .
                                                   // FILE_EXECUTE              0x0020    ,   .        ,
                                                   //                                    ,     .
                                                   // FILE_LIST_DIRECTORY       0x0001  ,    .
                                                   // FILE_READ_ATTRIBUTES      0x0080    .
                                                   // FILE_READ_DATA            0x0001   ,     .   ,  
                                                   //                                    .
                                                   // FILE_READ_EA              0x0008     .
                                                   // FILE_TRAVERSE             0x0020  ,   .  ,    BYPASS_TRAVERSE_CHECKING,
                                                   //                                      FILE_TRAVERSE.        .
                                                   // FILE_WRITE_ATTRIBUTES     0x0100    .
                                                   // FILE_WRITE_DATA           0x0002   ,     .   ,      (FILE_ADD_FILE).
                                                   // FILE_WRITE_EA             0x0010     .
                                                   // STANDARD_RIGHTS_READ              READ_CONTROL,  -          .
                                                   //                                       SACL.
                                                   // STANDARD_RIGHTS_WRITE            ,  STANDARD_RIGHTS_READ.
                                                   // SYNCHRONIZE                              .   ,     /,
                                                   //                                                 .
                     int    dwShareMode,           //    .
                                                   // FILE_SHARE_NO      0x00000000      .
                                                   // FILE_SHARE_DELETE  0x00000004            .
                                                   //                                   ,             .
                                                   //                                     ,        ,   .
                                                   //                                  ,       .
                                                   // FILE_SHARE_READ    0x00000001            .
                                                   //                                   ,             .
                                                   //                                     ,        ,   .
                                                   // FILE_SHARE_WRITE   0x00000002            .
                                                   //                                   ,             .
                                                   //                                     ,           ,
                                                   //                                    ,   .
                     int    lpSecurityAttributes,  //    SECURITY_ATTRIBUTES,        :   ,
                                                   //   ,         .     NULL.
                                                   //    NULL,   CreateFile       ,    
                                                   //           .  lpSecurityDescriptor  
                                                   // SECURITY_DESCRIPTOR    .    NULL,         
                                                   //  . CreateFile   lpSecurityDescriptor        
                                                   //   bInheritHandle.  bInheritHandle       .
                     int    dwCreationDisposition, // ,      ,     .    ,    
                                                   //  OPEN_EXISTING.        ,     :
                                                   // CREATE_ALWAYS     2    , .      - writable,   ,   ,
                                                   //                            ERROR_ALREADY_EXISTS (183).       -  ,
                                                   //                        ,   ,       .
                                                   // CREATE_NEW        1    ,   .   ,         
                                                   //                      ERROR_FILE_EXISTS (80).           writable,    .
                                                   // OPEN_ALWAYS       4   , .   ,         ERROR_ALREADY_EXISTS (183).
                                                   //                                writable,        - .
                                                   // OPEN_EXISTING     3     ,    .      ,    
                                                   //                           ERROR_FILE_NOT_FOUND (2).
                                                   // TRUNCATE_EXISTING 5	       -  ,    .    , 
                                                   //                           ERROR_FILE_NOT_FOUND (2).        GENERIC_WRITE 
                                                   //                         dwDesiredAccess.
                     int    dwFlagsAndAttributes,  //      , FILE_ATTRIBUTE_NORMAL       .    
                                                   //      (FILE_ATTRIBUTE_*).      FILE_ATTRIBUTE_NORMAL.
                                                   //        (FILE_FLAG_*)     ,  ,  ,
                                                   //    .     FILE_ATTRIBUTE_* .       
                                                   //     SECURITY_SQOS_PRESENT.   SQOS     ,  
                                                   //    .   CreateFile   ,        
                                                   //           dwFlagsAndAttributes.      
                                                   //   .                  , 
                                                   // CreateFile  .   ,          .
                                                   // ------------ . -------------------------------------------------------------------------------------------------------------------------------
                                                   // FILE_ATTRIBUTE_ARCHIVE      32  0x20           .    ,       .
                                                   // FILE_ATTRIBUTE_ENCRYPTED 16384  0x4000         .  ,  ,      .
                                                   //                                              ,  ,          .
                                                   //                                                   FILE_ATTRIBUTE_SYSTEM  .
                                                   // FILE_ATTRIBUTE_HIDDEN        2  0x2          .       .
                                                   // FILE_ATTRIBUTE_NORMAL      128  0x80             .    ,    .
                                                   // FILE_ATTRIBUTE_OFFLINE    4096  0x1000          .   ,     
                                                   //                                              offline .     ,   
                                                   //                                              .       .
                                                   // FILE_ATTRIBUTE_READONLY      1  0x1           .    ,        .
                                                   // FILE_ATTRIBUTE_SYSTEM        4  0x4                .
                                                   // FILE_ATTRIBUTE_TEMPORARY   256  0x100           .
                                                   // ------------- . ---------------------------------------------------------------------------------------------------------------------------------
                                                   // FILE_FLAG_BACKUP_SEMANTICS      0x02000000          .  ,  
                                                   //                                                     SE_BACKUP_NAME  
                                                   //                                             SE_RESTORE_NAME.  ,     .
                                                   //                                                 ,     .      
                                                   //                                                 .  ,   .
                                                   // FILE_FLAG_DELETE_ON_CLOSE       0x04000000       ,    
                                                   //                                                   .      ,  
                                                   //                                                      FILE_SHARE_DELETE.  
                                                   //                                                 ,    FILE_SHARE_DELETE  .
                                                   // FILE_FLAG_NO_BUFFERING          0x20000000       ,      .
                                                   //                                                        .   
                                                   //                                                  CreateFile,   FILE_FLAG_NO_BUFFERING,
                                                   //                                                 .
                                                   // FILE_FLAG_OPEN_NO_RECALL        0x00100000    ,        .
                                                   //                                                   .       .
                                                   // FILE_FLAG_OPEN_REPARSE_POINT    0x00200000   reparse    ; CreateFile   reparse .
                                                   //                                               ,   ,    ,   , .
                                                   //                                                    CREATE_ALWAYS.   -  reparse ,    .
                                                   // FILE_FLAG_OVERLAPPED            0x40000000          /.    /
                                                   //                                                ,    OVERLAPPED      .
                                                   //                                                ,          .
                                                   //                                                 ,   /  ,        
                                                   //                                               OVERLAPPED .
                                                   // FILE_FLAG_POSIX_SEMANTICS       0x0100000       POSIX.       ,
                                                   //                                                , ,   ,     .
                                                   //                                                  ,        
                                                   //                                              ,    -DOS  16- Windows.
                                                   // FILE_FLAG_RANDOM_ACCESS         0x10000000     .      ,  
                                                   //                                              .            /  FILE_FLAG_NO_BUFFERING.
                                                   // FILE_FLAG_SEQUENTIAL_SCAN       0x08000000       ,  .     
                                                   //                                             ,    .       -
                                                   //                                             ( , ( ) ),  .       
                                                   //                                                 /  FILE_FLAG_NO_BUFFERING.
                                                   // FILE_FLAG_WRITE_THROUGH         0x80000000         ,     .
                     int    hTemplateFile);        //       GENERIC_READ.          ,  .
                                                   //     NULL.    , CreateFile   .     ,
                                                   //          .
 //     C   .   -        ()    ,  THandle.
 //              .    -       ,     0.
 int    CreateFileMappingA (int hFile,                  //   -       $FFFFFFFF  
                                                        //  Windows.pas  MAXDWORD         -.
    /*SECURITY_ATTRIBUTES*/ int lpFileMappigAttributes, //     TSecurityAttributes,        -    NULL.
                            int flProtect,              //     ,         .
                                                        // PAGE_READWRITE -          (    fmOpenReadWrite);
                                                        // PAGE_READONLY  -     (        fmOpenRead);
                                                        // PAGE_WRITECOPY -      ,         
                                                        //                  (    ,               );
                            int dwMaximumSizeHigh,      //   64-         ( 4 Gbt)-     :) -     0.
                            int dwMaximumSizeLow,       //   64-         -   dwMaximumSizeHigh  0,      
                                                        //        .     ,   ""  Intel  4 KBt, ..    1   
                                                        // "   " :)  4 KBt,   4001,           8Kbt   ..
                                                        //     0,      .
                            string lpName);             //    .
 int    CreateIoCompletionPort (int FileHandle, int ExistingCompletionPort, int CompletionKey, int NumberOfConcurrentThreads);
 int    CreateMailslotA (string lpName, int nMaxMessageSize, int lReadTimeout, int lpSecurityAttributes /*SECURITY_ATTRIBUTES*/);
 int    CreateMutexA (int lpMutexAttributes /*SECURITY_ATTRIBUTES*/, int bInitialOwner, string lpName);
 int    CreateNamedPipeA (string lpName, int dwOpenMode, int dwPipeMode, int nMaxInstances, int nOutBufferSize, int nInBufferSize, int nDefaultTimeOut, int lpSecurityAttributes /*SECURITY_ATTRIBUTES*/);
 int    CreatePipe (int phReadPipe, int phWritePipe, int lpPipeAttributes /*SECURITY_ATTRIBUTES*/, int nSize);
 int    CreateProcessA (string lpApplicationName, string lpCommandLine, int lpProcessAttributes /*SECURITY_ATTRIBUTES*/, int lpThreadAttributes /*SECURITY_ATTRIBUTES*/, int bInheritHandles, int dwCreationFlags, int lpEnvironment /*VARIANT*/, string lpCurrentDriectory, int lpStartupInfo /*STARTUPINFO*/, int lpProcessInformation /*PROCESS_INFORMATION*/);
 int    CreateProcessAsUserA (int hToken, string lpApplicationName, string lpCommandLine, int lpProcessAttributes /*SECURITY_ATTRIBUTES*/, int lpThreadAttributes /*SECURITY_ATTRIBUTES*/, int bInheritHandles, int dwCreationFlags, string lpEnvironment, string lpCurrentDirectory, int lpStartupInfo /*STARTUPINFO*/, int lpProcessInformation /*PROCESS_INFORMATION*/);
 int    CreateRemoteThread (int hProcess, int lpThreadAttributes /*SECURITY_ATTRIBUTES*/, int dwStackSize, int lpStartAddress, int lpParameter /*VARIANT*/, int dwCreationFlags, int lpThreadId);
 int    CreateSemaphoreA (int lpSemaphoreAttributes /*SECURITY_ATTRIBUTES*/, int lInitialCount, int lMaximumCount, string lpName);
 int    CreateTapePartition (int hDevice, int dwPartitionMethod, int dwCount, int dwSize);
 int    CreateThread (int lpThreadAttributes /*SECURITY_ATTRIBUTES*/, int dwStackSize, int lpStartAddress, int lpParameter /*VARIANT*/, int dwCreationFlags, int lpThreadId);
 int    DefineDosDeviceA (int dwFlags, string lpDeviceName, string lpTargetPath);
 int    DeleteAtom (int nAtom);
 void   DeleteCriticalSection (int lpCriticalSection /*CRITICAL_SECTION*/);
 bool   DeleteFileA (string lpFileName);
 int    DeviceIoControl (int hDevice, int dwIoControlCode, int lpInBuffer /*VARIANT*/, int nInBufferSize, int lpOutBuffer /*VARIANT*/, int nOutBufferSize, int lpBytesReturned, int lpOverlapped /*OVERLAPPED*/);
 bool   DisableThreadLibraryCalls (int hLibModule);
 int    DisconnectNamedPipe (int hNamedPipe);
 int    DosDateTimeToFileTime (int wFatDate, int wFatTime, int lpFileTime /*FILETIME*/);
 int    DuplicateHandle (int hSourceProcessHandle, int hSourceHandle, int hTargetProcessHandle, int lpTargetHandle, int dwDesiredAccess, int bInheritHandle, int dwOptions);
 int    EndUpdateResource (int hUpdate, int fDiscard);
 void   EnterCriticalSection (int lpCriticalSection /*CRITICAL_SECTION*/);
 bool   EnumCalendarInfoA (int lpCalInfoEnumProc, int Locale, int Calendar, int CalType);
 int    EnumDateFormats (int lpDateFmtEnumProc, int Locale, int dwFlags);
 bool   EnumResourceLanguagesA (int hModule, string lpType, string lpName, int lpEnumFunc, int lParam);
 bool   EnumResourceLanguagesW (int hModule, string lpType, string lpName, int lpEnumFunc, int lParam);
 bool   EnumResourceNamesA (int hModule, string lpType, int lpEnumFunc, int lParam);
 bool   EnumResourceTypesA (int hModule, int lpEnumFunc, int lParam);
 int    EnumSystemCodePages (int lpCodePageEnumProc, int dwFlags);
 int    EnumSystemLocales (int lpLocaleEnumProc, int dwFlags);
 int    EnumTimeFormats (int lpTimeFmtEnumProc, int Locale, int dwFlags);
 int    EraseTape (int hDevice, int dwEraseType, int bimmediate);
 int    EscapeCommFunction (int nCid, int nFunc);
 void   ExitProcess (int uExitCode);
 void   ExitThread (int dwExitCode);
 int    ExpandEnvironmentStringsA (string lpSrc, string lpDst, int nSize);
 void   FatalAppExitA (int uAction, string lpMessageText);
 void   FatalExit (int code);
 int    FileTimeToDosDateTime (int lpFileTime /*FILETIME*/, int lpFatDate, int lpFatTime);
 int    FileTimeToLocalFileTime (int lpFileTime /*FILETIME*/, int lpLocalFileTime /*FILETIME*/);
 int    FileTimeToSystemTime (int lpFileTime /*FILETIME*/, int lpSystemTime /*SYSTEMTIME*/);
 int    FillConsoleOutputAttribute (int hConsoleOutput, int wAttribute, int nLength, int dwWriteCoord /*COORD*/, int lpNumberOfAttrsWritten);
 int    FillConsoleOutputCharacter (int hConsoleOutput, int cCharacter /*Byte*/, int nLength, int dwWriteCoord /*COORD*/, int lpNumberOfCharsWritten);
 int    FindAtomA (string lpString);
 int    FindAtomW (string lpString);
 //  FindClose    ,   FindFirstFile  FindFirstFileEx  FindFirstStreamW.
 //    ,   -  .
 //    ,    - . 
 bool   FindClose (int hFindFile); //     "FindFirstFileA()".
 int    FindCloseChangeNotification (int hChangeHandle);
 int    FindFirstChangeNotificationA (string lpPathName, int bWatchSubtree, int dwNotifyFilter);
 //  FindFirstFile           ,     .        .
 //    ,   -  ,      FindNextFile  FindClose.
 //    ,   - INVALID_HANDLE_VALUE. 
 int    FindFirstFileA (string lpFileName,        //   .
                        int&   lpFindFileData[]); //    WIN32_FIND_DATA,         .
 //  "FindFirstStreamA()"        .    ,   -  ,  
 //      FindNextStreamW.    ,   - INVALID_HANDLE_VALUE.
 int    FindFirstStreamA (string lpFileName, /*STREAM_INFO_LEVELS*/ int InfoLevel, int& lpFindStreamData[], int dwFlags);
 int    FindNextChangeNotification (int hChangeHandle);
 //  FindNextStreamA   ,     FindFirstStreamW.
 bool   FindNextStreamA (int hFindStream, /*LPVOID*/ int& lpFindStreamData[]);
 //  FindNextFile         FindFirstFile  FindFirstFileEx.    ,   -  .
 bool   FindNextFileA (int  hFindFile,         //     "FindFirstFileA()".
                       int& lpFindFileData[]); //    WIN32_FIND_DATA,         .
 int    FindResourceA (int hInstance, string lpName, string lpType);
 int    FindResourceExA (int hModule, string lpType, string lpName, int wLanguage);
 int    FormatMessageA (int dwFlags, string lpSource, int dwMessageId, int dwLanguageId, int& lpBuffer[], int nSize, int Arguments);
 int    FreeConsole();
 bool   FreeEnvironmentStringsA (string lpsz);
 int    FreeLibrary (int hLibModule);
 void   FreeLibraryAndExitThread (int hLibModule, int dwExitCode);
 bool   FreeResource (int hResData);
 int    GenerateConsoleCtrlEvent (int dwCtrlEvent, int dwProcessGroupId);
 int    GetACP();
 int    GetAtomNameA (int nAtom, string lpBuffer, int nSize);
 int    GetBinaryTypeA (string lpApplicationName, int lpBinaryType);
 string GetCommandLine();
 bool   GetCommConfig (int hCommDev, int lpCC /*COMMCONFIG*/, int lpdwSize);
 int    GetCommMask (int hFile, int lpEvtMask);
 int    GetCommModemStatus (int hFile, int lpModemStat);
 int    GetCommProperties (int hFile, int lpCommProp /*COMMPROP*/);
 int    GetCommState (int nCid, int lpDCB /*DCB*/);
 int    GetCommTimeouts (int hFile, int lpCommTimeouts /*COMMTIMEOUTS*/);
 int    GetCompressedFileSizeA (string lpFileName, int lpFileSizeHigh);
 int    GetComputerNameA (string lpBuffer, int nSize);
 int    GetConsoleCP();
 int    GetConsoleCursorInfo (int hConsoleOutput, int lpConsoleCursorInfo /*CONSOLE_CURSOR_INFO*/);
 int    GetConsoleMode (int hConsoleHandle, int lpMode);
 int    GetConsoleOutputCP();
 int    GetConsoleScreenBufferInfo (int hConsoleOutput, int lpConsoleScreenBufferInfo /*CONSOLE_SCREEN_BUFFER_INFO*/);
 int    GetCurrentProcess();
 int    GetDateFormatA (int Locale, int dwFlags, int lpDate /*SYSTEMTIME*/, string lpFormat, string lpDateStr, int cchDate);
 int    GetDateFormatW (int Locale, int dwFlags, int lpDate /*SYSTEMTIME*/, string lpFormat, string lpDateStr, int cchDate);
 bool   GetDefaultCommConfigA (string lpszName, int lpCC /*COMMCONFIG*/, int lpdwSize);
 int    GetDiskFreeSpaceA (string lpRootPathName, int lpSectorsPerCluster, int lpBytesPerSector, int lpNumberOfFreeClusters, int lpTtoalNumberOfClusters);
 int    GetDriveTypeA (string nDrive);
 string GetEnvironmentStringsA();
 int    GetEnvironmentVariableA (string lpName, string lpBuffer, int nSize);
 int    GetExitCodeProcess (int hProcess, int lpExitCode);
 int    GetExitCodeThread (int hThread, int lpExitCode);
 int    GetFileAttributesA (string lpFileName);
 int    GetFileInformationByHandle (int hFile, int lpFileInformation /*BY_HANDLE_FILE_INFORMATION*/);
 int    GetFileSize (int hFile, int lpFileSizeHigh);
 int    GetFileTime (int hFile, int lpCreationTime /*FILETIME*/, int lpLastAccessTime /*FILETIME*/, int lpLastWriteTime /*FILETIME*/);
 int    GetFileType (int hFile);
 int    GetFullPathNameA (string lpFileName , int nBufferLength, string lpBuffer, string lpFilePart);
 bool   GetHandleInformation (int hObject, int lpdwFlags);
 int/*COORD*/ GetLargestConsoleWindowSize (int hConsoleOutput);
// int    GetLastError();
 int    GetLocaleInfoA (int Locale, int LCType, string lpLCData, int cchData);
 void   GetLocalTime (/*SYSTEMTIME*/ int TimeArray[]);
        // int Year     = TimeArray[0] & 0x0000FFFF;
        // int Month    = TimeArray[0] >> 16;
        // int Day      = TimeArray[1] >> 16;
        // int Hour     = TimeArray[2] & 0x0000FFFF;
        // int Min      = TimeArray[2] >> 16;
        // int Sec      = TimeArray[3] & 0x0000FFFF;
        // int MilliSec = TimeArray[3] >> 16;
 int    GetLogicalDrives();
 int    GetLogicalDriveStringsA (int nBufferLength, string lpBuffer);
 int    GetMailslotInfo (int hMailslot, int lpMaxMessageSize, int lpNextSize, int lpMessageCount, int lpReadTimeout);
 int    GetModuleFileName (int hModule, string lpFileName, int nSize);
 int    GetModuleHandleA (string lpModuleName);
 int    GetOEMCP();
 int    GetOverlappedResult (int hFile, int lpOverlapped /*OVERLAPPED*/, int lpNumberOfBytesTransferred, int bWait);
 int    GetPriorityClass (int hProcess);
 int    GetPrivateProfileIntA (string lpApplicationName, string lpKeyName, int nDefault, string lpFileName);
 int    GetPrivateProfileSectionA (string lpAppName, string lpReturnedString, int nSize, string lpFileName);
 int    GetPrivateProfileStringA (string lpApplicationName, int lpKeyName /*VARIANT*/, string lpDefault, string lpReturnedString, int nSize, string lpFileName);
 int    GetProcAddress (int hModule, string lpProcName);
 int    GetProcessAffinityMask (int hProcess, int lpProcessAffinityMask, int SystemAffinityMask);
 int    GetProcessHeap();
 int    GetProcessHeaps (int NumberOfHeaps, int ProcessHeaps);
 int    GetProcessShutdownParameters (int lpdwLevel, int lpdwFlags);
 int    GetProcessTimes (int hProcess, int lpCreationTime /*FILETIME*/, int lpExitTime /*FILETIME*/, int lpKernelTime /*FILETIME*/, int lpUserTime /*FILETIME*/);
 bool   GetProcessWorkingSetSize (int hProcess, int lpMinimumWorkingSetSize, int lpMaximumWorkingSetSize);
 int    GetProfileIntA (string lpAppName, string lpKeyName, int nDefault);
 int    GetProfileSectionA ( string lpAppName, string lpReturnedString, int nSize);
 int    GetProfileStringA (string lpAppName, string lpKeyName, string lpDefault, string lpReturnedString, int nSize);
 bool   GetQueuedCompletionStatus (int CompletionPort, int lpNumberOfBytesTransferred, int lpCompletionKey, int lpOverlapped, int dwMilliseconds);
 int    GetShortPathName (string lpszLongPath, string lpszShortPath, int cchBuffer);
 void   GetStartupInfoA (int lpStartupInfo /*STARTUPINFO*/);
 int    GetStdHandle (int nStdHandle);
 bool   GetStringTypeA (int lcid, int dwInfoType, string lpSrcStr, int cchSrc, int lpCharType);
 bool   GetStringTypeExA (int Locale, int dwInfoType, string lpSrcStr, int cchSrc, int lpCharType);
 int    GetSystemPowerStatus (int lpSystemPowerStatus /*SYSTEM_POWER_STATUS*/);
 void   GetSystemTime (/*SYSTEMTIME*/ int TimeArray[]);
        // int Year     = TimeArray[0] & 0x0000FFFF;
        // int Month    = TimeArray[0] >> 16;
        // int Day      = TimeArray[1] >> 16;
        // int Hour     = TimeArray[2] & 0x0000FFFF;
        // int Min      = TimeArray[2] >> 16;
        // int Sec      = TimeArray[3] & 0x0000FFFF;
        // int MilliSec = TimeArray[3] >> 16;
 bool   GetSystemTimeAdjustment (int lpTimeAdjustment, int lpTimeIncrement, bool lpTimeAdjustmentDisabled);
 int    GetTapeParameters (int hDevice, int dwOperation, int lpdwSize, int lpTapeInformation /*VARIANT*/);
 int    GetTapePosition (int hDevice, int dwPositionType, int lpdwPartition, int lpdwOffsetLow, int lpdwOffsetHigh);
 int    GetTapeStatus (int hDevice);
 int    GetTempFileNameA (string lpszPath, string lpPrefixString, int wUnique, string lpTempFileName);
 int    GetTempPathA (int nBufferLength, string lpBuffer);
 int    GetThreadContext (int hThread, int lpContext /*CONTEXT*/);
 int    GetThreadLocale();
 int    GetThreadPriority (int hThread);
 int    GetThreadSelectorEntry (int hThread, int dwSelector, int lpSelectorEntry /*LDT_ENTRY*/);
 int    GetThreadTimes (int hThread, int lpCreationTime /*FILETIME*/, int lpExitTime /*FILETIME*/, int lpKernelTime /*FILETIME*/, int lpUserTime /*FILETIME*/);
// int    GetTickCount();
 int    GetTimeFormatA (int Locale, int dwFlags, int lpTime /*SYSTEMTIME*/, string lpFormat, string lpTimeStr, int cchTime);
 int    GetTimeZoneInformation (/*TIME_ZONE_INFORMATION*/ int TZInfoArray[17]);
        //     .
        // int gmt_shift = 0;
        // int ret = GetTimeZoneInformation (TZInfoArray);
        // if (ret != 0) gmt_shift = TZInfoArray[0];
        // Print ("Difference between your local time and GMT is: ", gmt_shift, " minutes");
        // if (ret == 2) gmt_shift += TZInfoArray[42];
        // Print ("Current difference between your local time and GMT is: ", gmt_shift, " minutes");
        //   (Year  ).
        // int Year  = TZInfoArray[17] & 0x0000FFFF;
        // int Month = TZInfoArray[17] >> 16;
        // int Day   = TZInfoArray[18] >> 16;
        // int Hour  = TZInfoArray[19] & 0x0000FFFF;
        // int Min   = TZInfoArray[19] >> 16;
        // int Sec   = TZInfoArray[20] & 0x0000FFFF;
        //   (Year  ).
        // int Year  = TZInfoArray[38] & 0x0000FFFF;
        // int Month = TZInfoArray[38] >> 16;
        // int Day   = TZInfoArray[39] >> 16;
        // int Hour  = TZInfoArray[40] & 0x0000FFFF;
        // int Min   = TZInfoArray[40] >> 16;
        // int Sec   = TZInfoArray[41] & 0x0000FFFF;
 int    GetUserDefaultLangID();
 int    GetUserDefaultLCID();
 int    GetVersion();
 int    GetVersionExA (int lpVersionInformation /*OSVERSIONINFO*/);
 int    GetVolumeInformationA (string lpRootPathName, string lpVolumeNameBuffer, int nVolumeNameSize, int lpVolumeSerialNumber, int lpMaximumComponentLength, int lpFileSystemFlags, string lpFileSystemNameBuffer, int nFileSystemNameSize);
 int    GetWindowsDirectoryA (string lpBuffer, int nSize);
 int    GlobalAddAtomA (string lpString);
 int    GlobalAddAtomW (string lpString);
 int    GlobalAlloc (int wFlags, int dwBytes);
 int    GlobalCompact (int dwMinFree);
 int    GlobalDeleteAtom (int nAtom);
 int    GlobalFindAtom (string lpString);
 void   GlobalFix (int hMem);
 int    GlobalFlags (int hMem);
 int    GlobalFree (int hMem);
 int    GlobalGetAtomNameA (int nAtom, string lpBuffer, int nSize);
 int    GlobalGetAtomNameW (int nAtom, string lpBuffer, int nSize);
 int    HeapAlloc (int hHeap, int dwFlags, int dwBytes);
 int    HeapCompact (int hHeap, int dwFlags);
 int    HeapCreate (int flOptions, int dwInitialSize, int dwMaximumSize);
 int    HeapDestroy (int hHeap);
 int    HeapFree (int hHeap, int dwFlags, string lpMem /*VARIANT*/);
 int    HeapLock (int hHeap);
 int    HeapReAlloc (int hHeap, int dwFlags, string lpMem /*VARIANT*/, int dwBytes);
 int    HeapSize (int hHeap, int dwFlags, string lpMem /*VARIANT*/);
 int    HeapUnlock (int hHeap);
 int    HeapValidate (int hHeap, int dwFlags, string lpMem /*VARIANT*/);
 int    ImpersonateLoggedOnUser (int hToken);
 int    InitAtomTable (int nSize);
 void   InitializeCriticalSection (int lpCriticalSection /*CRITICAL_SECTION*/);
 int    InterlockedDecrement (int lpAddend);
 int    InterlockedExchange (int Target, int Value);
 int    InterlockedIncrement (int lpAddend);
 bool   IsBadCodePtr (int lpfn);
 int    IsBadHugeReadPtr (string lp /*VARIANT*/, int ucb);
 int    IsBadHugeWritePtr (string lp /*VARIANT*/, int ucb);
 int    IsBadReadPtr (string lp /*VARIANT*/, int ucb);
 int    IsBadStringPtrA (string lpsz, int ucchMax);
 int    IsBadWritePtr (string lp /*VARIANT*/, int ucb);
 int    IsDBCSLeadByte (int bTestChar /*Byte*/);
 int    LCMapStringA (int Locale, int dwMapFlags, string lpSrcStr, int cchSrc, string lpDestStr, int cchDest);
 void   LeaveCriticalSection (int lpCriticalSection /*CRITICAL_SECTION*/);
 int    LoadLibraryA (string lpLibFileName);
 int    LoadLibraryExA (string lpLibFileName, int hFile, int dwFlags);
 int    LoadModule (string lpModuleName, int lpParameterBlock /*VARIANT*/);
 int    LoadResource (int hInstance, int hResInfo);
 int    LocalAlloc (int wFlags, int wBytes);
 int    LocalCompact (int uMinFree);
 int    LocalFileTimeToFileTime (int lpLocalFileTime /*FILETIME*/, int lpFileTime /*FILETIME*/);
 int    LocalFlags (int hMem);
 int    LocalFree (int hMem);
 int    LocalHandle (int wMem /*VARIANT*/);
 int    LocalLock (int hMem);
 int    LocalReAlloc (int hMem, int wBytes, int wFlags);
 int    LocalShrink (int hMem, int cbNewSize);
 int    LocalSize (int hMem);
 int    LocalUnlock (int hMem);
 int    LockFile (int hFile, int dwFileOffsetLow, int dwFileOffsetHigh, int nNumberOfBytesToLockLow, int nNumberOfBytesToLockHigh);
 int    LockFileEx (int hFile, int dwFlags, int dwReserved, int nNumberOfBytesToLockLow, int nNumberOfBytesToLockHigh, int lpOverlapped /*OVERLAPPED*/);
 int    LockResource (int hResData);
 int    LogonUserA (string lpszUsername, string lpszDomain, string lpszPassword, int dwLogonType, int dwLogonProvider, int phToken);
 int    lstrcatA (string lpString1, string lpString2);
 int    lstrcmpA (string lpString1, string lpString2);
 int    lstrcmpiA (string lpString1, string lpString2);
 int    lstrcpyA (string lpString1, string lpString2);
 int    lstrcpynA (string lpString1, string lpString2, int iMaxLength);
 int    lstrlenA (string lpString);
 //           .
 //      ,            ,  NIL.  Pointer - . 
 int    MapViewOfFile (int hFileMappingObject,    //  ()     .
                       int dwDesiredAccess,       //     .
                                                  // FILE_MAP_WRITE      -    .     CreateFileMapping    PAGE_READWRITE.
                                                  // FILE_MAP_READ       -   ,   CreateFileMapping    PAGE_READONLY  PAGE_READWRITE.
                                                  // FILE_MAP_ALL_ACCESS -  ,   FILE_MAP_WRITE.
                                                  // FILE_MAP_COPY       -      ,         .
                                                  //                         CreateFileMapping    PAGE_WRITECOPY.
                       int dwFileOffsetHigh,      // 64-    map-,     0.
                       int dwFileOffsetLow,       // 64-    map-,     0.
                       int dwNumberOfBytesToMap); //       ,      0,     .
 int    MapViewOfFileEx (int hFileMappingObject, int dwDesiredAccess, int dwFileOffsetHigh, int dwFileOffsetLow, int dwNumberOfBytesToMap, int lpBaseAddress /*VARIANT*/);
 int    MoveFileA (string lpExistingFileName, string lpNewFileName);
 int    MoveFileExA (string lpExistingFileName, string lpNewFileName, int dwFlags);
 int    MulDiv (int nNumber, int nNumerator, int nDenominator);
 int    MultiByteToWideChar (int CodePage, int dwFlags, string lpMultiByteStr, int cchMultiByte, string lpWideCharStr, int cchWideChar);
// int    ObjectOpenAuditAlarmA (string SubsystemName, int HandleId /*VARIANT*/, string ObjectTypeName, string ObjectName, int pSecurityDescriptor /*SECURITY_DESCRIPTOR*/, int ClientToken, int DesiredAccess, int GrantedAccess, int Privileges /*PRIVILEGE_SET*/, int ObjectCreation, int AccessGranted, int GenerateOnClose);
 int    OpenEventA (int dwDesiredAccess, int bInheritHandle, string lpName);
 //     .    ,      .    - HFILE_ERROR.
 int    OpenFile (string lpFileName,   //    .
    /*OFSTRUCT*/  int    lpReOpenBuff, //    OFSTRUCT,        .          OpenFile,
                                       //    .  OFSTRUCT      ,    OFS_MAXPATHNAME,  - 128 .
                                       // - ,      OpenFile,      ,   128 .  CreateFile      .
                  int    wStyle);      //  .          :
                                       // ---- . ---------------------------------------------------------------------------------------------------------------------------------------------------
                                       // OF_CANCEL           0x00000800 .  ,    ,   ,  OF_PROMPT.
                                       // OF_CREATE           0x00001000   .   ,     (0) .
                                       // OF_DELETE           0x00000200  .
                                       // OF_EXIST            0x00004000     .  ,     .
                                       // OF_PARSE            0x00000100   OFSTRUCT,    - .
                                       // OF_PROMPT           0x00002000        .    ,      ,  
                                       //                                     .    OpenFile,   --  .
                                       // OF_READ             0x00000000     .
                                       // OF_READWRITE        0x00000002    / .
                                       // OF_REOPEN           0x00008000        .
                                       // OF_SHARE_COMPAT     0x00000000    -DOS based,     ,      ,      ().
                                       //                                 ,         .      FILE_SHARE_READ|FILE_SHARE_WRITE  CreateFile.
                                       // OF_SHARE_DENY_NONE  0x00000040           .  -   DOS,   
                                       //                                     ,   .      FILE_SHARE_READ|FILE_SHARE_WRITE  CreateFile.
                                       // OF_SHARE_DENY_READ  0x00000030         .  -   DOS,     
                                       //                                ,       ,   .      FILE_SHARE_WRITE  CreateFile.
                                       // OF_SHARE_DENY_WRITE 0x00000020         .  -   DOS,     
                                       //                                ,       ,   .      FILE_SHARE_READ  CreateFile.
                                       // OF_SHARE_EXCLUSIVE  0x00000010         /    .        
                                       //                                / ,   ,   .
                                       // OF_VERIFY                      ,             .         .
                                       // OF_WRITE            0x00000001      .
 int    OpenFileMappingA (int dwDesiredAccess, int bInheritHandle, string lpName);
 int    OpenMutexA (int dwDesiredAccess, int bInheritHandle, string lpName);
 int    OpenProcess (int dwDesiredAccess, int bInheritHandle, int dwProcessId);
 int    OpenSemaphoreA (int dwDesiredAccess, int bInheritHandle, string lpName);
 void   OutputDebugStringA (string lpOutputString);
 int    PeekNamedPipe (int hNamedPipe, int lpBuffer /*VARIANT*/, int nBufferSize, int lpBytesRead, int lpTotalBytesAvail, int lpBytesLeftThisMessage);
 int    PrepareTape (int hDevice, int dwOperation, int bimmediate);
 int    PulseEvent (int hEvent);
 int    ReadConsoleOutputAttribute (int hConsoleOutput, int lpAttribute, int nLength, int dwReadCoord /*COORD*/, int lpNumberOfAttrsRead);
 int    ReadConsoleOutputCharacterA (int hConsoleOutput, string lpCharacter, int nLength, int dwReadCoord /*COORD*/, int lpNumberOfCharsRead);
 //     .     TRUE,  FALSE.
 bool   ReadFile (int  hFile,                 //  .
      /*VARIANT*/ int  lpBuffer,              //    .      .
                  int  nNumberOfBytesToRead,  //    .
                  int& lpNumberOfBytesRead[], //  ,          hFile.
                                              // ReadFile            .
                                              //  NULL      -  ,     .
                                              //     NULL   lpOverlapped   NULL.
   /*OVERLAPPED*/ int  lpOverlapped);         //   OVERLAPPED     hFile   FILE_FLAG_OVERLAPPED,       NULL.
                                              //  hFile  FILE_FLAG_OVERLAPPED, lpOverlapped        OVERLAPPED ,
                                              //       ,    .
                                              //  hFile,    ,     ,        ,
                                              //       .     Offset  OffsetHigh OVERLAPPED .
                                              //  hFile,     , Offset  OffsetHigh .
 bool   ReadFileEx (int hFile, int lpBuffer /*VARIANT*/, int nNumberOfBytesToRead, int lpOverlapped /*OVERLAPPED*/, int lpCompletionRoutine);
// int    ReadProcessMemory (int hProcess, int lpBaseAddress /*VARIANT*/, int lpBuffer /*VARIANT*/, int nSize, int lpNumberOfBytesWritten);
 int    ReadProcessMemory (int hProcess, int lpBaseAddress, string lpBuffer, int nSize, int& lpNumberOfBytesRead[]);
 int    ReleaseMutex (int hMutex);
 int    ReleaseSemaphore (int hSemaphore, int lReleaseCount, int lpPreviousCount);
 int    RemoveDirectoryA (string lpPathName);
 int    ResetEvent (int hEvent);
 int    ResumeThread (int hThread);
 void   RtlCopyMemory (int& Destination[] /*VARIANT*/, int Source[] /*VARIANT*/, int Length);
 void   RtlMoveMemory (int& Destination[] /*VARIANT*/, int Source[] /*VARIANT*/, int Length);
 int    SetCommBreak (int nCid);
 bool   SetCommConfig (int hCommDev, int lpCC /*COMMCONFIG*/, int dwSize);
 int    SetCommMask (int hFile, int dwEvtMask);
 int    SetCommState (int hCommDev, int lpDCB /*DCB*/);
 int    SetCommTimeouts (int hFile, int lpCommTimeouts /*COMMTIMEOUTS*/);
 int    SetComputerNameA (string lpComputerName);
 int    SetConsoleActiveScreenBuffer (int hConsoleOutput);
 int    SetConsoleCP (int wCodePageID);
 int    SetConsoleCtrlHandler (int HandlerRoutine, int Add);
 int    SetConsoleCursorInfo (int hConsoleOutput, int lpConsoleCursorInfo /*CONSOLE_CURSOR_INFO*/);
 int    SetConsoleCursorPosition (int hConsoleOutput, int dwCursorPosition /*COORD*/);
 int    SetConsoleMode (int hConsoleHandle, int dwMode);
 int    SetConsoleOutputCP (int wCodePageID);
 int    SetConsoleScreenBufferSize (int hConsoleOutput, int dwSize /*COORD*/);
 int    SetConsoleTextAttribute (int hConsoleOutput, int wAttributes);
 int    SetConsoleTitleA (string lpConsoleTitle);
 int    SetConsoleTitleW (string lpConsoleTitle);
 int    SetConsoleWindowInfo (int hConsoleOutput, int bAbsolute, int lpConsoleWindow /*SMALL_RECT*/);
 int    SetCurrentDirectoryA (string lpPathName);
 bool   SetDefaultCommConfigA (string lpszName, int lpCC /*COMMCONFIG*/, int dwSize);
 int    SetEndOfFile (int hFile);
 int    SetEnvironmentVariableA (string lpName, string lpValue);
 int    SetErrorMode (int wMode);
 int    SetEvent (int hEvent);
 void   SetFileApisToANSI();
 void   SetFileApisToOEM();
 int    SetFileAttributesA (string lpFileName, int dwFileAttributes);
 //   .   ,          (-1).
 int    SetFilePointer (int hFile,                //  .
                        int lDistanceToMove,      //          32-  NULL.
                        int lpDistanceToMoveHigh, //          32- 64-    NULL.
                        int dwMoveMethod);        //    . 0 - FILE_BEGIN      ;
                                                  //                                      1 - FILE_CURRENT    ;
                                                  //                                      2 - FILE_END        .
 int    SetFileTime (int hFile, int lpCreationTime /*FILETIME*/, int lpLastAccessTime /*FILETIME*/, int lpLastWriteTime /*FILETIME*/);
 bool   SetLocaleInfoA (int Locale, int LCType, string lpLCData);
 int    SetLocalTime (int lpSystemTime /*SYSTEMTIME*/);
 int    SetMailslotInfo (int hMailslot, int lReadTimeout);
 int    SetNamedPipeHandleState (int hNamedPipe, int lpMode, int lpMaxCollectionCount, int lpCollectDataTimeout);
 int    SetPriorityClass (int hProcess, int dwPriorityClass);
 int    SetProcessShutdownParameters (int dwLevel, int dwFlags);
 bool   SetProcessWorkingSetSize (int hProcess, int dwMinimumWorkingSetSize, int dwMaximumWorkingSetSize);
 int    SetStdHandle (int nStdHandle, int nHandle);
 int    SetSystemPowerState (int fSuspend, int fForce);
 int    SetSystemTime (int lpSystemTime /*SYSTEMTIME*/);
 bool   SetSystemTimeAdjustment (int dwTimeAdjustment, bool bTimeAdjustmentDisabled);
 int    SetTapeParameters (int hDevice, int dwOperation, int lpTapeInformation /*VARIANT*/);
 int    SetTapePosition (int hDevice, int dwPositionMethod, int dwPartition, int dwOffsetLow, int dwOffsetHigh, int bimmediate);
 int    SetThreadAffinityMask (int hThread, int dwThreadAffinityMask);
 int    SetThreadContext (int hThread, int lpContext /*CONTEXT*/);
 int    SetThreadLocale (int Locale);
 int    SetThreadPriority (int hThread, int nPriority);
 int    SetTimeZoneInformation (int lpTimeZoneInformation /*TIME_ZONE_INFORMATION*/);
 int    SetUnhandledExceptionFilter (int lpTopLevelExceptionFilter);
 int    SetupComm (int hFile, int dwInQueue, int dwOutQueue);
 int    SetVolumeLabelA (string lpRootPathName, string lpVolumeName);
 int    SuspendThread (int hThread);
 int    SystemTimeToFileTime (int lpSystemTime /*SYSTEMTIME*/, int lpFileTime /*FILETIME*/);
 int    SystemTimeToTzSpecificLocalTime (int lpTimeZoneInformation /*TIME_ZONE_INFORMATION*/, int lpUniversalTime /*SYSTEMTIME*/, int lpLocalTime /*SYSTEMTIME*/);
 int    TerminateProcess (int hProcess, int uExitCode);
 int    TerminateThread (int hThread, int dwExitCode);
 int    TlsAlloc();
 int    TlsFree (int dwTlsIndex);
 int    TlsGetValue (int dwTlsIndex);
 int    TlsSetValue (int dwTlsIndex, int lpTlsValue /*VARIANT*/);
 int    TransactNamedPipe (int hNamedPipe, int lpInBuffer /*VARIANT*/, int nInBufferSize, int lpOutBuffer /*VARIANT*/, int nOutBufferSize, int lpBytesRead, int lpOverlapped /*OVERLAPPED*/);
 int    TransmitCommChar (int nCid, int cChar /*Byte*/);
 int    UnhandledExceptionFilter (int ExceptionInfo /*EXCEPTION_POINTERS*/);
 int    UnlockFile (int hFile, int dwFileOffsetLow, int dwFileOffsetHigh, int nNumberOfBytesToUnlockLow, int nNumberOfBytesToUnlockHigh);
 int    UnlockFileEx (int hFile, int dwReserved, int nNumberOfBytesToUnlockLow, int nNumberOfBytesToUnlockHigh, int lpOverlapped /*OVERLAPPED*/);
 //       .  ,       TRUE,  FALSE.
 bool   UnmapViewOfFile (int lpBaseAddress /*VARIANT*/); //       ,   MapViewOfFile.
 int    UpdateResourceA (int hUpdate, string lpType, string lpName, int wLanguage, int lpData /*VARIANT*/, int cbData);
 int    VerLanguageNameA (int wLang, string szLang, int nSize);
 int    VirtualAlloc (int lpAddress, int dwSize, int flAllocationType, int flProtect);
 int    VirtualFree (int lpAddress, int dwSize, int dwFreeType);
 int    WaitCommEvent (int hFile, int lpEvtMask, int lpOverlapped /*OVERLAPPED*/);
 int    WaitForMultipleObjects (int nCount, int lpHandles, int bWaitAll, int dwMilliseconds);
 int    WaitForMultipleObjectsEx (int nCount, int lpHandles, int bWaitAll, int dwMilliseconds, int bAlertable);
 int    WaitForSingleObject (int hHandle, int dwMilliseconds);
 int    WaitForSingleObjectEx (int hHandle, int dwMilliseconds, int bAlertable);
 int    WaitNamedPipeA (string lpNamedPipeName, int nTimeOut);
 int    WideCharToMultiByte (int CodePage, int dwFlags, string lpWideCharStr, int cchWideChar, string lpMultiByteStr, int cchMultiByte, string lpDefaultChar, int lpUsedDefaultChar);
 int    WinExec (string lpCmdLine, int nCmdShow);
 int    WriteConsoleA (int hConsoleOutput, int lpBuffer /*VARIANT*/, int nNumberOfCharsToWrite, int lpNumberOfCharsWritten, int lpReserved /*VARIANT*/);
 //     .     TRUE,  FALSE.
 bool   WriteFile (int  hFile,                    //  .
       /*VARIANT*/ int  lpBuffer,                 //   .      .
                   int  nNumberOfBytesToWrite,    //  ,     .
                   int& lpNumberOfBytesWritten[], //  ,          hFile.
                                                  // WriteFile            .
                                                  //  NULL      -  ,     .
                                                  //     NULL   lpOverlapped   NULL.
                   int  lpOverlapped);            //   OVERLAPPED     hFile   FILE_FLAG_OVERLAPPED,        NULL.
                                                  //  hFile,    ,     ,        ,
                                                  //       .     Offset  OffsetHigh OVERLAPPED .
                                                  //  hFile,     , Offset  OffsetHigh .
                                                  //  ,     ,  Offset  OffsetHigh OVERLAPPED   0xFFFFFFFF.
                                                  //  -  ,     CreateFile,   hFile,   FILE_APPEND_DATA.
 int    WriteTapemark (int hDevice, int dwTapemarkType, int dwTapemarkCount, int bimmediate);
#import
//=================================================================================================================================================================-----------------------------------------------------------------------------------------------------------
                                       // OF_CANCEL           0x00000800 .  ,    ,   ,  OF_PROMPT.
                                       // OF_CREATE           0x00001000   .   ,     (0) .
                                       // OF_DELETE           0x00000200  .
                                       // OF_EXIST            0x00004000     .  ,     .
                                       // OF_PARSE            0x00000100   OFSTRUCT,    - .
                                       // OF_PROMPT           0x00002000        .    ,      ,  
                                       //                                     .    OpenFile,   --  .
                                       // OF_READ             0x00000000     .
                                       // OF_READWRITE        0x00000002    / .
                                       // OF_REOPEN           0x00008000        .
                                       // OF_SHARE_COMPAT     0x00000000    -DOS based,     ,      ,      ().
                                       //                                 ,         .      FILE_SHARE_READ|FILE_SHARE_WRITE  CreateFile.
                                       // OF_SHARE_DENY_NONE  0x00000040           .  -   DOS,   
                                       //                                     ,   .      FILE_SHARE_READ|FILE_SHARE_WRITE  CreateFile.
                                       // OF_SHARE_DENY_READ  0x00000030         .  -   DOS,     
                                       //                                ,       ,   .      FILE_SHARE_WRITE  CreateFile.
                                       // OF_SHARE_DENY_WRITE 0x00000020         .  -   DOS,     
                                       //                                ,       ,   .      FILE_SHARE_READ  CreateFile.
                                       // OF_SHARE_EXCLUSIVE  0x00000010         /    .        
                                       //                                / ,   ,   .
                                       // OF_VERIFY                      ,             .         .
                                       // OF_WRITE            0x00000001      .
 int    OpenFileMappingA (int dwDesiredAccess, int bInheritHandle, string lpName);
 int    OpenMutexA (int dwDesiredAccess, int bInheritHandle, string lpName);
 int    OpenProcess (int dwDesiredAccess, int bInheritHandle, int dwProcessId);
 int    OpenSemaphoreA (int dwDesiredAccess, int bInheritHandle, string lpName);
 void   OutputDebugStringA (string lpOutputString);
 int    PeekNamedPipe (int hNamedPipe, int lpBuffer /*VARIANT*/, int nBufferSize, int lpBytesRead, int lpTotalBytesAvail, int lpBytesLeftThisMessage);
 int    PrepareTape (int hDevice, int dwOperation, int bimmediate);
 int    PulseEvent (int hEvent);
 int    ReadConsoleOutputAttribute (int hConsoleOutput, int lpAttribute, int nLength, int dwReadCoord /*COORD*/, int lpNumberOfAttrsRead);
 int    ReadConsoleOutputCharacterA (int hConsoleOutput, string lpCharacter, int nLength, int dwReadCoord /*COORD*/, int lpNumberOfCharsRead);
 //     .     TRUE,  FALSE.
 bool   ReadFile (int  hFile,                 //  .
      /*VARIANT*/ int  lpBuffer,              //    .      .
                  int  nNumberOfBytesToRead,  //    .
                  int& lpNumberOfBytesRead[], //  ,          hFile.
                                              // ReadFile            .
                                              //  NULL      -  ,     .
                                              //     NULL   lpOverlapped   NULL.
   /*OVERLAPPED*/ int  lpOverlapped);         //   OVERLAPPED     hFile   FILE_FLAG_OVERLAPPED,       NULL.
                                              //  hFile  FILE_FLAG_OVERLAPPED, lpOverlapped        OVERLAPPED ,
                                              //       ,    .
                                              //  hFile,    ,     ,        ,
                                              //       .     Offset  OffsetHigh OVERLAPPED .
                                              //  hFile,     , Offset  OffsetHigh .
 bool   ReadFileEx (int hFile, int lpBuffer /*VARIANT*/, int nNumberOfBytesToRead, int lpOverlapped /*OVERLAPPED*/, int lpCompletionRoutine);
// int    ReadProcessMemory (int hProcess, int lpBaseAddress /*VARIANT*/, int lpBuffer /*VARIANT*/, int nSize, int lpNumberOfBytesWritten);
 int    ReadProcessMemory (int hProcess, int lpBaseAddress, string lpBuffer, int nSize, int& lpNumberOfBytesRead[]);
 int    ReleaseMutex (int hMutex);
 int    ReleaseSemaphore (int hSemaphore, int lReleaseCount, int lpPreviousCount);
 int    RemoveDirectoryA (string lpPathName);
 int    ResetEvent (int hEvent);
 int    ResumeThread (int hThread);
 void   RtlCopyMemory (int& Destination[] /*VARIANT*/, int Source[] /*VARIANT*/, int Length);
 void   RtlMoveMemory (int& Destination[] /*VARIANT*/, int Source[] /*VARIANT*/, int Length);
 int    SetCommBreak (int nCid);
 bool   SetCommConfig (int hCommDev, int lpCC /*COMMCONFIG*/, int dwSize);
 int    SetCommMask (int hFile, int dwEvtMask);
 int    SetCommState (int hCommDev, int lpDCB /*DCB*/);
 int    SetCommTimeouts (int hFile, int lpCommTimeouts /*COMMTIMEOUTS*/);
 int    SetComputerNameA (string lpComputerName);
 int    SetConsoleActiveScreenBuffer (int hConsoleOutput);
 int    SetConsoleCP (int wCodePageID);
 int    SetConsoleCtrlHandler (int HandlerRoutine, int Add);
 int    SetConsoleCursorInfo (int hConsoleOutput, int lpConsoleCursorInfo /*CONSOLE_CURSOR_INFO*/);
 int    SetConsoleCursorPosition (int hConsoleOutput, int dwCursorPosition /*COORD*/);
 int    SetConsoleMode (int hConsoleHandle, int dwMode);
 int    SetConsoleOutputCP (int wCodePageID);
 int    SetConsoleScreenBufferSize (int hConsoleOutput, int dwSize /*COORD*/);
 int    SetConsoleTextAttribute (int hConsoleOutput, int wAttributes);
 int    SetConsoleTitleA (string lpConsoleTitle);
 int    SetConsoleTitleW (string lpConsoleTitle);
 int    SetConsoleWindowInfo (int hConsoleOutput, int bAbsolute, int lpConsoleWindow /*SMALL_RECT*/);
 int    SetCurrentDirectoryA (string lpPathName);
 bool   SetDefaultCommConfigA (string lpszName, int lpCC /*COMMCONFIG*/, int dwSize);
 int    SetEndOfFile (int hFile);
 int    SetEnvironmentVariableA (string lpName, string lpValue);
 int    SetErrorMode (int wMode);
 int    SetEvent (int hEvent);
 void   SetFileApisToANSI();
 void   SetFileApisToOEM();
 int    SetFileAttributesA (string lpFileName, int dwFileAttributes);
 //   .   ,          (-1).
 int    SetFilePointer (int hFile,                //  .
                        int lDistanceToMove,      //          32-  NULL.
                        int lpDistanceToMoveHigh, //          32- 64-    NULL.
                        int dwMoveMethod);        //    . 0 - FILE_BEGIN      ;
                                                  //                                      1 - FILE_CURRENT    ;
                                                  //                                      2 - FILE_END        .
 int    SetFileTime (int hFile, int lpCreationTime /*FILETIME*/, int lpLastAccessTime /*FILETIME*/, int lpLastWriteTime /*FILETIME*/);
 bool   SetLocaleInfoA (int Locale, int LCType, string lpLCData);
 int    SetLocalTime (int lpSystemTime /*SYSTEMTIME*/);
 int    SetMailslotInfo (int hMailslot, int lReadTimeout);
 int    SetNamedPipeHandleState (int hNamedPipe, int lpMode, int lpMaxCollectionCount, int lpCollectDataTimeout);
 int    SetPriorityClass (int hProcess, int dwPriorityClass);
 int    SetProcessShutdownParameters (int dwLevel, int dwFlags);
 bool   SetProcessWorkingSetSize (int hProcess, int dwMinimumWorkingSetSize, int dwMaximumWorkingSetSize);
 int    SetStdHandle (int nStdHandle, int nHandle);
 int    SetSystemPowerState (int fSuspend, int fForce);
 int    SetSystemTime (int lpSystemTime /*SYSTEMTIME*/);
 bool   SetSystemTimeAdjustment (int dwTimeAdjustment, bool bTimeAdjustmentDisabled);
 int    SetTapeParameters (int hDevice, int dwOperation, int lpTapeInformation /*VARIANT*/);
 int    SetTapePosition (int hDevice, int dwPositionMethod, int dwPartition, int dwOffsetLow, int dwOffsetHigh, int bimmediate);
 int    SetThreadAffinityMask (int hThread, int dwThreadAffinityMask);
 int    SetThreadContext (int hThread, int lpContext /*CONTEXT*/);
 int    SetThreadLocale (int Locale);
 int    SetThreadPriority (int hThread, int nPriority);
 int    SetTimeZoneInformation (int lpTimeZoneInformation /*TIME_ZONE_INFORMATION*/);
 int    SetUnhandledExceptionFilter (int lpTopLevelExceptionFilter);
 int    SetupComm (int hFile, int dwInQueue, int dwOutQueue);
 int    SetVolumeLabelA (string lpRootPathName, string lpVolumeName);
 int    SuspendThread (int hThread);
 int    SystemTimeToFileTime (int lpSystemTime /*SYSTEMTIME*/, int lpFileTime /*FILETIME*/);
 int    SystemTimeToTzSpecificLocalTime (int lpTimeZoneInformation /*TIME_ZONE_INFORMATION*/, int lpUniversalTime /*SYSTEMTIME*/, int lpLocalTime /*SYSTEMTIME*/);
 int    TerminateProcess (int hProcess, int uExitCode);
 int    TerminateThread (int hThread, int dwExitCode);
 int    TlsAlloc();
 int    TlsFree (int dwTlsIndex);
 int    TlsGetValue (int dwTlsIndex);
 int    TlsSetValue (int dwTlsIndex, int lpTlsValue /*VARIANT*/);
 int    TransactNamedPipe (int hNamedPipe, int lpInBuffer /*VARIANT*/, int nInBufferSize, int lpOutBuffer /*VARIANT*/, int nOutBufferSize, int lpBytesRead, int lpOverlapped /*OVERLAPPED*/);
 int    TransmitCommChar (int nCid, int cChar /*Byte*/);
 int    UnhandledExceptionFilter (int ExceptionInfo /*EXCEPTION_POINTERS*/);
 int    UnlockFile (int hFile, int dwFileOffsetLow, int dwFileOffsetHigh, int nNumberOfBytesToUnlockLow, int nNumberOfBytesToUnlockHigh);
 int    UnlockFileEx (int hFile, int dwReserved, int nNumberOfBytesToUnlockLow, int nNumberOfBytesToUnlockHigh, int lpOverlapped /*OVERLAPPED*/);
 //       .  ,       TRUE,  FALSE.
 bool   UnmapViewOfFile (int lpBaseAddress /*VARIANT*/); //       ,   MapViewOfFile.
 int    UpdateResourceA (int hUpdate, string lpType, string lpName, int wLanguage, int lpData /*VARIANT*/, int cbData);
 int    VerLanguageNameA (int wLang, string szLang, int nSize);
 int    VirtualAlloc (int lpAddress, int dwSize, int flAllocationType, int flProtect);
 int    VirtualFree (int lpAddress, int dwSize, int dwFreeType);
 int    WaitCommEvent (int hFile, int lpEvtMask, int lpOverlapped /*OVERLAPPED*/);
 int    WaitForMultipleObjects (int nCount, int lpHandles, int bWaitAll, int dwMilliseconds);
 int    WaitForMultipleObjectsEx (int nCount, int lpHandles, int bWaitAll, int dwMilliseconds, int bAlertable);
 int    WaitForSingleObject (int hHandle, int dwMilliseconds);
 int    WaitForSingleObjectEx (int hHandle, int dwMilliseconds, int bAlertable);
 int    WaitNamedPipeA (string lpNamedPipeName, int nTimeOut);
 int    WideCharToMultiByte (int CodePage, int dwFlags, string lpWideCharStr, int cchWideChar, string lpMultiByteStr, int cchMultiByte, string lpDefaultChar, int lpUsedDefaultChar);
 //   .          16-  .     CreateProcess.
 //  : 0                     -    .
 //                        ERROR_BAD_FORMAT		 exe  .
 //                        ERROR_FILE_NOT_FOUND	  .
 //                        ERROR_PATH_NOT_FOUND	  .
 int    WinExec (string lpCmdLine, //    .
                 int nCmdShow);    //    .
                                   // SW_FORCEMINIMIZE    2000/XP:  ,    ,     .
                                   //                              .
                                   // SW_HIDE                 .
                                   // SW_MAXIMIZE          .
                                   // SW_MINIMIZE                   Z.
                                   // SW_RESTORE            .     ,         .
                                   //                            .
                                   // SW_SHOW                      . 
                                   // SW_SHOWDEFAULT           SW_    STARTUPINFO    CreateProcess ,
                                   //                      . 
                                   // SW_SHOWMAXIMIZED          .
                                   // SW_SHOWMINIMIZED          .
                                   // SW_SHOWMINNOACTIVE     .    SW_SHOWMINIMIZED,      .
                                   // SW_SHOWNA                 .    SW_SHOW,      .
                                   // SW_SHOWNOACTIVATE          .    SW_SHOWNORMAL,     -  actived.
                                   // SW_SHOWNORMAL         .     ,         .
                                   //                            .
 int    WriteConsoleA (int hConsoleOutput, int lpBuffer /*VARIANT*/, int nNumberOfCharsToWrite, int lpNumberOfCharsWritten, int lpReserved /*VARIANT*/);
 //     .     TRUE,  FALSE.
 bool   WriteFile (int  hFile,                    //  .
       /*VARIANT*/ int  lpBuffer,                 //   .      .
                   int  nNumberOfBytesToWrite,    //  ,     .
                   int& lpNumberOfBytesWritten[], //  ,          hFile.
                                                  // WriteFile            .
                                                  //  NULL      -  ,     .
                                                  //     NULL   lpOverlapped   NULL.
                   int  lpOverlapped);            //   OVERLAPPED     hFile   FILE_FLAG_OVERLAPPED,        NULL.
                                                  //  hFile,    ,     ,        ,
                                                  //       .     Offset  OffsetHigh OVERLAPPED .
                                                  //  hFile,     , Offset  OffsetHigh .
                                                  //  ,     ,  Offset  OffsetHigh OVERLAPPED   0xFFFFFFFF.
                                                  //  -  ,     CreateFile,   hFile,   FILE_APPEND_DATA.
 int    WriteProcessMemory(int hProcess, int lpBaseAddress, string lpBuffer, int nSize, int& lpNumberOfBytesWritten[]);
 int    WriteTapemark (int hDevice, int dwTapemarkType, int dwTapemarkCount, int bimmediate);
#import
//=================================================================================================================================================================