//+-------------------------------------------------------------------------------+
//|                                    ZI_File_Functions_Full_Main_Lib 0-81024.mq4|
//|                                    Copyright  Zhunko                         |
//|                                    ZHUNKO vadim@zhunko.ru                     |
//|24.10.2008                          Ilnur  X-79@yandex.ru                      |
//+-------------------------------------------------------------------------------+
//|      .                                                 |
//+-------------------------------------------------------------------------------+
//| 1.     .                                        |
//| 2.    .                                   |
//| 3.   .                                                    |
//| 4.   .                                                    |
//+-------------------------------------------------------------------------------+
//|      .                                           |
//+-------------------------------------------------------------------------------+
//| 5.       .                       |
//| 6.    .                                     |
//| 7.   .                                                 |
//| 8.   .                                                 |
//| 9.    .                                          |
//|10.    .                                   |
//|11.     .                                   |
//|12.       .               |
//+-------------------------------------------------------------------------------+
#property copyright "Copyright  2008 Zhunko, Ilnur"
#property link      "vadim@zhunko.ru ; X-79@yandex.ru"
#property library
//  .
#import "ntdll.dll"
 int RtlGetLastWin32Error();
 int RtlSetLastWin32Error (int dwErrCode);
#import
#include <WinKernel32.mqh> //    "kernel32.dll"  API Windows XP.
//
//   . 
//
// 1.     .========================================================================================================================
//  /    / .      ,    .   
//   "CreateDirectory()".  : handle -  ,     ;
//                                                               -1     -   ;
//                                                               -2     -        ;
//                                                               -3     -     .
int FileOpenFull (string PathName, //     .
                  int    ModeCWR)  //   : 0 - FILE_CREATE_       .   ,    
                                   //                                            .       ,    .
                                   //                        1 - FILE_WRITE_        .   .
                                   //                        2 - FILE_READ_         .    ,   .
                                   //                        3 - FILE_WRITE_END_        .   
                                   //                                               .    ,   .
 {
  int Error;  //   .
  int Handle; //  .
  //----
  RtlSetLastWin32Error(0);
  switch (ModeCWR)
   {
    case 0: //  .
     {
      Handle = CreateFileA (PathName, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
      Error = RtlGetLastWin32Error();
      Print ("   \"FileOpenFull()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
      return (Handle);
     }
    case 1: //  .
     {
      Handle = CreateFileA (PathName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
      Error = RtlGetLastWin32Error();
      Print ("   \"FileOpenFull()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
      return (Handle);
     }
    case 2: //  .
     {
      Handle = CreateFileA (PathName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
      Error = RtlGetLastWin32Error();
      Print ("   \"FileOpenFull()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
      return (Handle);
     }
    case 3: //    .
     {
      Handle = CreateFileA (PathName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
      if (Handle < 0) return (Handle);
      else
       {
        if (SetFilePointer (Handle, 0, 0, SEEK_END) < 0)
         {
          Error = RtlGetLastWin32Error();
          Print ("   \"FileOpenFull()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error)); return (-2);
         }
        else return (Handle);
       }    
      return (Handle);
     }
    default: Print ("   \"FileOpenFull()\".        \"", PathName, "\". ModeCWR = ", ModeCWR); return (-3);
   }
 }
//===============================================================================================================================================================
// 2.    .===================================================================================================================
//       ,       ,     .   
//     .      ,    ,   "-1".
int FileSeekFull (int Handle, //  ,   "FileOpenFull()".
                  int Offset, //   .
                  int Origin) //    : SEEK_CUR -   ,
                              //                                          SEEK_SET -  ,
                              //                                          SEEK_END -   .
 {
  int Error; //   .
  int Offst; // .
  //----
  RtlSetLastWin32Error (0);
  Offst = SetFilePointer (Handle, Offset, 0, Origin);
  if (Offst < 0)
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileSeekFull()\".  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  else return (Offst);
 }
//===============================================================================================================================================================
// 3.   .====================================================================================================================================
//     .    ,   TRUE,   FALSE.
bool FileCloseFull (int Handle) //  ,   "FileOpenFull()".
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  if (!CloseHandle (Handle))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileCloseFull()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else return (true);
 }
//===============================================================================================================================================================
// 4.   .====================================================================================================================================
//    .    ,   TRUE,   FALSE.
int FileDeleteFull (string PathName) //    .
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  if (!DeleteFileA (PathName))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileDeleteFull()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else return (true);
 }
//
//   . 
//
// 5.        .===========================================================================================
//   TRUE,      ,   FALSE.
bool FileIsEndingFull (int Handle) //  ,   "FileOpenFull()".
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  int PositionCurrent = SetFilePointer (Handle, 0, 0, 1);
  int PositionEOF = SetFilePointer (Handle, 0, 0, 2);
  if ((PositionCurrent < 0) || (PositionEOF < 0))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileIsEndingFull()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else
   {
    if (PositionCurrent == PositionEOF) return (true);
    else return (false);
   }
 }
//===============================================================================================================================================================
// 6.    .=====================================================================================================================
//          .
int FileTellFull (int Handle) //  ,   "FileOpenFull()".
 {
  int Error;  //   .
  int Offset; // .
  //----
  RtlSetLastWin32Error (0);
  Offset = SetFilePointer (Handle, 0, 0, 1);
  if (Offset < 0)
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileTellFull()\".  : \"", Error, "\". ", StringError (Error));
    return (Offset);
   }
  else return (Offset);
 }
//===============================================================================================================================================================
// 7.   .=================================================================================================================================
//         .   ,    .     .
//      ,    .      "CreateDirectory()".
//    ,   TRUE,   FALSE.
bool FileCopy (string ExistingFileName, //    .
               string NewFileName)      //  ,     .
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  if (!CopyFileA (ExistingFileName, NewFileName, false))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileCopy()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else return (true);
 }
//===============================================================================================================================================================
// 8.   .=================================================================================================================================
//         .   ,    .
//      ,    .      "CreateDirectory()".
//    ,   TRUE,   FALSE.
int FileMove (string ExistingFileName, //    .
              string NewFileName)      //  ,     .
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  if (!MoveFileA (ExistingFileName, NewFileName))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileMove()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else return (true);
 }
//===============================================================================================================================================================
// 9.    .==========================================================================================================================
//     ,   TRUE,   FALSE.
bool CreateDirectory (string PathName) //   .
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  if (!CreateDirectoryA (PathName, 0))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"CreateDirectory()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else return (true);
 }
//===============================================================================================================================================================
//10.    .===================================================================================================================
//     ,   TRUE,   FALSE.
bool RemoveDirectory (string PathName) //   .
 {
  int Error; //   .
  //----
  RtlSetLastWin32Error (0);
  if (!RemoveDirectoryA (PathName))
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"CreateDirectory()\".  : \"", Error, "\". ", StringError (Error));
    return (false);
   }
  else return (true);
 }
//===============================================================================================================================================================
//11.     .===================================================================================================================
int SystemError()
 {
  return (RtlGetLastWin32Error());
 }
//===============================================================================================================================================================
//12.       .===============================================================================================
string StringError (int ErrorCode) //   .
 {
  int    i;
  string String = "";
  //----
  int    Buffer[128];
  //----
  ArrayInitialize (Buffer, 0);
  FormatMessageA (0x1000, 0, ErrorCode, 0, Buffer, ArraySize (Buffer), 0);
  //----
  for (i = 0; i < ArraySize (Buffer); i++)
   {
    String = String + CharToStr (Buffer[i]       & 0xFF)
                    + CharToStr (Buffer[i] >>  8 & 0xFF)
                    + CharToStr (Buffer[i] >> 16 & 0xFF)
                    + CharToStr (Buffer[i] >> 24 & 0xFF);
   }
  return (StringTrimRight (String) + ".");
 }
//===============================================================================================================================================================
//
/*#import "kernel32.dll"
  int FindFirstFileA (string path, int& answer[]);
  bool FindNextFileA (int handle, int& answer[]);
#import
//+------------------------------------------------------------------+
void FileVariablesDeleteAll()
 {
  int win32_DATA[79];
  int handle = FindFirstFileA (TerminalPath() + "\experts\files\*", win32_DATA);

  while (FindNextFileA (handle, win32_DATA))
   {
    FileDelete (bufferToString (win32_DATA));
    ArrayInitialize (win32_DATA, 0);
   }
 }
//+--------------------------------+ 
string bufferToString (int buffer[])
 {
  string text = "";
  for (int pos = 11; pos < 75; pos++)
   {
    int curr = buffer[pos];
    text = text + CharToStr (curr & 0x000000FF)
                + CharToStr (curr >> 8 & 0x000000FF)
                + CharToStr (curr >> 16 & 0x000000FF)
                + CharToStr (curr >> 24 & 0x000000FF);
   }
  return(text);
 }*/
//+------------------------------------------------------------------+