//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                                   T3Series().mqh |
//|                                T3 code: Copyright  1998, Tilson |
//|             MQL4T3Series: Copyright  2006,     Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*

  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  T3Series() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

    T3Series()             
  ,         .      ():
  MetaTrader\experts\include\    ,      nT3_bar  ,    nT3_MaxBar-3*nT3_Period,   
  T3Series()     !   ! , ,      
    -        !      T3Series()    
         ,        .        T3Series()
         ,        
      !          T3Series(),  
         nT3_...  dT3_...  T3Series()     
        ,             ,      
        T3Series()      (nT3_number). 

  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nT3_number    -      T3Series(). (0, 1, 2, 3  .....)
  nT3_din       - ,      nT3_Period   . 0 -   , 
                     - .
  nT3_MaxBar    -   ,          (nT3_bar).   
                  Bars-1-period;   "period" -      ,        dT3_series  
                  ; 
  nT3_limit     -                 ,   
                   Bars-IndicatorCounted()-1;  
  nT3_Curvature -     0 ... +100,     ; 
  nT3_Period    -  
  dT3_series    -   ,      T3Series();
  nT3_bar       -    ,          
                  .            nT3_limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  T3Series()    -   T3.     nT3_bar    nT3_MaxBar-nT3_Length    T3MASeries() 
                    !!!
  nT3_reset     - ,       ,     0,           
                  , 0,        .            ,   
                  !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+

        T3Series(),       0, (     
            ),         
     ,                 T3Series()      
  T3SeriesResize()         :   T3SeriesResize(MaxT3_number+1);         
  nT3_number(MaxT3_number)            T3Series(),          ,  
   nT3_number. 

  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
           ,       
  .        T3Series()        \MetaTrader\EXPERTS\LOGS\. ,   
    T3Series()    ,    ,  MQL4 ,       
       .     T3Series()   T3Series()  MQL4 , 
             .       
  T3Series()  nT3_number       nJT3Resize_Size     
          .         
    nT3_limit.      init()      
      T3Series(),      T3SeriesResize()          
      .         T3Series()      
          nT3_bar,         . 
  ,                  , 
    T3Series()       ,        .
            T3Series()          
   .          
   ,       init(). 
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+


//----+   T3Series()
#include <T3Series.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1      (    T3Series()     !!!)
SetIndexBuffer(0,Ind_Buffer);
//----+      T3Series, nT3_number=1(    T3Series)
if(T3SeriesResize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+        
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+    T3Series()  0    Ind_Buffer[], 
  // nT3_Curvature  nT3_Length      (nT3_din=0)
  double Resalt=T3Series(0,0,MaxBar,limit,Curvature,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 
  */
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< T3Series()>>> ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSSSS+
double dT3_e1[1],dT3_e2[1],dT3_e3[1],dT3_e4[1],dT3_e5[1],dT3_e6[1];
double dT3_E1[1],dT3_E2[1],dT3_E3[1],dT3_E4[1],dT3_E5[1],dT3_E6[1];
double dT3_c1[1],dT3_c2[1],dT3_c3[1],dT3_c4[1],dT3_w1[1],dT3_w2[1];
double dT3_n[1],dT3_b2[1],dT3_b3[1],dT3_T3;
int    nT3_Error,nT3_num,nT3_size,nT3_Resize;
datetime nT3_TIME[1],nT3_Tnew,nT3_Old;
//----++ <<<   T3Series() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double T3Series
 (
  int nT3_number,    int nT3_din,     int    nT3_MaxBar,      int nT3_limit,
  int nT3_Curvature, int nT3_Period,  double dT3_series,       int nT3_bar,    int& nT3_reset
 )
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
{
nT3_num=nT3_number;

nT3_reset=1;
//=====+ <<<    >>> ==============================================================================+
if (nT3_bar==nT3_limit)
 {
  //----++     T3Series()
  if(nT3_Resize<1)
   {
    Print("T3Series number ="+(string)nT3_num+
         ".         T3SeriesResize()");
    if(nT3_Resize==0)
       Print("T3Series number ="+(string)nT3_num+
                ".      T3SeriesResize()   ");
         
    return(0.0);
   }
  //----++       ,   T3Series()
  nT3_Error=GetLastError();
  if(nT3_Error>4000)
    {
      Print("T3Series number ="+(string)nT3_num+
            ".  ,     T3Series() number = "
                                                                 +(string)nT3_num+" !!!");
      Print("T3Series() number ="+(string)nT3_num+ ". ",T3_ErrDescr(nT3_Error));  
    }

  //----++       nT3_number  nT3Resize_Size
  nT3_size=ArraySize(dT3_e1);
  if (nT3_size< nT3_num) 
   {
    Print("T3Series number ="+(string)nT3_num+
              ". !!!     nT3_number="
                                                        +(string)nT3_num+"  T3Series()");
    Print("T3Series number ="+(string)nT3_num+
            ".       nT3Resize_Size="
                                                 +(string)nT3_size+"  T3SeriesResize()");
    return(0.0);
   }
 }
//----++ +--------------------------------------------------------------------------------------------------------+

if (nT3_bar>nT3_MaxBar){nT3_reset=0;return(0.0);}
if((nT3_bar==nT3_MaxBar)||(nT3_din!=0))
  {
   //----++ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSS+
   double dT3_b=nT3_Curvature/100.0;
   dT3_b2[nT3_num]=dT3_b*dT3_b;
   dT3_b3[nT3_num]=dT3_b2[nT3_num]*dT3_b;
   dT3_c1[nT3_num]=-dT3_b3[nT3_num];
   dT3_c2[nT3_num]=(3*(dT3_b2[nT3_num]+dT3_b3[nT3_num]));
   dT3_c3[nT3_num]=-3*(2*dT3_b2[nT3_num]+dT3_b+dT3_b3[nT3_num]);
   dT3_c4[nT3_num]=(1+3*dT3_b+dT3_b3[nT3_num]+3*dT3_b2[nT3_num]);
   if (nT3_Period<1) nT3_Period=1;
   dT3_n [nT3_num] = 1 + 0.5*(nT3_Period-1);
   dT3_w1[nT3_num] = 2 / (dT3_n[nT3_num] + 1);
   dT3_w2[nT3_num] = 1 - dT3_w1[nT3_num];
   //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }
if (nT3_Period<1)nT3_Period=1;

//----++        nT3_bar
if((nT3_limit>=nT3_MaxBar)&&(nT3_bar==0)&&(nT3_din==0))
      if((nT3_MaxBar>nT3_Period*3)&&(nT3_TIME[nT3_num]==0))
                        Print("T3Series number ="+(string)nT3_num+
                        ". !!!      nT3_bar   !!!"); 

if((nT3_bar==nT3_limit)&&(nT3_limit<nT3_MaxBar))          
  {
   //----+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
   nT3_Tnew=Time[nT3_limit+1];
   nT3_Old=nT3_TIME[nT3_num];
   //--+   
   if(nT3_Tnew==nT3_Old)
    {
     dT3_e1[nT3_num]=dT3_E1[nT3_num]; dT3_e2[nT3_num]=dT3_E2[nT3_num]; 
     dT3_e3[nT3_num]=dT3_E3[nT3_num]; dT3_e4[nT3_num]=dT3_E4[nT3_num]; 
     dT3_e5[nT3_num]=dT3_E5[nT3_num]; dT3_e6[nT3_num]=dT3_E6[nT3_num];
    }

   if(nT3_Tnew!=nT3_Old)
    {
     nT3_reset=-1;
     //--+       T3_limit  T3Series()
     if (nT3_Tnew>nT3_Old)
       {
        Print("T3Series number ="+(string)nT3_num+
                   ". !!!  nT3_limit  T3Series()   ");
       }
     else 
       { 
        int nT3_LimitERROR=nT3_limit+1-iBarShift(NULL,0,nT3_Old,TRUE);
        Print("T3Series number ="+(string)nT3_num+
            ". !!!  nT3_limit  T3Series()     "
                                                                          +(string)nT3_LimitERROR+"");
       }
     //--+ 
     return(0);
   }
  //----+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }
//+---    +SSSSSSSSSSSS+
if((nT3_bar==1)&&(nT3_limit!=1))
  {
   nT3_TIME[nT3_num]=Time[2];
   dT3_E1[nT3_num]=dT3_e1[nT3_num]; 
   dT3_E2[nT3_num]=dT3_e2[nT3_num]; 
   dT3_E3[nT3_num]=dT3_e3[nT3_num]; 
   dT3_E4[nT3_num]=dT3_e4[nT3_num]; 
   dT3_E5[nT3_num]=dT3_e5[nT3_num]; 
   dT3_E6[nT3_num]=dT3_e6[nT3_num];
  }
//+---+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//---- <<<  dT3_T3 >>> --------------------------------------------------------------------+
dT3_e1[nT3_num] = dT3_w1[nT3_num]*dT3_series      + dT3_w2[nT3_num]*dT3_e1[nT3_num];
dT3_e2[nT3_num] = dT3_w1[nT3_num]*dT3_e1[nT3_num] + dT3_w2[nT3_num]*dT3_e2[nT3_num];
dT3_e3[nT3_num] = dT3_w1[nT3_num]*dT3_e2[nT3_num] + dT3_w2[nT3_num]*dT3_e3[nT3_num];
dT3_e4[nT3_num] = dT3_w1[nT3_num]*dT3_e3[nT3_num] + dT3_w2[nT3_num]*dT3_e4[nT3_num];
dT3_e5[nT3_num] = dT3_w1[nT3_num]*dT3_e4[nT3_num] + dT3_w2[nT3_num]*dT3_e5[nT3_num];
dT3_e6[nT3_num] = dT3_w1[nT3_num]*dT3_e5[nT3_num] + dT3_w2[nT3_num]*dT3_e6[nT3_num];
//----  
dT3_T3 = dT3_c1[nT3_num]*dT3_e6[nT3_num] 
                      + dT3_c2[nT3_num]*dT3_e5[nT3_num] 
                                     + dT3_c3[nT3_num]*dT3_e4[nT3_num] 
                                                   + dT3_c4[nT3_num]*dT3_e3[nT3_num];
//---- ----------------------------------------------------------------------------------------------+

//----++         T3Series()
nT3_Error=GetLastError();
if(nT3_Error>4000)
  {
    Print("T3Series number ="+(string)nT3_num+".    T3Series()  !!!");
    Print("T3Series number ="+(string)nT3_num+ ". ",T3_ErrDescr(nT3_Error));  
    return(0.0);
  }
nT3_reset=0;
if (nT3_bar<nT3_MaxBar-nT3_Period*3)return(dT3_T3);else return(0.0);
//----     T3_Series 
}
//---- ---------------------------------------------------------------------------------------------------------+


//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// T3SeriesResize -                 | 
//  T3Series.  : T3SeriesResize(5);  5 -          | 
// T3Series()  .      T3SeriesResize         |
//                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int T3SeriesResize(int nT3Resize_Size)
 {
//----+
  if(nT3Resize_Size<1)
   {
    Print("T3SeriesResize: !!!  nT3Resize_Size     !!!");
    nT3_Resize=-1;  
    return(0);
   }
  //----+    
  int nT3Resize_reset,nT3Resize_cycle=0;
  //--+
  while(nT3Resize_cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSS+
    if(ArrayResize(dT3_e1,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_e2,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_e3,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_e4,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_e5,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_e6,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_E1,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_E2,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_E3,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_E4,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_E5,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_E6,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_n,   nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_c1,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_c2,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_c3,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_c4,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_w1,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_w2,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_b2,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(dT3_b3,  nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    if(ArrayResize(nT3_TIME,nT3Resize_Size)==0){nT3Resize_reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nT3Resize_cycle=1;
   }
  //--+
  if(nT3Resize_reset==-1)
   {
    Print("T3SeriesResize: !!!        T3Series().");
    int nT3Resize_Error=GetLastError();
    if(nT3Resize_Error>4000)Print("T3SeriesResize(): ",T3_ErrDescr(nT3Resize_Error));       
    nT3_Resize=-2;
    return(0);
   }
  else  
   {
    Print("T3SeriesResize: T3Series Size = "+(string)nT3Resize_Size+"");
    nT3_Resize=nT3Resize_Size;
    return(nT3Resize_Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
T3SeriesAlert -                |
 T3Series.                                                                                 |
  --------------------------    --------------------------                        |
T3SeriesAlert_Number                                                                              |
T3SeriesAlert_ExternVar      nT3_Length                      |
T3SeriesAlert_name     nT3_Phase,  T3SeriesAlert_Number=1              |
  --------------------------    -----------------------                        |
  int init()                                                                                      |
//----                                                                                            |
 -                                                     |
                                                                                                  |
//----                                     |                                                                                                                  
T3SeriesAlert(0,"Length1",Length1);                                                               |
T3SeriesAlert(0,"Length2",Length2);                                                               |
//----                                                                     |
return(0);                                                                                        |
}                                                                                                 |
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void T3SeriesAlert
 (
  int T3SeriesAlert_Number, string T3SeriesAlert_name, int T3SeriesAlert_ExternVar
 )
 {
  //----        ==========================+ 
  if(T3SeriesAlert_Number==0)if(T3SeriesAlert_ExternVar<1)
          {Alert(" "+T3SeriesAlert_name+"     1" 
   
     + "    " +(string)T3SeriesAlert_ExternVar+ "    1"  );}
   /*  
  if(T3SeriesAlert_Number==1)
   {
    if(T3SeriesAlert_ExternVar<-100)
          {Alert(" "+T3SeriesAlert_name+"    -100  +100" 
          + "    "+T3SeriesAlert_ExternVar+  "   -100");}
    if(T3SeriesAlert_ExternVar> 100)
          {Alert(" "+T3SeriesAlert_name+"    -100  +100" 
          + "    "+T3SeriesAlert_ExternVar+  "    100");}
   }
   */
 }
//--+ -------------------------------------------------------------------------------------------+


//     01.12.2006  
//+------------------------------------------------------------------+
//|                                        T3_ErrDescr_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string T3_ErrDescr(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+(string)error_code+".  ";                                                  break;
     case 4001: error_string="  = "+(string)error_code+".   ";                              break;
     case 4002: error_string="  = "+(string)error_code+".      ";                 break;
     case 4003: error_string="  = "+(string)error_code+".     ";                                break;
     case 4004: error_string="  = "+(string)error_code+".     ";                break;
     case 4005: error_string="  = "+(string)error_code+".       ";                 break;
     case 4006: error_string="  = "+(string)error_code+".     ";                         break;
     case 4007: error_string="  = "+(string)error_code+".     ";                             break;
     case 4008: error_string="  = "+(string)error_code+".  ";                                 break;
     case 4009: error_string="  = "+(string)error_code+".    ";                       break;
     case 4010: error_string="  = "+(string)error_code+".     ";                           break;
     case 4011: error_string="  = "+(string)error_code+".   ";                                      break;
     case 4012: error_string="  = "+(string)error_code+".     ";                                  break;
     case 4013: error_string="  = "+(string)error_code+".   ";                                             break;
     case 4014: error_string="  = "+(string)error_code+".  ";                                         break;
     case 4015: error_string="  = "+(string)error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+(string)error_code+".  ";                                 break;
     case 4017: error_string="  = "+(string)error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+(string)error_code+".   ";                             break;
     case 4019: error_string="  = "+(string)error_code+".   ";                                  break;
     case 4020: error_string="  = "+(string)error_code+".      ";            break;
     case 4021: error_string="  = "+(string)error_code+".    ,   ";     break;
     case 4022: error_string="  = "+(string)error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+(string)error_code+".    ";                  break;
     case 4051: error_string="  = "+(string)error_code+".    ";                     break;
     case 4052: error_string="  = "+(string)error_code+".    ";                         break;
     case 4053: error_string="  = "+(string)error_code+".  ";                                              break;
     case 4054: error_string="  = "+(string)error_code+".   -";                break;
     case 4055: error_string="  = "+(string)error_code+".   ";                         break;
     case 4056: error_string="  = "+(string)error_code+".  ";                                        break;
     case 4057: error_string="  = "+(string)error_code+".    ";                     break;
     case 4058: error_string="  = "+(string)error_code+".    ";                         break;
     case 4059: error_string="  = "+(string)error_code+".      ";                      break;
     case 4060: error_string="  = "+(string)error_code+".   ";                                     break;
     case 4061: error_string="  = "+(string)error_code+".   ";                                       break;
     case 4062: error_string="  = "+(string)error_code+".    string";                              break;
     case 4063: error_string="  = "+(string)error_code+".    integer";                             break;
     case 4064: error_string="  = "+(string)error_code+".    double";                              break;
     case 4065: error_string="  = "+(string)error_code+".     ";                       break;
     case 4066: error_string="  = "+(string)error_code+".      ";      break;
     case 4067: error_string="  = "+(string)error_code+".     ";                     break;
     case 4099: error_string="  = "+(string)error_code+".  ";                                                 break;
     case 4100: error_string="  = "+(string)error_code+".     ";                                  break;
     case 4101: error_string="  = "+(string)error_code+".   ";                                      break;
     case 4102: error_string="  = "+(string)error_code+".    ";                               break;
     case 4103: error_string="  = "+(string)error_code+".   ";                                     break;
     case 4104: error_string="  = "+(string)error_code+".     ";                         break;
     case 4105: error_string="  = "+(string)error_code+".     ";                                     break;
     case 4106: error_string="  = "+(string)error_code+".  ";                                          break;
     case 4107: error_string="  = "+(string)error_code+".      ";             break;
     case 4108: error_string="  = "+(string)error_code+".   ";                                       break;
     case 4109: error_string="  = "+(string)error_code+".   ";                                       break;
     case 4110: error_string="  = "+(string)error_code+".    ";                                break;
     case 4111: error_string="  = "+(string)error_code+".    ";                               break;
     case 4200: error_string="  = "+(string)error_code+".   ";                                       break;
     case 4201: error_string="  = "+(string)error_code+".    ";                      break;
     case 4202: error_string="  = "+(string)error_code+".   ";                                        break;
     case 4203: error_string="  = "+(string)error_code+".   ";                                     break;
     case 4204: error_string="  = "+(string)error_code+".   ";                                           break;
     case 4205: error_string="  = "+(string)error_code+".   ";                                    break;
     case 4206: error_string="  = "+(string)error_code+".    ";                                break;
     case 4207: error_string="  = "+(string)error_code+".     ";                                break;
     default:   error_string="  = "+(string)error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

