/*           
T3Series.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\ */
//+------------------------------------------------------------------+  
//|                                          T3.2Bollinger Bands.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----     
#property indicator_chart_window
//----   
#property indicator_buffers 1
//----  
#property indicator_color1 Red
//----    --------------------------------------------------------------------------------------------------+
extern int        T3Period= 14;     //    T3Bollinger Bands
extern int           MA_method=0;   //  
extern int           MA_Smooth=20;  //    Moving Avereges
extern int        Bands_Smooth=20;  //    Bollinger Bands
extern int    Smooth_Curvature=100; //  ,    -100 ... +100,     ; 
extern int         Bands_Shift=0;   // c     
extern int Input_Price_Customs=0;   // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double T3MovingBuffer[];
double Series_buffer [];
//+------------------------------------------------------------------+ 
//----+   T3Series 
//----+   T3SeriesResize 
//----+   T3SeriesAlert 
//----+   T3_ErrDescr  
#include <T3Series.mqh>
//+------------------------------------------------------------------+ 
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| T3.2Bollinger Bands initialization function                      | 
//+------------------------------------------------------------------+  
int init()
  {
//----    
   SetIndexStyle(0,DRAW_LINE);
//---- 4       
   IndicatorBuffers(2);
   SetIndexBuffer(0,T3MovingBuffer);
   SetIndexBuffer(1,Series_buffer);
//----   ,      
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(1,0);
//----   ,       
   int drawbegin=100;
   SetIndexDrawBegin(0,drawbegin);
//----        
   IndicatorShortName ("T3 Lnx( Period="+(string)T3Period+")");
   string Moving;
   switch(MA_method)
     {
      case  0: Moving= "T3SMA";break;
      case  1: Moving= "T3EMA";break;
      case  2: Moving="T3SSMA";break;
      case  3: Moving="T3LWMA";break;
      default: Moving="T3SMA";
     }
   SetIndexLabel (1, "T3 Moving Average "+Moving+" ");
//----     
   IndicatorDigits(Digits);
//----+      T3Series, nT3.number=3(    T3Series)
   if (Bands_Smooth<=1){if (T3SeriesResize(1)!=1)return(-1);}else if (T3SeriesResize(3)!=3)return(-1);
//----       
   T3SeriesAlert(0,"MA_Smooth",MA_Smooth);
   T3SeriesAlert(0,"T3Period",T3Period);
   if((MA_method<0)||(MA_method>3))
     {Alert(" MA_method    0  3"+"    "
                                                           +(string)MA_method+ "   0");}
   PriceSeriesAlert(Input_Price_Customs);
//----     T3Period
   if(T3Period<1)T3Period=1;
//----  
   return(0);
  }
//+------------------------------------------------------------------+  
//| T3.2Bollinger Bands iteration function                           | 
//+------------------------------------------------------------------+  
int start()
  {
//----       
   if(Bars-1<=T3Period) return(0);
//----       
   double Temp_Series,Resalt;
//----+        
   int reset,MaxBar,MaxBarBB,bar,counted_bars=IndicatorCounted();
//----    
   if (counted_bars<0)return(-1);
//----       
//---- (    counted_bars  T3Series   !!!)
   if (counted_bars>0) counted_bars--;
//----     ,        
   int limit=Bars-counted_bars-1;MaxBar=Bars-1-T3Period;MaxBarBB=MaxBar-30;
//----+              
   for(bar=limit;bar>=0;bar--)Series_buffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----       Bollinger Bands 
//----            
   if (limit>MaxBar)
     {
      for(bar=limit;bar>=MaxBar;bar--)T3MovingBuffer[bar]=0;
      limit=MaxBar;
     }
//----+   Moving Avereges
   for(bar=limit;bar>=0;bar--)
     {
      //----+    Moving Avereges
      Temp_Series=iMAOnArray(Series_buffer,0,T3Period,0,MA_method, bar);
      //----+   Moving Avereges
      //----+    T3Series   0. s nT3.Length  t    (nT3.din=0)
      Resalt=T3Series(0,0,MaxBar,limit,Smooth_Curvature,MA_Smooth,Temp_Series,bar,reset);
      //----+       
      if(reset!=0)return(-1);
      T3MovingBuffer[bar]=Resalt;
     }
//----    
   return(0);
  }
//+---------------------------------------------------------------------------+