//+------------------------------------------------------------------+
//|                                              IncFramaOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int FramaPeriod=14;

   Declaration:
   #include <IncOnArray/IncFramaOnArray.mqh>
   CFramaOnArray frama;

   In OnInit:
   frama.Init(FramaPeriod);

   In OnCalculate:
   frama.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,FramaBuffer);
*/
//+------------------------------------------------------------------+
//| CFramaOnArray                                                    |
//+------------------------------------------------------------------+
class CFramaOnArray
  {
private:
   int               m_Period;
   int               m_br;
   string            m_Name;
public:
   void Init(int aPeriod)
     {
      m_Period=aPeriod;
      m_Name="FraMA("+IntegerToString(m_Period)+")";
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aDataClose[],
              double  &aFrama[])
     {

      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE)
              {
               if(aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
                 {
                  if(aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE)
                    {
                     Start=i+m_Period*2-2;
                     break;
                    }
                 }
              }
           }
         aFrama[Start]=aDataClose[Start];
         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }

      for(int i=Start;i<aRatesTotal;i++)
        {
         double Hi1=aDataHigh[ArrayMaximum(aDataHigh,i-m_Period+1,m_Period)];
         double Lo1=aDataLow[ArrayMinimum(aDataLow,i-m_Period+1,m_Period)];
         double Hi2=aDataHigh[ArrayMaximum(aDataHigh,i-m_Period*2+1,m_Period)];
         double Lo2=aDataLow[ArrayMinimum(aDataLow,i-m_Period*2+1,m_Period)];
         double Hi3=MathMax(Hi1,Hi2);
         double Lo3=MathMin(Lo1,Lo2);
         double N1=(Hi1-Lo1)/m_Period;
         double N2=(Hi2-Lo2)/m_Period;
         double N3=(Hi3-Lo3)/(2*m_Period);
         double D=(log(N1+N2)-log(N3))/log(2.0);
         double ALFA=exp(-4.6*(D-1.0));
         aFrama[i]=ALFA*aDataClose[i]+(1.0-ALFA)*aFrama[i-1];
        }

     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's FramaOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
