//+------------------------------------------------------------------+
//|                                                IncWPROnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int      WPRPeriod=14;

   Declaration:
   #include <IncOnArray/IncWPROnArray.mqh>
   CWPROnArray wpr;

   In OnInit:
   wpr.Init(WPRPeriod);

   In OnCalculate:
   wpr.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,WPRBuffer); 
*/
//+------------------------------------------------------------------+
//| CWPROnArray                                                      |
//+------------------------------------------------------------------+
class CWPROnArray
  {
private:
   int               m_Period;
   string            m_Name;
   int               m_br;
public:
   void Init(int aPeriod=34)
     {
      m_Period=aPeriod;
      m_Name="WPR("+IntegerToString(m_Period)+")";
      m_br=m_Period;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aDataClose[],
              double  &aWPR[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double m_Upper=aDataHigh[ArrayMaximum(aDataHigh,i-m_Period+1,m_Period)];
         double m_Lower=aDataLow[ArrayMinimum(aDataLow,i-m_Period+1,m_Period)];
         if(m_Upper!=m_Lower)
           {
            aWPR[i]=-(m_Upper-aDataClose[i])*100.0/(m_Upper-m_Lower);
           }
         else
           {
            aWPR[i]=aWPR[i-1];
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's WPROnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
