#define FAKE // Remove - workaround for posting code in CodeBase.

#property description "Original Filename: " + __FILE__
#property description "Compile Time: " + (string)__DATETIME__
#ifdef _RELEASE
  #property description "Compiler Version: " + (string)__MQLBUILD__ + " " + __CPU_ARCHITECTURE__ + " Release."
#else // #ifdef _RELEASE
  #property description "Compiler Version: " + (string)__MQLBUILD__ + " " + __CPU_ARCHITECTURE__ + " Debug."
#endif // #ifdef _RELEASE #else
#property link "https://www.mql5.com/ru/code/49132"

#property indicator_chart_window
#property indicator_buffers 0
#property indicator_plots 0

#ifndef FAKE

#include <fxsaber\PriceChanges\PriceChanges.mqh>
#include <fxsaber\PriceChanges\TwoVLines.mqh>
#include <fxsaber\PriceChanges\Chart.mqh>

sinput bool inAllSymbols = false;  // AllSymbols
input bool inSortByMinMax = false; // Sort By MinMax

input group "Tech. data" // https://www.mql5.com/ru/forum/464362/page10#comment_52993170
input string inSymbol = "";        // Symbol

// #include <fxsaber\Keyboard\KeyCode.mqh> // https://www.mql5.com/ru/code/48393
#define KEYCODE_KEY_C          67 // |C| - KEY_C
#define KEYCODE_NUMPAD_0       96 // |0| - NUMPAD_0
#define KEYCODE_OPEN_BRACKET  219 // |[| - OPEN_BRACKET
#define KEYCODE_CLOSE_BRACKET 221 // |]| - CLOSE_BRACKET

int OnInit()
{
  const bool Res = !inAllSymbols && ((inSymbol == "") ||
                                     !SymbolInfoInteger(inSymbol, SYMBOL_EXIST) ||
                                     !SymbolInfoInteger(inSymbol, SYMBOL_VISIBLE));

  if (Res)
  {
    const int Handle = _E(iCustom(_Symbol, _Period, MQLInfoString(MQL_PROGRAM_NAME),
                                  inAllSymbols, inSortByMinMax, "group", _Symbol));

    if ((Handle != INVALID_HANDLE) && !_E(ChartIndicatorAdd(0, 0, Handle)))
      _E(IndicatorRelease(Handle));
  }
  else
    Comment("Waiting Two VLines....");

  return(Res);
}

bool Comment(const TWOVLINES &TwoVLines, const PRICECHANGES &Changes )
{
  static const string Str = inAllSymbols ? ", AllSymbols" : ", Symbol = " + inSymbol;

  Comment(TwoVLines.ToString() + Str + Changes.ToString());

  return(true);
}

void OnChartEvent( const int id, const long &lparam, const double&, const string& )
{
  static CHART Chart;
  static TWOVLINES TwoVLines;
  static PRICECHANGES Changes;
  static const int Init = TwoVLines.IsChange() &&
                          Changes.Calc(TwoVLines.GetTime1(), TwoVLines.GetTime2(),
                                       inSortByMinMax, inAllSymbols ? NULL : inSymbol) &&
                          Comment(TwoVLines, Changes);

  switch (id)
  {
  case CHARTEVENT_KEYDOWN:
    if (Changes.IsCalc())
      switch ((int)lparam)
      {
      case KEYCODE_KEY_C:
        Chart.Swap();
        break;
      case KEYCODE_OPEN_BRACKET:
        _E(ChartSetSymbolPeriod(0, Changes.GetPrevSymbol(), _Period));
        break;
      case KEYCODE_CLOSE_BRACKET:
        _E(ChartSetSymbolPeriod(0, Changes.GetNextSymbol(), _Period));
        break;
      case KEYCODE_NUMPAD_0:
        _E(ChartSetSymbolPeriod(0, Changes.GetFirstSymbol(), _Period));
        break;
      }

    break;
  case CHARTEVENT_MOUSE_MOVE:
  case CHARTEVENT_OBJECT_CREATE:
  case CHARTEVENT_OBJECT_CHANGE:
  case CHARTEVENT_OBJECT_DELETE:
  case CHARTEVENT_OBJECT_DRAG:
    if (TwoVLines.IsChange() &&
        Changes.Calc(TwoVLines.GetTime1(), TwoVLines.GetTime2(),
                     inSortByMinMax, inAllSymbols ? NULL : inSymbol))
      Comment(TwoVLines, Changes);

    break;
  }

  return;
}

void OnDeinit( const int Reason )
{
  if ((Reason == REASON_INITFAILED) && !inAllSymbols &&
      ((inSymbol == "") ||
       !SymbolInfoInteger(inSymbol, SYMBOL_EXIST) ||
       !SymbolInfoInteger(inSymbol, SYMBOL_VISIBLE)))
  {
    const string ShortName = __FILE__ + (string)inAllSymbols + (string)inSortByMinMax + (string)inSymbol;

    if (_E2(IndicatorSetString(INDICATOR_SHORTNAME, ShortName), ShortName))
      _E2(ChartIndicatorDelete(0, 0, ShortName), ShortName);
  }
  else
    Comment("");
}

#endif // #ifndef FAKE

int OnCalculate( const int, const int, const int, const double &[] )
{
  return(0);
}