﻿//+------------------------------------------------------------------+
//|                                        MT4Orders_QuickReport.mqh |
//+------------------------------------------------------------------+
// Out to report all deals without filters & other options as on Report.mqh
// Sample call from MT4Orders expert: QuickReport("report", true);// will save report to report.htm file and open it on browser (DLL required)
// Sample call from Virtual library: 
// for (int v = 0 ; v <= VIRTUAL::Total(); v++){if (VIRTUAL::SelectByIndex(v)){QuickReport("report_"+(string)v, true, v);}} 
// will print report for each virtual tester. 
// Or call just to 2nd tester VIRTUAL::SelectByIndex(2)){QuickReport("report_2", true, 2);}

// #define REPORT_BROWSER  // Open report in browswer automatically. Require DLL.

// By default MT4Orders_QuickReport use free google.charts, but you can use highcharts if you have rights.
// #define USE_highcharts // You can download and try out all Highcharts products for free. Once your project/product is ready for launch, purchase a commercial license. https://shop.highcharts.com/

// for MT4 
#ifndef __MQL5__
   #property strict
   long OrderOpenTimeMsc( void ) { return(OrderOpenTime() * 1000); }
   long OrderCloseTimeMsc( void ) { return(OrderCloseTime() * 1000); }
   double OrderOpenPriceRequest( void ) {return(OrderOpenPrice()); }
   double OrderClosePriceRequest( void ) {return(OrderClosePrice()); }
   enum ENUM_ACCOUNT_MARGIN_MODE{ ACCOUNT_MARGIN_MODE_RETAIL_NETTING, ACCOUNT_MARGIN_MODE_EXCHANGE, ACCOUNT_MARGIN_MODE_RETAIL_HEDGING};
   #define SYMBOL_CUSTOM (-1)
   #define ACCOUNT_MARGIN_MODE (-1)
   #define ACCOUNT_CURRENCY_DIGITS (-2)
   long AccountInfoInteger2( const int Property ){
     switch (Property){
       case ACCOUNT_MARGIN_MODE:
         return(ACCOUNT_MARGIN_MODE_RETAIL_HEDGING);
       case ACCOUNT_CURRENCY_DIGITS:
         return(2);      
     }
     return(AccountInfoInteger(Property));
   }
   #define AccountInfoInteger AccountInfoInteger2
#endif // #ifndef __MQL5__
// end for MT4 



#ifndef __VIRTUAL__
  #include <MT4Orders.mqh>
#endif // #ifndef __VIRTUAL__

#ifdef REPORT_BROWSER
   #import "shell32.dll"
     int ShellExecuteW( int, string, string, string, string, int );
   #import
   
   #import "kernel32.dll"
     void GetLocalTime(ushort& time[]);
   #import
#endif

string GetLocalTimeS(){
   #ifdef REPORT_BROWSER
     if((bool)::MQLInfoInteger(MQL_DLLS_ALLOWED)){ushort time[8];GetLocalTime(time); return StringFormat ("%d.%d.%d %d:%d:%d.",time[0], time[1], time[3], time[4], time[5], time[6])+IntegerToString((long)time[7], 3, '0'); }
   #endif
   return (string)TimeLocal();
}

static ulong  TimeStartTest = ::GetMicrosecondCount();
static string TimeLocalStartTest = GetLocalTimeS();
static string TimeLocalEndTest;
static datetime TestSartTime = ::TimeLocal();

ulong FirstRepStartTime=0;

bool QuickReport(string file_name, bool is_open_file_in_browser=true, int virtual_number=-1, bool hide_account_and_name=false, bool common_path=false, bool fileANSI=true){//
   StringReplace(file_name,"\\","-");StringReplace(file_name,"/","-");StringReplace(file_name,":","-");StringReplace(file_name,"*","-");StringReplace(file_name,"?","-");StringReplace(file_name,"\"","-");StringReplace(file_name,"<","-");StringReplace(file_name,">","-");StringReplace(file_name,"|","-");
   ulong RepStartTime = ::GetMicrosecondCount();
   if(FirstRepStartTime==0){FirstRepStartTime=RepStartTime;TimeLocalEndTest=GetLocalTimeS();}//if more then one virtual testers out data, then save time first call

   string FileName;
   ResetLastError();
   int f;string agent="3000";
   if(common_path){
      string p=MQLInfoString(MQL_PROGRAM_PATH);// C:\Users\0\AppData\Roaming\MetaQuotes\Tester\.....\Agent-127.0.0.1-3000\MQL5\Experts\testEXE.ex5
      int agent_pos=StringFind(p,"Agent-");// при оптимизации запустится в папке с номером агента
      if(agent_pos!=-1){agent_pos=StringFind(p,"-",agent_pos+6);agent = StringSubstr(p,agent_pos+1,4);}// 3001, 3002... 
      FileName="QuickReport\\"+agent+"-"+file_name+".htm";
      if(fileANSI){f=FileOpen(FileName,FILE_WRITE|FILE_CSV|FILE_ANSI   |FILE_COMMON,",");}
      else{        f=FileOpen(FileName,FILE_WRITE|FILE_CSV|FILE_UNICODE|FILE_COMMON,",");}//UNICODE *2 filesize, and time to show
   } else{
      FileName="QuickReport\\"+file_name+".htm";
      if(fileANSI){f=FileOpen(FileName,FILE_WRITE|FILE_CSV|FILE_ANSI,",");}
      else{        f=FileOpen(FileName,FILE_WRITE|FILE_CSV|FILE_UNICODE,",");}//UNICODE *2 filesize, and time to show
   }
   if(f!=INVALID_HANDLE){
      FileWrite(f,QuickReport_HTMLTemplate());
      FileWrite(f,"<script>");
      FileWrite(f,"TimeLocalStartTest='"+TimeLocalStartTest+ "';");
      FileWrite(f,"PassTime='"+DoubleToString((::FirstRepStartTime - TimeStartTest) / 1e6, 3)+ " s.';");
      FileWrite(f,"TimeLocalEndTest='"+TimeLocalEndTest+"';");
    #ifdef __VIRTUAL__
      int realVirtual=VIRTUAL::GetNumber(VIRTUAL::GetHandle());
      FileWrite(f,"VIRTUAL_ID='"+(string)(virtual_number<0?realVirtual:virtual_number)+" " + VIRTUAL::GetID() +"';");
    #else // #ifdef __VIRTUAL__
      int realVirtual=0;
      FileWrite(f,"VIRTUAL_ID='"+(string)(virtual_number<0?0:virtual_number)+" ';");
    #endif // #ifdef __VIRTUAL__ #else
      FileWrite(f,"DigitsCurrency="+(string)(int)::AccountInfoInteger(ACCOUNT_CURRENCY_DIGITS)+";");
      FileWrite(f,"ACCOUNT_CURRENCY='"+::AccountInfoString(ACCOUNT_CURRENCY)+"';");
      FileWrite(f,"PROGRAM_NAME='"+::MQLInfoString(MQL_PROGRAM_NAME)+"';");
      FileWrite(f,"CurrSymbol='"+Symbol()+"';");
      FileWrite(f,"Custom="+(string)::SymbolInfoInteger(::Symbol(), SYMBOL_CUSTOM)+";");
      FileWrite(f,"SYMBOL_CURRENCY_PROFIT='"+::SymbolInfoString(::Symbol(), SYMBOL_CURRENCY_PROFIT)+"';");
      FileWrite(f,"Build='"+(string)::TerminalInfoInteger(TERMINAL_BUILD)+"';");
      FileWrite(f,"ACCOUNT_SERVER='"+::AccountInfoString(ACCOUNT_SERVER)+"';");
      FileWrite(f,"ACCOUNT_COMPANY='"+::AccountInfoString(ACCOUNT_COMPANY)+"';");
      FileWrite(f,"ACCOUNT_LOGIN='"+(hide_account_and_name?"****":(string)::AccountInfoInteger(ACCOUNT_LOGIN))+"';");
      FileWrite(f,"ACCOUNT_NAME='"+(hide_account_and_name?"****": ::AccountInfoString(ACCOUNT_NAME))+"';");
      FileWrite(f,"TestSartTime='"+(string)TestSartTime+"';");
      FileWrite(f,"TestEndTime='"+(string)(::TimeLocal()+(24 * 3600))+"';");
      FileWrite(f,"MT5Order=false;");
      
      int TRADE_EXEMODE = (int)SymbolInfoInteger(Symbol(),SYMBOL_TRADE_EXEMODE);//0=SYMBOL_TRADE_EXECUTION_REQUEST, 1=SYMBOL_TRADE_EXECUTION_INSTANT, 2=SYMBOL_TRADE_EXECUTION_MARKET, 3=SYMBOL_TRADE_EXECUTION_EXCHANGE
      FileWrite(f,"TRADE_EXEMODE='"+(TRADE_EXEMODE==0?"REQUEST":(TRADE_EXEMODE==1?"INSTANT":(TRADE_EXEMODE==2?"MARKET":"EXCHANGE")))+"';");

      FileWrite(f,"MODE='"+(((ENUM_ACCOUNT_MARGIN_MODE)::AccountInfoInteger(ACCOUNT_MARGIN_MODE) == ACCOUNT_MARGIN_MODE_RETAIL_HEDGING) ? "Hedge" : "Netting")+"';");
      FileWrite(f,"csv=[");
      int len = 0; 
      int symId=-1; int d=0; string sym=""; string Syms[]; int Digs[]; int sl_len=0; int D = (int)::AccountInfoInteger(ACCOUNT_CURRENCY_DIGITS);
      string t;
      for (int i = 0; i < OrdersHistoryTotal(); i++){
         if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) ){
            if(sym!=OrderSymbol()){ 
               sym=OrderSymbol(); symId=inArr(sym,Syms,sl_len);
               if(symId==-1){ symId=sl_len; sl_len++; ArrayResize(Syms, sl_len, 100); ArrayResize(Digs, sl_len, 100); Syms[symId]=sym; Digs[symId]=(int)SymbolInfoInteger(sym,SYMBOL_DIGITS); }
               d=Digs[symId];
            }
            string ordStat="";
          #ifdef __MQL5__
            bool StopLossFlag =(OrderCloseReason() == DEAL_REASON_SL); bool TakeProfitFlag =(OrderCloseReason() == DEAL_REASON_TP);
            int CloseReason = OrderCloseReason();
            if(realVirtual==0){//HistoryOrderGetInteger functions exist only in MT5 
              ulong Ticket = OrderTicketID();//::HistoryOrderGetTicket(i);
              ordStat= ","+(string)(OrderOpenTime()-::HistoryOrderGetInteger(Ticket, ORDER_TIME_SETUP))+","+(string)(::HistoryOrderGetInteger(Ticket, ORDER_TYPE))+","+(string)::HistoryOrderGetInteger(Ticket, ORDER_STATE)+","+(::HistoryOrderGetInteger(Ticket, ORDER_POSITION_ID)>0?"1":"0")+","+(::HistoryOrderGetDouble (Ticket, ORDER_VOLUME_INITIAL)==::HistoryOrderGetDouble (Ticket, ORDER_VOLUME_CURRENT)?"1":"0");
            }

          #else // #ifdef __MQL5__
            bool StopLossFlag   =(OrderCloseTime() && (OrderType() <= OP_SELL) && ((::StringFind(OrderComment(), "[sl]") >= 0) || (OrderStopLoss()   && (OrderType() ? (OrderClosePrice() >= OrderStopLoss()) :   (OrderClosePrice() <= OrderStopLoss()  )))));
            bool TakeProfitFlag =(OrderCloseTime() && (OrderType() <= OP_SELL) && ((::StringFind(OrderComment(), "[tp]") >= 0) || (OrderTakeProfit() && (OrderType() ? (OrderClosePrice() <= OrderTakeProfit()) : (OrderClosePrice() >= OrderTakeProfit())))));
            int CloseReason = (StopLossFlag ? 4 : (TakeProfitFlag ? 5: 3));
          #endif // #ifdef __MQL5__ #else

            t=OrderComment();
            FileWrite(f,"["+(string)OrderTicket(),OrderOpenTimeMsc(),OrderCloseTimeMsc()-OrderOpenTimeMsc(),OrderType(),OrderLots(),symId,DoubleToString(OrderOpenPrice(),d),toStr(OrderStopLoss(),d),toStr(OrderTakeProfit(),d),DoubleToString(OrderClosePrice(),d),toStr(OrderCommission(),fmax(8,D)),toStr(OrderSwap(),D),toStr(OrderProfit(),D),DoubleToString(OrderOpenPriceRequest(),d),DoubleToString(OrderClosePriceRequest(),d),OrderMagicNumber(), CloseReason, (t==""?"":(t=="end of test"?"0":"\""+t+"\""))+ordStat+"],");
            len++;
         }
      } 

      
      FileWrite(f,"];");

      FileWrite(f,"Syms=[");
      for (int i = 0; i < sl_len; i++){ FileWrite(f,"['"+Syms[i]+"'", (string)Digs[i]+"]"+(i==sl_len-1?"":",")); } 
      FileWrite(f,"];");
      FileWrite(f,"len="+(string)len+";");
      FileWrite(f,"TimeLocalEnd='"+GetLocalTimeS()+"';");
      FileWrite(f,"ReportGenTime='"+DoubleToString((::GetMicrosecondCount() - RepStartTime) / 1e6, 3)+ " s.';");
      FileFlush(f);
      FileWrite(f,"FileSize='"+(string)(::FileSize(f)+45)+ "';");
      FileWrite(f,"</script></body></html>");
      FileClose(f);
      string BASEPATH_ = (::TerminalInfoString(TERMINAL_DATA_PATH) + "\\MQL5\\Files\\");
      string COMMONPATH_ = (::TerminalInfoString(TERMINAL_COMMONDATA_PATH) + "\\Files\\");
    #ifndef __MQL5__
      BASEPATH_ = (::TerminalInfoString(TERMINAL_DATA_PATH) + "\\MQL4\\Files\\");
    #endif // #ifndef __MQL5__
      string file_path=(common_path ? COMMONPATH_ + FileName : BASEPATH_ + FileName);
      Print("Quick Report saved to: "+file_path);
    #ifdef REPORT_BROWSER
      if(is_open_file_in_browser){
         if ((bool)::MQLInfoInteger(MQL_DLLS_ALLOWED)){
            if (::MQLInfoInteger(MQL_TESTER)){if (!::MQLInfoInteger(MQL_OPTIMIZATION)){ shell32::ShellExecuteW(0, "Open", file_path, NULL, NULL, 3);}}
            else{shell32::ShellExecuteW(0, "Open", file_path, NULL, NULL, 3);}
         }
      }
    #endif
   }else{PrintFormat("Failed to open file %s, Error code = %d",FileName,GetLastError());}
   return(f!=INVALID_HANDLE);
}

string toStr(double v, int d){if(v==0.0){return "";} return DoubleToString(v,d);}

int inArr(string v, string &a[], int len){for (int i = 0; i < len; i++){ if(a[i] == v){return i;}}return -1;}

string QuickReport_HTMLTemplate(){ return 
"<!DOCTYPE html><html><head><meta http-equiv='Pragma' content='no-cache'><title>paginator sample</title>\n"

+"<!-- paginator - Generate content by call to function genRows(Page*PerPage,(Page+1)*PerPage);which should insert the requested rows into the table. In the code, you need to add (to display the upper and lower menu of the paginator)<div id='pagination1' class='pagination'></div><div id='pagination2' class='pagination'></div>-->\n"
+"<style>body {font-family:Arial;}.pagination {font-size:15px;}.pagination button { background:#eee; margin:20px 1px;min-width:20px;height:20px; cursor:pointer;padding: 5px;border: 0;box-sizing: content-box;font-size: 15px;}.pagination span button {display: none; }.pagination .act   {background:#f99;display: inline-block;}.pagination .show  {display: inline-block;} .inlBl{display:inline-block;}</style>\n"
+"<script>\n"
+"var showPagesInMenu = 9;var PerPage= 50;var PPVals=[5,10,15,20,25,30,40,50,70,100,200,300,500,1000,2000,5000,10000];\n"
+"function addListener(obj,type,listener){if (obj.addEventListener){obj.addEventListener(type,listener,false);return true;}else if(obj.attachEvent){obj.attachEvent('on'+type,listener);return true;}return false;}\n"
+"addListener(window, 'DOMContentLoaded', function() {eId('syList').innerHTML=genSymbols();startReport();startPagination();});\n"
+"addListener(document,'keydown', (event) => {if (event.keyCode === 37) {showPrevPage();}if (event.keyCode === 39) {showNextPage();}});\n"
+"function eId(id){return document.getElementById(id);}\n"
+"function startPagination(){ var t = ''; var s=''; var p = 0; for(var i = 0; i < lenFiltered; i += PerPage) {t += '<button onclick=showPage('+p+') '+(i==0 ? 'class=act':'')+'>'+(p+1)+'</button>'; s+='<option value='+p+'>'+(p+1)+'</option>'; p++;} t = '<strong>Select page:</strong> <select onchange=showPage(parseInt(this.value)) size=1>'+s+'</select> <button onclick=showPage(0)>1</button><button onclick=showPrevPage()><</button><span>'+t+'</span><button onclick=showNextPage()>></button><button onclick=showPage('+(p+1)+')>'+p+'</button> (you can use left & right arrows). Rows per page: '+PPageGen();maxPage = p-1; prevPage=0; eId('pagination1').innerHTML = t; eId('pagination2').innerHTML = t; showPage(0);}\n"
+"function showNextPage(){showPage(prevPage+1);}\n"
+"function showPrevPage(){showPage(prevPage-1);}\n"
+"function PPage(pp){PerPage = pp; startPagination();}\n"
+"function PPageGen(){var t='<select onchange=PPage(parseInt(this.value)) size=1>'; for(var i=0; i<PPVals.length; i++){t+='<option'+(PerPage==PPVals[i]?' selected':'')+'>'+PPVals[i]+'</option>'} t+='</select>';return t;}\n"
+"function showPage(Page){ if(Page<0){Page=0;}if(Page>maxPage){Page=maxPage;} genRows_(Page*PerPage,(Page+1)*PerPage); var p1 = eId('pagination1').getElementsByTagName('span')[0].getElementsByTagName('button'); var p2 = eId('pagination2').getElementsByTagName('span')[0].getElementsByTagName('button'); var n=0; var ph=parseInt(showPagesInMenu/2)+ 1;var p=ph+ph-1; for(var i=0; i < p1.length; i++) { if((i>Page-ph && i<Page+ph) || (Page<ph && n<p) || (Page>p1.length-ph && i > p1.length-(p+1))){p1[i].setAttribute('class',(i==Page?'act':'show')); p2[i].setAttribute('class',(i==Page?'act':'show'));n++;}else{ p1[i].removeAttribute('class'); p2[i].removeAttribute('class'); } }eId('pagination1').getElementsByTagName('select')[0].getElementsByTagName('option')[prevPage].removeAttribute('selected'); eId('pagination2').getElementsByTagName('select')[0].getElementsByTagName('option')[prevPage].removeAttribute('selected'); eId('pagination1').getElementsByTagName('select')[0].getElementsByTagName('option')[Page].setAttribute('selected','true'); eId('pagination2').getElementsByTagName('select')[0].getElementsByTagName('option')[Page].setAttribute('selected','true'); prevPage = Page;}\n"
+"function genRows_(from_, to_){genRows(from_, to_);}//get content from csv[]\n"
+"</script><!-- end paginator -->\n"

+"<!-- csv to table -->\n"
+"<style>.at {border-spacing:1px; border:0;text-align:right;font: 11px Tahoma,Arial;}.at tr:nth-child(odd) {background: #e0e0e0;}.at td {padding: 2px;vertical-align: bottom;}.at tr:nth-child(1), .at tr:nth-last-child(1) { background:#eee; color:magenta;}.at tr:nth-child(2), .at tr:nth-last-child(2) { background:transparent; color:red;}.at tr:nth-child(3) td, .at tr:nth-last-child(3) td { background:#c0c0c0; text-align:center;padding:1px;}.sl {color:red;    font-weight:bold;}.tp {color:#00A000;font-weight:bold;}.r {color:red;}.g {color:#00A000;}.b {color:blue;}.g {color:#777;}.db {color:#009;}.m {color:magenta;} .Comment{min-width:80px} .tmstat {text-align:right;font-size:14px;background: #eee;border:solid 1px #aaa;margin:10px 0;}.tmstat tr:nth-child(odd) {background: #fff;}.tstat  {text-align:right;font-size:14px;}.tstat tr:nth-child(odd) {background: #e0e0e0;}svg {border-bottom:solid 1px #000;}.svgc {font-family:Arial;font-size:12px;display:inline-block;border:solid 1px #aaa;margin:10px;} .pointer{cursor:pointer;}</style>\n"
+"<script>var idToPag='orders';version=1;var GMT= new Date().getTimezoneOffset();\n"
+"function genRows(from_, to_){loadFilters(); var s=''; var r=0; for(var i=0; i<len; i++) { rowParams(i); if(isFiltered(i)){continue;} if(r>=to_){break;} if(r>=from_){s+=getRow(i,r);} r++; } eId(idToPag).innerHTML=Average+Summary+head+s+head+Summary+Average;}\n"
+"csv=[];Syms=[];bal=[];balBuySell=[];slip=[];slipCum=[];priceLine=[]; profit_loss=[], balanc=[], pipses=[], turn=[];FileSize='';VIRTUAL_ID='0 ';len=0;DigitsCurrency=2;Custom=0;TimeLocalEnd='';ReportGenTime='';TimeLocalStartTest='';PassTime='';TimeLocalEndTest='';ACCOUNT_CURRENCY='';PROGRAM_NAME='';CurrSymbol='';SYMBOL_CURRENCY_PROFIT='';Build='';ACCOUNT_SERVER='';ACCOUNT_COMPANY='';ACCOUNT_LOGIN='';ACCOUNT_NAME='';TestSartTime='';TestEndTime='';MODE='';MT5Order=false;\n"
+"function setv(a,from_,to_,v_){a.length=to_;for (var r=from_; r<to_;r++){a[r]=v_;}}\n"
+"var h1_m10=true;hoursP=[];hoursL=[];hoursPBuy=[];hoursLBuy=[];hoursPSel=[];hoursLSel=[];wdP=[];wdL=[];wdPBuy=[];wdLBuy=[];wdPSel=[];wdLSel=[];\n"
+"HOpen=DOpen=0;dBuy=dBuyL=dBuyS=dSell=dSellL=dSellS=dBal=fNegO=fNegC=fSwap=fTP=fSL=fProfits=fLosses=fRejects=true; fMag=-1;fMinL=0;fMaxL=100; lenFiltered=0;fPosDays=fPosHours=fPosMinut=fPosSec=fPosDaysMax=fPosHoursMax=fPosMinutMax=fPosSecMax=fDtStart=fDtEnd=fDtStartCl=fDtEndCl=0; symFil=[];ordState=ordPos=ordVolEqual=ordPendSec=ordPendTyp=0;ordFromPend=false;\n"
+"function loadFilters(){dBuy=eId('dBuy').checked;dBuyL=eId('dBuyL').checked;dBuyS=eId('dBuyS').checked;dSell=eId('dSell').checked;dSellL=eId('dSellL').checked;dSellS=eId('dSellS').checked;dBal=eId('dBal').checked;fNegO=eId('fNegO').checked;fNegC=eId('fNegC').checked;fSwap=eId('fSwap').checked;fTP=eId('fTP').checked;fSL=eId('fSL').checked;fProfits=eId('fProfits').checked;fLosses=eId('fLosses').checked;fRejects=eId('fRejects').checked;fMag=eId('fMag').value;fMinL=eId('fMinL').value;fMaxL=eId('fMaxL').value;fPosDays=eId('fPosDays').value;fPosHours=eId('fPosHours').value;fPosMinut=eId('fPosMinut').value;fPosSec=eId('fPosSec').value;fPosDaysMax=eId('fPosDaysMax').value;fPosHoursMax=eId('fPosHoursMax').value;fPosMinutMax=eId('fPosMinutMax').value;fPosSecMax=eId('fPosSecMax').value;fDtStart = td_to_msec(eId('fDtStart').value); fDtEnd = td_to_msec(eId('fDtEnd').value);fDtStartCl = td_to_msec(eId('fDtStartCl').value); fDtEndCl = td_to_msec(eId('fDtEndCl').value);for(var i=0;i<Syms.length;i++){symFil[i]=eId('sy_'+i).checked;}}\n"
+"function isFiltered(r){if((Type==0 && !dBuy)||(Type==1 && !dSell)||(Type==2 && !dBuyL)||(Type==3 && !dSellL)||(Type==4 && !dBuyS)||(Type==5 && !dSellS)||(Type>5 && !dBal) || (fMag>=0 && fMag!=MagicNumber) ||  (fDtStart>0 && OpenTime<fDtStart) || OpenTime>fDtEnd ||  (fDtStartCl>0 && CloseTime<fDtStartCl) || CloseTime>fDtEndCl || (fSwap && (Swap==0 || Type>5))){return true;}\n"
+"var PosLenMin=fPosDays*86400000+fPosHours*3600000+fPosMinut*60000+fPosSec*1000;var PosLenMax=fPosDaysMax*86400000+fPosHoursMax*3600000+fPosMinutMax*60000+fPosSecMax*1000;\n"
+"if((!symFil[SId] || Lots<fMinL || Lots>fMaxL || ( PosLenMin>0 && PosLenMin>=LengthTime) || ( PosLenMax>0 && PosLenMax<=LengthTime)  ) && Type<6){return true;}\n"
+"if((fTP && CloseReason!=5) || (fSL && CloseReason!=4) || (fProfits && (Profit<=0 || Type>5) ) || (fLosses && Profit>=0)  ){return true;}\n"
+"if(((fNegO && (slip1>=0||Type>5)) || (fNegC && (slip2>=0 || Type>5)) )){return true;}\n"
+"HOpen=(h1_m10?msec_to_H(OpenTime):msec_to_M10(OpenTime)); DOpen=msec_to_D(OpenTime); if(!isTradeAllowed(OpenTime,Type,HOpen,DOpen)){return true;}\n"
+"if(fRejects && csv[r][18]!=undefined){if(ordState==4 || !(ordPos==1 || ordVolEqual==0 )){return true;}}\n"
+"return false;}\n"
+"function genSymbols(){var t='';for(var i=0;i<Syms.length;i++){t+=Syms[i][0]+' <input id=sy_'+i+' checked type=checkbox onchange=\\'startReport();startPagination();\\'>, ';}return t;}\n"

+"function startReport(typeCalc){\n"
+"	version=(eId('repver').checked?0:1);\n"
+"	TestSartTimeMs = Date.parse(TestSartTime.replace(/\\./g,'-')+'Z'); TestEndTimeMs = Date.parse(TestEndTime.replace(/\\./g,'-')+'Z');\n"
+"	timeBegin=0;BeginDD=0;EndDD=0;max_pl=0;MaxDD=0;max_dd2=0;dep_w=0;WinningTrades=0;WinningTradesV=0;LosingTrades=0;LosingTradesV=0;MaxWin=0;MaxLos=0;Wins=0;Loses=0;MaxConWins=0;MaxConWinsV=0;MaxConLos=0;MaxConLosV=0;ConWinsV=0;ConLosV=0; MaxConPrWins=0;MaxConPrWinsV=0;MaxConPrLos=0;MaxConPrLosV=0;DigitsPrev=0; TickValue=1;\n"
+"	profit_loss=[]; balanc=[]; pipses=[]; turn=[]; balBuySell=[];slip=[];slipCum=[];priceLine=[];//reset\n"
+"	h1_m10=eId('h1_m10').checked;	var tn=24*(h1_m10?1:6); setv(hoursP,0,tn,0.0);setv(hoursL,0,tn,0.0);setv(hoursPBuy,0,tn,0.0);setv(hoursLBuy,0,tn,0.0);setv(hoursPSel,0,tn,0.0);setv(hoursLSel,0,tn,0.0);  setv(wdP,0,7,0.0);setv(wdL,0,7,0.0);setv(wdPBuy,0,7,0.0);setv(wdLBuy,0,7,0.0);setv(wdPSel,0,7,0.0);setv(wdLSel,0,7,0.0);\n"
+"	loadFilters();\n"
+"	var l=0,c=0,c2=0,s=0,s2=0,p=0,p_no_slip=0,b=0,bBuy=0,bSell=0,pi=0,pi_no_slip=0,sl=0,lt=0,to=0,n=0,sl1=0,sl2=0,res=0,n_swaps=0;lenFiltered=0;\n"
+"	for (var r=0; r<len;r++){\n"
+"		rowParams(r);\n"
+"		if(isFiltered(r)){continue;} lenFiltered++;\n"
+"		if(typeCalc==1 && CloseTime>=TestForwardTimeMs){break;}\n"
+"		if(typeCalc==2 && CloseTime< TestForwardTimeMs){continue;}\n"
+"		res=Commission+Swap+Profit; b+=res; bal[r]=b; c+=Commission; c2+=PipsCommission; s+=Swap; s2+=PipsSwap; if(Swap!=0){n_swaps++;} to+=TurnOver; pi+=pips; pi_no_slip+=pips_no_Slip; \n"
+"		if(Type<2){\n"
+"			n++; p+=Profit; l+=Lots; lt+=LengthTime; sl+=slips; sl1+=slip1; sl2+=slip2; p_no_slip+=prof_no_Slip;\n"
+"			if(Type==0){bBuy+=res;}else{bSell+=res;}\n"
+"			//depozit stats\n"
+"			if(res>0){ WinningTrades++;WinningTradesV+=res;if(MaxWin<res){MaxWin=res;} Wins++;  ConWinsV+=res;if(MaxConWins<Wins){MaxConWins=Wins;MaxConWinsV=ConWinsV;}else if(MaxConWins==Wins){MaxConWinsV=Math.max(MaxConWinsV,ConWinsV);}if(MaxConPrWinsV<ConWinsV){MaxConPrWinsV=ConWinsV;MaxConPrWins=Wins;} Loses=0;ConLosV=0; }\n"
+"			else if(res<0){LosingTrades++; LosingTradesV+= res;if(MaxLos>res){MaxLos=res;} Loses++; ConLosV+= res;if(MaxConLos<Loses){MaxConLos=Loses;MaxConLosV= ConLosV; }else if(MaxConLos==Loses){MaxConLosV= Math.min(MaxConLosV, ConLosV); }if(MaxConPrLosV> ConLosV){ MaxConPrLosV= ConLosV; MaxConPrLos=Loses;} Wins=0; ConWinsV=0;}\n"
+"			if(timeBegin==0){timeBegin=CloseTime;}//time of firt deal\n"
+"			if(max_pl<WinningTradesV+LosingTradesV){max_pl=WinningTradesV+LosingTradesV; calcMaxLengthDD(CloseTime);}\n"
+"			if (MaxDD < max_pl - (WinningTradesV+LosingTradesV)){MaxDD = max_pl - (WinningTradesV+LosingTradesV);if (b <= 0){max_dd2 = 100;}else{max_dd2 = 100 * MaxDD / b;}}\n"
+"			if(res>0){hoursP[HOpen]+=res;wdP[DOpen]+=res;if(Type==0){hoursPBuy[HOpen]+=res;wdPBuy[DOpen]+=res;}else{hoursPSel[HOpen]+=res;wdPSel[DOpen]+=res;}}else{hoursL[HOpen]+=res;wdL[DOpen]+=res;if(Type==0){hoursLBuy[HOpen]+=res;wdLBuy[DOpen]+=res;}else{hoursLSel[HOpen]+=res;wdLSel[DOpen]+=res;}}\n"

+"		}\n"
+"		if(Type==6 && !MT5Order){dep_w+=Profit;}//end depozit stats\n"
+"		//charts\n"
+"		if(Type<2 || (Type==6 && !MT5Order)){profit_loss.push([CloseTime, p+c+s, p_no_slip+c+s, p, p_no_slip]); pipses.push([CloseTime, pi, pi_no_slip]); balanc.push([CloseTime, b]);balBuySell.push([CloseTime, p+c+s, bBuy, bSell]);slip.push([CloseTime, slips, slip1, slip2]);slipCum.push([CloseTime, sl, sl1, sl2]);if(ClosePrice!=0){priceLine.push([CloseTime, ClosePrice]);}}//turn.push([CloseTime, to]);\n"
+"	}\n"
+"	calcMaxLengthDD((typeCalc==1 ? TestForwardTimeMs : TestEndTimeMs));\n"
+"	if(typeCalc==1){eId('Balance_ReportBack').innerHTML='<b>BackTest Balance Report</b><table class=tstat><tr><td>Deposit/Withdrawal:</td><td>'+moneyFormat(dep_w,DigitsCurrency)+'</td></tr><tr><td>Summary P/L:</td><td>'+moneyFormat(WinningTradesV+LosingTradesV,DigitsCurrency)+'</td></tr><tr><td>Balance:</td><td>'+moneyFormat(b,DigitsCurrency)+'</td></tr><tr><td>Winning trades:</td><td>('+WinningTrades+') '+moneyFormat(WinningTradesV,DigitsCurrency)+'</td></tr><tr><td>Losing trades:</td><td>('+LosingTrades+') '+moneyFormat(LosingTradesV,DigitsCurrency)+'</td></tr><tr><td>Max summary P/L:</td><td>'+moneyFormat(max_pl,DigitsCurrency)+'</td></tr><tr><td>Largest winning trade:</td><td>'+moneyFormat(MaxWin,DigitsCurrency)+'</td></tr><tr><td>Largest losing trade:</td><td>'+moneyFormat(MaxLos,DigitsCurrency)+'</td></tr><tr><td>Max consecutive winners:</td><td>'+MaxConWins+' ('+moneyFormat(MaxConWinsV,DigitsCurrency)+')</td></tr><tr><td>Max consecutive losers:</td><td>'+MaxConLos+' ('+moneyFormat(MaxConLosV,DigitsCurrency)+')'+'</td></tr><tr><td>Max consecutive profit:</td><td>'+moneyFormat(MaxConPrWinsV,DigitsCurrency)+' ('+MaxConPrWins+')</td></tr><tr><td>Max consecutive loss:</td><td>'+moneyFormat(MaxConPrLosV,DigitsCurrency)+' ('+MaxConPrLos+')'+'</td></tr><tr><td>Absolute drawdown:</td><td>*</td></tr><tr><td>Max balance:</td><td>'+moneyFormat(dep_w+max_pl,DigitsCurrency)+'</td></tr><tr><td>Max drawdown:</td><td>'+moneyFormat(MaxDD,DigitsCurrency)+' ('+moneyFormat(max_dd2,3)+'%)</td></tr><tr><td>Max drawdown time:</td><td>'+msec_to_len_tx(EndDD - BeginDD)+'<br/>'+msec_to_tx(BeginDD)+'<br/>...'+msec_to_tx(EndDD)+'</td></tr><tr><td>Profit factor:</td><td>'+(LosingTradesV==0?'*':moneyFormat(WinningTradesV/LosingTradesV,5))+'</td></tr><tr><td>Avg. profit factor:</td><td>'+(LosingTradesV*LosingTrades==0?'*': moneyFormat(Math.abs((WinningTradesV*LosingTrades)/(LosingTradesV*WinningTrades)),5))+'</td></tr><tr><td>Risk factor:</td><td>'+(MaxDD==0?'*':moneyFormat((WinningTradesV+LosingTradesV)/MaxDD,5))+'</td></tr></table>';return;}\n"
+"	if(typeCalc==2){eId('Balance_ReportForw').innerHTML='<b>ForwardTest Balance Report</b><table class=tstat><tr><td>Deposit/Withdrawal:</td><td>'+moneyFormat(dep_w,DigitsCurrency)+'</td></tr><tr><td>Summary P/L:</td><td>'+moneyFormat(WinningTradesV+LosingTradesV,DigitsCurrency)+'</td></tr><tr><td>Balance:</td><td>'+moneyFormat(b,DigitsCurrency)+'</td></tr><tr><td>Winning trades:</td><td>('+WinningTrades+') '+moneyFormat(WinningTradesV,DigitsCurrency)+'</td></tr><tr><td>Losing trades:</td><td>('+LosingTrades+') '+moneyFormat(LosingTradesV,DigitsCurrency)+'</td></tr><tr><td>Max summary P/L:</td><td>'+moneyFormat(max_pl,DigitsCurrency)+'</td></tr><tr><td>Largest winning trade:</td><td>'+moneyFormat(MaxWin,DigitsCurrency)+'</td></tr><tr><td>Largest losing trade:</td><td>'+moneyFormat(MaxLos,DigitsCurrency)+'</td></tr><tr><td>Max consecutive winners:</td><td>'+MaxConWins+' ('+moneyFormat(MaxConWinsV,DigitsCurrency)+')</td></tr><tr><td>Max consecutive losers:</td><td>'+MaxConLos+' ('+moneyFormat(MaxConLosV,DigitsCurrency)+')'+'</td></tr><tr><td>Max consecutive profit:</td><td>'+moneyFormat(MaxConPrWinsV,DigitsCurrency)+' ('+MaxConPrWins+')</td></tr><tr><td>Max consecutive loss:</td><td>'+moneyFormat(MaxConPrLosV,DigitsCurrency)+' ('+MaxConPrLos+')'+'</td></tr><tr><td>Absolute drawdown:</td><td>*</td></tr><tr><td>Max balance:</td><td>'+moneyFormat(dep_w+max_pl,DigitsCurrency)+'</td></tr><tr><td>Max drawdown:</td><td>'+moneyFormat(MaxDD,DigitsCurrency)+' ('+moneyFormat(max_dd2,3)+'%)</td></tr><tr><td>Max drawdown time:</td><td>'+msec_to_len_tx(EndDD - BeginDD)+'<br/>'+msec_to_tx(BeginDD)+'<br/>...'+msec_to_tx(EndDD)+'</td></tr><tr><td>Profit factor:</td><td>'+(LosingTradesV==0?'*':moneyFormat(WinningTradesV/LosingTradesV,5))+'</td></tr><tr><td>Avg. profit factor:</td><td>'+(LosingTradesV*LosingTrades==0?'*': moneyFormat(Math.abs((WinningTradesV*LosingTrades)/(LosingTradesV*WinningTrades)),5))+'</td></tr><tr><td>Risk factor:</td><td>'+(MaxDD==0?'*':moneyFormat((WinningTradesV+LosingTradesV)/MaxDD,5))+'</td></tr></table>';return;}\n"
+"	eId('Balance_Report').innerHTML='<b>Balance Report</b><br/><table class=tstat><tr><td>Deposit/Withdrawal:</td><td>'+moneyFormat(dep_w,DigitsCurrency)+'</td></tr><tr><td>Summary P/L:</td><td>'+moneyFormat(WinningTradesV+LosingTradesV,DigitsCurrency)+'</td></tr><tr><td>Balance:</td><td>'+moneyFormat(b,DigitsCurrency)+'</td></tr><tr><td>Winning trades:</td><td>('+WinningTrades+') '+moneyFormat(WinningTradesV,DigitsCurrency)+'</td></tr><tr><td>Losing trades:</td><td>('+LosingTrades+') '+moneyFormat(LosingTradesV,DigitsCurrency)+'</td></tr><tr><td>Max summary P/L:</td><td>'+moneyFormat(max_pl,DigitsCurrency)+'</td></tr><tr><td>Largest winning trade:</td><td>'+moneyFormat(MaxWin,DigitsCurrency)+'</td></tr><tr><td>Largest losing trade:</td><td>'+moneyFormat(MaxLos,DigitsCurrency)+'</td></tr><tr><td>Max consecutive winners:</td><td>'+MaxConWins+' ('+moneyFormat(MaxConWinsV,DigitsCurrency)+')</td></tr><tr><td>Max consecutive losers:</td><td>'+MaxConLos+' ('+moneyFormat(MaxConLosV,DigitsCurrency)+')'+'</td></tr><tr><td>Max consecutive profit:</td><td>'+moneyFormat(MaxConPrWinsV,DigitsCurrency)+' ('+MaxConPrWins+')</td></tr><tr><td>Max consecutive loss:</td><td>'+moneyFormat(MaxConPrLosV,DigitsCurrency)+' ('+MaxConPrLos+')'+'</td></tr><tr><td>Absolute drawdown:</td><td>*</td></tr><tr><td>Max balance:</td><td>'+moneyFormat(dep_w+max_pl,DigitsCurrency)+'</td></tr><tr><td>Max drawdown:</td><td>'+moneyFormat(MaxDD,DigitsCurrency)+' ('+moneyFormat(max_dd2,3)+'%)</td></tr><tr><td>Max drawdown time:</td><td>'+msec_to_len_tx(EndDD - BeginDD)+'<br/>'+msec_to_tx(BeginDD)+'<br/>...'+msec_to_tx(EndDD)+'</td></tr><tr><td>Profit factor:</td><td>'+(LosingTradesV==0?'*':moneyFormat(WinningTradesV/LosingTradesV,5))+'</td></tr><tr><td>Avg. profit factor:</td><td>'+(LosingTradesV*LosingTrades==0?'*': moneyFormat(Math.abs((WinningTradesV*LosingTrades)/(LosingTradesV*WinningTrades)),5))+'</td></tr><tr><td>Risk factor:</td><td>'+(MaxDD==0?'*':moneyFormat((WinningTradesV+LosingTradesV)/MaxDD,5))+'</td></tr></table>';\n"

+"	var slProf=p-p_no_slip;var slProf_comiss = (c!=0 ? '<t title=How_Part_of_Comission_Cover_Slippage> - ' + moneyFormat(100 * -slProf / c, 1) + '%</t>' : '');\n"
+"	if(n==0){n=1;}\n"

+"	if(version==1){\n"
+"		Summary='<tr><td>Summary</td><td>'+lenFiltered+'</td><td></td><td></td><td></td><td><t title=Total_LengthTime>'+msec_to_len_tx(lt)+'</t></td><td><t title=TotalTurnOver>'+moneyFormat(to,DigitsCurrency)+'</t></td><td></td><td></td><td><t title=Total_Lots>'+moneyFormat(l,DigitsCurrency)+'</t></td><td></td><td></td><td></td><td></td><td><t title=Total_Comission>'+moneyFormat(c,DigitsCurrency)+'</t><br/><t title=Total_Commission_in_Pips>'+tf(moneyFormat(c2,DigitsCurrency))+'</t></td><td><t title=Total_Swap>'+moneyFormat(s,DigitsCurrency)+'</t><br/><t title=Total_Swap_in_Pips>'+tf(moneyFormat(s2,DigitsCurrency))+'</t><br/><t title=Total_Deals_w_Swap>'+moneyFormat(n_swaps,0)+'</t></td><td><t title=Total_Profit>'+moneyFormat(p,DigitsCurrency)+'<br/><t title=Total_Profit_without_Slippage>('+moneyFormat(p_no_slip,DigitsCurrency)+')</t></td><td></td><td><t title=Total_Pips>'+moneyFormat(pi,0)+'</t><br/><t title=Total_Pips_without_Slippage>('+moneyFormat(pi_no_slip,0)+')</t></td><td><t title=Total_Open_Slippage>'+moneyFormat(sl1,0)+'</t><t title=Total_Close_Slippage>+ '+moneyFormat(sl2,0)+'<br/><t title=Total_Slippage_in_Pips>= '+moneyFormat(sl,0)+'</t><br/><t title=Total_Slippage_in_Money>('+moneyFormat(slProf,DigitsCurrency)+')'+slProf_comiss+'</t></td><td><t title=Total_Balance>'+moneyFormat(b,DigitsCurrency)+'</t></td></tr>';\n"
+"		Average='<tr><td>Average</td><td></td><td></td><td></td><td></td><td><t title=Avg_LengthTime>'+msec_to_len_tx(lt/n)+'</t></td><td><t title=AvgTurnOver>'+moneyFormat(to/n,DigitsCurrency)+'</t></td><td></td><td></td><td><t title=Avg_Lots>'+moneyFormat(l/n,DigitsCurrency)+'</t></td><td></td><td></td><td></td><td></td><td><t title=Avg_Comission>'+moneyFormat(c/n,DigitsCurrency+1)+'</t><br/><t title=Avg_Commission_in_Pips>'+tf(moneyFormat(c2/n,DigitsCurrency+1))+'</t></td><td><t title=Avg_Swap>'+moneyFormat(s/n,DigitsCurrency+1)+'</t><br/><t title=Awg_Swap_in_Pips>'+tf(moneyFormat(s2/n,DigitsCurrency+1))+'</t></td><td><t title=Awg_Profit>'+moneyFormat(p/n,DigitsCurrency+1)+'<br/><t title=Avg_Profit_without_Slippage>('+moneyFormat(p_no_slip/n,DigitsCurrency+1)+')</t></td><td></td><td><t title=Avg_Pips>'+moneyFormat(pi/n,1)+'</t><br/><t title=Avg_Pips_without_Slippage>('+moneyFormat(pi_no_slip/n,1)+')</t></td><td><t title=Awg_Slippage>'+moneyFormat(sl/n,1)+'</t><br/><t title=Awg_Slippage_in_Money>('+moneyFormat(slProf/n,DigitsCurrency)+')</t></td><td></td></tr>';\n"
+"		head='<tr><td>N</td><td>Ticket</td><td>Magic</td><td>OpenTime</td><td>CloseTime</td><td>LengthTime</td><td>TurnOver</td><td>Symbol</td><td>Type</td><td>Lots</td><td>OpenPrice</td><td>StopLoss</td><td>TakeProfit</td><td>ClosePrice</td><td>Commission</td><td>Swap</td><td>Profit</td><td class=Comment>Comment</td><td>Pips</td><td>Slippage</td><td>Balance</td></tr>';\n"
+"	}\n"
+"	else{\n"
+"		Summary='<tr><td>Summary</td><td>'+lenFiltered+'</td><td></td><td></td><td><t title=Total_Lots>'+moneyFormat(l,DigitsCurrency)+'</t></td><td><t title=TotalTurnOver>'+moneyFormat(to,DigitsCurrency)+'</t></td><td></td><td></td><td></td><td></td><td></td><td></td><td><t title=Total_Comission>'+moneyFormat(c,DigitsCurrency)+'</t><br/><t title=Total_PipsCommission>'+tf(moneyFormat(c2,DigitsCurrency))+'</t></td><td><t title=Total_Swap>'+moneyFormat(s,DigitsCurrency)+'</t><br/><t title=Total_PipsSwap>'+tf(moneyFormat(s2,DigitsCurrency))+'</t><br/><t title=Total_Deals_w_Swap>'+moneyFormat(n_swaps,0)+'</t></td><td><t title=Total_Profit>'+moneyFormat(p,DigitsCurrency)+'<br/><t title=Total_Profit_without_Slippage>('+moneyFormat(p_no_slip,DigitsCurrency)+')</t></td><td></td><td><t title=Total_Pips>'+moneyFormat(pi,0)+'</t><br/><t title=Total_Pips_without_Slippage>('+moneyFormat(pi_no_slip,0)+')</t></td><td><t title=Total_Open_Slippage>'+moneyFormat(sl1,0)+'</t><t title=Total_Close_Slippage>+ '+moneyFormat(sl2,0)+'<br/><t title=Total_Slippage_in_Pips>= '+moneyFormat(sl,0)+'</t><br/><t title=Total_Slippage_in_Money>('+moneyFormat(slProf,DigitsCurrency)+')'+slProf_comiss+'</t></td><td></td><td><t title=Total_LengthTime>'+msec_to_len_tx(lt)+'</t></td><td><t title=Total_Balance>'+moneyFormat(b,DigitsCurrency)+'</t></td></tr>';\n"
+"		Average='<tr><td>Average</td><td></td><td></td><td></td><td><t title=Avg_Lots>'+moneyFormat(l/n,DigitsCurrency)+'</t></td><td><t title=AvgTurnOver>'+moneyFormat(to/n,DigitsCurrency)+'</t></td><td></td><td></td><td></td><td></td><td></td><td></td><td><t title=Avg_Comission>'+moneyFormat(c/n,DigitsCurrency+1)+'</t><br/><t title=Avg_PipsCommission>'+tf(moneyFormat(c2/n,DigitsCurrency+1))+'</t></td><td><t title=Avg_Swap>'+moneyFormat(s/n,DigitsCurrency+1)+'</t><br/><t title=Awg_PipsSwap>'+tf(moneyFormat(s2/n,DigitsCurrency+1))+'</t></td><td><t title=Awg_Profit>'+moneyFormat(p/n,DigitsCurrency+1)+'<br/><t title=Avg_Profit_without_Slippage>('+moneyFormat(p_no_slip/n,DigitsCurrency+1)+')</t></td><td></td><td><t title=Avg_Pips>'+moneyFormat(pi/n,1)+'</t><br/><t title=Avg_Pips_without_Slippage>('+moneyFormat(pi_no_slip/n,1)+')</t></td><td><t title=Awg_Slippage>'+moneyFormat(sl/n,1)+'</t><br/><t title=Awg_Slippage_in_Money>('+moneyFormat(slProf/n,DigitsCurrency)+')</t></td><td></td><td><t title=Avg_LengthTime>'+msec_to_len_tx(lt/n)+'</t></td><td></td></tr>';\n"
+"		head='<tr><td>N</td><td>Ticket</td><td>OpenTime</td><td>Type</td><td>Lots</td><td>TurnOver</td><td>Symbol</td><td>OpenPrice</td><td>StopLoss</td><td>TakeProfit</td><td>CloseTime</td><td>ClosePrice</td><td>Commission</td><td>Swap</td><td>Profit</td><td class=Comment>Comment</td><td>Pips</td><td>Slippage</td><td>MagicNumber</td><td>LengthTime</td><td>Balance</td></tr>';\n"
+"	}\n"

+"	eId('img_pl').innerHTML  ='<span class=pointer onclick=f_show(profit_loss,this,DigitsCurrency)>'+time_line_svg(profit_loss,900,300,true,true,['Profit/Loss','w/o Slippages','w/o Comissions & Swaps','w/o Slippages & Comissions & Swaps'],['#000080','#008000','#800000','#808000'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_bal').innerHTML ='<span class=pointer onclick=f_show(balanc,this,DigitsCurrency)>'+time_line_svg(balanc,900,300,true,true,['Balance with all balance operations (deposits/withdrawals)'],['#000080'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_pip').innerHTML ='<span class=pointer onclick=f_show(pipses,this,0)>'+time_line_svg(pipses,900,300,true,true,['Pips','w/o Slippages'],['#000080','#008000'],true,false,TestForwardTimeMs)+'</span>';\n"
+"//	eId('img_turn').innerHTML='<span class=pointer onclick=f_show(turn,this,DigitsCurrency)>'+time_line_svg(turn,900,300,true,true,['TurnOver'],['#000080'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_balBuySell').innerHTML='<span class=pointer onclick=f_show(balBuySell,this,DigitsCurrency)>'+time_line_svg(balBuySell,900,300,true,true,['Profit/Loss','Profit/Loss Buy','Profit/Loss Sell'],['#000080','#800000','#008000'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_slip').innerHTML='<span class=pointer onclick=f_show(slip,this,DigitsCurrency)>'+time_line_svg(slip,900,300,true,true,['Slippage','Slippage open','Slippage close'],['#000080','#800000','#008000'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_slipCum').innerHTML='<span class=pointer onclick=f_show(slipCum,this,DigitsCurrency)>'+time_line_svg(slipCum,900,300,true,true,['Cumulative Slippage','Cum. Slippage open','Cum. Slippage close'],['#000080','#800000','#008000'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_priceLine').innerHTML='<span class=pointer onclick=f_show(priceLine,this,DigitsCurrency)>'+time_line_svg(priceLine,900,300,true,true,['Close price'],['#000080'],true,false,TestForwardTimeMs)+'</span>';\n"
+"	eId('img_priceLine2').innerHTML='<span class=pointer onclick=f_show(priceLine,this,DigitsCurrency)>'+time_line_svg(priceLine,900,300,true,true,['Close price copy'],['#000080'],true,false,TestForwardTimeMs)+'</span>';\n"

+"	eId('test_params').innerHTML='History Interval: '+TestSartTime.split(' ')[0]+' ... '+TestEndTime.split(' ')[0]+'<br/>ExpertName: '+PROGRAM_NAME+' (<b>'+CurrSymbol+(Custom!=0?' Custom ('+SYMBOL_CURRENCY_PROFIT+')':'')+'</b>)<br/>Build: '+Build+' Server: '+ACCOUNT_SERVER+' ('+ACCOUNT_COMPANY+') Acc No:'+ACCOUNT_LOGIN+' (<b>'+ACCOUNT_CURRENCY+', '+MODE+'</b>) Name:<b>'+ACCOUNT_NAME+'</b> Execution: <b>'+TRADE_EXEMODE+'</b> '+(VIRTUAL_ID!='0 '?'Virtual tester: <b>'+VIRTUAL_ID:'Tester: <b>MetaQuotes')+'</b>';\n"
+"	eId('time_stats').innerHTML='<table class=tmstat><tr><td>Start Pass Time: '+TimeLocalStartTest+' ... '+TimeLocalEndTest+'</td><td>Clear Pass time:</td><td>'+PassTime+'</td></tr><tr><td><span style=float:left>Report FileSize: '+moneyFormat(FileSize/1024,0)+'KB.</span> Finish Time: '+TimeLocalEnd+'</td><td>Report Generation time:</td><td>'+ReportGenTime+'</td></tr></table>';\n"
+"	eId('hours').innerHTML=hoursStat(hoursP,hoursL,'Buy + Sell',2)+hoursStat(hoursPBuy,hoursLBuy,'Buy',0)+hoursStat(hoursPSel,hoursLSel,'Sell',1);\n"
+"	eId('wdays').innerHTML=wdaysStat(wdP,wdL,'Buy + Sell',2)+wdaysStat(wdPBuy,wdLBuy,'Buy',0)+wdaysStat(wdPSel,wdLSel,'Sell',1);\n"

+"	document.title=moneyFormat(WinningTradesV+LosingTradesV,DigitsCurrency)+', '+lenFiltered+' ';\n"
+"}\n"
+"function hoursStat(ap,al,tx,tradeType){var t='';var s=0.0,sp=0.0,sl=0.0,l=ap.length,mh=l/24;var ht=[];var hsum=[];for(var r=0;r<l;r++){ht.push([r, ap[r], -al[r]]);hsum.push([r, ap[r]+al[r]]);s+=ap[r]+al[r];sp+=ap[r];sl+=al[r];} ht.push([r, ap[l-1], -al[l-1]]);hsum.push([r, ap[l-1]+al[l-1]]);t+='<span class=svgc><b>'+tx+'</b><br><span class=svgc onclick=showTbh()>'+time_line_svg(ht,(h1_m10?300:1800),100,false,false,['Profit','Loss'],['#000080','#800000'],false,false,l/2,0)+'<br>'+time_line_svg(hsum,(h1_m10?300:1800),100,false,false,['Profit + Loss'],['#008000'],false,false,l/2,0)+'</span>';t+='</span><div id=tbh'+tradeType+' style=display:'+(tbh==0?'none':'block')+';><table class=tmstat><tr><td>Time</td>';for(var r=0;r<l;r++){t+='<td>'+Math.floor(r/mh)+':'+(r-Math.floor(r/mh)*mh)+'0</td>';} t+='<td>Sum</td></tr><tr><td>Profit</td>';for(var r=0;r<l;r++){t+='<td>'+Math.round(ap[r])+'</td>';} t+='<td>'+Math.round(sp)+'</td></tr><tr><td>Loss</td>'; for(var r=0;r<l;r++){t+='<td>'+Math.round(al[r])+'</td>';}t+='<td>'+Math.round(sl)+'</td></tr><tr><td>Sum</td>'; for(var r=0;r<l;r++){t+='<td>'+Math.round(ap[r]+al[r])+'<div id=tr'+tradeType+'_'+r+'_v>'+Math.round((al[r]!=0?-(ap[r]+al[r])/al[r]*100 : 0))+'%</div></td>';} t+='<td>'+Math.round(s)+'<div onclick=\"checksDW(0,'+l+','+tradeType+');\">'+Math.round((sl!=0?-(sp+sl)/sl*100 : 0))+'%</div></td></tr><tr><td>Trade</td>'; for(var r=0;r<l;r++){t+='<td><input id=tr'+tradeType+'_'+r+' type=checkbox onclick=\"startReport();startPagination();\" '+(eId('tr'+tradeType+'_'+r)==null || eId('tr'+tradeType+'_'+r).checked?'checked':'')+'></td>';} t+='<td></td></tr></table></div>';t+=actHours(l,tradeType);return t;}\n"
+"var weekday=['Sun','Mon','Tue','Wed','Thu','Fri','Sat'];\n"
+"function wdaysStat(ap,al,tx,tradeType){var t='';var s=0.0,sp=0.0,sl=0.0,l=7;var ht=[];var hsum=[];for(var r=0;r<l;r++){ht.push([r, ap[r], -al[r]]);hsum.push([r, ap[r]+al[r]]);s+=ap[r]+al[r];sp+=ap[r];sl+=al[r];} ht.push([r, ap[l-1], -al[l-1]]);hsum.push([r, ap[l-1]+al[l-1]]);t+='<span class=svgc><b>'+tx+'</b><br><span class=svgc onclick=showTbh()>'+time_line_svg(ht,300,100,false,false,['Profit','Loss'],['#000080','#800000'],false,false,l/2,0)+'<br>'+time_line_svg(hsum,300,100,false,false,['Profit + Loss'],['#008000'],false,false,l/2,0)+'</span>';t+='<div id=tbw'+tradeType+' style=display:'+(tbh==0?'none':'block')+';><table class=tmstat><tr><td>Day</td>';for(var r=0;r<l;r++){t+='<td>'+weekday[r]+'</td>';} t+='<td>Sum</td></tr><tr><td>Profit</td>';for(var r=0;r<l;r++){t+='<td>'+Math.round(ap[r])+'</td>';} t+='<td>'+Math.round(sp)+'</td></tr><tr><td>Loss</td>'; for(var r=0;r<l;r++){t+='<td>'+Math.round(al[r])+'</td>';}t+='<td>'+Math.round(sl)+'</td></tr><tr><td>Sum</td>'; for(var r=0;r<l;r++){t+='<td>'+Math.round(ap[r]+al[r])+'<div id=trw'+tradeType+'_'+r+'_v>'+Math.round((al[r]!=0?-(ap[r]+al[r])/al[r]*100 : 0))+'%</div></td>';} t+='<td>'+Math.round(s)+'<div onclick=\"checksDW(1,'+l+','+tradeType+');\">'+Math.round((sl!=0?-(sp+sl)/sl*100 : 0))+'%</div></td></tr><tr><td>Trade</td>'; for(var r=0;r<l;r++){t+='<td><input id=trw'+tradeType+'_'+r+' type=checkbox onclick=\"startReport();startPagination();\" '+(eId('trw'+tradeType+'_'+r)==null || eId('trw'+tradeType+'_'+r).checked?'checked':'')+'></td>';} t+='<td></td></tr></table></div>';return t+'</span>';}\n"
+"function checksDW(wd,l,tradeType){v=Number(window.prompt('Enter number in %', 0)); for(var r=0;r<l;r++){eId('tr'+(wd==0?'':'w')+tradeType+'_'+r).checked=Number((eId('tr'+(wd==0?'':'w')+tradeType+'_'+r+'_v').innerHTML.replace('%',''))<v?false:true);}startReport();startPagination();}\n"
+"function actHours(l,tradeType){var tm='';var c=true; var cPrev=false; var t_start='';var t_end='';var mh=l/24;for(var r=0;r<l;r++){c = eId('tr'+tradeType+'_'+r)!=undefined && eId('tr'+tradeType+'_'+r).checked;if(c){t_end=Math.floor((r+1)/mh)+':'+((r+1)-Math.floor((r+1)/mh)*mh)+'0';if(!cPrev){t_start=Math.floor(r/mh)+':'+(r-Math.floor(r/mh)*mh)+'0';}}else{if(t_start!=''){tm+=','+t_start+'-'+t_end; t_start='';t_end='';}}cPrev=c;}if(t_start!=''){tm+=','+t_start+'-'+t_end;}return (tm!=''?tm.substring(1)+'<br>':'');}\n"
+"function isTradeAllowed(OpenTime,Type,HOpen,DOpen){if(eId('tr'+Type+'_'+HOpen)==null){return true;}if(eId('tr'+Type+'_'+HOpen).checked && eId('tr2_'+HOpen).checked && eId('trw'+Type+'_'+DOpen).checked && eId('trw2_'+DOpen).checked){return true;}return false;}\n"
+"function clearHoursDays(){eId('hours').innerHTML='';eId('wdays').innerHTML='';}\n"
+"function showTbh(){var ds=(tbh==0?'block':'none');tbh=(tbh==0?1:0);eId('tbh0').style.display=ds;eId('tbh1').style.display=ds;eId('tbh2').style.display=ds;eId('tbw0').style.display=ds;eId('tbw1').style.display=ds;eId('tbw2').style.display=ds;} tbh=0\n"

+"function rowParams(r){\n"
+"	var a=csv[r]; \n"
+"	Ticket=a[0];OpenTime=a[1];CloseTime=a[1]+a[2];Type=a[3];Lots=a[4];SId=a[5];OpenPrice=a[6];StopLoss=Undef0(a[7]);TakeProfit=Undef0(a[8]);ClosePrice=a[9];Commission=Undef0(a[10]);Swap=Undef0(a[11]);Profit=Undef0(a[12]);OpenRequest=a[13];CloseRequest=a[14];MagicNumber=a[15];CloseReason=a[16];\n"
+"	Comment=(a[17]==undefined?'':( a[17]===0?'end of test':a[17])); if(SId>-1){ Symbol_=Syms[SId][0]; Digits=Syms[SId][1];}else{ Symbol_=''; Digits=5;}\n"
+"	if(OpenTime==0){OpenTime=TestSartTimeMs;} if(CloseTime==0){CloseTime=TestSartTimeMs;}\n"
+"	if(DigitsPrev!=Digits){povDigits = Math.pow(10,Digits);DigitsPrev=Digits;}\n"
+"	pips= Math.round((OpenPrice-ClosePrice)   *povDigits  * (Type==0?-1:(Type==1? 1:0)));\n"
+"	slip1=Math.round((OpenPrice -OpenRequest )*povDigits) * (Type==0?-1:(Type==1? 1:0));\n"
+"	slip2=Math.round((ClosePrice-CloseRequest)*povDigits) * (Type==0? 1:(Type==1?-1:0));\n"
+"	slips = slip1+slip2;\n"
+"	pips_no_Slip=pips-slips; \n"
+"	if(pips!=0 && Lots!=0){TickValue= povDigits * Profit/(pips*Lots);}//else - use previous TickValue \n"
+"	TickLots=Lots * TickValue;\n"
+"	LengthTime=CloseTime-OpenTime;\n"
+"	TurnOver =TickLots * (OpenPrice + ClosePrice)*(Type<2?1.0:0);\n"
+"	PipsCommission=(TickLots==0.0?0:Commission * povDigits / TickLots);\n"
+"	PipsSwap = (TickLots==0.0?0:Swap * povDigits / TickLots);\n"
+"	prof_no_Slip=TickLots * (CloseRequest - OpenRequest) * (Type == 0 ? 1.0 : -1.0);\n"
+"	if(a[18]!=undefined){ordPendSec=a[18];ordPendTyp=a[19];ordState=a[20];ordPos=a[21];ordVolEqual=a[22];ordFromPend = ordState==4 && ordPendTyp>1;}else{ordState=ordPos=ordVolEqual=ordPendSec=ordPendTyp=0;ordFromPend=false;}\n"
+"}\n"

+"function Undef0(v){return (v==undefined ? 0.0 : v);}\n"
+"function getRow(r,rfiltered){rowParams(r);var pipsSlipTx=''; var prof_no_SlipTx=''; if(slip1!=0.0 || slip2!=0.0){pipsSlipTx=tf(pips_no_Slip); prof_no_SlipTx=tf(moneyFormat(prof_no_Slip, DigitsCurrency));}\n"
+"	if(version==1){return '<tr'+(Type>1 ? (Type==6 ?' class=b':' class=db'):'')+'><td>'+(rfiltered+1)+'</td><td>'+Ticket+'</td><td>'+MagicNumber+'</td><td>'+msec_to_tx(OpenTime)+'</td><td>'+msec_to_tx(CloseTime)+'</td><td>'+msec_to_len_tx(LengthTime)+'</td><td>'+moneyFormat(TurnOver,DigitsCurrency)+'</td><td>'+(Type==6 && !MT5Order?'':Symbol_)+'</td><td>'+(ordFromPend?'<t class=db>'+TypeToString(ordPendTyp)+' '+ordPendSec+'s -> </t>':'')+TypeToString(Type)+'</td><td>'+moneyFormat(Lots,DigitsCurrency)+'</td><td>'+moneyFormat(OpenPrice,Digits)+'</td><td'+(CloseReason==4?' class=sl':'')+'>'+moneyFormat(StopLoss,Digits)+'</td><td'+(CloseReason==5?' class=tp':'')+'>'+moneyFormat(TakeProfit,Digits)+'</td><td>'+moneyFormat(ClosePrice,Digits)+'</td><td>'+moneyFormat(Commission,DigitsCurrency)+tf(moneyFormat(PipsCommission,DigitsCurrency))+'</td><td>'+moneyFormat(Swap,DigitsCurrency)+tf(moneyFormat(PipsSwap,DigitsCurrency))+'</td><td>'+moneyFormat(Profit,DigitsCurrency)+prof_no_SlipTx+'</td><td>'+(CloseReason==2?' expired':'')+Comment+'</td><td>'+(pips==0?'':pips)+pipsSlipTx+'</td><td>'+(slip1==0 && slip2==0?'':'<span title=Open_Slippage>'+(slip1>0?'+':'')+slip1+'</span>, <span title=Close_Slippage>'+(slip2>0?'+':'')+slip2+'</span>')+'</td><td>'+(moneyFormat(bal[r]))+'</td>'}\n"
+"	else{return '<tr'+(Type>1 ? (Type==6 ?' class=b':' class=db'):'')+'><td>'+(rfiltered+1)+'</td><td>'+Ticket+'</td><td>'+msec_to_tx(OpenTime)+'</td><td>'+(ordFromPend?'<t class=db>'+TypeToString(ordPendTyp)+' '+ordPendSec+'s-> </t>':'')+TypeToString(Type)+'</td><td>'+moneyFormat(Lots,DigitsCurrency)+'</td><td>'+moneyFormat(TurnOver,DigitsCurrency)+'</td><td>'+Symbol_+'</td><td>'+moneyFormat(OpenPrice,Digits)+'</td><td'+(CloseReason==4?' class=sl':'')+'>'+moneyFormat(StopLoss,Digits)+'</td><td'+(CloseReason==5?' class=tp':'')+'>'+moneyFormat(TakeProfit,Digits)+'</td><td>'+msec_to_tx(CloseTime)+'</td><td>'+moneyFormat(ClosePrice,Digits)+'</td><td>'+moneyFormat(Commission,DigitsCurrency)+tf(moneyFormat(PipsCommission,DigitsCurrency))+'</td><td>'+moneyFormat(Swap,DigitsCurrency)+tf(moneyFormat(PipsSwap,DigitsCurrency))+'</td><td>'+moneyFormat(Profit,DigitsCurrency)+prof_no_SlipTx+'</td><td>'+(CloseReason==2?' expired':'')+Comment+'</td><td>'+(pips==0?'':pips)+pipsSlipTx+'</td><td>'+(slip1==0 && slip2==0?'':'<span title=Open_Slippage>'+(slip1>0?'+':'')+slip1+'</span>, <span title=Close_Slippage>'+(slip2>0?'+':'')+slip2+'</span>')+'</td><td>'+MagicNumber+'</td><td>'+msec_to_len_tx(LengthTime)+'</td><td>'+(moneyFormat(bal[r]))+'</td>'}\n"
+"}\n"
+"timeBegin=0;BeginDD=0;EndDD=0;\n"
+"function calcMaxLengthDD(timeEnd){//run on new max value or on end test\n"
+"	if (timeBegin==0){return;}\n"
+"	if (timeEnd - timeBegin > EndDD - BeginDD){BeginDD = timeBegin; EndDD = timeEnd;}\n"
+"	timeBegin = timeEnd;//new time of max value\n"
+"}\n"
+"function TypeToString( Type ){ Types4 = ['buy', 'sell', 'buy limit', 'sell limit', 'buy stop', 'sell stop', 'balance'];  Types5 = ['buy', 'sell', 'buy limit', 'sell limit', 'buy stop', 'sell stop', 'buy stop limit', 'sell stop limit', 'close by'];  return(MT5Order ? Types5[Type] : ((Type < 7) ? Types4[Type] : 'type_'+type));}\n"
+"function tf(v){if(v==0.0 || v==''){return '';} return ' ('+v+')';}\n"
+"function moneyFormat(nm, d, s){if(nm=='0.0'){return '';} if(d==undefined){d=2;}if(s==undefined){s=3;} return nm.toFixed(d).replace(new RegExp('\\\\d(?=(\\\\d{'+s+'})+'+(d>0?'\\\\.':'$')+')','g'),'$& ');}\n"
+"function add_zeros(s,d){if(d==undefined){d=2;} return ('000' + s).slice(-d); }//'3',2 = 03   '3',3 = '003'  //add zeros before number\n"
+"function msec_to_tx(dt){var nd = new Date(dt);	 nd = new Date(nd.getTime() + (GMT * 60 * 1000)); return nd.getFullYear()+'.'+add_zeros((nd.getMonth()+1))+'.'+add_zeros(nd.getDate())+' '+add_zeros(nd.getHours())+':'+add_zeros(nd.getMinutes())+':'+add_zeros(nd.getSeconds())+'.'+add_zeros(nd.getMilliseconds(),3);}\n"
+"function msec_to_len_tx(dt){var nd = new Date(dt);nd = new Date(nd.getTime() + (GMT * 60 * 1000)); Days = dt / (24 * 3600 * 1000);	return (Days>=1 ? parseInt(Days) + 'd ': '') +' '+add_zeros(nd.getHours())+':'+add_zeros(nd.getMinutes())+':'+add_zeros(nd.getSeconds())+'.'+add_zeros(nd.getMilliseconds(),3);}\n"
+"function msec_to_D(dt){var nd = new Date(dt);	 nd = new Date(nd.getTime() + (GMT * 60 * 1000)); return nd.getDay();}\n"
+"function msec_to_H(dt){var nd = new Date(dt);	 nd = new Date(nd.getTime() + (GMT * 60 * 1000)); return nd.getHours();}\n"
+"function msec_to_M10(dt){var nd = new Date(dt);	 nd = new Date(nd.getTime() + (GMT * 60 * 1000)); return Math.floor((nd.getHours()*60+nd.getMinutes())/10);}\n"
+"function td_to_msec(dt){return Date.parse(dt.replace(/\\./g,'-')+'T00:00:00Z')}\n"

+"</script><!-- enf csv to table -->\n"

+"<!-- svg images --><script>\n"
+"//joins several lines into one array [[[1,3,2],[4,7,9],[5,2,5]...],[[1,3,2],[4,7,9],[5,2,5]...],...] => [[1,3,2,4,5...],[4,7,9,4,5,...],[5,2,5,4,5,...]...] //var aa=[[[1,1,2],[4,4,9],[10,10,5]],   [[2,2,22],[3,3,9],[9,9,5]]]; vv=join_time_line(aa,0,aa.length); console.log(vv)\n"
+"function join_time_line(a,from_,to_, is_sum){	var o=[], next=[]; var t={};var i=0,lines=0;for(var n=from_;n<to_;n++){next[n]=0;lines+=a[n][0].length-1;}	if(a.length<1 || a.length<to_){return o;}for(var n=from_;n<to_;n++){for(var r=0;r<a[n].length;r++){t[''+a[n][r][0]]=a[n][r][0];}}for(var k in t){o[i]=Number(k); i++;}o.sort(function(a,b) {return a-b;});if(is_sum===true){lines++;}	var tmp=new Array(lines+1);for(i=0;i<lines+1;i++){tmp[i]=0;}for(var r=0;r<o.length;r++){i=1;tmp[0]=o[r];for(var n=from_;n<to_;n++){var r2=next[n];if(r2>=a[n].length){continue;}if(a[n][r2][0]==tmp[0]){for(var c=1;c<a[n][r2].length;c++){tmp[i]=a[n][r2][c];i++;}next[n]++;}else{i+=a[n][r2].length-1;	}}if(is_sum===true){tmp[lines]=0; for(i=1;i<lines;i++){tmp[lines]+=tmp[i];}}o[r]=new Array(lines+1);for(i=0;i<lines+1;i++){o[r][i]=tmp[i];}}return o;}\n"
+"//a - array of arrays [[1,3,2],[4,7,9],[5,2,5]...] 1st item is coordinate x, others - coordinates by у (like to google.charts), colors - colors of lines//sample d=[[1438560000,10000,9989],[1438646400,9897,9897],[1438732800,10853,9853]];  OR d=[[1,3,2],[2,4,3],[4,7,9],[5,2,5]]; var svg=time_line_svg(d,700,700,true,false,[],['#0000ff','#00ff00']); document.getElementById('i1').innerHTML=svg;\n"
+"function time_line_svg(a,w,h,one_scale,is_time,bio,custom_colors,strt_line,strt_end_line,vert_line,Xdigits){colors=['#0000FF','#00FF00','#FF0000','#000080','#008000','#800000','#bFFF00','#808000','#00bFFF','#008080','#bF00FF','#800080','#0000bF','#00bF00','#bF0000','#000040','#004000','#400000','#bFbF00','#404000','#00bFbF','#004040','#bF00bF','#400040'];if(Xdigits==undefined){Xdigits=5;}if(strt_line==undefined){strt_line=false;}if(strt_end_line==undefined){strt_end_line=false;}if(custom_colors!=undefined){for(var c=0;c<custom_colors.length;c++){colors[c]=custom_colors[c];}}if(a[0]==undefined || a.length<2){return '<svg width='+w+' height='+h+'><text x=0 y=10>No data</text></svg>';}var len=a[0].length, r_prev=0,max_v,min_v, ma=[], mi=[], max=[], min=[], k=[],bio_tx='';for(var r=0;r<a.length;r++){for(var c=0;c<len;c++){a[r][c]=parseFloat(a[r][c]);}}for(var c=0;c<len;c++){max[c]=a[0][c]; min[c]=a[0][c];} for(var r=0;r<a.length;r++){for(var c=0;c<len;c++){if(max[c]<a[r][c]){max[c]=a[r][c];}if(min[c]>a[r][c]){min[c]=a[r][c];}}}one_scale=true;	if(one_scale){max_v=max[1]; min_v=min[1];for(var c=1;c<len;c++){if(max_v<max[c]){max_v=max[c];}if(min_v>min[c]){min_v=min[c];}}for(var c=1;c<len;c++){max[c]=max_v;min[c]=min_v;}}k[0]=(max[0]-min[0])/w; for(var c=1;c<len;c++){k[c]=(max[c]-min[c])/(h-1);} var start=a[0][0];var end=a[a.length-1][0];	if(is_time){start=new Date(start); end=new Date(end);}	var s='<svg width='+w+' height='+h+' >'; s+='<text x=0 y=10>'+max_v.toFixed(2)+'</text><text x=0 y='+h+'>'+min_v.toFixed(2)+'</text><text x=0 y='+(h-15)+'>'+(is_time?printDT(start):start.toFixed(Xdigits))+'</text><text x='+(w-64+(is_time?0:(6-Xdigits)*7+5))+' y='+(h-15)+'>'+(is_time?printDT(end):end.toFixed(Xdigits))+'</text>';if(strt_line){for(var c=1;c<len;c++){s+='<line x1=0 x2='+w+' y1='+parseInt((max[c]-a[0][c])/k[c])+' y2='+parseInt((max[c]-a[0][c])/k[c])+' stroke='+colors[c-1]+' stroke-dasharray=5,5 />';}}		if(vert_line!=undefined){var xf=parseInt((vert_line-min[0])/k[0]);s+='<text x='+xf+' y='+h+'>'+(is_time?printDT(vert_line):vert_line.toFixed(Xdigits))+'</text><line x1='+xf+' x2='+xf+' y1=0 y2='+h+' stroke=#FF0000 stroke-dasharray=5,5 />';}	if(strt_end_line==true){for(var c=1;c<len;c++){s+='<line x1=0 x2='+w+' y1='+parseInt((max[c]-a[0][c])/k[c])+' y2='+parseInt((max[c]-a[a.length-1][c])/k[c])+' stroke=#FF0000 stroke-dasharray=5,5 />';}}s+='<line x1=0 x2='+w+' y1='+parseInt((max[1]-0)/k[1])+' y2='+parseInt((max[1]-0)/k[1])+' stroke=#FF0000 stroke-dasharray=5,5 />';s+='<line x1='+parseInt((0-min[0])/k[0])+' x2='+parseInt((0-min[0])/k[0])+' y1=0 y2='+h+' stroke=#FF0000 stroke-dasharray=5,5 />';for(var x=0;x<w;x++){for(var c=1;c<len;c++){ma[c]=a[r_prev][c];mi[c]=a[r_prev][c];}for(var r=r_prev+1;r<a.length;r++){if( (a[r][0] - min[0]) / k[0] > x+1 ){break;}for(var c=1;c<len;c++){if(ma[c] < a[r][c]){ma[c]=a[r][c];} if(mi[c] > a[r][c]){mi[c]=a[r][c];}}r_prev=r;}for(var c=1;c<len;c++){	s+='<line x1='+x+' x2='+x+' y1='+parseInt((max[c]-ma[c])/k[c])+' y2='+parseInt((max[c]-mi[c])/k[c] + 1)+' stroke='+colors[c-1]+' />';}		}s+='</svg>';if(bio!=undefined && bio.length>0){s+='<br/>';for(var c=0; c<bio.length; c++){s+=' <b style=color:'+colors[c]+'>'+bio[c]+'</b>'+(c<bio.length-1?',':'');}}return s;}\n"

+"function printDT(t){if(t.getMonth ==undefined){t = new Date(t);}var m=t.getMonth()+1; var d=t.getDate(); if(m<10){m='0'+m;}if(d<10){d='0'+d;} return t.getFullYear()+'-'+m+'-'+d;}\n"
+"TestForwardTimeMs=0;\n"
+"function startForward (){var fwd= eId('forwardStart').value;if(fwd==0){alert('Select date!');return;} TestForwardTimeMs = Date.parse(fwd.replace(/\\./g,'-')+'T00:00:00Z');if(TestForwardTimeMs<TestSartTimeMs){alert('Set forvard >= start date '+printDT(TestSartTimeMs + (GMT * 60 * 1000)));return;}if(TestForwardTimeMs>TestEndTimeMs){alert('Set forvard <= end date '+printDT(TestEndTimeMs + (GMT * 60 * 1000)));return;}startReport(1);startReport(2);startReport();startPagination();}\n"
+"function hide_chart (){eId('Ext_charts').style.height='0'; eId('Ext_charts').innerHTML=''; eId('Ordinal_cont').style.display='none'; eId('Log_cont').style.display='none';eId('hide_chart_btn').style.display='none';}\n"

+"</script><!-- end svg images -->\n"

#ifndef USE_highcharts
+"<script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>\n"
+"<script>\n"
+"function f_show(arr,elm){\n"
+" if(arr.length==0){return;}\n"
+" var lineTmp=[]; var n_lines=arr[0].length;\n"
+" for(var i=0; i<arr.length; i++){\n"
+" lineTmp[i]=[];\n"
+" lineTmp[i][0]=new Date(arr[i][0] + (GMT * 60 * 1000));\n"
+" for(var j=1; j<n_lines; j++){lineTmp[i][j]=arr[i][j];}\n"
+" }\n"
+" var biosa=[];var bTags=elm.getElementsByTagName('b'); \n"
+" for(var i=0; i<bTags.length; i++)  {biosa[i]=bTags[i].innerHTML.replace(/&amp;/g,'&');}\n"
+" eId('Ext_charts').style.height='600px'; eId('Log_cont').style.display='inline';eId('hide_chart_btn').style.display='inline';\n"
+" drawLogScales('',lineTmp,biosa,true,'Ext_charts');\n"
+" lineTmp=[]; \n"
+"}\n"
+"google.charts.load('current', {packages: ['corechart', 'line', 'scatter']});\n"
+"function drawLogScales(titl,arr_w,_bio,isTime,eid) {\n"
+" var data = new google.visualization.DataTable();\n"
+" if(isTime){data.addColumn('datetime', 'Time');}else{data.addColumn('number', 'X');}\n"
+" for (var i=1; i<arr_w[0].length; i++){data.addColumn('number', _bio[i-1]);}\n"
+" data.addRows(arr_w);\n"
+" var options = {\n"
+" title: titl,\n"
+" vAxis: {title: 'Amount', logScale: eId('Logarithmic').checked},\n"
+" aggregationTarget:'category', focusTarget: 'category',\n"
+" theme: 'maximized' ,\n"
+" explorer: { axis: 'horizontal', maxZoomIn: .0001  }\n"
+" };\n"
+" var chart = new google.visualization.LineChart(document.getElementById(eid));\n"
+" chart.draw(data, options);\n"
+"}\n"
+"</script>\n"

#else //USE_highcharts

+"<script src='https://code.highcharts.com/stock/highstock.js'></script>\n"
+"<script src='https://code.highcharts.com/stock/modules/exporting.js'></script>\n"
+"<script src='https://code.highcharts.com/stock/modules/export-data.js'></script>\n"
+"<script>\n"
+"function f_show(arr,elm,decimals){\n"
+"	if(arr.length==0){return;}\n"
+"	eId('Ext_charts').style.height='600px'; eId('Ordinal_cont').style.display='inline'; eId('Log_cont').style.display='inline';eId('hide_chart_btn').style.display='inline';\n"
+"	var bTags=elm.getElementsByTagName('b'); var sumTitle='';\n"
+"	var lineTmp=[]; var dtt=[];\n"
+"	for(var j=1; j<arr[0].length; j++){\n"
+"		dtt[j]=[];\n"
+"		for(var i=0; i<arr.length; i++){ dtt[j][i]=[arr[i][0], arr[i][j]]; }\n"
+"		var Name=bTags[j-1].innerHTML.replace(/&amp;/g,'&');\n"
+"		lineTmp[j-1]={name: Name, data:dtt[j]};\n"
+"		sumTitle += (j==1?'':', ')+Name;\n"
+"	}\n"
+"	Highcharts.stockChart('Ext_charts', {\n"
+"    title: {text: sumTitle,align: 'left'}, subtitle: {text: 'Total <b>' + lenFiltered + '</b> orders. Account balance: <b>' + moneyFormat(bal[bal.length-1],DigitsCurrency) + '</b> ' + ACCOUNT_CURRENCY, align: 'left'},\n"
+"    chart: { zoomType: 'x'},\n"
+"    rangeSelector: { enabled: true },\n"
+"    tooltip: {valueDecimals: decimals },\n"
+"    xAxis: { type: 'datetime', ordinal: eId('Ordinal').checked, gridLineWidth:1}, yAxis: [{ type: (eId('Logarithmic').checked?'logarithmic':'linear')}],\n"
+"    series: lineTmp\n"
+"});\n"
+"	lineTmp=[];	\n"
+"}\n"
+"function ResetFilters(){\n"
+"	eId('fMag').value=-1;eId('fMaxL').value=100;eId('fMinL').value=eId('fPosDays').value=eId('fPosHours').value=eId('fPosMinut').value=eId('fPosSec').value=eId('fPosDaysMax').value=eId('fPosHoursMax').value=eId('fPosMinutMax').value=eId('fPosSecMax').value=eId('fDtStart').value=eId('fDtEnd').value=eId('fDtStartCl').value=eId('fDtEndCl').value=0;\n"
+"	eId('dBuy').checked=eId('dBuyL').checked=eId('dBuyS').checked=eId('dSell').checked=eId('dSellL').checked=eId('dSellS').checked=eId('dBal').checked=true; eId('fNegO').checked=eId('fNegC').checked=eId('fSwap').checked=eId('fTP').checked=eId('fSL').checked=eId('fProfits').checked=eId('fLosses').checked=eId('fRejects').checked=false;\n"
+"	f_SelectAll();\n"
+"	startReport();startPagination();\n"
+"}\n"
+"function f_SelectAll(){for(var i=0;i<Syms.length;i++){eId('sy_'+i).checked=true;}}\n"
+"function f_UnselectAll(){for(var i=0;i<Syms.length;i++){eId('sy_'+i).checked=false;}}\n"
+"</script>\n"

#endif //USE_highcharts

+"</head><body topmargin=1 marginheight=1><div align=center>\n"
+"<b style='line-height: 30px;'>Orders Report</b><br/><div id='Ext_charts' style='margin-bottom: 10px;'></div><span id='Ordinal_cont' style='display:none;'>Ordinal<input type=checkbox id='Ordinal'></span> &nbsp;&nbsp;&nbsp;&nbsp;<span id='Log_cont' style='display:none;'>Logarithmic<input type=checkbox id='Logarithmic'></span> &nbsp;&nbsp;&nbsp;&nbsp;<input type='button' value='Hide chart' onclick='hide_chart()' id='hide_chart_btn' style='display:none;'><br/><span id='img_pl' class='svgc'></span><span id='img_bal' class='svgc'></span><span id='img_pip' class='svgc'></span><span id='img_balBuySell' class='svgc'></span><span id='img_priceLine' class='svgc'></span><span id='img_priceLine2' class='svgc'></span><span id='img_slip' class='svgc'></span><span id='img_slipCum' class='svgc'></span>\n"
+"<br><br>Profit/Loss by Hours <input id='h1_m10' name='h1_m10' type='radio' onchange='clearHoursDays();startReport();' checked> or M10 <input id='m10' name='h1_m10'  type='radio' onchange='clearHoursDays();startReport();'><div id='hours'></div><br><br>Profit/Loss by Week Days<div id='wdays'></div>\n"
+"<br><br><b>Filters:</b> <input type=button value=Reset onclick=ResetFilters()>\n"
+"<table class='tmstat'><tr><td>Buy</td><td>Sell</td><td>Buy limit</td><td>Sell limit</td><td>Buy stop</td><td>Sell stop</td><td>Balance</td><td>Symbols: <input type=button value=SelectAll onclick=f_SelectAll()> <input type=button value=UnselectAll onclick=f_UnselectAll()> </td><td>Magic</td><td>Min Lot</td><td>Max Lot</td><td>Negative Slippage</td><td>Swap</td><td>Min LengthTime</td><td>Max LengthTime</td><td>Open Time</td><td>Close Time</td><td>TP</td><td>SL</td><td>Profits</td><td>Losses</td><td>Rejects</td></tr>\n"
+"<tr style='background:#fff;'><td><input id='dBuy' type='checkbox' checked onchange='startReport();startPagination();'></td><td><input id='dSell' type='checkbox' checked onchange='startReport();startPagination();'></td><td><input id='dBuyL' type='checkbox' checked onchange='startReport();startPagination();'></td><td><input id='dSellL' type='checkbox' checked onchange='startReport();startPagination();'></td><td><input id='dBuyS' type='checkbox' checked onchange='startReport();startPagination();'></td><td><input id='dSellS' type='checkbox' checked onchange='startReport();startPagination();'></td><td><input id='dBal' type='checkbox' checked onchange='startReport();startPagination();'></td><td id=syList></td><td><input id=fMag type=number min=-1 value=-1 onchange='startReport();startPagination();' style='width:70px;'></td><td><input id=fMinL type=number min=0 value=0 step=0.01 onchange='startReport();startPagination();' style='width:70px;'></td><td><input id=fMaxL type=number min=0 value=100 step=0.01 onchange='startReport();startPagination();' style='width:70px;'></td><td>Open<input id='fNegO' type='checkbox' onchange='startReport();startPagination();'> Close<input id='fNegC' type='checkbox' onchange='startReport();startPagination();'></td><td><input id='fSwap' type='checkbox' onchange='startReport();startPagination();'></td><td>D:<input id=fPosDays type=number min=0 value=0 onchange='startReport();startPagination();' style='width:40px;'><br>H:<input id=fPosHours type=number min=0 max=23 value=0 onchange='startReport();startPagination();' style='width:40px;'><br>M:<input id=fPosMinut type=number min=0 max=59 value=0 onchange='startReport();startPagination();' style='width:40px;'><br>S:<input id=fPosSec type=number min=0 max=59 value=0 onchange='startReport();startPagination();' style='width:40px;'></td><td>D:<input id=fPosDaysMax type=number min=0 value=0 onchange='startReport();startPagination();' style='width:40px;'><br>H:<input id=fPosHoursMax type=number min=0 max=23 value=0 onchange='startReport();startPagination();' style='width:40px;'><br>M:<input id=fPosMinutMax type=number min=0 max=59 value=0 onchange='startReport();startPagination();' style='width:40px;'><br>S:<input id=fPosSecMax type=number min=0 max=59 value=0 onchange='startReport();startPagination();' style='width:40px;'></td><td>From:<br><input id='fDtStart' type='date' onchange='startReport();startPagination();'><br>To:<br><input id='fDtEnd' type='date' onchange='startReport();startPagination();'></td><td>From:<br><input id='fDtStartCl' type='date' onchange='startReport();startPagination();'><br>To:<br><input id='fDtEndCl' type='date' onchange='startReport();startPagination();'></td><td><input id='fTP' type='checkbox' onchange='startReport();startPagination();'></td><td><input id='fSL' type='checkbox' onchange='startReport();startPagination();'></td><td><input id='fProfits' type='checkbox' onchange='startReport();startPagination();'></td><td><input id='fLosses' type='checkbox' onchange='startReport();startPagination();'></td><td><input id='fRejects' type='checkbox' onchange='startReport();startPagination();'></td></tr>\n"
+"</table><br><br>\n"
+"<div id='test_params'></div>\n"
+"<div id='pagination1' class='pagination'></div><table class='at' id='orders'></table><div id='pagination2' class='pagination'></div><br/>\n"
+"<div id='Balance_Report' class='inlBl'></div><div id='Balance_ReportBack' class='inlBl'></div><div id='Balance_ReportForw' class='inlBl'></div><br/>\n"
+"<div id='time_stats'></div><br/>\n"
+"<b>Options</b><br/>\n"
+"Set Forward Test Date: <input id='forwardStart' type='date'> <input type='button' onclick='startForward()' value='Apply'><br/>\n"
+"<label><input id='repver' type='checkbox' onchange='startReport();startPagination();'> Old column order</label><br/>\n"
+"</div>\n";
}
