//+------------------------------------------------------------------+
//|                                 BasedOnIndicatorExpertSignal.mqh |
//|                                                    2011, etrader |
//|                                             http://efftrading.ru |
//+------------------------------------------------------------------+
#property copyright "2011, etrader"
#property link      "http://efftrading.ru"
#include <Expert\ExpertSignal.mqh>
//+------------------------------------------------------------------+
//| CBasedOnIndicatorExpertSignal class                              |
//| Purpose: A class for a module of trade signals, based            |
//|          on custom indicator                                     |
//+------------------------------------------------------------------+
class CBasedOnIndicatorExpertSignal: public CExpertSignal
{
  protected:
    CiCustom m_indicator;    // custom indicator
    MqlParam m_parameters[]; // parameters of custom indicator
  public:
    void CBasedOnIndicatorExpertSignal(){
//---  timeseries used
      m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE+USE_SERIES_TIME;
    }
    virtual bool      InitIndicators(CIndicators* indicators);        // initialization of indicators
    virtual bool      InitCustomIndicator(CIndicators* indicators);   // initialization of custom indicator
    virtual void      FillParameters(){};                             // filling of m_parameters[] array
};

//+------------------------------------------------------------------+
//| Initialization of indicators                                     |
//| INPUT:  indicators - pointer to indicators collection            |
//| OUTPUT: true if successful, otherwise false                      |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
bool CBasedOnIndicatorExpertSignal::InitIndicators(CIndicators* indicators)
{
//--- checking of pointer
   if(indicators==NULL)                           return(false);
//--- initialization of indicators, timeseries and additional filters
   if(!CExpertSignal::InitIndicators(indicators)) return(false);
//--- creation and initialization of custom indicator
   if(!InitCustomIndicator(indicators))           return(false);
//--- ok
   return(true);
}


//+------------------------------------------------------------------+
//| Initialization of custom indicator                               |
//| INPUT: indicators - pointer to indicators collection             |
//| OUTPUT: true if successful, otherwise false                      |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
bool CBasedOnIndicatorExpertSignal::InitCustomIndicator(CIndicators* indicators)
{
//--- checking of pointer
   if(indicators==NULL) return(false);
//--- adding the object to collection
   if(!indicators.Add(GetPointer(m_indicator))){
      printf(__FUNCTION__+": error in adding of object to collection");
      return(false);
   }
//--- parameters setting of custom indicator
   FillParameters();
//--- initialization of custom indicator
   if(!m_indicator.Create(m_symbol.Name(),m_period,IND_CUSTOM, ArraySize(m_parameters), m_parameters  )){
      printf(__FUNCTION__+": error in object initialization");
      return(false);
   }
//--- ok
   return(true);
}

//+------------------------------------------------------------------+