//+------------------------------------------------------------------+
//|                                         ExpertHistoryExample.mq4 |
//|                                      Copyright 2021, Yuriy Bykov |
//|                               https://www.mql5.com/ru/code/37444 |
//|                               https://www.mql5.com/ru/code/38981 |
//|                               https://www.mql5.com/en/code/38938 |
//|                               https://www.mql5.com/en/code/38980 |
//+------------------------------------------------------------------+
#property description   "Save deals history and/or parameters of expert runs to common folder of terminal"
#property copyright     "Copyright 2021, Yuriy Bykov"
#property link          "https://www.mql5.com/ru/code/37444"
#property link          "https://www.mql5.com/ru/code/38981"
#property link          "https://www.mql5.com/en/code/38938"
#property link          "https://www.mql5.com/en/code/38980"
#property version       "1.77"
#property strict

// 0. Include library with CExpertHistory class
#include <ExpertHistory.mqh>

// 1. Create object instance in global scope
string expertName = "SomeExpert";
string expertVersion = "1.00";     // Not required

CExpertHistory expertHistory(expertName, expertVersion);



//--- input parameters
input double   SL = 500.0;
input double   TP = 1000.0;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit() {
//---
   expertHistory.AddParam("Symbol", Symbol());
   expertHistory.AddParam("TP", TP);
   expertHistory.AddParam("SL", SL);
//---
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason) {
//---

}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick() {
//---

}
//+------------------------------------------------------------------+
//| Tester function                                                  |
//+------------------------------------------------------------------+
double OnTester() {
//---
   double ret = 0.0;
//---
   // 3. Add in OnTester() function call of Export() method:
   
   // If you want save history only in single tester run
   // do it only if it was not optimization run 
   if(!MQLInfoInteger(MQL_OPTIMIZATION)) { 
      expertHistory.Export();
   }
//---
   return(ret);
}
//+------------------------------------------------------------------+
