//+------------------------------------------------------------------+
//|                                                    DynamicRS.mq5 |
//|                                 Copyright  2007, Nick A. Zhilin |
//|                                                  rebus58@mail.ru |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, Nick A. Zhilin"
//---    
#property link      "rebus58@mail.ru"
//---   
#property version   "1.00"
#property description ",   " 
//---     
#property indicator_chart_window 
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+----------------------------------------------+ 
//|     1            |
//+----------------------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---   
#property indicator_label1  "DynamicRS"
//---     
#property indicator_color1 clrDodgerBlue
//---   - 
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//+----------------------------------------------+ 
//|                            |
//+----------------------------------------------+ 
#define RESET 0 //        
//+----------------------------------------------+ 
//|                    |
//+----------------------------------------------+ 
input uint Filter=15; // 
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---
double dFilter;
//---      
int min_rates_total;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=2;
   dFilter=Filter*_Point;
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---          
   ArraySetAsSeries(IndBuffer,true);
//---  ,    
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string shortname;
   StringConcatenate(shortname,"DynamicRS(",Filter,")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---   
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total)return(RESET);
//---    
   int limit,bar;
//---    limit        
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//---        
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(high[bar]<high[bar+1] && high[bar]<IndBuffer[bar+1]-dFilter) IndBuffer[bar]=high[bar];
      else if(low[bar]>low[bar+1] && low[bar]>IndBuffer[bar+1]+dFilter) IndBuffer[bar]=low[bar];
      else IndBuffer[bar]=IndBuffer[bar+1];
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
