//+---------------------------------------------------------------------+
//|                                                             PFE.mq5 | 
//|                     Copyright  2008, giampiero.raschetti@gmail.com | 
//|                                              http://www.fxtrade.it/ | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2008, giampiero.raschetti@gmail.com"
#property link "http://www.fxtrade.it/"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrTeal,clrBlueViolet,clrIndianRed,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1  "PFE"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint PfePeriod=5;
input Smooth_Method XMA_Method=MODE_JJMA;// 
input uint XLength=5;                    //                     
input int XPhase=100;                    // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;   // 
input int Shift=0;                       //     
input double UpLevel=+0.5;               // 
input double DnLevel=-0.5;               // 
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
//----      
int min_rates_total,min_rates_1;
//+------------------------------------------------------------------+   
//| PFE indicator initialization function                            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=int(PfePeriod)+1;
   min_rates_total=min_rates_1+GetStartBars(XMA_Method,XLength,XPhase);

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"PFE(",PfePeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);  
//----      2  
   IndicatorSetInteger(INDICATOR_LEVELS,2);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,UpLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,DnLevel);
//----             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrRed);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
//----  
  }
//+------------------------------------------------------------------+ 
//| PFE iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double noise,pfe;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_1; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      noise=_Point;
      for(int kkk=0; kkk<int(PfePeriod); kkk++) noise+=MathAbs(PriceSeries(IPC,bar-kkk,open,low,high,close)-PriceSeries(IPC,bar-kkk-1,open,low,high,close));      
      pfe=(PriceSeries(IPC,bar,open,low,high,close)-PriceSeries(IPC,bar-PfePeriod,open,low,high,close))/noise;
      IndBuffer[bar]=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,pfe,bar,false);
     }

   if(prev_calculated>rates_total || prev_calculated<=0) first=min_rates_total;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int bar1=bar-1;
      int clr=0;

      if(IndBuffer[bar]>=0)
        {
         if(IndBuffer[bar]>IndBuffer[bar1]) clr=0;
         if(IndBuffer[bar]<IndBuffer[bar1]) clr=1;
         if(IndBuffer[bar]==IndBuffer[bar1]) clr=int(ColorIndBuffer[bar1]);
        }

      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar1]) clr=2;
         if(IndBuffer[bar]>IndBuffer[bar1]) clr=3;
         if(IndBuffer[bar]==IndBuffer[bar1]) clr=int(ColorIndBuffer[bar1]);
        }
      ColorIndBuffer[bar]=clr;
     }
//----         
   return(rates_total);
  }
//+------------------------------------------------------------------+
