//+---------------------------------------------------------------------+
//|                                                ColorJFatl_Cloud.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//----     
#property indicator_chart_window
//----    6
#property indicator_buffers 6 
//----     
#property indicator_plots   3
//+------------------------------------------------+
//|                          |
//+------------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
#property indicator_type2   DRAW_FILLING
//----   
#property indicator_color1  clrPaleTurquoise
#property indicator_color2  clrThistle
//----  
#property indicator_label1  "Upper Cloud"
#property indicator_label2  "Lower Cloud"
//+------------------------------------------------+
//|                    |
//+------------------------------------------------+
//----      
#property indicator_type3   DRAW_COLOR_LINE
//----      
#property indicator_color3  clrMagenta,clrGray,clrGold
//----   -  
#property indicator_style3  STYLE_SOLID
//----     5
#property indicator_width3  5
//----   
#property indicator_label3  "JFATL"
//+------------------------------------------------+
//|                          |
//+------------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+------------------------------------------------+
//|                      |
//+------------------------------------------------+
input int JLength=5; //  JMA                    
input int JPhase=-100; //  JMA ,
//----    -100 ... +100,
//----     ;
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int FATLShift=0; //      
input int PriceFATLShift=0; // c     
input uint Dev=20; //   
//+------------------------------------------------+

//----         
int FATLPeriod=39;
//----   ,         
double LineBuffer[];
double ColorLineBuffer[];

double UpCloudBuffer1[],UpCloudBuffer2[];
double DnCloudBuffer1[],DnCloudBuffer2[];

//----      
int min_rates_total,fstart,FATLSize;
double dPriceFATLShift;
//+------------------------------------------------+
//|      |
//+------------------------------------------------+
double dFATLTable[]=
  {
   +0.4360409450, +0.3658689069, +0.2460452079, +0.1104506886,
   -0.0054034585, -0.0760367731, -0.0933058722, -0.0670110374,
   -0.0190795053, +0.0259609206, +0.0502044896, +0.0477818607,
   +0.0249252327, -0.0047706151, -0.0272432537, -0.0338917071,
   -0.0244141482, -0.0055774838, +0.0128149838, +0.0226522218,
   +0.0208778257, +0.0100299086, -0.0036771622, -0.0136744850,
   -0.0160483392, -0.0108597376, -0.0016060704, +0.0069480557,
   +0.0110573605, +0.0095711419, +0.0040444064, -0.0023824623,
   -0.0067093714, -0.0072003400, -0.0047717710, +0.0005541115,
   +0.0007860160, +0.0130129076, +0.0040364019
  };
//+------------------------------------------------------------------+
//   iPriceSeries()                                   |
//   iPriceSeriesAlert()                              |
//   CJJMA                                             |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----   
   FATLSize=ArraySize(dFATLTable);
   min_rates_total=FATLSize+30;
//----      
   string shortname;
   StringConcatenate(shortname,"_Cloud(",JLength," ,",JPhase,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----    
   dPriceFATLShift=_Point*PriceFATLShift;
//----    CJJMA   JJMASeries_Cls.mqh
   CJJMA JMA;
//----       
   JMA.JJMALengthCheck("JLength", JLength);
   JMA.JJMAPhaseCheck("JPhase", JPhase);  
//----         
   SetIndexBuffer(0,UpCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,UpCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,DnCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(3,DnCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(4,LineBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(5,ColorLineBuffer,INDICATOR_COLOR_INDEX);
   
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int first,bar,clr;
   double jfatl,FATL;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=FATLPeriod-1; //      
      fstart=first;
     }
   else first=prev_calculated-1; //      

//----    CJJMA   JJMASeries_Cls.mqh
   static CJJMA JMA;

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----    FATL
      FATL=0.0;
      for(int iii=0; iii<FATLSize; iii++) FATL+=dFATLTable[iii]*PriceSeries(IPC,bar-iii,open,low,high,close);
      jfatl=JMA.JJMASeries(fstart,prev_calculated,rates_total,0,JPhase,JLength,FATL,bar,false);
      LineBuffer[bar]=UpCloudBuffer2[bar]=DnCloudBuffer1[bar]=jfatl+dPriceFATLShift;     
      UpCloudBuffer1[bar]=LineBuffer[bar]*Dev;
      DnCloudBuffer2[bar]=LineBuffer[bar]/Dev;
     }

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;

//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      clr=1;
      if(LineBuffer[bar-1]<LineBuffer[bar]) clr=2;
      if(LineBuffer[bar-1]>LineBuffer[bar]) clr=0;
      ColorLineBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
