//+---------------------------------------------------------------------+
//|                                                 ColorX2MA_Digit.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrBlueViolet,clrGray,clrMagenta
//----   -  
#property indicator_style1  STYLE_SOLID
//----     4
#property indicator_width1  4
//----   
#property indicator_label1  "ColorX2MA_Digit"

//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input string  SirName="ColorX2MA_Digit";     //    

input Smooth_Method MA_Method1=MODE_SMA_; //    
input int Length1=12; //                       
input int Phase1=15; //  ,
                     // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_JJMA; //    
input int Length2= 5; //    
input int Phase2=15;  //  ,
                      // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
input int PriceShift=0; //      
input uint Digit=2;                       //  
input bool ShowPrice=true; //  
//----   
input color  Price_color=clrGray;
//+-----------------------------------+

//----   ,    
//      
double LineBuffer[];
double ColorLineBuffer[];

//----      
double dPriceShift;
double PointPow10;
//----      
int min_rates_total,min_rates_1,min_rates_2;
//----     
string Price_name;
//+------------------------------------------------------------------+   
//| X2MA indicator initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=XMA1.GetStartBars(MA_Method1, Length1, Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=min_rates_1+min_rates_2+2;
//----       
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
//----       
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);

//----    
   dPriceShift=_Point*PriceShift;
   PointPow10=_Point*MathPow(10,Digit);
//----  
   Price_name=SirName+"Price";

//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(1,ColorLineBuffer,INDICATOR_COLOR_INDEX);

//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"X2MA(",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,Price_name);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+ 
//| X2MA iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price,x1xma,x2xma,trend;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price
      price=PriceSeries(IPC,bar,open,low,high,close);

      //----    XMASeries. 
      //    begin   min_rates_1 . .   XMA   
      x1xma = XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      x2xma = XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method2, Phase2, Length2,x1xma,bar,false);
      LineBuffer[bar]=x2xma+dPriceShift;
      LineBuffer[bar]=PointPow10*MathRound(LineBuffer[bar]/PointPow10);
     }
   if(ShowPrice)
     {
      int bar0=rates_total-1;
      datetime time0=time[bar0]+1*PeriodSeconds();
      SetRightPrice(0,Price_name,0,time0,LineBuffer[bar0],Price_color);
     }

//----    first
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      

//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      double clr=1;
      trend=LineBuffer[bar]-LineBuffer[bar-1];
      if(!trend) clr=ColorLineBuffer[bar-1];
      else
        {
         if(trend>0) clr=0;
         if(trend<0) clr=2;
        }
      ColorLineBuffer[bar]=clr;
     }
//----
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color              // Text color
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,2);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color              // Text color
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
