//+------------------------------------------------------------------+
//|                                       AsymmetricStochNR_Sign.mq5 | 
//|                                    Copyright  2010,   Svinozavr | 
//+------------------------------------------------------------------+
//|     SmoothAlgorithms.mqh                  |
//|    : __\MQL5\Include  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010,   Svinozavr"
#property link ""
#property description "Asymmetric Stoch NR"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1 DRAW_ARROW
//----     
#property indicator_color1 clrDeepSkyBlue
//----   - 
#property indicator_style1 STYLE_SOLID
//----     5
#property indicator_width1 5
//----    
#property indicator_label1  "Buy AsymmetricStochNR signal"
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type2 DRAW_ARROW
//----     
#property indicator_color2 clrPlum
//----   - 
#property indicator_style2 STYLE_SOLID
//----     5
#property indicator_width2 5
//----    
#property indicator_label2  "Sell AsymmetricStochNR signal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -    SmoothAlgorithms.mqh
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint KperiodShort=5;                   //  %K
input uint KperiodLong=12;                   //  %K
input Smooth_Method DMethod=MODE_SMA_;       //     
input uint Dperiod=7;                        //    %D
input int DPhase=15;                         //    
input uint Slowing=3;                        // 
input ENUM_STO_PRICE PriceField=STO_LOWHIGH; //     
input uint Sens=7;                           //   
input uint OverBought=80;                    //    %%
input uint OverSold=20;                      //    %%
input int Shift=0;                           //      
//+----------------------------------------------+
//----   ,    
//----      
double SignUp[];
double SignDown[];
double sens; //   
//---      
int ATR_Handle;
//----      
int min_rates_total,min_rates_stoch;
//+------------------------------------------------------------------+   
//| Asymmetric Stoch NR indicator initialization function            | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_stoch=int(MathMax(KperiodShort,KperiodLong)+Slowing);
   min_rates_total=min_rates_stoch+XMA.GetStartBars(DMethod,Dperiod,DPhase)+1;
   int ATR_Period=15;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period))+1;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }

//----     
   sens=Sens*_Point; //   

//----       
   XMA.XMALengthCheck("Dperiod",Dperiod);
   XMA.XMALengthCheck("Dperiod",Dperiod);
   XMA.XMAPhaseCheck("DPhase",DPhase,DMethod);

//----      
   SetIndexBuffer(0,SignUp,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    ,      
   ArraySetAsSeries(SignUp,true);

//----      
   SetIndexBuffer(1,SignDown,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    ,      
   ArraySetAsSeries(SignDown,true);

//----      
   string shortname,Smooth;
   Smooth=XMA.GetString_MA_Method(DMethod);
   StringConcatenate(shortname,"Asymmetric Stochastic NR(",KperiodShort,",",KperiodLong,",",Dperiod,",",Smooth,",",Slowing,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Asymmetric Stoch NR iteration function                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----   
   int limit,to_copy,bar,maxbar;
//----     
   double ATR[],Stoch,XStoch;

//----    
   static uint Kperiod0,Kperiod1;
   static double Stoch_prev,XStoch_prev;

//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_stoch; //      
      Kperiod0=KperiodShort;
      Kperiod1=KperiodShort;
     }
   else limit=rates_total-prev_calculated; //       
   to_copy=limit+1;

//----    ,     
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);

   maxbar=rates_total-1-min_rates_stoch;

//---       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Stoch=Stoch(Kperiod0,Kperiod1,Slowing,PriceField,sens,bar,low,high,close);
      //----
      XStoch=XMA.XMASeries(maxbar,prev_calculated,rates_total,DMethod,DPhase,Dperiod,Stoch,bar,true);

      //---  
      if(XStoch_prev>OverBought)
        { //  
         Kperiod0=KperiodShort;
         Kperiod1=KperiodLong;
        }

      if(XStoch_prev<OverSold)
        { //  
         Kperiod0=KperiodLong;
         Kperiod1=KperiodShort;
        }
        
      SignUp[bar]=NULL;
      SignDown[bar]=NULL;
      
      if(XStoch_prev>=Stoch_prev && XStoch<Stoch) SignUp[bar]=low[bar]-ATR[bar]*3/8;
      if(Stoch_prev>=XStoch_prev && Stoch<XStoch) SignDown[bar]=high[bar]+ATR[bar]*3/8;

      if(bar)
        {
         Stoch_prev=Stoch;
         XStoch_prev=XStoch;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
double Stoch(
             int Kperiod0,
             int Kperiod1,
             int Slowing_,
             int PriceField_,
             double sens_,
             int Bar,
             const double &Low[],
             const double &High[],
             const double &Close[])
  {
//----
   double max,min,c,delta,diff;

   c=0.0;
   max=0.0;
   min=0.0;
   int end=Bar+Slowing_;;

   for(int j=Bar; j<end; j++)
     {
      if(PriceField_==STO_CLOSECLOSE)
        {
         max+=Close[ArrayMaximum(Close,j,Kperiod0)];
         min+=Close[ArrayMinimum(Close,j,Kperiod1)];
        }

      if(PriceField_==STO_LOWHIGH)
        {
         max+=High[ArrayMaximum(High,j,Kperiod0)];
         min+=Low[ArrayMinimum(Low,j,Kperiod1)];
        }

      c+=Close[j];
     }

//--- 
   sens_*=Slowing_; //       
   delta=max-min;   // 
   diff=sens-delta; //      

//---   >0 (  )
   if(diff>0)
     {
      delta=sens;   //  = 
      min-=diff/2;  //   
     }
//---  
   if(delta) return(100*(c-min)/delta); // 
//----
   return(-2);
  }
//+------------------------------------------------------------------+
