//+------------------------------------------------------------------+
//|                                        DonchianChannelsCloud.mq5 |
//|                         Copyright  2005, Luis Guilherme Damiani |
//|                                      http://www.damianifx.com.br |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Luis Guilherme Damiani"
#property link      "http://www.damianifx.com.br"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//---        
#property indicator_buffers 7
//---    
#property indicator_plots   5
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----      LightSkyBlue
#property indicator_color1  clrLightSkyBlue
//----   
#property indicator_label1  "Upper Cloud"
//+----------------------------------------------+
//|              |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        DodgerBlue
#property indicator_color2  clrDodgerBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Upper Donchian"
//+----------------------------------------------+
//|                |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        DarkViolet
#property indicator_color3  clrDarkViolet
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Middle Donchian"
//+----------------------------------------------+
//|               |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_LINE
//----        Magenta
#property indicator_color4  clrMagenta
//----   4 -  
#property indicator_style4  STYLE_SOLID
//----    4  2
#property indicator_width4  2
//----    
#property indicator_label4  "Lower Donchian"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_FILLING
//----      Violet
#property indicator_color5  clrViolet
//----   
#property indicator_label5  "Lower Cloud"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_Extrem // 
  {
   HIGH_LOW,
   HIGH_LOW_OPEN,
   HIGH_LOW_CLOSE,
   OPEN_HIGH_LOW,
   CLOSE_HIGH_LOW
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int DonchianPeriod=20; // 
input Applied_Extrem Extremes=HIGH_LOW; // 
input int Margins=-2;
input int Shift = 0; //      
//+-----------------------------------+
//----   ,         
double ExtUp1Buffer[];
double ExtUp2Buffer[];
double ExtABuffer[];
double ExtBBuffer[];
double ExtCBuffer[];
double ExtDn1Buffer[];
double ExtDn2Buffer[];
//----      
int  min_rates_total;
//+------------------------------------------------------------------+
//|  searching index of the highest bar                              |
//+------------------------------------------------------------------+
int iHighest(
             const double &array[],//      
             int count,//    (        ), 
             //      .
             int startPos // (   )  , 
             //      
             )
  {
//----+
   int index=startPos;

//----     
   if(startPos<0)
     {
      Print("    iHighest, startPos = ",startPos);
      return(0);
     }

//----   startPos  
   if(startPos-count<0)
      count=startPos;

   double max=array[startPos];

//----  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]>max)
        {
         index=i;
         max=array[i];
        }
     }
//----+    
   return(index);
  }
//+------------------------------------------------------------------+
//|  searching index of the lowest bar                               |
//+------------------------------------------------------------------+
int iLowest(
            const double &array[],//      
            int count,//    (        ), 
            //      .
            int startPos // (   )  , 
            //      
            )
  {
//----+
   int index=startPos;

//----     
   if(startPos<0)
     {
      Print("    iLowest, startPos = ",startPos);
      return(0);
     }

//----   startPos  
   if(startPos-count<0)
      count=startPos;

   double min=array[startPos];

//----  
   for(int i=startPos; i>startPos-count; i--)
     {
      if(array[i]<min)
        {
         index=i;
         min=array[i];
        }
     }
//----+    
   return(index);
  }
//+------------------------------------------------------------------+    
//| Donchian Channel indicator initialization function               | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(DonchianPeriod)+1;
//----      
   SetIndexBuffer(0,ExtUp1Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtUp2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(2,ExtABuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(3,ExtBBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(4,ExtCBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
   
//----      
   SetIndexBuffer(5,ExtDn1Buffer,INDICATOR_DATA);
   SetIndexBuffer(6,ExtDn2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);

//----      
   string shortname;
   StringConcatenate(shortname,"Donchian( DonchianPeriod = ",DonchianPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Donchian Channel iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double smin,smax,SsMax=0,SsMin=0;
//----   
   int first,bar;

//----    first    
   if(prev_calculated==0) //      
     {
      first=min_rates_total-1; //      
     }
   else
     {
      first=prev_calculated-1;//      
     }

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      switch(Extremes)
        {
         case HIGH_LOW:
            SsMax=high[iHighest(high,DonchianPeriod,bar)];
            SsMin=low[iLowest(low,DonchianPeriod,bar)];
            break;

         case HIGH_LOW_OPEN:
            SsMax=(open[iHighest(open,DonchianPeriod,bar)]+high[iHighest(high,DonchianPeriod,bar)])/2;
            SsMin=(open[iLowest(open,DonchianPeriod,bar)]+low[iLowest(high,DonchianPeriod,bar)])/2;
            break;

         case HIGH_LOW_CLOSE:
            SsMax=(close[iHighest(close,DonchianPeriod,bar)]+high[iHighest(high,DonchianPeriod,bar)])/2;
            SsMin=(close[iLowest(close,DonchianPeriod,bar)]+low[iLowest(high,DonchianPeriod,bar)])/2;
            break;

         case OPEN_HIGH_LOW:
            SsMax=open[iHighest(open,DonchianPeriod,bar)];
            SsMin=open[iLowest(open,DonchianPeriod,bar)];
            break;

         case CLOSE_HIGH_LOW:
            SsMax=close[iHighest(close,DonchianPeriod,bar)];
            SsMin=close[iLowest(close,DonchianPeriod,bar)];
            break;
        }

      smin=SsMin+(SsMax-SsMin)*Margins/100;
      smax=SsMax-(SsMax-SsMin)*Margins/100;      
      ExtABuffer[bar]=smax;
      ExtCBuffer[bar]=smin;
      ExtBBuffer[bar]=(smax+smin)/2.0;
      ExtUp1Buffer[bar]=ExtABuffer[bar];
      ExtUp2Buffer[bar]=ExtBBuffer[bar];
      ExtDn1Buffer[bar]=ExtBBuffer[bar];
      ExtDn2Buffer[bar]=ExtCBuffer[bar];
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
