//+------------------------------------------------------------------+
//|                                                 RJTX_Matches.mq5 |
//|                            Copyright 2015, Rafael Jimenez Tocino |
//|               http://www.tradingrafa.com/indicadores/rjt_matches |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright 2015, Rafael Jimenez Tocino"
//---    
#property link      "http://www.tradingrafa.com/indicadores/rjt_matches"
#property description "We recommend adjust the body and head size of the matches for better visualization."
//---   
#property version   "2.00"
//----     
#property indicator_separate_window
//---        
#property indicator_buffers 5
//---     
#property indicator_plots   5
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrBlue
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  2
#property indicator_width1  2
//----   
#property indicator_label1  "match 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2  clrBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  "match 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3  clrBlue
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----   
#property indicator_label3  "match 3"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_ARROW
//---        
#property indicator_color4  clrMagenta
//---    4  2
#property indicator_width4  2
//---    
#property indicator_label4  "RJTX_Matches Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   5   
#property indicator_type5   DRAW_ARROW
//---        
#property indicator_color5  clrLime
//---    5  2
#property indicator_width5  2
//---    
#property indicator_label5 "RJTX_Matches Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iPeriod=10;
//+----------------------------------------------+
//---   ,   
//---      
double LineBuffer0[];
double LineBuffer1[];
double LineBuffer2[];
double SellBuffer[];
double BuyBuffer[];
//---
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   min_rates_total=int(iPeriod);
//----   
   IndInit(0,LineBuffer0,0,min_rates_total,0);
   IndInit(1,LineBuffer1,0,min_rates_total,0);
   IndInit(2,LineBuffer2,0,min_rates_total,0);
   IndInit(3,SellBuffer,0,min_rates_total,0);
   IndInit(4,BuyBuffer,0,min_rates_total,0);
//---   
   PlotIndexSetInteger(3,PLOT_ARROW,174);
   PlotIndexSetInteger(4,PLOT_ARROW,174);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="RJTX_Matches";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int limit,bar;
   static uint p=0;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//---         
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(open,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //--- the color of matchstick heads
      if(close[bar]>open[bar+iPeriod])
        {
         SellBuffer[bar]=0.0;
         BuyBuffer[bar]=close[bar];
        }
      else
        {
         SellBuffer[bar]=close[bar];
         BuyBuffer[bar]=0.0;
        }
      //---
      switch(p)
        {
         case 0:
           {
            LineBuffer0[bar]=open[bar+iPeriod-1];
            LineBuffer1[bar]=0.0;
            LineBuffer2[bar]=close[bar];
            break;
           }
         case 1:
           {
            LineBuffer0[bar]=close[bar];
            LineBuffer1[bar]=open[bar+iPeriod-1];
            LineBuffer2[bar]=0.0;
            break;
           }
         case 2:
           {
            LineBuffer0[bar]=0.0;
            LineBuffer1[bar]=close[bar];
            LineBuffer2[bar]=open[bar+iPeriod-1];
           }
        }
      if(bar) p++;
      if(p>2) p=0;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
