//+---------------------------------------------------------------------+
//|                                               XDidi_Index_Cloud.mq5 |
//|                                 Copyright  2016, Rudinei Felipetto |
//|                                            http://www.conttinua.com |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
//---  
#property copyright "Copyright  2016, Rudinei Felipetto"
//---    
#property link      "http://www.conttinua.com"
//---   
#property version   "1.00"
//----     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrDodgerBlue,clrMagenta
//---   
#property indicator_label1  "XDidi_Index"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  1.0
#property indicator_levelcolor clrDarkViolet
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelwidth 2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method Curta_Method=MODE_SMA; // Curta  
input uint Curta=3; // Curta  
input int CPhase=15; // Curta  
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
//--- 
input Smooth_Method Media_Method=MODE_SMA; // Media  
input uint Media=8; // Media  
input int MPhase=15; // Media  
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Smooth_Method Longa_Method=MODE_SMA; // Longa  
input uint Longa=20; // Longa  
input int LPhase=15; // Longa  
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;    //  
input bool  Revers=false;  //     
//+----------------------------------------------+
//---   ,   
//---      
double DnBuffer[];
double UpBuffer[];
//---
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   min_rates_total=int(MathMax(MathMax(GetStartBars(Curta_Method,Curta,CPhase),
                       GetStartBars(Media_Method,Media,MPhase)),
                       GetStartBars(Longa_Method,Longa,LPhase)));
//---      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//---      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="XDidi_Index";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int first,bar;
   double price,Cur,Med,Lon;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      Cur=XMA1.XMASeries(0,prev_calculated,rates_total,Curta_Method,CPhase,Curta,price,bar,false);
      Med=XMA2.XMASeries(0,prev_calculated,rates_total,Media_Method,MPhase,Media,price,bar,false);
      Lon=XMA3.XMASeries(0,prev_calculated,rates_total,Longa_Method,LPhase,Longa,price,bar,false);
      //---
      if(Revers)
        {
         DnBuffer[bar]=-Cur/Med;
         UpBuffer[bar]=-Lon/Med;
        }
      else
        {
         UpBuffer[bar]=Cur/Med;
         DnBuffer[bar]=Lon/Med;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
