//+---------------------------------------------------------------------+
//|                                                        ATR_3XMA.mq5 |
//|                                              Copyright 2015, fxborg |
//|                                      http://fxborg-labo.hateblo.jp/ |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright 2015, fxborg"
#property link      "http://fxborg-labo.hateblo.jp/"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|    ATR             |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrLime
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  2
#property indicator_width1  2
//----   
#property indicator_label1  "Fast ATR"
//+----------------------------------------------+
//|    ATR           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2  clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  " Medium ATR"
//+----------------------------------------------+
//|    ATR           |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3  clrBlue
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----   
#property indicator_label3  "Slow ATR"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3,XMA4,XMA5,XMA6;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint FastATRPeriod=14;     //   ATR
input uint MediumATRPeriod=25;   //   ATR
input uint SlowATRPeriod=50;     //   ATR
input double SmoothRatio=5.0;    //   
input Smooth_Method MA_Method1=MODE_JJMA; //    
input int Phase1=15; //   
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_SMA_; //    
input int Phase2=15; //   
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer1[],IndBuffer2[],IndBuffer3[];
//----      
int min_rates_total,min_rates_1;
uint FastSmoothPeriod,MediumSmoothPeriod,SlowSmoothPeriod;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   int max1=int(MathMax(FastATRPeriod,MathMax(MediumATRPeriod,SlowATRPeriod)));
   min_rates_1=1+GetStartBars(MA_Method1,max1,Phase1);;
   double Ratio=MathMax(1,SmoothRatio);
   FastSmoothPeriod=int(MathCeil(FastATRPeriod/Ratio));
   MediumSmoothPeriod=int(MathCeil(MediumATRPeriod/Ratio));
   SlowSmoothPeriod=int(MathCeil(SlowATRPeriod/Ratio));
   int max2=int(MathMax(FastSmoothPeriod,MathMax(MediumSmoothPeriod,SlowSmoothPeriod)));
   min_rates_total=min_rates_1+GetStartBars(MA_Method2,max2,Phase2);
//----      
   SetIndexBuffer(0,IndBuffer1,INDICATOR_DATA);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(1,IndBuffer2,INDICATOR_DATA);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(2,IndBuffer3,INDICATOR_DATA);
//----       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"ATR_3XMA(",FastATRPeriod,", ",MediumATRPeriod,", ",SlowATRPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,5);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double atr,xatr1,xatr2,xatr3;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      atr=calc_atr(bar,high,low,close);
      //----
      xatr1=XMA1.XMASeries(1,prev_calculated,rates_total,MA_Method1,Phase1,FastATRPeriod,atr,bar,false);
      xatr2=XMA2.XMASeries(1,prev_calculated,rates_total,MA_Method1,Phase1,MediumATRPeriod,atr,bar,false);
      xatr3=XMA3.XMASeries(1,prev_calculated,rates_total,MA_Method1,Phase1,SlowATRPeriod,atr,bar,false);
      //----
      IndBuffer1[bar]=XMA4.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method1,Phase1,FastSmoothPeriod,xatr1,bar,false);
      IndBuffer2[bar]=XMA5.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method1,Phase1,MediumSmoothPeriod,xatr2,bar,false);
      IndBuffer3[bar]=XMA6.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method1,Phase1,SlowSmoothPeriod,xatr3,bar,false);
     }
//----     
   return(rates_total);
  }
//+----------------------------------------------------+
//| calc lwma atr                                      |
//+----------------------------------------------------+
double calc_atr(int index,const double  &h[],const double  &l[],const double  &c[])
  {
//--- 
   return(MathMax(h[index],c[index-1])-MathMin(l[index],c[index-1]));
  }
//+------------------------------------------------------------------+
