//+---------------------------------------------------------------------+
//|                                                   EMV_Histogram.mq5 |
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
//----  
#property copyright "Copyright  2015, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru"
#property description "Ease of Movement Value"
//----   
#property version   "1.11"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 4
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrBlue,clrPurple
//----   
#property indicator_label1  "EMV Signal"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----      
#property indicator_type2 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color2 clrDeepPink,clrOrange,clrGray,clrYellowGreen,clrTeal
//----   - 
#property indicator_style2 STYLE_SOLID
//----     2
#property indicator_width2 2
//----   
#property indicator_label2  "Ease of Movement Value"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price 
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method1=MODE_SMA; //    
input int XLength1=14; //    
input int XPhase1=15;  //    
//----  JJMA    -100 ... +100,     ;
//---- VIDIA   CMO,  AMA    
input Smooth_Method XMA_Method2=MODE_JJMA; //    
input int XLength2=5;  //                       
input int XPhase2=100; //    
//----  JJMA    -100 ... +100,     ;
//---- VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_QUARTER_; //  
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK; // 
input int Shift=0; //       
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
double UpBuffer[],DnBuffer[];
//----      
int min_rates_total,min_rates_1;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_1=GetStartBars(XMA_Method1,XLength1,XPhase1)+1;
   min_rates_total=min_rates_1+GetStartBars(XMA_Method2,XLength2,XPhase2);
//----      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,IndBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(3,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Ease of Movement Value");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   double price0,price1,EMV,XEMV;
   long Volume;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
     }
//----
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----   PriceSeries     price_
      price0=PriceSeries(PRICE_MEDIAN,bar,  open,low,high,close);
      price1=PriceSeries(PRICE_MEDIAN,bar-1,open,low,high,close);
      //----
      if(VolumeType==VOLUME_TICK) Volume=long(tick_volume[bar]);
      else                        Volume=long(volume[bar]);
      //----
      if(Volume!=0) EMV=(price0-price1)*price0/(2*Volume);
      else          EMV=0;
      //----
      XEMV=XMA1.XMASeries(1,prev_calculated,rates_total,XMA_Method1,XPhase1,XLength1,EMV,bar,false);
      IndBuffer[bar]=UpBuffer[bar]=XEMV;
      DnBuffer[bar]=XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method2,XPhase2,XLength2,XEMV,bar,false);
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) first=min_rates_total;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int clr=2;
      //----
      if(IndBuffer[bar]>0)
        {
         if(IndBuffer[bar]>IndBuffer[bar-1]) clr=4;
         if(IndBuffer[bar]<IndBuffer[bar-1]) clr=3;
        }
      //----
      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar-1]) clr=0;
         if(IndBuffer[bar]>IndBuffer[bar-1]) clr=1;
        }
      //----
      ColorIndBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+