//+------------------------------------------------------------------+
//|                                   Chande Momentum Oscillator.mq5 |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
/*
 *  <<    >>
 *
 *         
 * SmoothAlgorithms.mqh
 *   (): MetaTrader\\MQL5\Include
 *
 *       :
 *
 * 1)    CMO -  /. 
 *  -   +70  ,    +30  .
 * 2)  .  -   CMO    CMO 
 * ,  - ,   CMO    CMO  .
 */
//----  
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrGold
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "CMO"
//----    
#property indicator_level1  +50
#property indicator_level2    0
#property indicator_level3  -50
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int CMO_period= 9; //  CMO
input int CMO_Shift = 0; //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtLineBuffer[];
//+------------------------------------------------------------------+
//|   CCMO                                             |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,CMO_Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,CMO_period);
//----      
   string shortname;
   StringConcatenate(shortname,"CMO(",CMO_period,")");
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[])    //     
  {
//----       
   if(rates_total<CMO_period+1+begin)
      return(0);
//----    
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0+begin; //      
      //---      begin ,      
      if(begin>0) PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,CMO_period+2+begin);
     }
   else
     {
      first=prev_calculated-1; //      
     }
//----    CCMO
   static CCMO CMO;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
      ExtLineBuffer[bar]=CMO.CMOSeries(begin,prev_calculated,rates_total,CMO_period,price[bar],bar,false)*200-100;
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
