//+------------------------------------------------------------------+ 
//|                                          Begin_Trend_v02_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "Begin_Trend_v02       "
//---     
#property indicator_chart_window
//---        
#property indicator_buffers 4
//---    
#property indicator_plots   4
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                            //        
#define INDICATOR_NAME "Begin_Trend_v02"   //    
#define SIZE 1                             //      CountIndicator 
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 4
//---    
#property indicator_plots   4
//+----------------------------------------------+
//|    +             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrLimeGreen
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "Begin_Trend_v01 Up"
//+----------------------------------------------+
//|    -             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrRed
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2  "Begin_Trend_v01 Down"
//+----------------------------------------------+
//|    Buy           |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_HISTOGRAM
//---         
#property indicator_color3  clrLime
//---   3 -  
#property indicator_style3  STYLE_SOLID
//---    3  4
#property indicator_width3  4
//---    
#property indicator_label3  "Begin_Trend_v01 Up"
//+----------------------------------------------+
//|    Sell          |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_HISTOGRAM
//---         
#property indicator_color4  clrRed
//---   4 -  
#property indicator_style4  STYLE_SOLID
//---    4  4
#property indicator_width4  4
//---    
#property indicator_label4  "Begin_Trend_v01 Down"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +100.0
#property indicator_level2  +50.0
#property indicator_level3    0.0
#property indicator_level4  -50.0
#property indicator_level5 -100.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelwidth 1
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  //    ()
input uint Period_Channel=70;
input uint Period_Input=48;
input int Shift=0;                          //      
//+----------------------------------------------+
//---   ,   
//---      
double Up1IndBuffer[];
double Dn1IndBuffer[];
double Up2IndBuffer[];
double Dn2IndBuffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    Begin_Trend_v02
   Ind_Handle=iCustom(Symbol(),TimeFrame,"Begin_Trend_v02",Period_Channel,Period_Input,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Begin_Trend_v02");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,Up1IndBuffer,INDICATOR_DATA);
   IndInit(1,Dn1IndBuffer,INDICATOR_DATA);
   IndInit(2,Up2IndBuffer,INDICATOR_DATA);
   IndInit(3,Dn2IndBuffer,INDICATOR_DATA);
//---  
   PlotInit(0,EMPTY_VALUE,0,Shift);
   PlotInit(1,EMPTY_VALUE,0,Shift);
   PlotInit(2,EMPTY_VALUE,0,Shift);
   PlotInit(3,EMPTY_VALUE,0,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,Up1IndBuffer,1,Dn1IndBuffer,2,
      Up2IndBuffer,3,Dn2IndBuffer,time,rates_total,prev_calculated,min_rates_total))return(RESET);
//---     
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     Up1BuffNumb,      //       
                    double&  Up1IndBuf[],      //     1
                    uint     Dn1BuffNumb,      //       
                    double&  Dn1IndBuf[],      //     2
                    uint     Up2BuffNumb,      //       
                    double&  Up2IndBuf[],      //     3
                    uint     Dn2BuffNumb,      //       
                    double&  Dn2IndBuf[],      //     4
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Up1Arr[1],Dn1Arr[1];
         double Up2Arr[1],Dn2Arr[1];
         //---      
         if(CopyBuffer(IndHandle,Up1BuffNumb,iTime[bar],1,Up1Arr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,Dn1BuffNumb,iTime[bar],1,Dn1Arr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,Up2BuffNumb,iTime[bar],1,Up2Arr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,Dn2BuffNumb,iTime[bar],1,Dn2Arr)<=0) return(RESET);
         //---         
         Up1IndBuf[bar]=Up1Arr[0];
         Dn1IndBuf[bar]=Dn1Arr[0];
         Up2IndBuf[bar]=Up2Arr[0];
         Dn2IndBuf[bar]=Dn2Arr[0];
        }
      else
        {
         Up1IndBuf[bar]=Up1IndBuf[bar+1];
         Dn1IndBuf[bar]=Dn1IndBuf[bar+1];
         Up2IndBuf[bar]=Up2IndBuf[bar+1];
         Dn2IndBuf[bar]=Dn2IndBuf[bar+1];
        }
     }
//--- 
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
