//+------------------------------------------------------------------+
//|                                              Begin_Trend_v02.mq5 |
//|                                   Copyright  2014, Inkov Evgeni | 
//|                                                    ew123@mail.ru | 
//+------------------------------------------------------------------+ 
//---  
#property copyright "Copyright  2014, Inkov Evgeni"
//---  
#property link      "ew123@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 4
//---    
#property indicator_plots   4
//+----------------------------------------------+
//|    +             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrLimeGreen
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "Begin_Trend_v02 Up"
//+----------------------------------------------+
//|    -             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrRed
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2  "Begin_Trend_v02 Down"
//+----------------------------------------------+
//|    Buy           |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_HISTOGRAM
//---         
#property indicator_color3  clrLime
//---   3 -  
#property indicator_style3  STYLE_SOLID
//---    3  4
#property indicator_width3  4
//---    
#property indicator_label3  "Begin_Trend_v02 Up"
//+----------------------------------------------+
//|    Sell          |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_HISTOGRAM
//---         
#property indicator_color4  clrRed
//---   4 -  
#property indicator_style4  STYLE_SOLID
//---    4  4
#property indicator_width4  4
//---    
#property indicator_label4  "Begin_Trend_v02 Down"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +100.0
#property indicator_level2  +50.0
#property indicator_level3    0.0
#property indicator_level4  -50.0
#property indicator_level5 -100.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelwidth 1
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Period_Channel=70;
input uint Period_Input=48;
input int Shift=0;            //       
//+----------------------------------------------+
//---   ,   
//---      
double Up1Buffer[];
double Dn1Buffer[];
double Up2Buffer[];
double Dn2Buffer[];
//---      
int Up_Handle,Dn_Handle,Md_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(MathMax(Period_Channel,Period_Input));
//---    iMA
   Up_Handle=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_HIGH);
   if(Up_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---    iMA
   Md_Handle=iMA(NULL,0,Period_Input,0,MODE_SMA,PRICE_CLOSE);
   if(Md_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---    iMA
   Dn_Handle=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_LOW);
   if(Dn_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,Up1Buffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(Up1Buffer,true);
//---      
   SetIndexBuffer(1,Dn1Buffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(Dn1Buffer,true);
//---      
   SetIndexBuffer(2,Up2Buffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//---       2  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(Up2Buffer,true);
//---      
   SetIndexBuffer(3,Dn2Buffer,INDICATOR_DATA);
//---    3    Shift
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//---       3  min_rates_total
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(Dn2Buffer,true);
//---      
   string shortname="Begin_Trend_v02";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(Up_Handle)<rates_total
      || BarsCalculated(Md_Handle)<rates_total
      || BarsCalculated(Dn_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit;
   double Up[],Md[],Dn[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-2; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---      
   if(CopyBuffer(Up_Handle,0,0,to_copy,Up)<=0) return(RESET);
   if(CopyBuffer(Md_Handle,0,0,to_copy,Md)<=0) return(RESET);
   if(CopyBuffer(Dn_Handle,0,0,to_copy,Dn)<=0) return(RESET);
//---         
   ArraySetAsSeries(Up,true);
   ArraySetAsSeries(Md,true);
   ArraySetAsSeries(Dn,true);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double d=MathMax(MathAbs(Up[bar]-Dn[bar]),MathMax(MathAbs(Up[bar]-Md[bar]),MathAbs(Dn[bar]-Md[bar])));
      if(!d) d=1e-10;
      Up1Buffer[bar]=(Up[bar]-Md[bar])/d*100.0;
      Dn1Buffer[bar]=(Dn[bar]-Md[bar])/d*100.0;
      Up2Buffer[bar]=EMPTY_VALUE;
      Dn2Buffer[bar]=EMPTY_VALUE;
      //---      
      if(Up1Buffer[bar]<0) Dn2Buffer[bar]=Up1Buffer[bar];
      if(Dn1Buffer[bar]>0) Up2Buffer[bar]=Dn1Buffer[bar];
     }
//---
   return(rates_total);
  }
//+------------------------------------------------------------------+
