//+------------------------------------------------------------------+
//|                                                Ozymandias_v2.mq4 |
//|                                     Copyright  2014, GoldnMoney |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2014, GoldnMoney"
#property link "http://www.mql5.com"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---    4
#property indicator_buffers 4 
//---     
#property indicator_plots   2
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1  clrOrange,clrChartreuse
//---   -  
#property indicator_style1  STYLE_SOLID
//---     3
#property indicator_width1  3
//---   
#property indicator_label1  "Line"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type2   DRAW_COLOR_LINE
//---      
#property indicator_color2  clrOrange,clrLimeGreen
//---   -  
#property indicator_style2  STYLE_DASHDOT
//---     1
#property indicator_width2  1
//---   
#property indicator_label2  "Signal"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Length=2;
input  ENUM_MA_METHOD MAType=MODE_SMA;
input int Shift=0;   //      
//+-----------------------------------+
//---   ,   
//---      
double IndBuffer[],ColorIndBuffer[];
double SigBuffer[],ColorSigBuffer[];
//---      
int min_rates_total;
int ATR_Handle,HMA_Handle,LMA_Handle;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---     
   min_rates_total=int(Length);
//---    
   int ATR_Period=100;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---    iMA
   HMA_Handle=iMA(NULL,0,Length,0,MAType,PRICE_HIGH);
   if(HMA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---    iMA
   LMA_Handle=iMA(NULL,0,Length,0,MAType,PRICE_LOW);
   if(LMA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---          
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorIndBuffer,true);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---      
   SetIndexBuffer(2,SigBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(SigBuffer,true);
//---          
   SetIndexBuffer(3,ColorSigBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorSigBuffer,true);
//---    1  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//---      
   string shortname="Ozymandias_v2";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total
      || BarsCalculated(HMA_Handle)<rates_total
      || BarsCalculated(LMA_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//---  
   int to_copy,limit;
   double highprice,lowprice,maxlo,zone,minhi,map0,lowma,highma,ATR[],HMA[],LMA[];
   static double map1,maxlo1,minhi1;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      map1=0;
      minhi1=99999999;
      maxlo1=1;
     }
   else limit=rates_total-prev_calculated;  //       
   to_copy=limit+1;
//---      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
   if(CopyBuffer(HMA_Handle,0,0,to_copy,HMA)<=0) return(RESET);
   if(CopyBuffer(LMA_Handle,0,0,to_copy,LMA)<=0) return(RESET);
//---         
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(HMA,true);
   ArraySetAsSeries(LMA,true);
//---
   maxlo=maxlo1;
   minhi=minhi1;
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      highprice=high[ArrayMaximum(high,bar,Length)];
      lowprice=low[ArrayMinimum(low,bar,Length)];
      lowma=LMA[bar];
      highma=HMA[bar];
      zone=ATR[bar]/2;
      maxlo=MathMax(lowprice,maxlo);
      minhi=MathMin(highprice,minhi);
      map0=map1;
      //---
      if(highma<maxlo && close[bar]<low[bar+1])
        {
         map0=-1;
         maxlo=lowprice;
        }
      //---
      if(lowma>minhi && close[bar]>high[bar+1])
        {
         map0=1;
         minhi=highprice;
        }
      //---
      if(map0>0 && map1<0)
        {
         IndBuffer[bar]=IndBuffer[bar+1];
         ColorIndBuffer[bar]=1;
         SigBuffer[bar]=SigBuffer[bar+1];
         ColorSigBuffer[bar]=1;
        }
      //---
      if(map0>0 && map1>0)
        {
         IndBuffer[bar]=MathMax(maxlo,IndBuffer[bar+1]);
         ColorIndBuffer[bar]=1;
         SigBuffer[bar]=IndBuffer[bar]-zone;
         ColorSigBuffer[bar]=1;
        }
      //---
      if(map0<0 && map1>0)
        {
         IndBuffer[bar]=IndBuffer[bar+1];
         ColorIndBuffer[bar]=0;
         SigBuffer[bar]=SigBuffer[bar+1];
         ColorSigBuffer[bar]=0;
        }
      //---
      if(map0<0 && map1<0)
        {
         IndBuffer[bar]=MathMin(minhi,IndBuffer[bar+1]);
         ColorIndBuffer[bar]=0;
         SigBuffer[bar]=IndBuffer[bar]+zone;
         ColorSigBuffer[bar]=0;
        }
      //---
      if(bar)
        {
         map1=map0;
         maxlo1=maxlo;
         minhi1=minhi;
        }
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
