//+------------------------------------------------------------------+
//|                                            StohasticWithFlat.mq5 |
//|                                 Copyright  2014, Powered byStep | 
//|                                                                  | 
//+------------------------------------------------------------------+
#property description "Stochastic indicator With Flat"
//---  
#property copyright "Copyright  2014, Powered byStep"
//---  
#property link      ""
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|    CG            |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        Orchid 
#property indicator_color1  clrOrchid
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Stohastic Oscillator"
//+----------------------------------------------+
//|    Signal        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrBlue
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "Signal"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  +75
#property indicator_level2  +50
#property indicator_level3  +25
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|       |
//+----------------------------------------------+
#property indicator_minimum 0
#property indicator_maximum 100
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint                BBPeriod=20;                 //    
input double              StdDeviation=2.0;            // -  
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE;   //   
input uint KPeriod=5;
input uint DPeriod=3;
input uint Slowing=3;
input ENUM_MA_METHOD MA_Method=MODE_SMA;
input ENUM_STO_PRICE Price_field=STO_LOWHIGH;
input uint flat=100;       //    
input int Shift=0;         //       
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer[];
double SignalBuffer[];
//---      
int BB_Handle,STO_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(MathMax(BBPeriod,KPeriod+DPeriod+Slowing));
//---    iBands
   BB_Handle=iBands(Symbol(),PERIOD_CURRENT,BBPeriod,0,StdDeviation,applied_price);
   if(BB_Handle==INVALID_HANDLE)
     {
      Print("      iBands");
      return(INIT_FAILED);
     }
//---    iStochastic
   STO_Handle=iStochastic(Symbol(),PERIOD_CURRENT,KPeriod,DPeriod,Slowing,MA_Method,Price_field);
   if(STO_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   SetIndexBuffer(1,SignalBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(SignalBuffer,true);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   IndicatorSetString(INDICATOR_SHORTNAME,"StohasticWithFlat");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(BB_Handle)<rates_total || BarsCalculated(STO_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit,bar;
   double MainSTO[],SignSTO[],UpBB[],MainBB[];
//---         limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;
//---      
   if(CopyBuffer(BB_Handle,UPPER_BAND,0,to_copy,UpBB)<=0) return(RESET);
   if(CopyBuffer(BB_Handle,BASE_LINE,0,to_copy,MainBB)<=0) return(RESET);
   if(CopyBuffer(STO_Handle,MAIN_LINE,0,to_copy,MainSTO)<=0) return(RESET);
   if(CopyBuffer(STO_Handle,SIGNAL_LINE,0,to_copy,SignSTO)<=0) return(RESET);
//---         
   ArraySetAsSeries(UpBB,true);
   ArraySetAsSeries(MainBB,true);
   ArraySetAsSeries(MainSTO,true);
   ArraySetAsSeries(SignSTO,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double res=(UpBB[bar]-MainBB[bar])/_Point;
      if(res<flat)
        {
         if(MainSTO[bar]>SignSTO[bar])
           {
            IndBuffer[bar]=55;
            SignalBuffer[bar]=45;
           }
         if(MainSTO[bar]<SignSTO[bar])
           {
            IndBuffer[bar]=45;
            SignalBuffer[bar]=55;
           }
        }
      else
        {
         IndBuffer[bar]=MainSTO[bar];
         SignalBuffer[bar]=SignSTO[bar];
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
