//+------------------------------------------------------------------+
//|                                                     Tail_Bar.mq5 | 
//|                                   Copyright  2014, Inkov Evgeni | 
//|                                                    ew123@mail.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2014, Inkov Evgeni"
#property link "ew123@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---   
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//---     
#property indicator_color1  clrTeal,clrMagenta
//---   -  
#property indicator_style1  STYLE_SOLID
//---     3
#property indicator_width1  3
//---   
#property indicator_label1  "Tail_Bar"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int Shift=0; //      
//+-----------------------------------+
//---   ,   
//---      
double IndBuffer[],ColorIndBuffer[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=2;
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Tail_Bar");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---       
   double Val0;
   static double Val1;
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total-1; //      
      bar=first-1;
      Val1=((high[bar]-MathMax(close[bar],open[bar]))-(MathMin(close[bar],open[bar])-low[bar]))/_Point;
     }
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      Val0=((high[bar]-MathMax(close[bar],open[bar]))-(MathMin(close[bar],open[bar])-low[bar]))/_Point;
      IndBuffer[bar]=Val0;
      if(Val1<Val0) ColorIndBuffer[bar]=0;
      else ColorIndBuffer[bar]=1;      
      if(bar<rates_total-1) Val1=Val0;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
