//+------------------------------------------------------------------+
//|                                                    Resources.mqh |
//|                                                  2011, KTS Group |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "2011, KTS Group"

#resource "\\Images\\TradePanel\\Left\\LBlue.bmp"
#resource "\\Images\\TradePanel\\Left\\LBlueDn.bmp"
#resource "\\Images\\TradePanel\\Left\\LRed.bmp"
#resource "\\Images\\TradePanel\\Left\\LRedDn.bmp"
#resource "\\Images\\TradePanel\\Left\\LGray.bmp"
#resource "\\Images\\TradePanel\\Left\\LGrayDn.bmp"
#resource "\\Images\\TradePanel\\Left\\LDis.bmp"
#resource "\\Images\\TradePanel\\Right\\RBlue.bmp"
#resource "\\Images\\TradePanel\\Right\\RBlueDn.bmp"
#resource "\\Images\\TradePanel\\Right\\RRed.bmp"
#resource "\\Images\\TradePanel\\Right\\RRedDn.bmp"
#resource "\\Images\\TradePanel\\Right\\RGray.bmp"
#resource "\\Images\\TradePanel\\Right\\RGrayDn.bmp"
#resource "\\Images\\TradePanel\\Right\\RDis.bmp"
#resource "\\Images\\TradePanel\\sBtns\\ToSetAs.bmp"
#resource "\\Images\\TradePanel\\sBtns\\ToSetAsD.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Drag.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DragD.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Disabled\\DragDis.bmp"
#resource "\\Images\\TradePanel\\Frames\\TradeForm.bmp"
#resource "\\Images\\TradePanel\\Frames\\TradeForm1.bmp"
#resource "\\Images\\TradePanel\\Frames\\DragForm.bmp"
#resource "\\Images\\TradePanel\\Frames\\TradeFormD.bmp"
#resource "\\Images\\TradePanel\\sBtns\\SeBkg.bmp"
#resource "\\Images\\TradePanel\\sBtns\\SeBkgDis.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Inc.bmp"
#resource "\\Images\\TradePanel\\sBtns\\IncD.bmp"
#resource "\\Images\\TradePanel\\sBtns\\IncDis.bmp"
#resource "\\Images\\TradePanel\\sBtns\\IncP.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Dec.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DecD.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DecDis.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DecP.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Inc1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\IncD1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\IncDis1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\IncP1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Dec1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DecD1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DecDis1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\DecP1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\TabA.bmp"
#resource "\\Images\\TradePanel\\sBtns\\TabD.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Tab1.bmp"
#resource "\\Images\\TradePanel\\sBtns\\rbChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\rbUnChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Disabled\\rbChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Disabled\\rbUnChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\chbChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\chbUnChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Disabled\\chbChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Disabled\\chbUnChecked.bmp"
#resource "\\Images\\TradePanel\\sBtns\\pnlTrade.bmp"
#resource "\\Images\\TradePanel\\sBtns\\Comment.bmp"
#resource "\\Images\\TradePanel\\sBtns\\CommentD.bmp"

string rc[1][55]=
  {
     {//---Command buttons
      "::Images\\TradePanel\\Left\\LBlue.bmp",                   //0
      "::Images\\TradePanel\\Left\\LBlueDn.bmp",                 //1
      "::Images\\TradePanel\\Left\\LRed.bmp",                    //2
      "::Images\\TradePanel\\Left\\LRedDn.bmp",                  //3
      "::Images\\TradePanel\\Left\\LGray.bmp",                   //4
      "::Images\\TradePanel\\Left\\LGrayDn.bmp",                 //5
      "::Images\\TradePanel\\Left\\LDis.bmp",                    //6
      "::Images\\TradePanel\\Right\\RBlue.bmp",                  //7
      "::Images\\TradePanel\\Right\\RBlueDn.bmp",                //8
      "::Images\\TradePanel\\Right\\RRed.bmp",                   //9
      "::Images\\TradePanel\\Right\\RRedDn.bmp",                 //10
      "::Images\\TradePanel\\Right\\RGray.bmp",                  //11
      "::Images\\TradePanel\\Right\\RGrayDn.bmp",                //12
      "::Images\\TradePanel\\Right\\RDis.bmp",                   //13
      //---      
      "::Images\\TradePanel\\sBtns\\ToSetAs.bmp",                //14
      "::Images\\TradePanel\\sBtns\\ToSetAsD.bmp",               //15
      "::Images\\TradePanel\\Frames\\TradeForm1.bmp",            //16
      "::Images\\TradePanel\\Frames\\TradeForm.bmp",             //17
      "::Images\\TradePanel\\Frames\\DragForm.bmp",              //18
      "::Images\\TradePanel\\Frames\\TradeFormD.bmp",            //19
      "::Images\\TradePanel\\sBtns\\Drag.bmp",                   //20
      "::Images\\TradePanel\\sBtns\\DragD.bmp",                  //21
      "::Images\\TradePanel\\sBtns\\Disabled\\DragDis.bmp",      //22
      //---Tabs Control
      "::Images\\TradePanel\\sBtns\\Tab1.bmp",                   //23
      "::Images\\TradePanel\\sBtns\\TabA.bmp",                   //24
      "::Images\\TradePanel\\sBtns\\TabD.bmp",                   //25
      //---SpinEdit Control(BP_LEFT_RIGHT)
      "::Images\\TradePanel\\sBtns\\SeBkg.bmp",                  //26
      "::Images\\TradePanel\\sBtns\\SeBkgDis.bmp",               //27
      "::Images\\TradePanel\\sBtns\\Inc.bmp",                    //28
      "::Images\\TradePanel\\sBtns\\IncD.bmp",                   //29
      "::Images\\TradePanel\\sBtns\\IncDis.bmp",                 //30
      "::Images\\TradePanel\\sBtns\\IncP.bmp",                   //31
      "::Images\\TradePanel\\sBtns\\Dec.bmp",                    //32
      "::Images\\TradePanel\\sBtns\\DecD.bmp",                   //33
      "::Images\\TradePanel\\sBtns\\DecDis.bmp",                 //34
      "::Images\\TradePanel\\sBtns\\DecP.bmp",                   //35
      //---SpinEdit Control(BP_RIGHT)
      "::Images\\TradePanel\\sBtns\\Inc1.bmp",                   //36
      "::Images\\TradePanel\\sBtns\\IncD1.bmp",                  //37
      "::Images\\TradePanel\\sBtns\\IncDis1.bmp",                //38
      "::Images\\TradePanel\\sBtns\\IncP1.bmp",                  //39
      "::Images\\TradePanel\\sBtns\\Dec1.bmp",                   //40
      "::Images\\TradePanel\\sBtns\\DecD1.bmp",                  //41
      "::Images\\TradePanel\\sBtns\\DecDis1.bmp",                //42
      "::Images\\TradePanel\\sBtns\\DecP1.bmp",                  //43
      //---Radiogroup control
      "::Images\\TradePanel\\sBtns\\rbChecked.bmp",              //44
      "::Images\\TradePanel\\sBtns\\rbUnChecked.bmp",            //45
      "::Images\\TradePanel\\sBtns\\Disabled\\rbChecked.bmp",    //46
      "::Images\\TradePanel\\sBtns\\Disabled\\rbUnChecked.bmp",  //47
      //---Checkbox control
      "::Images\\TradePanel\\sBtns\\chbChecked.bmp",             //48
      "::Images\\TradePanel\\sBtns\\chbUnChecked.bmp",           //49
      "::Images\\TradePanel\\sBtns\\Disabled\\chbChecked.bmp",   //50
      "::Images\\TradePanel\\sBtns\\Disabled\\chbUnChecked.bmp", //51
      //---
      "::Images\\TradePanel\\sBtns\\pnlTrade.bmp",               //52
      "::Images\\TradePanel\\sBtns\\Comment.bmp",                //53
      "::Images\\TradePanel\\sBtns\\CommentD.bmp"                //54

     }
  };
#include <Controls\Controls.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

WAVList CTRLS_PlayList[]=
  {
     {"Tick.wav", CTRL_TAB_HEADER},
     {"Tick.wav",     CTRL_RADIOBUTTON},
     {"Tick.wav",CTRL_CHECKBOX},
     {"Tick.wav",CTRL_UP_SPINBUTTON},
     {"Tick.wav",CTRL_DN_SPINBUTTON},
     {"Tick.wav",       CTRL_BUTTON},
     {"Tick.wav",     CTRL_CMD_BUTTON}
  };
//+------------------------------------------------------------------+

//---SpinEdit font defines
#define  CLR_SEBKG             C'26,26,26'
#define  CLR_SE_RO_BKG         C'47,47,47'
#define  CLR_SETEXT            DarkGray
#define  CLR_SETEXT_RO         C'99,99,99'
#define  SE_FONTNAME           "Tahoma"
#define  SE_FONTSIZE           10
//--

//---CMD buttons font defines
#define  CMDBTN_FONTNAME       "Tahoma"
#define  CMDBTN_FONTSIZE_SMALL 10
#define  CMDBTN_FONTSIZE_LARGE 2*CMDBTN_FONTSIZE_SMALL

#define  CMDBTN_TEXT           White
#define  CMDBTN_TEXT_DIS       C'47,47,47'
#define  CMDBTN_TEXT_DISABLED  White
//---

//---Labels,captions  font defines
#define  TEXT_FONTNAME         "Tahoma"
#define  TEXT_FONTSIZE         8
#define  CLR_TEXT              White
#define  CLR_TEXT_DIS          DarkGray
#define  CLR_TEXT_DISABLED     DimGray//C'77,77,77'
#define  CLR_TEXT_STATUS       C'240,230,140'
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CAppResources:public CResources
  {
public:
   ushort            m_SkinSection;
                     CAppResources(void);
   virtual bool      CreateResources(uchar f_SkinSection=0) {return(false);}
   virtual string    LoadImgResource(ushort f_idx){return(" ");}
  };
//---
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CAppResources::CAppResources(void)
  {
   m_SkinSection=0;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CTradePadResources:public CAppResources
  {
public:
   bool              CreateResources(uchar f_SkinSection=0);
   string            LoadImgResource(ushort f_idx);
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string CTradePadResources::LoadImgResource(ushort f_idx)
  {
   return((string)rc[m_SkinSection][f_idx]);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CTradePadResources::CreateResources(uchar f_SkinSection=0)
  {
   CImgResource  *Images=NULL;
   CFontResource *Font=NULL;
   CWavResource  *Wavs=NULL;
   if(f_SkinSection!=0)
     {
      m_SkinSection=f_SkinSection;
     }
   bool result=true;
   
   if((Wavs=AddWavResource("CTRLS",new CWavResource))!=NULL)  //default resource name for all controls "CTRLS"
     {
      Wavs.AddResource(CTRLS_PlayList);
     }
  
   if((Font=AddFontResource("COMMON_FONT",new CFontResource))!=NULL)
     {
      Font.AddResource(TEXT_FONTNAME,TEXT_FONTSIZE,CLR_TEXT,CLR_TEXT_DIS,CLR_TEXT_DISABLED);
     }

   if((Font=AddFontResource("CMD_FONT",new CFontResource))!=NULL)
     {
      Font.AddResource(CMDBTN_FONTNAME,CMDBTN_FONTSIZE_SMALL,CMDBTN_TEXT,CMDBTN_TEXT_DIS,CMDBTN_TEXT_DISABLED);
     }

   if((Font=AddFontResource("EDIT_FONT",new CFontResource))!=NULL)
     {
      Font.AddResource(SE_FONTNAME,SE_FONTSIZE,CLR_SETEXT,CLR_SEBKG,CLR_SETEXT_RO,CLR_SE_RO_BKG);
     }

   if((Font=AddFontResource("STATUS_FONT",new CFontResource))!=NULL)
     {
      Font.AddResource(TEXT_FONTNAME,TEXT_FONTSIZE,CLR_TEXT_DIS,CLR_TEXT_DISABLED,CLR_TEXT_DISABLED);
     }
//---

   if((Images=AddImgsResource(FRAME_SECTION,new CImgResource))!=NULL)
     {
      for(ushort i=16;i<=19;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("CMD_SELL",new CImgResource))!=NULL)
     {
      for(ushort i=0;i<=6;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("CMD_BUY",new CImgResource))!=NULL)
     {
      for(ushort i=7;i<=13;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("RS_DRAGBTN",new CImgResource))!=NULL)
     {
      for(ushort i=20;i<=22;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("RS_TABS",new CImgResource))!=NULL)
     {
      for(ushort i=23;i<=25;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
      result&=Images.AddResource(" ");
      result&=Images.AddResource(" ");
     }

   if((Images=AddImgsResource("RS_SPIN",new CImgResource))!=NULL)
     {
      for(ushort i=26;i<=35;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("RS_SPIN1",new CImgResource))!=NULL)
     {
      result&=Images.AddResource(" ");
      result&=Images.AddResource(" ");
      for(ushort i=36;i<=43;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("RS_RG",new CImgResource))!=NULL)
     {
      result&=Images.AddResource(" ");
      for(ushort i=44;i<=47;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("RS_CHKBOX",new CImgResource))!=NULL)
     {
      for(ushort i=48;i<=51;i++)
        {
         result&=Images.AddResource(LoadImgResource(i));
        }
     }

   if((Images=AddImgsResource("RS_BKGTRADE",new CImgResource))!=NULL)
     {
      result&=Images.AddResource(LoadImgResource(52));
      result&=Images.AddResource(" ");
     }

   if((Images=AddImgsResource("RS_SET_AS",new CImgResource))!=NULL)
     {
      result&=Images.AddResource(LoadImgResource(14));
      result&=Images.AddResource(LoadImgResource(15));
     }

   if((Images=AddImgsResource("RS_COMMENT",new CImgResource))!=NULL)
     {
      result&=Images.AddResource(LoadImgResource(53));
      result&=Images.AddResource(LoadImgResource(54));
     }

   if(result) Print("Load resources complete!");
   return(result);
  }
//+------------------------------------------------------------------+
