//+------------------------------------------------------------------+
//|                                         AutomataTesterSample.mq4 |
//|                                                     Version: 1.1 |
//+------------------------------------------------------------------+

#property copyright "Copyright  2011, Symr"

#include <testerControl.mqh>

//+------------------------------------------------------------------+

#property show_inputs
#property show_confirm

extern string s_advisor = "ea_symr_Test";
extern string s_symbol  = "EURUSD;GBPUSD";
extern string s_period  = "M5";
extern string s_model   = "";
extern string s_from    = "2011.05.01;2011.06.01";
extern string s_to      = "2011.06.01;2011.07.01";

//+------------------------------------------------------------------+

void init() {
  InitTester();
  return (0);
}

//+------------------------------------------------------------------+

void start() {

  SetTestingOptions(s_advisor,1000,"USD",TST_POS_LONG_SHORT,TST_OPT_BALANCE,false);
  
  string advisors[]; fillArraySetting(advisors,s_advisor);
  string symbols[]; fillArraySetting(symbols,s_symbol);
  string periods[]; fillArraySetting(periods,s_period);
  string froms[]; fillArraySetting(froms,s_from);
  string tos[]; fillArraySetting(tos,s_to);
  
  for(int i=0; i<ArraySize(advisors); i++)
   for(int j=0; j<ArraySize(symbols); j++)
    for(int k=0; k<ArraySize(periods); k++)
     for(int l=0; l<ArraySize(froms); l++) {
       SetTesterOptions(advisors[i], symbols[j], periods[k], s_model, froms[l], tos[l]);
       StartTester();
       Print("Substep done - "+advisors[i]+" "+symbols[j]+" "+periods[k]+" "+s_model+" "+froms[l]+" "+tos[l]);
     }

  Print("Test done");
 
  return (0);
}

