//+------------------------------------------------------------------+
//|                                            NCycleGoertzelDft.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#include<GoertzelCycle.mqh>
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_plots   5 
//--- plot Wave
#property indicator_label1  "Wave"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrBlack
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Up
#property indicator_label2  "Peak"
#property indicator_type2   DRAW_NONE
//--- plot Dwn
#property indicator_label3  "Trough"
#property indicator_type3   DRAW_NONE
//--- plot Up
#property indicator_label4  "Long"
#property indicator_type4   DRAW_LINE
#property indicator_color4  clrBlue
#property indicator_style4  STYLE_SOLID
#property indicator_width4  2
//--- plot Dwn
#property indicator_label5  "Short"
#property indicator_type5   DRAW_LINE
#property indicator_color5  clrRed
#property indicator_style5  STYLE_SOLID
#property indicator_width5  2
//--- input parameters
input bool     Detrend=true;
input bool     EndFlatten=true; 
input bool     SquaredAmp=true;
input bool     UseCycleStrength=false;
input uint     Maxper=72;
input uint     Minper=5;
input uint     MaxCycles=10;
input double   pntup=0.5;//Percent increase threshold
input double   pntdn=0.5;//Percent decrease threshold
//--- indicator buffers

double  Wave[],Peak[],Trough[],Long[],Short[];
CGoertzelCycle *Gc;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,Wave,INDICATOR_DATA);
   SetIndexBuffer(1,Peak,INDICATOR_DATA);
   SetIndexBuffer(2,Trough,INDICATOR_DATA);
   SetIndexBuffer(3,Long,INDICATOR_DATA);
   SetIndexBuffer(4,Short,INDICATOR_DATA);
//---   
   IndicatorSetInteger(INDICATOR_DIGITS,5);
//---   
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,0.0);
//---
   Gc=new CGoertzelCycle(Detrend,SquaredAmp,EndFlatten,Minper,Maxper);
   
   if(Gc==NULL)
    {
     Print("Invalid Goertzel object");
     return(INIT_FAILED);
    }  
//---     
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Indicator DeInitialization function                              |
//+------------------------------------------------------------------+
void OnDeinit (const int reason)
 {
  if(CheckPointer(Gc)==POINTER_DYNAMIC)
      delete Gc;
 }  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int lim=0;
   
   if(prev_calculated<=0)
      lim=(int)(Maxper*3)+2;
   else 
      lim=prev_calculated;
   
   
//---
    Gc.CalculateWave(prev_calculated,rates_total,MaxCycles,UseCycleStrength,price,Wave);
//---
   for(int i=lim;i<rates_total-1;i++)
      {
       Peak[i]=Trough[i]=0.0;   
       
       if(Wave[i]>Wave[i+1] && Wave[i]>Wave[i-1])
         Peak[i]=Wave[i];
       else 
         if(Wave[i]<Wave[i+1] && Wave[i]<Wave[i-1])
           Trough[i]=Wave[i];
         
       if(i<int(Maxper*3*2)) 
          {
           continue;
          } 
          
       double lp,lt;
          lp=lt=0;  
               
       if(i==int(Maxper*3*2))
         {
          lp=getlastPeakTrough(i,Peak);
          lt=getlastPeakTrough(i,Trough);
          if(Wave[i]>Wave[i-1] && lt)
            {
             Long[i]=Wave[i];
             Short[i]=0.0;
            } 
          else
            if(Wave[i]<Wave[i-1] && lp)
              {
               Short[i]=Wave[i];
               Long[i]=0.0;
              } 
         }
       else
         {
         
           Long[i]=(Long[i-1]!=0)?Wave[i]:Long[i-1];
           Short[i]=(Short[i-1]!=0)?Wave[i]:Short[i-1];
          
          if(Short[i-1]!=0 && Wave[i]>Wave[i-1])
           {
            lt=getlastPeakTrough(i,Trough);
            if(lt && (Wave[i]-lt)/lt > pntup/100 )
              {
               Long[i]=Wave[i];
               Short[i]=0.0;
              }
            else
              {
               Short[i]=Wave[i];
               Long[i]=0.0;
              }    
           }
          else
           if(Long[i-1]!=0 && Wave[i]<Wave[i-1])
           {
            lp=getlastPeakTrough(i,Peak);
            if(lp && (lp-Wave[i])/lp > pntdn/100 )
              {
                Short[i]=Wave[i];
                Long[i]=0.0;
              }
             else
              {
                Long[i]=Wave[i];
                Short[i]=0.0;
              }    
           }
         }  
      
      }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| helper function that returns either last peak or trough          |
//+------------------------------------------------------------------+
double getlastPeakTrough(int shift, double &buffer[])
  {
   uint j;
   double value=0.0;
   for(j=shift-1;j>(Maxper*3)+2;j--)
     {
      if(buffer[j]==0.0)
         continue;
      else
         return(buffer[j]);
     }
   return(value);
  }
//+-----------------------------------------------------------------------------------------------++
        