//+------------------------------------------------------------------+
//|                                                AdaptiveGARSI.mq5 |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#include<GoertzelCycle.mqh>
#property indicator_buffers 2
#property indicator_plots   1
//--- plot RSi
#property indicator_label1  "RSi"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//---
#property indicator_level1        70
#property indicator_level2        50
#property indicator_level3        30
//---
input bool     Detrend=true;
input bool     EndFlatten=true; 
input bool     SquaredAmp=true;
input bool     UseCycleStrength=false;
input uint     Maxper=72;
input uint     Minper=5;
//--- indicator buffers
double         RSiBuffer[];
double         DomPeriodBuffer[];

CGoertzelCycle *Gc;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,RSiBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,DomPeriodBuffer,INDICATOR_CALCULATIONS);
//---
   Gc=new CGoertzelCycle(Detrend,SquaredAmp,EndFlatten,Minper,Maxper);
//---   
   if(Gc==NULL)
    {
     Print("Invalid Goertzel object");
     return(INIT_FAILED);
    }  
//---    
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Indicator DeInitialization function                              |
//+------------------------------------------------------------------+
void OnDeinit (const int reason)
 {
  if(CheckPointer(Gc)==POINTER_DYNAMIC)
      delete Gc;
 }    
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   uint lim=0;
//---
   Gc.CalculateDominantCycles(prev_calculated,rates_total,UseCycleStrength,close,DomPeriodBuffer);
//---
   if(prev_calculated<=0)
       lim=int(Maxper*3)+int(DomPeriodBuffer[(Maxper*3)-1]) - 1;
   else
       lim=prev_calculated; 
       
//---
   double cu,cd;
   for(int i =int(lim);i<rates_total;i++)
    {
      cd=0.0;
      cu=0.0;
      double p=DomPeriodBuffer[i];
      int j=0;
      for(j=0;j<int(p);j++)
        {
         if(close[i-j]-close[i-j-1]>0)cu=cu+(close[i-j]-close[i-j-1]);
         if(close[i-j]-close[i-j-1]<0)cd=cd+(close[i-j-1]-close[i-j]);
        }
      if(cu+cd!=0)
         RSiBuffer[i]=100*cu/(cu+cd);
      else 
         RSiBuffer[i]=0.0;
    
    }        
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
