#define LAYOUT_WEB_COLORS_COUNT 133
#define LAYOUT_GUI_COLORS_COUNT 14

class LayoutColors
{
  public:
    const static string WebColorNames[LAYOUT_WEB_COLORS_COUNT];
    const static color WebColorValues[LAYOUT_WEB_COLORS_COUNT];
    const static string GUIColorNames[LAYOUT_GUI_COLORS_COUNT];
    const static color GUIColorValues[LAYOUT_GUI_COLORS_COUNT];

    static bool isDefaultGUIcolor(const color clr)
    {
      for(int i = 0; i < ArraySize(GUIColorValues); i++)
      {
        if(GUIColorValues[i] == clr)
        {
          return true;
        }
      }
      return false;
    }
};

const static string LayoutColors::WebColorNames[LAYOUT_WEB_COLORS_COUNT] =
{
  "",
  "Black",
  "DarkGreen",
  "DarkSlateGray",
  "Olive",
  "Green",
  "Teal",
  "Navy",
  "Purple",
  "Maroon",
  "Indigo",
  "MidnightBlue",
  "DarkBlue",
  "DarkOliveGreen",
  "SaddleBrown",
  "ForestGreen",
  "OliveDrab",
  "SeaGreen",
  "DarkGoldenrod",
  "DarkSlateBlue",
  "Sienna",
  "MediumBlue",
  "Brown",
  "DarkTurquoise",
  "DimGray",
  "LightSeaGreen",
  "DarkViolet",
  "FireBrick",
  "MediumVioletRed",
  "MediumSeaGreen",
  "Chocolate",
  "Crimson",
  "SteelBlue",
  "Goldenrod",
  "MediumSpringGreen",
  "LawnGreen",
  "CadetBlue",
  "DarkOrchid",
  "YellowGreen",
  "LimeGreen",
  "OrangeRed",
  "DarkOrange",
  "Orange",
  "Gold",
  "Yellow",
  "Chartreuse",
  "Lime",
  "SpringGreen",
  "Aqua",
  "DeepSkyBlue",
  "Blue",
  "Magenta",
  "Red",
  "Gray",
  "SlateGray",
  "Peru",
  "BlueViolet",
  "LightSlateGray",
  "DeepPink",
  "MediumTurquoise",
  "DodgerBlue",
  "Turquoise",
  "RoyalBlue",
  "SlateBlue",
  "DarkKhaki",
  "IndianRed",
  "MediumOrchid",
  "GreenYellow",
  "MediumAquamarine",
  "DarkSeaGreen",
  "Tomato",
  "RosyBrown",
  "Orchid",
  "MediumPurple",
  "PaleVioletRed",
  "Coral",
  "CornflowerBlue",
  "DarkGray",
  "SandyBrown",
  "MediumSlateBlue",
  "Tan",
  "DarkSalmon",
  "BurlyWood",
  "HotPink",
  "Salmon",
  "Violet",
  "LightCoral",
  "SkyBlue",
  "LightSalmon",
  "Plum",
  "Khaki",
  "LightGreen",
  "Aquamarine",
  "Silver",
  "LightSkyBlue",
  "LightSteelBlue",
  "LightBlue",
  "PaleGreen",
  "Thistle",
  "PowderBlue",
  "PaleGoldenrod",
  "PaleTurquoise",
  "LightGray",
  "Wheat",
  "NavajoWhite",
  "Moccasin",
  "LightPink",
  "Gainsboro",
  "PeachPuff",
  "Pink",
  "Bisque",
  "LightGoldenrod",
  "BlanchedAlmond",
  "LemonChiffon",
  "Beige",
  "AntiqueWhite",
  "PapayaWhip",
  "Cornsilk",
  "LightYellow",
  "LightCyan",
  "Linen",
  "Lavender",
  "MistyRose",
  "OldLace",
  "WhiteSmoke",
  "Seashell",
  "Ivory",
  "Honeydew",
  "AliceBlue",
  "LavenderBlush",
  "MintCream",
  "Snow",
  "White"
};

const static color LayoutColors::WebColorValues[LAYOUT_WEB_COLORS_COUNT] =
{
  clrNONE,
  clrBlack,
  clrDarkGreen,
  clrDarkSlateGray,
  clrOlive,
  clrGreen,
  clrTeal,
  clrNavy,
  clrPurple,
  clrMaroon,
  clrIndigo,
  clrMidnightBlue,
  clrDarkBlue,
  clrDarkOliveGreen,
  clrSaddleBrown,
  clrForestGreen,
  clrOliveDrab,
  clrSeaGreen,
  clrDarkGoldenrod,
  clrDarkSlateBlue,
  clrSienna,
  clrMediumBlue,
  clrBrown,
  clrDarkTurquoise,
  clrDimGray,
  clrLightSeaGreen,
  clrDarkViolet,
  clrFireBrick,
  clrMediumVioletRed,
  clrMediumSeaGreen,
  clrChocolate,
  clrCrimson,
  clrSteelBlue,
  clrGoldenrod,
  clrMediumSpringGreen,
  clrLawnGreen,
  clrCadetBlue,
  clrDarkOrchid,
  clrYellowGreen,
  clrLimeGreen,
  clrOrangeRed,
  clrDarkOrange,
  clrOrange,
  clrGold,
  clrYellow,
  clrChartreuse,
  clrLime,
  clrSpringGreen,
  clrAqua,
  clrDeepSkyBlue,
  clrBlue,
  clrMagenta,
  clrRed,
  clrGray,
  clrSlateGray,
  clrPeru,
  clrBlueViolet,
  clrLightSlateGray,
  clrDeepPink,
  clrMediumTurquoise,
  clrDodgerBlue,
  clrTurquoise,
  clrRoyalBlue,
  clrSlateBlue,
  clrDarkKhaki,
  clrIndianRed,
  clrMediumOrchid,
  clrGreenYellow,
  clrMediumAquamarine,
  clrDarkSeaGreen,
  clrTomato,
  clrRosyBrown,
  clrOrchid,
  clrMediumPurple,
  clrPaleVioletRed,
  clrCoral,
  clrCornflowerBlue,
  clrDarkGray,
  clrSandyBrown,
  clrMediumSlateBlue,
  clrTan,
  clrDarkSalmon,
  clrBurlyWood,
  clrHotPink,
  clrSalmon,
  clrViolet,
  clrLightCoral,
  clrSkyBlue,
  clrLightSalmon,
  clrPlum,
  clrKhaki,
  clrLightGreen,
  clrAquamarine,
  clrSilver,
  clrLightSkyBlue,
  clrLightSteelBlue,
  clrLightBlue,
  clrPaleGreen,
  clrThistle,
  clrPowderBlue,
  clrPaleGoldenrod,
  clrPaleTurquoise,
  clrLightGray,
  clrWheat,
  clrNavajoWhite,
  clrMoccasin,
  clrLightPink,
  clrGainsboro,
  clrPeachPuff,
  clrPink,
  clrBisque,
  clrLightGoldenrod,
  clrBlanchedAlmond,
  clrLemonChiffon,
  clrBeige,
  clrAntiqueWhite,
  clrPapayaWhip,
  clrCornsilk,
  clrLightYellow,
  clrLightCyan,
  clrLinen,
  clrLavender,
  clrMistyRose,
  clrOldLace,
  clrWhiteSmoke,
  clrSeashell,
  clrIvory,
  clrHoneydew,
  clrAliceBlue,
  clrLavenderBlush,
  clrMintCream,
  clrSnow,
  clrWhite
};

const static string LayoutColors::GUIColorNames[LAYOUT_GUI_COLORS_COUNT] =
{
  "GUI input",
  "GUI button",
  "GUI background",
  "GUI border",
  "GUI selection",
  "GUI client",
  "GUI client bg",
  "GUI scroll",
  "GUI scroll bg",
  "GUI dialog",
  "GUI dialog bg",
  "GUI caption",
  "GUI text",
  "GUI NONE"
};

const static color LayoutColors::GUIColorValues[LAYOUT_GUI_COLORS_COUNT] =
{
  clrWhite,
  C'0xDD,0xE2,0xEB',
  C'0xF7,0xF7,0xF7',
  C'0xB2,0xC3,0xCF',
  C'0x33,0x99,0xFF',
  C'0xDE,0xDE,0xDE',
  C'0xC8,0xC8,0xC8',
  C'0xEC,0xEC,0xEC',
  C'0xD3,0xD3,0xD3',
  C'0xF0,0xF0,0xF0',
  C'0xB6,0xB6,0xB6',
  C'0x28,0x29,0x3B',
  C'0x3B,0x29,0x28',
  0xFFFFFFFF
};

/* // problem with GUI colors support (how to detect default colors of control types?)

"GUI input"      White
"GUI button"     C'0xDD,0xE2,0xEB'
"GUI background" C'0xF7,0xF7,0xF7'
"GUI border"     C'0xB2,0xC3,0xCF'
"GUI selection"  C'0x33,0x99,0xFF'
"GUI client"     C'0xDE,0xDE,0xDE'
"GUI client br"  C'0xC8,0xC8,0xC8'
"GUI scroll"     C'0xEC,0xEC,0xEC'
"GUI scroll br"  C'0xD3,0xD3,0xD3'
"GUI dialog"     C'0xF0,0xF0,0xF0'
"GUI dialog br"  C'0xB6,0xB6,0xB6'
"GUI caption"    C'0x28,0x29,0x3B'
"GUI text"       C'0x3B,0x29,0x28'

*/
