//+------------------------------------------------------------------+
//|                                                    DummyForm.mqh |
//|                                    Copyright (c) 2020, Marketeer |
//|                          https://www.mql5.com/en/users/marketeer |
//|                           https://www.mql5.com/ru/articles/7795/ |
//+------------------------------------------------------------------+

#include <ControlsPlus/Dialog.mqh>
#include <ControlsPlus/Button.mqh>
#include <ControlsPlus/Edit.mqh>
#include <ControlsPlus/CheckBox.mqh>
#include <Layouts/LayoutDefines.mqh>
#include <Layouts/Box.mqh>
#include <Layouts/ComboBoxResizable.mqh>
#include <Layouts/RadioGroupResizable.mqh>
#include <Layouts/CheckGroupResizable.mqh>
#include <Layouts/AppDialogResizable.mqh>
#include <Layouts/LayoutMonitors.mqh>
#include <Layouts/LayoutStdLib.mqh>
#include <Layouts/SpinEditResizable.mqh>
#include <Layouts/TraceObjects.mqh>

//+------------------------------------------------------------------+
//| defines                                                          |
//+------------------------------------------------------------------+

class DummyForm;


class MyStdLayoutCache: public StdLayoutCache
{
  protected:
    DummyForm *parent;
  public:
    MyStdLayoutCache(DummyForm *owner): parent(owner) {}

    virtual bool onEvent(const int event, CWnd *control) override
    {
      if(control != NULL)
      {
        Print(control._rtti, " / ", control.Name());
        return true;
      }
      return false;
    }
};


//+-----------------------------------------------------------------------+
//| Main dialog window with controls                                      |
//+-----------------------------------------------------------------------+
class DummyForm: public AppDialogResizable
{
  private:
    MyStdLayoutCache *cache;
    CBox *pMain;
    
  public:
    DummyForm(void);
    ~DummyForm(void);

    bool CreateLayout(const long chart, const string name, const int subwin, const int x1, const int y1, const int x2, const int y2);
    
    // general event handler
    virtual bool OnEvent(const int id, const long &lparam, const double &dparam, const string &sparam);

    MyStdLayoutCache *getCache(void) const
    {
      return cache;
    }

  protected:
    CBox *GetMainContainer(void);
    virtual void SelfAdjustment(const bool restore = false) override;
    bool OnRefresh();
};


//+------------------------------------------------------------------+
//| Event handling                                                   |
//+------------------------------------------------------------------+

EVENT_MAP_BEGIN(DummyForm)
  ON_EVENT_LAYOUT_ARRAY(ON_CLICK, cache)
  ON_NO_ID_EVENT(ON_LAYOUT_REFRESH, OnRefresh)
EVENT_MAP_END(AppDialogResizable)

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
DummyForm::DummyForm(void)
{
  RTTI;
  pMain = NULL;
  cache = new MyStdLayoutCache(&this);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
DummyForm::~DummyForm(void)
{
  delete cache;
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool DummyForm::CreateLayout(const long chart, const string name, const int subwin, const int x1, const int y1, const int x2, const int y2)
{
  StdLayoutBase::setCache(cache);
  {
    _layout<DummyForm> dialog(this, name, x1, y1, x2, y2);
    
    // ------------------
    
    // insert exported MQL-layout here
    // NB. we need to define/include all classes which are referenced in imported layout

    // ----------------------
  }

  SelfAdjustment();
  EventChartCustom(CONTROLS_SELF_MESSAGE, ON_LAYOUT_REFRESH, 0, 0.0, NULL);

  return true;
}

CBox *DummyForm::GetMainContainer(void)
{
  for(int i = 0; i < ControlsTotal(); i++)
  {
    CWndClient *client = dynamic_cast<CWndClient *>(Control(i));
    if(client != NULL)
    {
      for(int j = 0; j < client.ControlsTotal(); j++)
      {
        CBox *box = dynamic_cast<CBox *>(client.Control(j));
        if(box != NULL)
        {
          return box;
        }
      }
    }
  }
  return NULL;
}

void DummyForm::SelfAdjustment(const bool restore = false)
{
  if(pMain == NULL)
  {
    pMain = GetMainContainer();
  }
  
  if(pMain)
  {
    pMain.Show();
    pMain.Pack();
    Rebound(Rect());
  }
}

bool DummyForm::OnRefresh()
{
  SelfAdjustment();
  return true;
}
