//+------------------------------------------------------------------+
//|                                                     Designer.mq5 |
//|                                    Copyright (c) 2020, Marketeer |
//|                          https://www.mql5.com/en/users/marketeer |
//|                           https://www.mql5.com/ru/articles/7795/ |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2020, Marketeer"
#property link "https://www.mql5.com/en/users/marketeer"
#property version "1.0"
#property description "GUI designer based on MQL layout system"


#include "InspectorDialog.mqh"
#include "DesignerForm.mqh"


InspectorDialog inspector;
DesignerForm designer;

int OnInit()
{
    if(!inspector.CreateLayout(0, "Inspector", 0, 20, 20, 200, 370))
        return (INIT_FAILED);

    if(!inspector.Run())
        return (INIT_FAILED);

    if(!designer.CreateLayout(0, "Designer", 0, 300, 50, 500, 300))
        return (INIT_FAILED);

    if(!designer.Run())
        return (INIT_FAILED);

    return (INIT_SUCCEEDED);
}

void OnDeinit(const int reason)
{
    inspector.Destroy(reason);
    designer.Destroy(reason);
}

void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
{
    inspector.ChartEvent(id, lparam, dparam, sparam);
    designer.ChartEvent(id, lparam, dparam, sparam);
}
//+------------------------------------------------------------------+
